/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.bucket;

import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"deletes an empty bucket"})
public class DeleteBucketHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume/bucket.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;

    @Override
    public Void call() throws Exception {
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureBucketAddress();
        OzoneClient client = address.createClient(this.createOzoneConfiguration());
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        if (this.isVerbose()) {
            System.out.printf("Volume Name : %s%n", volumeName);
            System.out.printf("Bucket Name : %s%n", bucketName);
        }
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        vol.deleteBucket(bucketName);
        return null;
    }
}

