/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.bucket;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientUtils;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.rest.response.BucketInfo;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import org.apache.hadoop.ozone.web.utils.JsonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"lists the buckets in a volume."})
public class ListBucketHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Option(names={"--length", "-l"}, description={"Limit of the max results"}, defaultValue="100", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private int maxBuckets;
    @CommandLine.Option(names={"--start", "-s"}, description={"The first bucket to start the listing"})
    private String startBucket;
    @CommandLine.Option(names={"--prefix", "-p"}, description={"Prefix to filter the buckets"})
    private String prefix;

    @Override
    public Void call() throws Exception {
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureVolumeAddress();
        OzoneClient client = address.createClient(this.createOzoneConfiguration());
        String volumeName = address.getVolumeName();
        if (this.maxBuckets < 1) {
            throw new IllegalArgumentException("the length should be a positive number");
        }
        if (this.isVerbose()) {
            System.out.printf("Volume Name : %s%n", volumeName);
        }
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        Iterator bucketIterator = vol.listBuckets(this.prefix, this.startBucket);
        ArrayList<BucketInfo> bucketList = new ArrayList<BucketInfo>();
        while (this.maxBuckets > 0 && bucketIterator.hasNext()) {
            BucketInfo bucketInfo = OzoneClientUtils.asBucketInfo((OzoneBucket)((OzoneBucket)bucketIterator.next()));
            bucketList.add(bucketInfo);
            --this.maxBuckets;
        }
        if (this.isVerbose()) {
            System.out.printf("Found : %d buckets for volume : %s ", bucketList.size(), volumeName);
        }
        System.out.println(JsonUtils.toJsonStringWithDefaultPrettyPrinter((String)JsonUtils.toJsonString(bucketList)));
        return null;
    }
}

