/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.token;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import org.apache.hadoop.ozone.web.utils.JsonUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import picocli.CommandLine;

@CommandLine.Command(name="get", description={"get a delegation token."})
public class GetTokenHandler
extends Handler {
    @CommandLine.Option(names={"--renewer", "-r"}, description={"Token renewer"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String renewer;

    @Override
    public Void call() throws Exception {
        Token token;
        OzoneAddress address = new OzoneAddress();
        OzoneClient client = address.createClient(this.createOzoneConfiguration());
        if (!OzoneSecurityUtil.isSecurityEnabled((Configuration)this.createOzoneConfiguration())) {
            System.err.println("Error:Token operations work only when security is enabled. To enable security set ozone.security.enabled to true.");
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)this.renewer)) {
            this.renewer = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        if (Objects.isNull(token = client.getObjectStore().getDelegationToken(new Text(this.renewer)))) {
            System.err.println("Error: Get delegation token operation failed. Check OzoneManager logs for more details.");
            return null;
        }
        System.out.printf("%s", JsonUtils.toJsonStringWithDefaultPrettyPrinter((String)JsonUtils.toJsonString((Object)token.encodeToUrlString())));
        return null;
    }
}

