/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.volume;

import java.util.Objects;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import org.apache.hadoop.ozone.web.utils.JsonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="setacl", description={"Set acls."})
public class SetAclVolumeHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume/bucket.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Option(names={"--acls", "-al"}, required=true, description={"Comma separated acls.r = READ,w = WRITE,c = CREATE,d = DELETE,l = LIST,a = ALL,n = NONE,x = READ_AC,y = WRITE_ACEx user:user1:rw,user:user2:a,group:hadoop:a"})
    private String acls;
    @CommandLine.Option(names={"--store", "-s"}, required=false, description={"store type. i.e OZONE or S3"})
    private String storeType;

    @Override
    public Void call() throws Exception {
        Objects.requireNonNull(this.acls, "New acls to be added not specified.");
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureVolumeAddress();
        OzoneClient client = address.createClient(this.createOzoneConfiguration());
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        if (this.isVerbose()) {
            System.out.printf("Volume Name : %s%n", volumeName);
            System.out.printf("Bucket Name : %s%n", bucketName);
        }
        OzoneObjInfo obj = OzoneObjInfo.Builder.newBuilder().setBucketName(bucketName).setVolumeName(volumeName).setResType(OzoneObj.ResourceType.VOLUME).setStoreType(this.storeType == null ? OzoneObj.StoreType.OZONE : OzoneObj.StoreType.valueOf((String)this.storeType)).build();
        System.out.printf(" acls" + this.acls.length() + " " + this.acls, new Object[0]);
        boolean result = client.getObjectStore().setAcl((OzoneObj)obj, OzoneAcl.parseAcls((String)this.acls));
        System.out.printf("%s%n", JsonUtils.toJsonStringWithDefaultPrettyPrinter((String)JsonUtils.toJsonString((Object)("Acl set successfully: " + result))));
        client.close();
        return null;
    }
}

