/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.clientrm;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceProfilesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceProfilesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAttributesToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAttributesToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeAttributesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeAttributesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToAttributesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToAttributesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetResourceProfileRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetResourceProfileResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.federation.failover.FederationProxyProviderUtil;
import org.apache.hadoop.yarn.server.federation.policies.RouterPolicyFacade;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.router.RouterMetrics;
import org.apache.hadoop.yarn.server.router.RouterServerUtil;
import org.apache.hadoop.yarn.server.router.clientrm.AbstractClientRequestInterceptor;
import org.apache.hadoop.yarn.server.router.clientrm.ClientMethod;
import org.apache.hadoop.yarn.server.router.clientrm.ClientRequestInterceptor;
import org.apache.hadoop.yarn.server.router.clientrm.RouterYarnClientUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationClientInterceptor
extends AbstractClientRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(FederationClientInterceptor.class);
    private int numSubmitRetries;
    private Map<SubClusterId, ApplicationClientProtocol> clientRMProxies;
    private FederationStateStoreFacade federationFacade;
    private Random rand;
    private RouterPolicyFacade policyFacade;
    private RouterMetrics routerMetrics;
    private ThreadPoolExecutor executorService;
    private final Clock clock = new MonotonicClock();

    @Override
    public void init(String userName) {
        super.init(userName);
        this.federationFacade = FederationStateStoreFacade.getInstance();
        this.rand = new Random(System.currentTimeMillis());
        int numThreads = this.getConf().getInt("yarn.router.interceptor.user.threadpool-size", 5);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("RPC Router Client-" + userName + "-%d ").build();
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        this.executorService = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, workQueue, threadFactory);
        Configuration conf = this.getConf();
        try {
            this.policyFacade = new RouterPolicyFacade(conf, this.federationFacade, this.federationFacade.getSubClusterResolver(), null);
        }
        catch (FederationPolicyInitializationException e) {
            LOG.error(e.getMessage());
        }
        this.numSubmitRetries = conf.getInt("yarn.router.submit.retry", 3);
        this.clientRMProxies = new ConcurrentHashMap<SubClusterId, ApplicationClientProtocol>();
        this.routerMetrics = RouterMetrics.getMetrics();
    }

    @Override
    public void setNextInterceptor(ClientRequestInterceptor next) {
        throw new YarnRuntimeException("setNextInterceptor is being called on FederationClientRequestInterceptor, which should be the last one in the chain. Check if the interceptor pipeline configuration is correct");
    }

    @VisibleForTesting
    protected ApplicationClientProtocol getClientRMProxyForSubCluster(SubClusterId subClusterId) throws YarnException {
        if (this.clientRMProxies.containsKey(subClusterId)) {
            return this.clientRMProxies.get(subClusterId);
        }
        ApplicationClientProtocol clientRMProxy = null;
        try {
            boolean serviceAuthEnabled = this.getConf().getBoolean("hadoop.security.authorization", false);
            UserGroupInformation realUser = this.user;
            if (serviceAuthEnabled) {
                realUser = UserGroupInformation.createProxyUser((String)this.user.getShortUserName(), (UserGroupInformation)UserGroupInformation.getLoginUser());
            }
            clientRMProxy = (ApplicationClientProtocol)FederationProxyProviderUtil.createRMProxy((Configuration)this.getConf(), ApplicationClientProtocol.class, (SubClusterId)subClusterId, (UserGroupInformation)realUser);
        }
        catch (Exception e) {
            RouterServerUtil.logAndThrowException("Unable to create the interface to reach the SubCluster " + subClusterId, e);
        }
        this.clientRMProxies.put(subClusterId, clientRMProxy);
        return clientRMProxy;
    }

    private SubClusterId getRandomActiveSubCluster(Map<SubClusterId, SubClusterInfo> activeSubclusters) throws YarnException {
        if (activeSubclusters == null || activeSubclusters.size() < 1) {
            RouterServerUtil.logAndThrowException("No active SubCluster available to submit the request.", null);
        }
        ArrayList<SubClusterId> list = new ArrayList<SubClusterId>(activeSubclusters.keySet());
        return (SubClusterId)list.get(this.rand.nextInt(list.size()));
    }

    public GetNewApplicationResponse getNewApplication(GetNewApplicationRequest request) throws YarnException, IOException {
        long startTime = this.clock.getTime();
        Map subClustersActive = this.federationFacade.getSubClusters(true);
        for (int i = 0; i < this.numSubmitRetries; ++i) {
            SubClusterId subClusterId = this.getRandomActiveSubCluster(subClustersActive);
            LOG.debug("getNewApplication try #{} on SubCluster {}", (Object)i, (Object)subClusterId);
            ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
            GetNewApplicationResponse response = null;
            try {
                response = clientRMProxy.getNewApplication(request);
            }
            catch (Exception e) {
                LOG.warn("Unable to create a new ApplicationId in SubCluster " + subClusterId.getId(), (Throwable)e);
            }
            if (response != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededAppsCreated(stopTime - startTime);
                return response;
            }
            subClustersActive.remove(subClusterId);
        }
        this.routerMetrics.incrAppsFailedCreated();
        String errMsg = "Fail to create a new application.";
        LOG.error(errMsg);
        throw new YarnException(errMsg);
    }

    public SubmitApplicationResponse submitApplication(SubmitApplicationRequest request) throws YarnException, IOException {
        long startTime = this.clock.getTime();
        if (request == null || request.getApplicationSubmissionContext() == null || request.getApplicationSubmissionContext().getApplicationId() == null) {
            this.routerMetrics.incrAppsFailedSubmitted();
            RouterServerUtil.logAndThrowException("Missing submitApplication request or applicationSubmissionContex information.", null);
        }
        ApplicationId applicationId = request.getApplicationSubmissionContext().getApplicationId();
        ArrayList<SubClusterId> blacklist = new ArrayList<SubClusterId>();
        for (int i = 0; i < this.numSubmitRetries; ++i) {
            String message;
            SubClusterId subClusterId = this.policyFacade.getHomeSubcluster(request.getApplicationSubmissionContext(), blacklist);
            LOG.info("submitApplication appId" + applicationId + " try #" + i + " on SubCluster " + subClusterId);
            ApplicationHomeSubCluster appHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)applicationId, (SubClusterId)subClusterId);
            if (i == 0) {
                try {
                    subClusterId = this.federationFacade.addApplicationHomeSubCluster(appHomeSubCluster);
                }
                catch (YarnException e) {
                    this.routerMetrics.incrAppsFailedSubmitted();
                    message = "Unable to insert the ApplicationId " + applicationId + " into the FederationStateStore";
                    RouterServerUtil.logAndThrowException(message, e);
                }
            } else {
                try {
                    this.federationFacade.updateApplicationHomeSubCluster(appHomeSubCluster);
                }
                catch (YarnException e) {
                    message = "Unable to update the ApplicationId " + applicationId + " into the FederationStateStore";
                    SubClusterId subClusterIdInStateStore = this.federationFacade.getApplicationHomeSubCluster(applicationId);
                    if (subClusterId == subClusterIdInStateStore) {
                        LOG.info("Application " + applicationId + " already submitted on SubCluster " + subClusterId);
                    }
                    this.routerMetrics.incrAppsFailedSubmitted();
                    RouterServerUtil.logAndThrowException(message, e);
                }
            }
            ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
            SubmitApplicationResponse response = null;
            try {
                response = clientRMProxy.submitApplication(request);
            }
            catch (Exception e) {
                LOG.warn("Unable to submit the application " + applicationId + "to SubCluster " + subClusterId.getId(), (Throwable)e);
            }
            if (response != null) {
                LOG.info("Application " + request.getApplicationSubmissionContext().getApplicationName() + " with appId " + applicationId + " submitted on " + subClusterId);
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededAppsSubmitted(stopTime - startTime);
                return response;
            }
            blacklist.add(subClusterId);
        }
        this.routerMetrics.incrAppsFailedSubmitted();
        String errMsg = "Application " + request.getApplicationSubmissionContext().getApplicationName() + " with appId " + applicationId + " failed to be submitted.";
        LOG.error(errMsg);
        throw new YarnException(errMsg);
    }

    public KillApplicationResponse forceKillApplication(KillApplicationRequest request) throws YarnException, IOException {
        long startTime = this.clock.getTime();
        if (request == null || request.getApplicationId() == null) {
            this.routerMetrics.incrAppsFailedKilled();
            RouterServerUtil.logAndThrowException("Missing forceKillApplication request or ApplicationId.", null);
        }
        ApplicationId applicationId = request.getApplicationId();
        SubClusterId subClusterId = null;
        try {
            subClusterId = this.federationFacade.getApplicationHomeSubCluster(request.getApplicationId());
        }
        catch (YarnException e) {
            this.routerMetrics.incrAppsFailedKilled();
            RouterServerUtil.logAndThrowException("Application " + applicationId + " does not exist in FederationStateStore", e);
        }
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        KillApplicationResponse response = null;
        try {
            LOG.info("forceKillApplication " + applicationId + " on SubCluster " + subClusterId);
            response = clientRMProxy.forceKillApplication(request);
        }
        catch (Exception e) {
            this.routerMetrics.incrAppsFailedKilled();
            LOG.error("Unable to kill the application report for " + request.getApplicationId() + "to SubCluster " + subClusterId.getId(), (Throwable)e);
            throw e;
        }
        if (response == null) {
            LOG.error("No response when attempting to kill the application " + applicationId + " to SubCluster " + subClusterId.getId());
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededAppsKilled(stopTime - startTime);
        return response;
    }

    public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnException, IOException {
        long startTime = this.clock.getTime();
        if (request == null || request.getApplicationId() == null) {
            this.routerMetrics.incrAppsFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing getApplicationReport request or applicationId information.", null);
        }
        SubClusterId subClusterId = null;
        try {
            subClusterId = this.federationFacade.getApplicationHomeSubCluster(request.getApplicationId());
        }
        catch (YarnException e) {
            this.routerMetrics.incrAppsFailedRetrieved();
            RouterServerUtil.logAndThrowException("Application " + request.getApplicationId() + " does not exist in FederationStateStore", e);
        }
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        GetApplicationReportResponse response = null;
        try {
            response = clientRMProxy.getApplicationReport(request);
        }
        catch (Exception e) {
            this.routerMetrics.incrAppsFailedRetrieved();
            LOG.error("Unable to get the application report for " + request.getApplicationId() + "to SubCluster " + subClusterId.getId(), (Throwable)e);
            throw e;
        }
        if (response == null) {
            LOG.error("No response when attempting to retrieve the report of the application " + request.getApplicationId() + " to SubCluster " + subClusterId.getId());
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededAppsRetrieved(stopTime - startTime);
        return response;
    }

    public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetClusterMetricsResponse getClusterMetrics(GetClusterMetricsRequest request) throws YarnException, IOException {
        Map subclusters = this.federationFacade.getSubClusters(true);
        ClientMethod remoteMethod = new ClientMethod("getClusterMetrics", new Class[]{GetClusterMetricsRequest.class}, request);
        ArrayList<SubClusterId> clusterList = new ArrayList<SubClusterId>(subclusters.keySet());
        Map<SubClusterId, GetClusterMetricsResponse> clusterMetrics = this.invokeConcurrent(clusterList, remoteMethod, GetClusterMetricsResponse.class);
        return RouterYarnClientUtils.merge(clusterMetrics.values());
    }

    <R> Map<SubClusterId, R> invokeConcurrent(ArrayList<SubClusterId> clusterIds, final ClientMethod request, Class<R> clazz) throws YarnException, IOException {
        ArrayList<1> callables = new ArrayList<1>();
        ArrayList futures = new ArrayList();
        TreeMap<SubClusterId, IOException> exceptions = new TreeMap<SubClusterId, IOException>();
        for (final SubClusterId subClusterId : clusterIds) {
            callables.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ApplicationClientProtocol protocol = FederationClientInterceptor.this.getClientRMProxyForSubCluster(subClusterId);
                    Method method = ApplicationClientProtocol.class.getMethod(request.getMethodName(), request.getTypes());
                    return method.invoke((Object)protocol, request.getParams());
                }
            });
        }
        TreeMap<SubClusterId, R> results = new TreeMap<SubClusterId, R>();
        try {
            SubClusterId subClusterId;
            IOException ioe;
            futures.addAll(this.executorService.invokeAll(callables));
            for (int i = 0; i < futures.size(); ++i) {
                SubClusterId subClusterId2 = clusterIds.get(i);
                try {
                    Future future = (Future)futures.get(i);
                    Object result = future.get();
                    results.put(subClusterId2, clazz.cast(result));
                    continue;
                }
                catch (ExecutionException ex) {
                    IOException ioe2;
                    Throwable cause = ex.getCause();
                    LOG.debug("Cannot execute {} on {}: {}", new Object[]{request.getMethodName(), subClusterId2.getId(), cause.getMessage()});
                    if (cause instanceof IOException) {
                        ioe2 = (IOException)cause;
                    } else {
                        if (cause instanceof YarnException) {
                            throw (YarnException)cause;
                        }
                        ioe2 = new IOException("Unhandled exception while calling " + request.getMethodName() + ": " + cause.getMessage(), cause);
                    }
                    exceptions.put(subClusterId2, ioe2);
                }
            }
            if (results.isEmpty() && !clusterIds.isEmpty() && (ioe = (IOException)exceptions.get(subClusterId = clusterIds.get(0))) != null) {
                throw ioe;
            }
        }
        catch (InterruptedException e) {
            throw new YarnException((Throwable)e);
        }
        return results;
    }

    public GetClusterNodesResponse getClusterNodes(GetClusterNodesRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetQueueInfoResponse getQueueInfo(GetQueueInfoRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetQueueUserAclsInfoResponse getQueueUserAcls(GetQueueUserAclsInfoRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public MoveApplicationAcrossQueuesResponse moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetNewReservationResponse getNewReservation(GetNewReservationRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public ReservationSubmissionResponse submitReservation(ReservationSubmissionRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public ReservationListResponse listReservations(ReservationListRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public ReservationUpdateResponse updateReservation(ReservationUpdateRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public ReservationDeleteResponse deleteReservation(ReservationDeleteRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetNodesToLabelsResponse getNodeToLabels(GetNodesToLabelsRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetLabelsToNodesResponse getLabelsToNodes(GetLabelsToNodesRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetClusterNodeLabelsResponse getClusterNodeLabels(GetClusterNodeLabelsRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetApplicationAttemptReportResponse getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetApplicationAttemptsResponse getApplicationAttempts(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetContainerReportResponse getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetContainersResponse getContainers(GetContainersRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public FailApplicationAttemptResponse failApplicationAttempt(FailApplicationAttemptRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public UpdateApplicationPriorityResponse updateApplicationPriority(UpdateApplicationPriorityRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public UpdateApplicationTimeoutsResponse updateApplicationTimeouts(UpdateApplicationTimeoutsRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetAllResourceProfilesResponse getResourceProfiles(GetAllResourceProfilesRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetResourceProfileResponse getResourceProfile(GetResourceProfileRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetAllResourceTypeInfoResponse getResourceTypeInfo(GetAllResourceTypeInfoRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
        super.shutdown();
    }

    public GetAttributesToNodesResponse getAttributesToNodes(GetAttributesToNodesRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetClusterNodeAttributesResponse getClusterNodeAttributes(GetClusterNodeAttributesRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }

    public GetNodesToAttributesResponse getNodesToAttributes(GetNodesToAttributesRequest request) throws YarnException, IOException {
        throw new NotImplementedException("Code is not implemented");
    }
}

