/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.clientrm;

import java.util.Collection;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;

public final class RouterYarnClientUtils {
    private RouterYarnClientUtils() {
    }

    public static GetClusterMetricsResponse merge(Collection<GetClusterMetricsResponse> responses) {
        YarnClusterMetrics tmp = YarnClusterMetrics.newInstance((int)0);
        for (GetClusterMetricsResponse response : responses) {
            YarnClusterMetrics metrics = response.getClusterMetrics();
            tmp.setNumNodeManagers(tmp.getNumNodeManagers() + metrics.getNumNodeManagers());
            tmp.setNumActiveNodeManagers(tmp.getNumActiveNodeManagers() + metrics.getNumActiveNodeManagers());
            tmp.setNumDecommissioningNodeManagers(tmp.getNumDecommissioningNodeManagers() + metrics.getNumDecommissioningNodeManagers());
            tmp.setNumDecommissionedNodeManagers(tmp.getNumDecommissionedNodeManagers() + metrics.getNumDecommissionedNodeManagers());
            tmp.setNumLostNodeManagers(tmp.getNumLostNodeManagers() + metrics.getNumLostNodeManagers());
            tmp.setNumRebootedNodeManagers(tmp.getNumRebootedNodeManagers() + metrics.getNumRebootedNodeManagers());
            tmp.setNumUnhealthyNodeManagers(tmp.getNumUnhealthyNodeManagers() + metrics.getNumUnhealthyNodeManagers());
            tmp.setNumShutdownNodeManagers(tmp.getNumShutdownNodeManagers() + metrics.getNumShutdownNodeManagers());
        }
        return GetClusterMetricsResponse.newInstance((YarnClusterMetrics)tmp);
    }
}

