/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.reader;

import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.ApplicationEntityReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.EntityTypeReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.FlowActivityEntityReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.FlowRunEntityReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.GenericEntityReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.SubApplicationEntityReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.TimelineEntityReader;

public final class TimelineEntityReaderFactory {
    private TimelineEntityReaderFactory() {
    }

    public static TimelineEntityReader createSingleEntityReader(TimelineReaderContext context, TimelineDataToRetrieve dataToRetrieve) {
        if (TimelineEntityType.YARN_APPLICATION.matches(context.getEntityType())) {
            return new ApplicationEntityReader(context, dataToRetrieve);
        }
        if (TimelineEntityType.YARN_FLOW_RUN.matches(context.getEntityType())) {
            return new FlowRunEntityReader(context, dataToRetrieve);
        }
        if (TimelineEntityType.YARN_FLOW_ACTIVITY.matches(context.getEntityType())) {
            return new FlowActivityEntityReader(context, dataToRetrieve);
        }
        return new GenericEntityReader(context, dataToRetrieve);
    }

    public static TimelineEntityReader createMultipleEntitiesReader(TimelineReaderContext context, TimelineEntityFilters filters, TimelineDataToRetrieve dataToRetrieve) {
        if (TimelineEntityType.YARN_APPLICATION.matches(context.getEntityType())) {
            return new ApplicationEntityReader(context, filters, dataToRetrieve);
        }
        if (TimelineEntityType.YARN_FLOW_ACTIVITY.matches(context.getEntityType())) {
            return new FlowActivityEntityReader(context, filters, dataToRetrieve);
        }
        if (TimelineEntityType.YARN_FLOW_RUN.matches(context.getEntityType())) {
            return new FlowRunEntityReader(context, filters, dataToRetrieve);
        }
        if (context.getDoAsUser() != null) {
            return new SubApplicationEntityReader(context, filters, dataToRetrieve);
        }
        return new GenericEntityReader(context, filters, dataToRetrieve);
    }

    public static EntityTypeReader createEntityTypeReader(TimelineReaderContext context) {
        return new EntityTypeReader(context);
    }
}

