/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.EmptyWatcher;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ReadWriteConsistencyControl;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;

public class HBaseTestingUtility {
    private static final Log LOG = LogFactory.getLog(HBaseTestingUtility.class);
    private Configuration conf;
    private MiniZooKeeperCluster zkCluster = null;
    private boolean passedZkCluster = false;
    private MiniDFSCluster dfsCluster = null;
    private MiniHBaseCluster hbaseCluster = null;
    private MiniMRCluster mrCluster = null;
    private File clusterTestBuildDir = null;
    public static final String TEST_DIRECTORY_KEY = "test.build.data";
    public static final String DEFAULT_TEST_DIRECTORY = "target/test-data";
    public static final byte[][] KEYS = new byte[][]{HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"kkk"), Bytes.toBytes((String)"lll"), Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"nnn"), Bytes.toBytes((String)"ooo"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"qqq"), Bytes.toBytes((String)"rrr"), Bytes.toBytes((String)"sss"), Bytes.toBytes((String)"ttt"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"vvv"), Bytes.toBytes((String)"www"), Bytes.toBytes((String)"xxx"), Bytes.toBytes((String)"yyy")};

    public HBaseTestingUtility() {
        this(HBaseConfiguration.create());
    }

    public HBaseTestingUtility(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public static Path getTestDir() {
        return new Path(System.getProperty(TEST_DIRECTORY_KEY, DEFAULT_TEST_DIRECTORY));
    }

    public static Path getTestDir(String subdirName) {
        return new Path(HBaseTestingUtility.getTestDir(), subdirName);
    }

    public File setupClusterTestBuildDir() {
        String randomStr = UUID.randomUUID().toString();
        String dirStr = HBaseTestingUtility.getTestDir(randomStr).toString();
        File dir = new File(dirStr).getAbsoluteFile();
        dir.deleteOnExit();
        return dir;
    }

    void isRunningCluster(String passedBuildPath) throws IOException {
        if (this.clusterTestBuildDir == null || passedBuildPath != null) {
            return;
        }
        throw new IOException("Cluster already running at " + this.clusterTestBuildDir);
    }

    public MiniDFSCluster startMiniDFSCluster(int servers) throws Exception {
        return this.startMiniDFSCluster(servers, null);
    }

    public MiniDFSCluster startMiniDFSCluster(int servers, File dir) throws Exception {
        this.clusterTestBuildDir = dir == null ? this.setupClusterTestBuildDir() : dir;
        System.setProperty(TEST_DIRECTORY_KEY, this.clusterTestBuildDir.toString());
        System.setProperty("test.cache.data", this.clusterTestBuildDir.toString());
        this.dfsCluster = new MiniDFSCluster(0, this.conf, servers, true, true, true, null, null, null, null);
        FileSystem fs = this.dfsCluster.getFileSystem();
        this.conf.set("fs.defaultFS", fs.getUri().toString());
        this.conf.set("fs.default.name", fs.getUri().toString());
        return this.dfsCluster;
    }

    public void shutdownMiniDFSCluster() throws Exception {
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
        }
    }

    public MiniZooKeeperCluster startMiniZKCluster() throws Exception {
        return this.startMiniZKCluster(this.setupClusterTestBuildDir());
    }

    private MiniZooKeeperCluster startMiniZKCluster(File dir) throws Exception {
        this.passedZkCluster = false;
        if (this.zkCluster != null) {
            throw new IOException("Cluster already running at " + dir);
        }
        this.zkCluster = new MiniZooKeeperCluster();
        int clientPort = this.zkCluster.startup(dir);
        this.conf.set("hbase.zookeeper.property.clientPort", Integer.toString(clientPort));
        return this.zkCluster;
    }

    public void shutdownMiniZKCluster() throws IOException {
        if (this.zkCluster != null) {
            this.zkCluster.shutdown();
            this.zkCluster = null;
        }
    }

    public MiniHBaseCluster startMiniCluster() throws Exception {
        return this.startMiniCluster(1, 1);
    }

    public MiniHBaseCluster startMiniCluster(int numSlaves) throws Exception {
        return this.startMiniCluster(1, numSlaves);
    }

    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves) throws Exception {
        LOG.info((Object)("Starting up minicluster with " + numMasters + " master(s) and " + numSlaves + " regionserver(s) and datanode(s)"));
        String testBuildPath = this.conf.get(TEST_DIRECTORY_KEY, null);
        this.isRunningCluster(testBuildPath);
        if (testBuildPath != null) {
            LOG.info((Object)("Using passed path: " + testBuildPath));
        }
        this.clusterTestBuildDir = testBuildPath == null ? this.setupClusterTestBuildDir() : new File(testBuildPath);
        System.setProperty(TEST_DIRECTORY_KEY, this.clusterTestBuildDir.getPath());
        this.startMiniDFSCluster(numSlaves, this.clusterTestBuildDir);
        this.dfsCluster.waitClusterUp();
        if (this.zkCluster == null) {
            this.startMiniZKCluster(this.clusterTestBuildDir);
        }
        return this.startMiniHBaseCluster(numMasters, numSlaves);
    }

    public MiniHBaseCluster startMiniHBaseCluster(int numMasters, int numSlaves) throws IOException, InterruptedException {
        this.createRootDir();
        Configuration c = new Configuration(this.conf);
        this.hbaseCluster = new MiniHBaseCluster(c, numMasters, numSlaves);
        HTable t = new HTable(c, HConstants.META_TABLE_NAME);
        ResultScanner s = t.getScanner(new Scan());
        while (s.next() != null) {
        }
        LOG.info((Object)"Minicluster is up");
        return this.hbaseCluster;
    }

    public void restartHBaseCluster(int servers) throws IOException, InterruptedException {
        this.hbaseCluster = new MiniHBaseCluster(this.conf, servers);
        HTable t = new HTable(new Configuration(this.conf), HConstants.META_TABLE_NAME);
        ResultScanner s = t.getScanner(new Scan());
        while (s.next() != null) {
        }
        LOG.info((Object)"HBase has been restarted");
    }

    public MiniHBaseCluster getMiniHBaseCluster() {
        return this.hbaseCluster;
    }

    public void shutdownMiniCluster() throws IOException {
        LOG.info((Object)"Shutting down minicluster");
        if (this.hbaseCluster != null) {
            this.hbaseCluster.shutdown();
            this.hbaseCluster.join();
        }
        if (!this.passedZkCluster) {
            this.shutdownMiniZKCluster();
        }
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
        }
        if (this.clusterTestBuildDir != null && this.clusterTestBuildDir.exists()) {
            if (!FSUtils.deleteDirectory((FileSystem)FileSystem.getLocal((Configuration)this.conf), (Path)new Path(this.clusterTestBuildDir.toString()))) {
                LOG.warn((Object)("Failed delete of " + this.clusterTestBuildDir.toString()));
            }
            this.clusterTestBuildDir = null;
        }
        LOG.info((Object)"Minicluster is down");
    }

    public Path createRootDir() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path hbaseRootdir = fs.makeQualified(fs.getHomeDirectory());
        this.conf.set("hbase.rootdir", hbaseRootdir.toString());
        fs.mkdirs(hbaseRootdir);
        FSUtils.setVersion((FileSystem)fs, (Path)hbaseRootdir);
        return hbaseRootdir;
    }

    public void flush() throws IOException {
        this.hbaseCluster.flushcache();
    }

    public void flush(byte[] tableName) throws IOException {
        this.hbaseCluster.flushcache(tableName);
    }

    public HTable createTable(byte[] tableName, byte[] family) throws IOException {
        return this.createTable(tableName, new byte[][]{family});
    }

    public HTable createTable(byte[] tableName, byte[][] families) throws IOException {
        return this.createTable(tableName, families, new Configuration(this.getConfiguration()));
    }

    public HTable createTable(byte[] tableName, byte[][] families, Configuration c) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            desc.addFamily(new HColumnDescriptor(family));
        }
        this.getHBaseAdmin().createTable(desc);
        return new HTable(c, tableName);
    }

    public HTable createTable(byte[] tableName, byte[] family, int numVersions) throws IOException {
        return this.createTable(tableName, (byte[][])new byte[][]{family}, numVersions);
    }

    public HTable createTable(byte[] tableName, byte[][] families, int numVersions) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family, numVersions, HColumnDescriptor.DEFAULT_COMPRESSION, false, true, Integer.MAX_VALUE, Integer.MAX_VALUE, HColumnDescriptor.DEFAULT_BLOOMFILTER, 0);
            desc.addFamily(hcd);
        }
        this.getHBaseAdmin().createTable(desc);
        return new HTable(new Configuration(this.getConfiguration()), tableName);
    }

    public HTable createTable(byte[] tableName, byte[][] families, int[] numVersions) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        int i = 0;
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family, numVersions[i], HColumnDescriptor.DEFAULT_COMPRESSION, false, true, Integer.MAX_VALUE, Integer.MAX_VALUE, HColumnDescriptor.DEFAULT_BLOOMFILTER, 0);
            desc.addFamily(hcd);
            ++i;
        }
        this.getHBaseAdmin().createTable(desc);
        return new HTable(new Configuration(this.getConfiguration()), tableName);
    }

    public void deleteTable(byte[] tableName) throws IOException {
        HBaseAdmin admin = new HBaseAdmin(this.getConfiguration());
        admin.disableTable(tableName);
        admin.deleteTable(tableName);
    }

    public HTable truncateTable(byte[] tableName) throws IOException {
        HTable table = new HTable(this.getConfiguration(), tableName);
        Scan scan = new Scan();
        ResultScanner resScan = table.getScanner(scan);
        for (Result res : resScan) {
            Delete del = new Delete(res.getRow());
            table.delete(del);
        }
        resScan = table.getScanner(scan);
        return table;
    }

    public int loadTable(HTable t, byte[] f) throws IOException {
        t.setAutoFlush(false);
        byte[] k = new byte[3];
        int rowCount = 0;
        for (int b1 = 97; b1 <= 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 <= 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 <= 122; b3 = (int)((byte)(b3 + 1))) {
                    k[0] = b1;
                    k[1] = b2;
                    k[2] = b3;
                    Put put = new Put(k);
                    put.add(f, null, k);
                    t.put(put);
                    ++rowCount;
                }
            }
        }
        t.flushCommits();
        return rowCount;
    }

    public int loadRegion(HRegion r, byte[] f) throws IOException {
        byte[] k = new byte[3];
        int rowCount = 0;
        for (int b1 = 97; b1 <= 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 <= 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 <= 122; b3 = (int)((byte)(b3 + 1))) {
                    k[0] = b1;
                    k[1] = b2;
                    k[2] = b3;
                    Put put = new Put(k);
                    put.add(f, null, k);
                    if (r.getLog() == null) {
                        put.setWriteToWAL(false);
                    }
                    r.put(put);
                    ++rowCount;
                }
            }
        }
        return rowCount;
    }

    public int countRows(HTable table) throws IOException {
        Scan scan = new Scan();
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            ++count;
        }
        results.close();
        return count;
    }

    public String checksumRows(HTable table) throws Exception {
        Scan scan = new Scan();
        ResultScanner results = table.getScanner(scan);
        MessageDigest digest = MessageDigest.getInstance("MD5");
        for (Result res : results) {
            digest.update(res.getRow());
        }
        results.close();
        return digest.toString();
    }

    public int createMultiRegions(HTable table, byte[] columnFamily) throws IOException {
        return this.createMultiRegions(this.getConfiguration(), table, columnFamily);
    }

    public int createMultiRegions(Configuration c, HTable table, byte[] columnFamily) throws IOException {
        return this.createMultiRegions(c, table, columnFamily, KEYS);
    }

    public int createMultiRegions(Configuration c, HTable table, byte[] family, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IOException("Must create at least 3 regions");
        }
        byte[] startKey = Bytes.toBytes((String)"aaaaa");
        byte[] endKey = Bytes.toBytes((String)"zzzzz");
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        byte[][] regionStartKeys = new byte[splitKeys.length + 1][];
        for (int i = 0; i < splitKeys.length; ++i) {
            regionStartKeys[i + 1] = splitKeys[i];
        }
        regionStartKeys[0] = HConstants.EMPTY_BYTE_ARRAY;
        return this.createMultiRegions(c, table, family, regionStartKeys);
    }

    public int createMultiRegions(Configuration c, HTable table, byte[] columnFamily, byte[][] startKeys) throws IOException {
        Arrays.sort(startKeys, Bytes.BYTES_COMPARATOR);
        HTable meta = new HTable(c, HConstants.META_TABLE_NAME);
        HTableDescriptor htd = table.getTableDescriptor();
        if (!htd.hasFamily(columnFamily)) {
            HColumnDescriptor hcd = new HColumnDescriptor(columnFamily);
            htd.addFamily(hcd);
        }
        List<byte[]> rows = this.getMetaTableRows(htd.getName());
        ArrayList<HRegionInfo> newRegions = new ArrayList<HRegionInfo>(startKeys.length);
        int count = 0;
        for (int i = 0; i < startKeys.length; ++i) {
            int j = (i + 1) % startKeys.length;
            HRegionInfo hri = new HRegionInfo(table.getTableDescriptor(), startKeys[i], startKeys[j]);
            Put put = new Put(hri.getRegionName());
            put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
            meta.put(put);
            LOG.info((Object)("createMultiRegions: inserted " + hri.toString()));
            newRegions.add(hri);
            ++count;
        }
        for (byte[] row : rows) {
            LOG.info((Object)("createMultiRegions: deleting meta row -> " + Bytes.toStringBinary((byte[])row)));
            meta.delete(new Delete(row));
        }
        HConnection conn = table.getConnection();
        conn.clearRegionCache();
        if (this.getHBaseAdmin().isTableEnabled(table.getTableName())) {
            for (HRegionInfo hri : newRegions) {
                this.hbaseCluster.getMaster().assignRegion(hri);
            }
        }
        return count;
    }

    public List<HRegionInfo> createMultiRegionsInMeta(Configuration conf, HTableDescriptor htd, byte[][] startKeys) throws IOException {
        HTable meta = new HTable(conf, HConstants.META_TABLE_NAME);
        Arrays.sort(startKeys, Bytes.BYTES_COMPARATOR);
        ArrayList<HRegionInfo> newRegions = new ArrayList<HRegionInfo>(startKeys.length);
        int count = 0;
        for (int i = 0; i < startKeys.length; ++i) {
            int j = (i + 1) % startKeys.length;
            HRegionInfo hri = new HRegionInfo(htd, startKeys[i], startKeys[j]);
            Put put = new Put(hri.getRegionName());
            put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
            meta.put(put);
            LOG.info((Object)("createMultiRegionsInMeta: inserted " + hri.toString()));
            newRegions.add(hri);
            ++count;
        }
        return newRegions;
    }

    public List<byte[]> getMetaTableRows() throws IOException {
        HTable t = new HTable(new Configuration(this.conf), HConstants.META_TABLE_NAME);
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        ResultScanner s = t.getScanner(new Scan());
        for (Result result : s) {
            LOG.info((Object)("getMetaTableRows: row -> " + Bytes.toStringBinary((byte[])result.getRow())));
            rows.add(result.getRow());
        }
        s.close();
        return rows;
    }

    public List<byte[]> getMetaTableRows(byte[] tableName) throws IOException {
        HTable t = new HTable(new Configuration(this.conf), HConstants.META_TABLE_NAME);
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        ResultScanner s = t.getScanner(new Scan());
        for (Result result : s) {
            HRegionInfo info = Writables.getHRegionInfo((byte[])result.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
            HTableDescriptor desc = info.getTableDesc();
            if (Bytes.compareTo((byte[])desc.getName(), (byte[])tableName) != 0) continue;
            LOG.info((Object)("getMetaTableRows: row -> " + Bytes.toStringBinary((byte[])result.getRow())));
            rows.add(result.getRow());
        }
        s.close();
        return rows;
    }

    public HRegionServer getRSForFirstRegionInTable(byte[] tableName) throws IOException {
        List<byte[]> metaRows = this.getMetaTableRows(tableName);
        if (metaRows == null || metaRows.size() == 0) {
            return null;
        }
        int index = this.hbaseCluster.getServerWith(metaRows.get(0));
        return this.hbaseCluster.getRegionServerThreads().get(index).getRegionServer();
    }

    public void startMiniMapReduceCluster() throws IOException {
        this.startMiniMapReduceCluster(2);
    }

    public void startMiniMapReduceCluster(int servers) throws IOException {
        LOG.info((Object)"Starting mini mapreduce cluster...");
        Configuration c = this.getConfiguration();
        System.setProperty("hadoop.log.dir", c.get("hadoop.log.dir"));
        c.set("mapred.output.dir", c.get("hadoop.tmp.dir"));
        this.mrCluster = new MiniMRCluster(servers, FileSystem.get((Configuration)c).getUri().toString(), 1);
        LOG.info((Object)"Mini mapreduce cluster started");
        c.set("mapred.job.tracker", this.mrCluster.createJobConf().get("mapred.job.tracker"));
    }

    public void shutdownMiniMapReduceCluster() {
        LOG.info((Object)"Stopping mini mapreduce cluster...");
        if (this.mrCluster != null) {
            this.mrCluster.shutdown();
        }
        this.conf.set("mapred.job.tracker", "local");
        LOG.info((Object)"Mini mapreduce cluster stopped");
    }

    public void enableDebug(Class<?> clazz) {
        Log l = LogFactory.getLog(clazz);
        if (l instanceof Log4JLogger) {
            ((Log4JLogger)l).getLogger().setLevel(org.apache.log4j.Level.DEBUG);
        } else if (l instanceof Jdk14Logger) {
            ((Jdk14Logger)l).getLogger().setLevel(Level.ALL);
        }
    }

    public void expireMasterSession() throws Exception {
        HMaster master = this.hbaseCluster.getMaster();
        this.expireSession(master.getZooKeeper(), (Server)master);
    }

    public void expireRegionServerSession(int index) throws Exception {
        HRegionServer rs = this.hbaseCluster.getRegionServer(index);
        this.expireSession(rs.getZooKeeper(), (Server)rs);
    }

    public void expireSession(ZooKeeperWatcher nodeZK, Server server) throws Exception {
        Configuration c = new Configuration(this.conf);
        String quorumServers = ZKConfig.getZKQuorumServersString((Configuration)c);
        int sessionTimeout = 5000;
        ZooKeeper zk = nodeZK.getZooKeeper();
        byte[] password = zk.getSessionPasswd();
        long sessionID = zk.getSessionId();
        ZooKeeper newZK = new ZooKeeper(quorumServers, sessionTimeout, (Watcher)EmptyWatcher.instance, sessionID, password);
        newZK.close();
        long sleep = (long)sessionTimeout * 5L;
        LOG.info((Object)("ZK Closed Session 0x" + Long.toHexString(sessionID) + "; sleeping=" + sleep));
        Thread.sleep(sleep);
        new HTable(new Configuration(this.conf), HConstants.META_TABLE_NAME);
    }

    public MiniHBaseCluster getHBaseCluster() {
        return this.hbaseCluster;
    }

    public HBaseAdmin getHBaseAdmin() throws IOException {
        return new HBaseAdmin(new Configuration(this.getConfiguration()));
    }

    public void closeRegion(String regionName) throws IOException {
        this.closeRegion(Bytes.toBytes((String)regionName));
    }

    public void closeRegion(byte[] regionName) throws IOException {
        HBaseAdmin admin = this.getHBaseAdmin();
        admin.closeRegion(regionName, null);
    }

    public void closeRegionByRow(String row, HTable table) throws IOException {
        this.closeRegionByRow(Bytes.toBytes((String)row), table);
    }

    public void closeRegionByRow(byte[] row, HTable table) throws IOException {
        HRegionLocation hrl = table.getRegionLocation(row);
        this.closeRegion(hrl.getRegionInfo().getRegionName());
    }

    public MiniZooKeeperCluster getZkCluster() {
        return this.zkCluster;
    }

    public void setZkCluster(MiniZooKeeperCluster zkCluster) {
        this.passedZkCluster = true;
        this.zkCluster = zkCluster;
    }

    public MiniDFSCluster getDFSCluster() {
        return this.dfsCluster;
    }

    public FileSystem getTestFileSystem() throws IOException {
        return FileSystem.get((Configuration)this.conf);
    }

    public boolean cleanupTestDir() throws IOException {
        return this.deleteDir(HBaseTestingUtility.getTestDir());
    }

    public boolean cleanupTestDir(String subdir) throws IOException {
        return this.deleteDir(HBaseTestingUtility.getTestDir(subdir));
    }

    public boolean deleteDir(Path dir) throws IOException {
        FileSystem fs = this.getTestFileSystem();
        if (fs.exists(dir)) {
            return fs.delete(HBaseTestingUtility.getTestDir(), true);
        }
        return false;
    }

    public void waitTableAvailable(byte[] table, long timeoutMillis) throws InterruptedException, IOException {
        HBaseAdmin admin = this.getHBaseAdmin();
        long startWait = System.currentTimeMillis();
        while (!admin.isTableAvailable(table)) {
            Assert.assertTrue((String)("Timed out waiting for table " + Bytes.toStringBinary((byte[])table)), (System.currentTimeMillis() - startWait < timeoutMillis ? 1 : 0) != 0);
            Thread.sleep(500L);
        }
    }

    public boolean ensureSomeRegionServersAvailable(int num) throws IOException {
        if (this.getHBaseCluster().getLiveRegionServerThreads().size() < num) {
            LOG.info((Object)("Started new server=" + this.getHBaseCluster().startRegionServer()));
            return true;
        }
        return false;
    }

    public static User getDifferentUser(Configuration c, String differentiatingSuffix) throws IOException {
        FileSystem currentfs = FileSystem.get((Configuration)c);
        if (!(currentfs instanceof DistributedFileSystem)) {
            return User.getCurrent();
        }
        String username = User.getCurrent().getName() + differentiatingSuffix;
        User user = User.createUserForTesting((Configuration)c, (String)username, (String[])new String[]{"supergroup"});
        return user;
    }

    public void setNameNodeNameSystemLeasePeriod(int soft, int hard) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = this.dfsCluster.getClass().getDeclaredField("nameNode");
        field.setAccessible(true);
        NameNode nn = (NameNode)field.get(this.dfsCluster);
        nn.namesystem.leaseManager.setLeasePeriod(100L, 50000L);
    }

    public static void setMaxRecoveryErrorCount(OutputStream stream, int max) {
        try {
            Class<?>[] clazzes;
            for (Class<?> clazz : clazzes = DFSClient.class.getDeclaredClasses()) {
                String className = clazz.getSimpleName();
                if (!className.equals("DFSOutputStream") || !clazz.isInstance(stream)) continue;
                Field maxRecoveryErrorCountField = stream.getClass().getDeclaredField("maxRecoveryErrorCount");
                maxRecoveryErrorCountField.setAccessible(true);
                maxRecoveryErrorCountField.setInt(stream, max);
                break;
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Could not set max recovery field", (Throwable)e);
        }
    }

    public void waitUntilAllRegionsAssigned(int countOfRegions) throws IOException {
        HTable meta = new HTable(this.getConfiguration(), HConstants.META_TABLE_NAME);
        while (true) {
            byte[] b;
            int rows = 0;
            Scan scan = new Scan();
            scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
            ResultScanner s = meta.getScanner(scan);
            Result r = null;
            while ((r = s.next()) != null && (b = r.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER)) != null && b.length > 0) {
                ++rows;
            }
            s.close();
            if (rows == countOfRegions) break;
            LOG.info((Object)("Found=" + rows));
            Threads.sleep((int)1000);
        }
    }

    public static List<KeyValue> getFromStoreFile(Store store, Get get) throws IOException {
        KeyValue kv;
        ReadWriteConsistencyControl.resetThreadReadPoint();
        Scan scan = new Scan(get);
        InternalScanner scanner = (InternalScanner)store.getScanner(scan, (NavigableSet)scan.getFamilyMap().get(store.getFamily().getName()));
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        scanner.next(result);
        if (!result.isEmpty() && !Bytes.equals((byte[])(kv = (KeyValue)result.get(0)).getRow(), (byte[])get.getRow())) {
            result.clear();
        }
        return result;
    }

    public static List<KeyValue> getFromStoreFile(Store store, byte[] row, NavigableSet<byte[]> columns) throws IOException {
        Get get = new Get(row);
        Map s = get.getFamilyMap();
        s.put(store.getFamily().getName(), columns);
        return HBaseTestingUtility.getFromStoreFile(store, get);
    }
}

