/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HMsg;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.io.MapWritable;
import org.apache.zookeeper.KeeperException;

public class MiniHBaseCluster {
    static final Log LOG = LogFactory.getLog((String)MiniHBaseCluster.class.getName());
    private Configuration conf;
    public LocalHBaseCluster hbaseCluster;
    private static int index;

    public MiniHBaseCluster(Configuration conf, int numRegionServers) throws IOException, InterruptedException {
        this(conf, 1, numRegionServers);
    }

    public MiniHBaseCluster(Configuration conf, int numMasters, int numRegionServers) throws IOException, InterruptedException {
        this.conf = conf;
        conf.set("hbase.master.port", "0");
        this.init(numMasters, numRegionServers);
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    private void init(int nMasterNodes, int nRegionNodes) throws IOException, InterruptedException {
        try {
            this.hbaseCluster = new LocalHBaseCluster(this.conf, nMasterNodes, 0, MiniHBaseClusterMaster.class, MiniHBaseClusterRegionServer.class);
            for (int i = 0; i < nRegionNodes; ++i) {
                Configuration rsConf = HBaseConfiguration.create((Configuration)this.conf);
                User user = HBaseTestingUtility.getDifferentUser(rsConf, ".hfs." + index++);
                this.hbaseCluster.addRegionServer(rsConf, i, user);
            }
            this.hbaseCluster.startup();
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
        catch (Throwable t) {
            LOG.error((Object)"Error starting cluster", t);
            this.shutdown();
            throw new IOException("Shutting down", t);
        }
    }

    public JVMClusterUtil.RegionServerThread startRegionServer() throws IOException {
        Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        User rsUser = HBaseTestingUtility.getDifferentUser(newConf, ".hfs." + index++);
        JVMClusterUtil.RegionServerThread t = null;
        try {
            t = this.hbaseCluster.addRegionServer(newConf, this.hbaseCluster.getRegionServers().size(), rsUser);
            t.start();
            t.waitForServerOnline();
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted executing UserGroupInformation.doAs()", ie);
        }
        return t;
    }

    public String abortRegionServer(int serverNumber) {
        HRegionServer server = this.getRegionServer(serverNumber);
        LOG.info((Object)("Aborting " + server.toString()));
        server.abort("Aborting for tests", (Throwable)new Exception("Trace info"));
        return server.toString();
    }

    public JVMClusterUtil.RegionServerThread stopRegionServer(int serverNumber) {
        return this.stopRegionServer(serverNumber, true);
    }

    public JVMClusterUtil.RegionServerThread stopRegionServer(int serverNumber, boolean shutdownFS) {
        JVMClusterUtil.RegionServerThread server = (JVMClusterUtil.RegionServerThread)this.hbaseCluster.getRegionServers().get(serverNumber);
        LOG.info((Object)("Stopping " + server.toString()));
        server.getRegionServer().stop("Stopping rs " + serverNumber);
        return server;
    }

    public String waitOnRegionServer(int serverNumber) {
        return this.hbaseCluster.waitOnRegionServer(serverNumber);
    }

    public JVMClusterUtil.MasterThread startMaster() throws IOException {
        Configuration c = HBaseConfiguration.create((Configuration)this.conf);
        User user = HBaseTestingUtility.getDifferentUser(c, ".hfs." + index++);
        JVMClusterUtil.MasterThread t = null;
        try {
            t = this.hbaseCluster.addMaster(c, this.hbaseCluster.getMasters().size(), user);
            t.start();
            t.waitForServerOnline();
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted executing UserGroupInformation.doAs()", ie);
        }
        return t;
    }

    public HServerAddress getHMasterAddress() {
        return this.hbaseCluster.getActiveMaster().getMasterAddress();
    }

    public HMaster getMaster() {
        return this.hbaseCluster.getActiveMaster();
    }

    public HMaster getMaster(int serverNumber) {
        return this.hbaseCluster.getMaster(serverNumber);
    }

    public String abortMaster(int serverNumber) {
        HMaster server = this.getMaster(serverNumber);
        LOG.info((Object)("Aborting " + server.toString()));
        server.abort("Aborting for tests", (Throwable)new Exception("Trace info"));
        return server.toString();
    }

    public JVMClusterUtil.MasterThread stopMaster(int serverNumber) {
        return this.stopMaster(serverNumber, true);
    }

    public JVMClusterUtil.MasterThread stopMaster(int serverNumber, boolean shutdownFS) {
        JVMClusterUtil.MasterThread server = (JVMClusterUtil.MasterThread)this.hbaseCluster.getMasters().get(serverNumber);
        LOG.info((Object)("Stopping " + server.toString()));
        server.getMaster().stop("Stopping master " + serverNumber);
        return server;
    }

    public String waitOnMaster(int serverNumber) {
        return this.hbaseCluster.waitOnMaster(serverNumber);
    }

    public boolean waitForActiveAndReadyMaster() throws InterruptedException {
        List<JVMClusterUtil.MasterThread> mts;
        while ((mts = this.getMasterThreads()).size() > 0) {
            for (JVMClusterUtil.MasterThread mt : mts) {
                if (!mt.getMaster().isActiveMaster() || !mt.getMaster().isInitialized()) continue;
                return true;
            }
            Thread.sleep(200L);
        }
        return false;
    }

    public List<JVMClusterUtil.MasterThread> getMasterThreads() {
        return this.hbaseCluster.getMasters();
    }

    public List<JVMClusterUtil.MasterThread> getLiveMasterThreads() {
        return this.hbaseCluster.getLiveMasters();
    }

    public void join() {
        this.hbaseCluster.join();
    }

    public void shutdown() throws IOException {
        if (this.hbaseCluster != null) {
            this.hbaseCluster.shutdown();
        }
        HConnectionManager.deleteAllConnections((boolean)false);
    }

    public void flushcache() throws IOException {
        for (JVMClusterUtil.RegionServerThread t : this.hbaseCluster.getRegionServers()) {
            for (HRegion r : t.getRegionServer().getOnlineRegionsLocalContext()) {
                r.flushcache();
            }
        }
    }

    public void flushcache(byte[] tableName) throws IOException {
        for (JVMClusterUtil.RegionServerThread t : this.hbaseCluster.getRegionServers()) {
            for (HRegion r : t.getRegionServer().getOnlineRegionsLocalContext()) {
                if (!Bytes.equals((byte[])r.getTableDesc().getName(), (byte[])tableName)) continue;
                r.flushcache();
            }
        }
    }

    public List<JVMClusterUtil.RegionServerThread> getRegionServerThreads() {
        return this.hbaseCluster.getRegionServers();
    }

    public List<JVMClusterUtil.RegionServerThread> getLiveRegionServerThreads() {
        return this.hbaseCluster.getLiveRegionServers();
    }

    public HRegionServer getRegionServer(int serverNumber) {
        return this.hbaseCluster.getRegionServer(serverNumber);
    }

    public List<HRegion> getRegions(byte[] tableName) {
        ArrayList<HRegion> ret = new ArrayList<HRegion>();
        for (JVMClusterUtil.RegionServerThread rst : this.getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            for (HRegion region : hrs.getOnlineRegionsLocalContext()) {
                if (!Bytes.equals((byte[])region.getTableDesc().getName(), (byte[])tableName)) continue;
                ret.add(region);
            }
        }
        return ret;
    }

    public int getServerWithMeta() {
        return this.getServerWith(HRegionInfo.FIRST_META_REGIONINFO.getRegionName());
    }

    public int getServerWith(byte[] regionName) {
        int index = -1;
        int count = 0;
        for (JVMClusterUtil.RegionServerThread rst : this.getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            HRegion metaRegion = hrs.getOnlineRegion(regionName);
            if (metaRegion != null) {
                index = count;
                break;
            }
            ++count;
        }
        return index;
    }

    public void addExceptionToSendRegionServer(int serverNumber, IOException ex) throws IOException {
        MiniHBaseClusterRegionServer hrs = (MiniHBaseClusterRegionServer)this.getRegionServer(serverNumber);
        this.addExceptionToSendRegionServer(hrs, ex);
    }

    public void addExceptionToSendRegionServer(MiniHBaseClusterRegionServer hrs, IOException ex) throws IOException {
        ((MiniHBaseClusterMaster)this.getMaster()).addException(hrs.getHServerInfo(), ex);
    }

    public void addMessageToSendRegionServer(int serverNumber, HMsg msg) throws IOException {
        MiniHBaseClusterRegionServer hrs = (MiniHBaseClusterRegionServer)this.getRegionServer(serverNumber);
        this.addMessageToSendRegionServer(hrs, msg);
    }

    public void addMessageToSendRegionServer(MiniHBaseClusterRegionServer hrs, HMsg msg) throws IOException {
        ((MiniHBaseClusterMaster)this.getMaster()).addMessage(hrs.getHServerInfo(), msg);
    }

    public long countServedRegions() {
        long count = 0L;
        for (JVMClusterUtil.RegionServerThread rst : this.getLiveRegionServerThreads()) {
            count += (long)rst.getRegionServer().getNumberOfOnlineRegions();
        }
        return count;
    }

    static class SingleFileSystemShutdownThread
    extends Thread {
        private final FileSystem fs;

        SingleFileSystemShutdownThread(FileSystem fs) {
            super("Shutdown of " + fs);
            this.fs = fs;
        }

        @Override
        public void run() {
            try {
                LOG.info((Object)("Hook closing fs=" + this.fs));
                this.fs.close();
            }
            catch (NullPointerException npe) {
                LOG.debug((Object)("Need to fix these: " + npe.toString()));
            }
            catch (IOException e) {
                LOG.warn((Object)"Running hook", (Throwable)e);
            }
        }
    }

    public static class MiniHBaseClusterRegionServer
    extends HRegionServer {
        private Thread shutdownThread = null;
        private User user = User.getCurrent();

        public MiniHBaseClusterRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        public void setHServerInfo(HServerInfo hsi) {
            this.serverInfo = hsi;
        }

        protected void handleReportForDutyResponse(MapWritable c) throws IOException {
            super.handleReportForDutyResponse(c);
            this.shutdownThread = new SingleFileSystemShutdownThread(this.getFileSystem());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.user.runAs((PrivilegedAction)new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        MiniHBaseClusterRegionServer.this.runRegionServer();
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                LOG.error((Object)"Exception in run", t);
            }
            finally {
                if (this.shutdownThread != null) {
                    this.shutdownThread.start();
                    Threads.shutdown((Thread)this.shutdownThread, (long)30000L);
                }
            }
        }

        private void runRegionServer() {
            super.run();
        }

        public void kill() {
            super.kill();
        }

        public void abort(final String reason, final Throwable cause) {
            this.user.runAs((PrivilegedAction)new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    MiniHBaseClusterRegionServer.this.abortRegionServer(reason, cause);
                    return null;
                }
            });
        }

        private void abortRegionServer(String reason, Throwable cause) {
            super.abort(reason, cause);
        }
    }

    public static class MiniHBaseClusterMaster
    extends HMaster {
        private final Map<HServerInfo, List<HMsg>> messages = new ConcurrentHashMap<HServerInfo, List<HMsg>>();
        private final Map<HServerInfo, IOException> exceptions = new ConcurrentHashMap<HServerInfo, IOException>();

        public MiniHBaseClusterMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addMessage(HServerInfo hsi, HMsg msg) {
            Map<HServerInfo, List<HMsg>> map = this.messages;
            synchronized (map) {
                List<HMsg> hmsgs = this.messages.get(hsi);
                if (hmsgs == null) {
                    hmsgs = new ArrayList<HMsg>();
                    this.messages.put(hsi, hmsgs);
                }
                hmsgs.add(msg);
            }
        }

        void addException(HServerInfo hsi, IOException ex) {
            this.exceptions.put(hsi, ex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HMsg[] adornRegionServerAnswer(HServerInfo hsi, HMsg[] msgs) throws IOException {
            IOException ex = this.exceptions.remove(hsi);
            if (ex != null) {
                throw ex;
            }
            HMsg[] answerMsgs = msgs;
            Map<HServerInfo, List<HMsg>> map = this.messages;
            synchronized (map) {
                List<HMsg> hmsgs = this.messages.get(hsi);
                if (hmsgs != null && !hmsgs.isEmpty()) {
                    int size = answerMsgs.length;
                    HMsg[] newAnswerMsgs = new HMsg[size + hmsgs.size()];
                    System.arraycopy(answerMsgs, 0, newAnswerMsgs, 0, answerMsgs.length);
                    for (int i = 0; i < hmsgs.size(); ++i) {
                        newAnswerMsgs[answerMsgs.length + i] = hmsgs.get(i);
                    }
                    answerMsgs = newAnswerMsgs;
                    hmsgs.clear();
                }
            }
            return super.adornRegionServerAnswer(hsi, answerMsgs);
        }
    }
}

