/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;

public class MultiRegionTable
extends HBaseClusterTestCase {
    protected static final byte[][] KEYS = new byte[][]{HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"kkk"), Bytes.toBytes((String)"lll"), Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"nnn"), Bytes.toBytes((String)"ooo"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"qqq"), Bytes.toBytes((String)"rrr"), Bytes.toBytes((String)"sss"), Bytes.toBytes((String)"ttt"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"vvv"), Bytes.toBytes((String)"www"), Bytes.toBytes((String)"xxx"), Bytes.toBytes((String)"yyy")};
    protected final byte[] columnFamily;
    protected HTableDescriptor desc;

    public MultiRegionTable(String familyName) {
        this(1, familyName);
    }

    public MultiRegionTable(int nServers, String familyName) {
        super(nServers);
        this.columnFamily = Bytes.toBytes((String)familyName);
        System.setProperty("hadoop.log.dir", this.conf.get("hadoop.log.dir"));
        this.conf.set("mapred.output.dir", this.conf.get("hadoop.tmp.dir"));
    }

    @Override
    protected void preHBaseClusterSetup() throws Exception {
        try {
            int i;
            HRegion[] regions = new HRegion[KEYS.length];
            for (i = 0; i < regions.length; ++i) {
                int j = (i + 1) % regions.length;
                regions[i] = this.createARegion(KEYS[i], KEYS[j]);
            }
            this.createRootAndMetaRegions();
            for (i = 0; i < regions.length; ++i) {
                HRegion.addRegionToMETA((HRegion)this.meta, (HRegion)regions[i]);
            }
            this.closeRootAndMeta();
        }
        catch (Exception e) {
            MultiRegionTable.shutdownDfs(this.dfsCluster);
            throw e;
        }
    }

    private HRegion createARegion(byte[] startKey, byte[] endKey) throws IOException {
        HRegion region = this.createNewHRegion(this.desc, startKey, endKey);
        MultiRegionTable.addContent(region, this.columnFamily);
        this.closeRegionAndDeleteLog(region);
        return region;
    }

    private void closeRegionAndDeleteLog(HRegion region) throws IOException {
        region.close();
        region.getLog().closeAndDelete();
    }
}

