/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHBaseTestingUtility {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private HBaseTestingUtility hbt;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.hbt = new HBaseTestingUtility();
        this.hbt.cleanupTestDir();
    }

    @After
    public void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void multiClusters() throws Exception {
        HBaseTestingUtility htu1 = new HBaseTestingUtility();
        htu1.getConfiguration().set("zookeeper.znode.parent", "/1");
        htu1.startMiniZKCluster();
        HBaseTestingUtility htu2 = new HBaseTestingUtility();
        htu2.getConfiguration().set("zookeeper.znode.parent", "/2");
        htu2.setZkCluster(htu1.getZkCluster());
        HBaseTestingUtility htu3 = new HBaseTestingUtility();
        htu3.getConfiguration().set("zookeeper.znode.parent", "/3");
        htu3.setZkCluster(htu1.getZkCluster());
        try {
            htu1.startMiniCluster();
            htu2.startMiniCluster();
            htu3.startMiniCluster();
            byte[] TABLE_NAME = Bytes.toBytes((String)"test");
            byte[] FAM_NAME = Bytes.toBytes((String)"fam");
            byte[] ROW = Bytes.toBytes((String)"row");
            byte[] QUAL_NAME = Bytes.toBytes((String)"qual");
            byte[] VALUE = Bytes.toBytes((String)"value");
            HTable table1 = htu1.createTable(TABLE_NAME, FAM_NAME);
            HTable table2 = htu2.createTable(TABLE_NAME, FAM_NAME);
            Put put = new Put(ROW);
            put.add(FAM_NAME, QUAL_NAME, VALUE);
            table1.put(put);
            Get get = new Get(ROW);
            get.addColumn(FAM_NAME, QUAL_NAME);
            Result res = table1.get(get);
            Assert.assertEquals((long)1L, (long)res.size());
            res = table2.get(get);
            Assert.assertEquals((long)0L, (long)res.size());
        }
        finally {
            htu3.shutdownMiniCluster();
            htu2.shutdownMiniCluster();
            htu1.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniCluster() throws Exception {
        MiniHBaseCluster cluster = this.hbt.startMiniCluster();
        try {
            Assert.assertEquals((long)1L, (long)cluster.getLiveRegionServerThreads().size());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniDFSCluster() throws Exception {
        MiniDFSCluster cluster = this.hbt.startMiniDFSCluster(1);
        FileSystem dfs = cluster.getFileSystem();
        Path dir = new Path("dir");
        Path qualifiedDir = dfs.makeQualified(dir);
        this.LOG.info((Object)("dir=" + dir + ", qualifiedDir=" + qualifiedDir));
        Assert.assertFalse((boolean)dfs.exists(qualifiedDir));
        Assert.assertTrue((boolean)dfs.mkdirs(qualifiedDir));
        Assert.assertTrue((boolean)dfs.delete(qualifiedDir, true));
        cluster.shutdown();
    }

    @Test
    public void testSetupClusterTestBuildDir() {
        File testdir = this.hbt.setupClusterTestBuildDir();
        this.LOG.info((Object)("uuid-subdir=" + testdir));
        Assert.assertFalse((boolean)testdir.exists());
        Assert.assertTrue((boolean)testdir.mkdirs());
        Assert.assertTrue((boolean)testdir.exists());
    }

    @Test
    public void testTestDir() throws IOException {
        Path testdir = HBaseTestingUtility.getTestDir();
        this.LOG.info((Object)("testdir=" + testdir));
        FileSystem fs = this.hbt.getTestFileSystem();
        Assert.assertTrue((!fs.exists(testdir) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.mkdirs(testdir));
        Assert.assertTrue((boolean)this.hbt.cleanupTestDir());
    }
}

