/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.HMsg;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

public class TestHMsg
extends TestCase {
    public void testList() {
        ArrayList<HMsg> msgs = new ArrayList<HMsg>();
        HMsg hmsg = null;
        int size = 10;
        for (int i = 0; i < 10; ++i) {
            byte[] b = Bytes.toBytes((int)i);
            hmsg = new HMsg(HMsg.Type.STOP_REGIONSERVER, new HRegionInfo(new HTableDescriptor(Bytes.toBytes((String)"test")), b, b));
            msgs.add(hmsg);
        }
        TestHMsg.assertEquals((int)10, (int)msgs.size());
        int index = msgs.indexOf(hmsg);
        TestHMsg.assertNotSame((Object)-1, (Object)index);
        msgs.remove(index);
        TestHMsg.assertEquals((int)9, (int)msgs.size());
        byte[] other = Bytes.toBytes((String)"other");
        hmsg = new HMsg(HMsg.Type.STOP_REGIONSERVER, new HRegionInfo(new HTableDescriptor(Bytes.toBytes((String)"test")), other, other));
        TestHMsg.assertEquals((int)-1, (int)msgs.indexOf(hmsg));
        byte[] b = Bytes.toBytes((int)1);
        hmsg = new HMsg(HMsg.Type.STOP_REGIONSERVER, new HRegionInfo(new HTableDescriptor(Bytes.toBytes((String)"test")), b, b));
        TestHMsg.assertNotSame((Object)-1, (Object)msgs.indexOf(hmsg));
    }

    public void testSerialization() throws IOException {
        byte[] abytes = Bytes.toBytes((String)"a");
        byte[] bbytes = Bytes.toBytes((String)"b");
        byte[] parentbytes = Bytes.toBytes((String)"parent");
        HRegionInfo parent = new HRegionInfo(new HTableDescriptor(Bytes.toBytes((String)"parent")), parentbytes, parentbytes);
        HMsg hmsg = new HMsg(HMsg.Type.STOP_REGIONSERVER, parent);
        byte[] bytes = Writables.getBytes((Writable)hmsg);
        HMsg close = (HMsg)Writables.getWritable((byte[])bytes, (Writable)new HMsg());
        TestHMsg.assertTrue((boolean)close.equals((Object)hmsg));
        HRegionInfo daughtera = new HRegionInfo(new HTableDescriptor(Bytes.toBytes((String)"a")), abytes, abytes);
        HRegionInfo daughterb = new HRegionInfo(new HTableDescriptor(Bytes.toBytes((String)"b")), bbytes, bbytes);
        HMsg splithmsg = new HMsg(HMsg.Type.REGION_SPLIT, parent, daughtera, daughterb, Bytes.toBytes((String)"REGION_SPLIT"));
        bytes = Writables.getBytes((Writable)splithmsg);
        hmsg = (HMsg)Writables.getWritable((byte[])bytes, (Writable)new HMsg());
        TestHMsg.assertTrue((boolean)splithmsg.equals((Object)hmsg));
    }
}

