/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.client.HTable;

public class TestInfoServers
extends HBaseClusterTestCase {
    static final Log LOG = LogFactory.getLog(TestInfoServers.class);

    @Override
    protected void preHBaseClusterSetup() {
        this.conf.setInt("hbase.master.info.port", 0);
        this.conf.setInt("hbase.regionserver.info.port", 0);
    }

    public void testInfoServersAreUp() throws Exception {
        new HTable(this.conf, ".META.");
        int port = this.cluster.getMaster().getInfoServer().getPort();
        this.assertHasExpectedContent(new URL("http://localhost:" + port + "/index.html"), "master");
        port = this.cluster.getRegionServerThreads().get(0).getRegionServer().getInfoServer().getPort();
        this.assertHasExpectedContent(new URL("http://localhost:" + port + "/index.html"), "regionserver");
    }

    private void assertHasExpectedContent(URL u, String expected) throws IOException {
        LOG.info((Object)("Testing " + u.toString() + " has " + expected));
        URLConnection c = u.openConnection();
        c.connect();
        TestInfoServers.assertTrue((c.getContentLength() > 0 ? 1 : 0) != 0);
        StringBuilder sb = new StringBuilder(c.getContentLength());
        BufferedInputStream bis = new BufferedInputStream(c.getInputStream());
        byte[] bytes = new byte[1024];
        int read = -1;
        while ((read = bis.read(bytes)) != -1) {
            sb.append(new String(bytes, 0, read));
        }
        bis.close();
        String content = sb.toString();
        TestInfoServers.assertTrue((boolean)content.contains(expected));
    }
}

