/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAdmin {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private HBaseAdmin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
    }

    @Test
    public void testDisableAndEnableTable() throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        byte[] table = Bytes.toBytes((String)"testDisableAndEnableTable");
        HTable ht = TEST_UTIL.createTable(table, HConstants.CATALOG_FAMILY);
        Put put = new Put(row);
        put.add(HConstants.CATALOG_FAMILY, qualifier, value);
        ht.put(put);
        Get get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        ht.get(get);
        this.admin.disableTable(table);
        get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        boolean ok = false;
        try {
            ht.get(get);
        }
        catch (NotServingRegionException e) {
            ok = true;
        }
        catch (RetriesExhaustedException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        this.admin.enableTable(table);
        try {
            ht.get(get);
        }
        catch (RetriesExhaustedException e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
    }

    @Test
    public void testCreateTable() throws IOException {
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TEST_UTIL.createTable(Bytes.toBytes((String)"testCreateTable"), HConstants.CATALOG_FAMILY);
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
    }

    @Test
    public void testGetTableDescriptor() throws IOException {
        HColumnDescriptor fam1 = new HColumnDescriptor("fam1");
        HColumnDescriptor fam2 = new HColumnDescriptor("fam2");
        HColumnDescriptor fam3 = new HColumnDescriptor("fam3");
        HTableDescriptor htd = new HTableDescriptor("myTestTable");
        htd.addFamily(fam1);
        htd.addFamily(fam2);
        htd.addFamily(fam3);
        this.admin.createTable(htd);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), "myTestTable");
        HTableDescriptor confirmedHtd = table.getTableDescriptor();
        Assert.assertEquals((long)htd.compareTo(confirmedHtd), (long)0L);
    }

    @Test
    public void testChangeTableSchema() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"changeTableSchema");
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY);
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
        HTableDescriptor htd = this.admin.getTableDescriptor(tableName);
        HTableDescriptor copy = new HTableDescriptor(htd);
        Assert.assertTrue((boolean)htd.equals((Object)copy));
        long newFlushSize = htd.getMemStoreFlushSize() / 2L;
        copy.setMemStoreFlushSize(newFlushSize);
        String key = "anyoldkey";
        Assert.assertTrue((htd.getValue("anyoldkey") == null ? 1 : 0) != 0);
        copy.setValue("anyoldkey", "anyoldkey");
        boolean expectedException = false;
        try {
            this.admin.modifyTable(tableName, copy);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertTrue((boolean)expectedException);
        this.admin.disableTable(tableName);
        Assert.assertTrue((boolean)this.admin.isTableDisabled(tableName));
        this.modifyTable(tableName, copy);
        HTableDescriptor modifiedHtd = this.admin.getTableDescriptor(tableName);
        Assert.assertFalse((boolean)htd.equals((Object)modifiedHtd));
        Assert.assertTrue((boolean)copy.equals((Object)modifiedHtd));
        Assert.assertEquals((long)newFlushSize, (long)modifiedHtd.getMemStoreFlushSize());
        Assert.assertEquals((Object)"anyoldkey", (Object)modifiedHtd.getValue("anyoldkey"));
        this.admin.enableTable(tableName);
        Assert.assertFalse((boolean)this.admin.isTableDisabled(tableName));
        int countOfFamilies = modifiedHtd.getFamilies().size();
        Assert.assertTrue((countOfFamilies > 0 ? 1 : 0) != 0);
        HColumnDescriptor hcd = (HColumnDescriptor)modifiedHtd.getFamilies().iterator().next();
        int maxversions = hcd.getMaxVersions();
        int newMaxVersions = maxversions + 1;
        hcd.setMaxVersions(newMaxVersions);
        byte[] hcdName = hcd.getName();
        expectedException = false;
        try {
            this.admin.modifyColumn(tableName, hcd);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertTrue((boolean)expectedException);
        this.admin.disableTable(tableName);
        Assert.assertTrue((boolean)this.admin.isTableDisabled(tableName));
        this.admin.modifyColumn(tableName, hcd);
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        HColumnDescriptor modifiedHcd = modifiedHtd.getFamily(hcdName);
        Assert.assertEquals((long)newMaxVersions, (long)modifiedHcd.getMaxVersions());
        this.admin.enableTable(tableName);
        Assert.assertFalse((boolean)this.admin.isTableDisabled(tableName));
        String xtracolName = "xtracol";
        HColumnDescriptor xtracol = new HColumnDescriptor("xtracol");
        xtracol.setValue("xtracol", "xtracol");
        try {
            this.admin.addColumn(tableName, xtracol);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertTrue((boolean)expectedException);
        this.admin.disableTable(tableName);
        Assert.assertTrue((boolean)this.admin.isTableDisabled(tableName));
        this.admin.addColumn(tableName, xtracol);
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        hcd = modifiedHtd.getFamily(xtracol.getName());
        Assert.assertTrue((hcd != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)hcd.getValue("xtracol").equals("xtracol"));
        this.admin.deleteColumn(tableName, xtracol.getName());
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        hcd = modifiedHtd.getFamily(xtracol.getName());
        Assert.assertTrue((hcd == null ? 1 : 0) != 0);
        this.admin.deleteTable(tableName);
        this.admin.listTables();
        Assert.assertFalse((boolean)this.admin.tableExists(tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        HMaster services = TEST_UTIL.getMiniHBaseCluster().getMaster();
        ExecutorService executor = services.getExecutorService();
        AtomicBoolean done = new AtomicBoolean(false);
        executor.registerListener(EventHandler.EventType.C_M_MODIFY_TABLE, (EventHandler.EventHandlerListener)new DoneListener(done));
        this.admin.modifyTable(tableName, htd);
        while (!done.get()) {
            AtomicBoolean atomicBoolean = done;
            synchronized (atomicBoolean) {
                try {
                    done.wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        executor.unregisterListener(EventHandler.EventType.C_M_MODIFY_TABLE);
    }

    @Test
    public void testCreateTableWithRegions() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes((String)"testCreateTableWithRegions");
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, (byte[][])splitKeys);
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        Map regions = ht.getRegionsInfo();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        Iterator hris = regions.keySet().iterator();
        HRegionInfo hri = (HRegionInfo)hris.next();
        Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[0]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[0]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[1]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[1]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[2]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[2]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[3]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[3]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[4]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[5]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[5]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[6]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[6]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[7]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[7]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[8]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[8]));
        Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
        byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
        expectedRegions = 10;
        byte[] TABLE_2 = Bytes.add((byte[])tableName, (byte[])Bytes.toBytes((String)"_2"));
        desc = new HTableDescriptor(TABLE_2);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        this.admin.createTable(desc, startKey, endKey, expectedRegions);
        ht = new HTable(TEST_UTIL.getConfiguration(), TABLE_2);
        regions = ht.getRegionsInfo();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        hris = regions.keySet().iterator();
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
        Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
        startKey = new byte[]{0, 0, 0, 0, 0, 0};
        endKey = new byte[]{1, 0, 0, 0, 0, 0};
        expectedRegions = 5;
        byte[] TABLE_3 = Bytes.add((byte[])tableName, (byte[])Bytes.toBytes((String)"_3"));
        desc = new HTableDescriptor(TABLE_3);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        this.admin.createTable(desc, startKey, endKey, expectedRegions);
        ht = new HTable(TEST_UTIL.getConfiguration(), TABLE_3);
        regions = ht.getRegionsInfo();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {2, 2, 2}};
        byte[] TABLE_4 = Bytes.add((byte[])tableName, (byte[])Bytes.toBytes((String)"_4"));
        desc = new HTableDescriptor(TABLE_4);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        try {
            this.admin.createTable(desc, (byte[][])splitKeys);
            Assert.assertTrue((String)"Should not be able to create this table because of duplicate split keys", (boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }

    @Test
    public void testTableExist() throws IOException {
        byte[] table = Bytes.toBytes((String)"testTableExist");
        boolean exist = false;
        exist = this.admin.tableExists(table);
        Assert.assertEquals((Object)false, (Object)exist);
        TEST_UTIL.createTable(table, HConstants.CATALOG_FAMILY);
        exist = this.admin.tableExists(table);
        Assert.assertEquals((Object)true, (Object)exist);
    }

    @Test
    public void testForceSplit() throws Exception {
        byte[] familyName = HConstants.CATALOG_FAMILY;
        byte[] tableName = Bytes.toBytes((String)"testForceSplit");
        final HTable table = TEST_UTIL.createTable(tableName, familyName);
        byte[] k = new byte[3];
        int rowCount = 0;
        for (int b1 = 97; b1 < 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 < 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 < 122; b3 = (int)((byte)(b3 + 1))) {
                    k[0] = b1;
                    k[1] = b2;
                    k[2] = b3;
                    Put put = new Put(k);
                    put.add(familyName, new byte[0], k);
                    table.put(put);
                    ++rowCount;
                }
            }
        }
        Map m = table.getRegionsInfo();
        System.out.println("Initial regions (" + m.size() + "): " + m);
        Assert.assertTrue((m.size() == 1 ? 1 : 0) != 0);
        Scan scan = new Scan();
        ResultScanner scanner = table.getScanner(scan);
        int rows = 0;
        for (Result result : scanner) {
            ++rows;
        }
        scanner.close();
        Assert.assertEquals((long)rowCount, (long)rows);
        scan = new Scan();
        scanner = table.getScanner(scan);
        scanner.next();
        final AtomicInteger count = new AtomicInteger(0);
        Thread t = new Thread("CheckForSplit"){

            @Override
            public void run() {
                for (int i = 0; i < 20; ++i) {
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    Map regions = null;
                    try {
                        regions = table.getRegionsInfo();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (regions == null) continue;
                    count.set(regions.size());
                    if (count.get() >= 2) break;
                    TestAdmin.this.LOG.debug((Object)"Cycle waiting on split");
                }
            }
        };
        t.start();
        this.admin.split(Bytes.toString((byte[])tableName));
        t.join();
        rows = 1;
        for (Result result : scanner) {
            if (++rows <= rowCount) continue;
            scanner.close();
            Assert.assertTrue((String)("Scanned more than expected (" + rowCount + ")"), (boolean)false);
        }
        scanner.close();
        Assert.assertEquals((long)rowCount, (long)rows);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyHHTableDescriptor() throws IOException {
        this.admin.createTable(new HTableDescriptor());
    }

    @Test
    public void testEnableDisableAddColumnDeleteColumn() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testMasterAdmin");
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY);
        this.admin.disableTable(tableName);
        try {
            new HTable(TEST_UTIL.getConfiguration(), tableName);
        }
        catch (RegionOfflineException e) {
            // empty catch block
        }
        this.admin.addColumn(tableName, new HColumnDescriptor("col2"));
        this.admin.enableTable(tableName);
        try {
            this.admin.deleteColumn(tableName, Bytes.toBytes((String)"col2"));
        }
        catch (TableNotDisabledException tableNotDisabledException) {
            // empty catch block
        }
        this.admin.disableTable(tableName);
        this.admin.deleteColumn(tableName, Bytes.toBytes((String)"col2"));
        this.admin.deleteTable(tableName);
    }

    @Test
    public void testCreateBadTables() throws IOException {
        int i;
        String msg = null;
        try {
            this.admin.createTable(HTableDescriptor.ROOT_TABLEDESC);
        }
        catch (IllegalArgumentException e) {
            msg = e.toString();
        }
        Assert.assertTrue((String)("Unexcepted exception message " + msg), (msg != null && msg.startsWith(IllegalArgumentException.class.getName()) && msg.contains(HTableDescriptor.ROOT_TABLEDESC.getNameAsString()) ? 1 : 0) != 0);
        msg = null;
        try {
            this.admin.createTable(HTableDescriptor.META_TABLEDESC);
        }
        catch (IllegalArgumentException e) {
            msg = e.toString();
        }
        Assert.assertTrue((String)("Unexcepted exception message " + msg), (msg != null && msg.startsWith(IllegalArgumentException.class.getName()) && msg.contains(HTableDescriptor.META_TABLEDESC.getNameAsString()) ? 1 : 0) != 0);
        final HTableDescriptor threadDesc = new HTableDescriptor("threaded_testCreateBadTables");
        threadDesc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        int count = 10;
        Thread[] threads = new Thread[count];
        final AtomicInteger successes = new AtomicInteger(0);
        final AtomicInteger failures = new AtomicInteger(0);
        final HBaseAdmin localAdmin = this.admin;
        for (i = 0; i < count; ++i) {
            threads[i] = new Thread(Integer.toString(i)){

                @Override
                public void run() {
                    try {
                        localAdmin.createTable(threadDesc);
                        successes.incrementAndGet();
                    }
                    catch (TableExistsException e) {
                        failures.incrementAndGet();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed threaded create" + this.getName(), e);
                    }
                }
            };
        }
        for (i = 0; i < count; ++i) {
            threads[i].start();
        }
        for (i = 0; i < count; ++i) {
            while (threads[i].isAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
        }
        Assert.assertEquals((long)1L, (long)successes.get());
        Assert.assertEquals((long)(count - 1), (long)failures.get());
    }

    @Test
    public void testTableNameClash() throws Exception {
        String name = "testTableNameClash";
        this.admin.createTable(new HTableDescriptor(name + "SOMEUPPERCASE"));
        this.admin.createTable(new HTableDescriptor(name));
        new HTable(TEST_UTIL.getConfiguration(), name);
    }

    @Test
    public void testReadOnlyTable() throws Exception {
        byte[] name = Bytes.toBytes((String)"testReadOnlyTable");
        HTable table = TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        byte[] value = Bytes.toBytes((String)"somedata");
        Put put = new Put(value);
        put.add(HConstants.CATALOG_FAMILY, HConstants.CATALOG_FAMILY, value);
        table.put(put);
    }

    @Test
    public void testTableNames() throws IOException {
        byte[][] illegalNames = new byte[][]{Bytes.toBytes((String)"-bad"), Bytes.toBytes((String)".bad"), HConstants.ROOT_TABLE_NAME, HConstants.META_TABLE_NAME};
        for (int i = 0; i < illegalNames.length; ++i) {
            try {
                new HTableDescriptor(illegalNames[i]);
                throw new IOException("Did not detect '" + Bytes.toString((byte[])illegalNames[i]) + "' as an illegal user table name");
            }
            catch (IllegalArgumentException e) {
                continue;
            }
        }
        byte[] legalName = Bytes.toBytes((String)"g-oo.d");
        try {
            new HTableDescriptor(legalName);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Legal user table name: '" + Bytes.toString((byte[])legalName) + "' caused IllegalArgumentException: " + e.getMessage());
        }
    }

    @Test(expected=TableExistsException.class)
    public void testTableNotFoundExceptionWithATable() throws IOException {
        byte[] name = Bytes.toBytes((String)"testTableNotFoundExceptionWithATable");
        TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY);
    }

    @Test(expected=TableNotFoundException.class)
    public void testTableNotFoundExceptionWithoutAnyTables() throws IOException {
        new HTable(TEST_UTIL.getConfiguration(), "testTableNotFoundExceptionWithoutAnyTables");
    }

    @Test
    public void testHundredsOfTable() throws IOException {
        int i;
        int times = 100;
        HColumnDescriptor fam1 = new HColumnDescriptor("fam1");
        HColumnDescriptor fam2 = new HColumnDescriptor("fam2");
        HColumnDescriptor fam3 = new HColumnDescriptor("fam3");
        for (i = 0; i < 100; ++i) {
            HTableDescriptor htd = new HTableDescriptor("table" + i);
            htd.addFamily(fam1);
            htd.addFamily(fam2);
            htd.addFamily(fam3);
            this.admin.createTable(htd);
        }
        for (i = 0; i < 100; ++i) {
            String tableName = "table" + i;
            this.admin.disableTable(tableName);
            byte[] tableNameBytes = Bytes.toBytes((String)tableName);
            Assert.assertTrue((boolean)this.admin.isTableDisabled(tableNameBytes));
            this.admin.enableTable(tableName);
            Assert.assertFalse((boolean)this.admin.isTableDisabled(tableNameBytes));
            this.admin.disableTable(tableName);
            Assert.assertTrue((boolean)this.admin.isTableDisabled(tableNameBytes));
            this.admin.deleteTable(tableName);
        }
    }

    static class DoneListener
    implements EventHandler.EventHandlerListener {
        private final AtomicBoolean done;

        DoneListener(AtomicBoolean done) {
            this.done = done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterProcess(EventHandler event) {
            this.done.set(true);
            AtomicBoolean atomicBoolean = this.done;
            synchronized (atomicBoolean) {
                this.done.notifyAll();
            }
        }

        public void beforeProcess(EventHandler event) {
        }
    }
}

