/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestFromClientSide {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[] VALUE = Bytes.toBytes((String)"testValue");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetConfiguration() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testGetConfiguration");
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"foo")};
        Configuration conf = TEST_UTIL.getConfiguration();
        HTable table = TEST_UTIL.createTable(TABLE, (byte[][])FAMILIES, conf);
        Assert.assertSame((Object)conf, (Object)table.getConfiguration());
    }

    @Test
    public void testWeirdCacheBehaviour() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testWeirdCacheBehaviour");
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"trans-blob"), Bytes.toBytes((String)"trans-type"), Bytes.toBytes((String)"trans-date"), Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"trans-group")};
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILIES);
        String value = "this is the value";
        String value2 = "this is some other value";
        String keyPrefix1 = UUID.randomUUID().toString();
        String keyPrefix2 = UUID.randomUUID().toString();
        String keyPrefix3 = UUID.randomUUID().toString();
        this.putRows(ht, 3, value, keyPrefix1);
        this.putRows(ht, 3, value, keyPrefix2);
        this.putRows(ht, 3, value, keyPrefix3);
        ht.flushCommits();
        this.putRows(ht, 3, value2, keyPrefix1);
        this.putRows(ht, 3, value2, keyPrefix2);
        this.putRows(ht, 3, value2, keyPrefix3);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), TABLE);
        System.out.println("Checking values for key: " + keyPrefix1);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix1, value2, table));
        System.out.println("Checking values for key: " + keyPrefix2);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix2, value2, table));
        System.out.println("Checking values for key: " + keyPrefix3);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix3, value2, table));
        this.deleteColumns(ht, value2, keyPrefix1);
        this.deleteColumns(ht, value2, keyPrefix2);
        this.deleteColumns(ht, value2, keyPrefix3);
        System.out.println("Starting important checks.....");
        Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix1), (long)0L, (long)this.getNumberOfRows(keyPrefix1, value2, table));
        Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix2), (long)0L, (long)this.getNumberOfRows(keyPrefix2, value2, table));
        Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix3), (long)0L, (long)this.getNumberOfRows(keyPrefix3, value2, table));
        ht.setScannerCaching(0);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)0L, (long)this.getNumberOfRows(keyPrefix1, value2, table));
        ht.setScannerCaching(100);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)0L, (long)this.getNumberOfRows(keyPrefix2, value2, table));
    }

    private void deleteColumns(HTable ht, String value, String keyPrefix) throws IOException {
        ResultScanner scanner = this.buildScanner(keyPrefix, value, ht);
        Iterator it = scanner.iterator();
        int count = 0;
        while (it.hasNext()) {
            Result result = (Result)it.next();
            Delete delete = new Delete(result.getRow());
            delete.deleteColumn(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"));
            ht.delete(delete);
            ++count;
        }
        Assert.assertEquals((String)"Did not perform correct number of deletes", (long)3L, (long)count);
    }

    private int getNumberOfRows(String keyPrefix, String value, HTable ht) throws Exception {
        ResultScanner resultScanner = this.buildScanner(keyPrefix, value, ht);
        Iterator scanner = resultScanner.iterator();
        int numberOfResults = 0;
        while (scanner.hasNext()) {
            Result result = (Result)scanner.next();
            System.out.println("Got back key: " + Bytes.toString((byte[])result.getRow()));
            for (KeyValue kv : result.raw()) {
                System.out.println("kv=" + kv.toString() + ", " + Bytes.toString((byte[])kv.getValue()));
            }
            ++numberOfResults;
        }
        return numberOfResults;
    }

    private ResultScanner buildScanner(String keyPrefix, String value, HTable ht) throws IOException {
        FilterList allFilters = new FilterList();
        allFilters.addFilter((Filter)new PrefixFilter(Bytes.toBytes((String)keyPrefix)));
        SingleColumnValueFilter filter = new SingleColumnValueFilter(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"), CompareFilter.CompareOp.EQUAL, Bytes.toBytes((String)value));
        filter.setFilterIfMissing(true);
        allFilters.addFilter((Filter)filter);
        Scan scan = new Scan();
        scan.addFamily(Bytes.toBytes((String)"trans-blob"));
        scan.addFamily(Bytes.toBytes((String)"trans-type"));
        scan.addFamily(Bytes.toBytes((String)"trans-date"));
        scan.addFamily(Bytes.toBytes((String)"trans-tags"));
        scan.addFamily(Bytes.toBytes((String)"trans-group"));
        scan.setFilter((Filter)allFilters);
        return ht.getScanner(scan);
    }

    private void putRows(HTable ht, int numRows, String value, String key) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            String row = key + "_" + UUID.randomUUID().toString();
            System.out.println(String.format("Saving row: %s, with value %s", row, value));
            Put put = new Put(Bytes.toBytes((String)row));
            put.add(Bytes.toBytes((String)"trans-blob"), null, Bytes.toBytes((String)"value for blob"));
            put.add(Bytes.toBytes((String)"trans-type"), null, Bytes.toBytes((String)"statement"));
            put.add(Bytes.toBytes((String)"trans-date"), null, Bytes.toBytes((String)"20090921010101999"));
            put.add(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"), Bytes.toBytes((String)value));
            put.add(Bytes.toBytes((String)"trans-group"), null, Bytes.toBytes((String)"adhocTransactionGroupId"));
            ht.put(put);
        }
    }

    @Test
    public void testFilterAcrossMultipleRegions() throws IOException, InterruptedException {
        byte[] name = Bytes.toBytes((String)"testFilterAcrossMutlipleRegions");
        HTable t = TEST_UTIL.createTable(name, FAMILY);
        int rowCount = TEST_UTIL.loadTable(t, FAMILY);
        this.assertRowCount(t, rowCount);
        Map<HRegionInfo, HServerAddress> regions = this.splitTable(t);
        this.assertRowCount(t, rowCount);
        byte[] endKey = regions.keySet().iterator().next().getEndKey();
        int endKeyCount = this.countRows(t, this.createScanWithRowFilter(endKey));
        Assert.assertTrue((endKeyCount < rowCount ? 1 : 0) != 0);
        byte[] key = new byte[]{endKey[0], endKey[1], (byte)(endKey[2] + 1)};
        int plusOneCount = this.countRows(t, this.createScanWithRowFilter(key));
        Assert.assertEquals((long)(endKeyCount + 1), (long)plusOneCount);
        key = new byte[]{endKey[0], endKey[1], (byte)(endKey[2] + 2)};
        int plusTwoCount = this.countRows(t, this.createScanWithRowFilter(key));
        Assert.assertEquals((long)(endKeyCount + 2), (long)plusTwoCount);
        key = new byte[]{endKey[0], endKey[1], (byte)(endKey[2] - 1)};
        int minusOneCount = this.countRows(t, this.createScanWithRowFilter(key));
        Assert.assertEquals((long)(endKeyCount - 1), (long)minusOneCount);
        key = new byte[]{97, 97, 97};
        int countBBB = this.countRows(t, this.createScanWithRowFilter(key, null, CompareFilter.CompareOp.EQUAL));
        Assert.assertEquals((long)1L, (long)countBBB);
        int countGreater = this.countRows(t, this.createScanWithRowFilter(endKey, null, CompareFilter.CompareOp.GREATER_OR_EQUAL));
        Assert.assertEquals((long)0L, (long)countGreater);
        countGreater = this.countRows(t, this.createScanWithRowFilter(endKey, endKey, CompareFilter.CompareOp.GREATER_OR_EQUAL));
        Assert.assertEquals((long)(rowCount - endKeyCount), (long)countGreater);
    }

    private Scan createScanWithRowFilter(byte[] key) {
        return this.createScanWithRowFilter(key, null, CompareFilter.CompareOp.LESS);
    }

    private Scan createScanWithRowFilter(byte[] key, byte[] startRow, CompareFilter.CompareOp op) {
        Assert.assertTrue((key != null && key.length > 0 && Bytes.BYTES_COMPARATOR.compare(key, new byte[]{97, 97, 97}) >= 0 ? 1 : 0) != 0);
        this.LOG.info((Object)("Key=" + Bytes.toString((byte[])key)));
        Scan s = startRow == null ? new Scan() : new Scan(startRow);
        RowFilter f = new RowFilter(op, (WritableByteArrayComparable)new BinaryComparator(key));
        f = new WhileMatchFilter((Filter)f);
        s.setFilter((Filter)f);
        return s;
    }

    private int countRows(HTable t, Scan s) throws IOException {
        ResultScanner scanner = t.getScanner(s);
        int count = 0;
        for (Result result : scanner) {
            ++count;
            Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        }
        return count;
    }

    private void assertRowCount(HTable t, int expected) throws IOException {
        Assert.assertEquals((long)expected, (long)this.countRows(t, new Scan()));
    }

    private Map<HRegionInfo, HServerAddress> splitTable(HTable t) throws IOException, InterruptedException {
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        admin.split(t.getTableName());
        Map<HRegionInfo, HServerAddress> regions = this.waitOnSplit(t);
        Assert.assertTrue((regions.size() > 1 ? 1 : 0) != 0);
        return regions;
    }

    private Map<HRegionInfo, HServerAddress> waitOnSplit(HTable t) throws IOException {
        Map regions = t.getRegionsInfo();
        int originalCount = regions.size();
        for (int i = 0; i < TEST_UTIL.getConfiguration().getInt("hbase.test.retries", 30); ++i) {
            Thread.currentThread();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            regions = t.getRegionsInfo();
            if (regions.size() > originalCount) break;
        }
        return regions;
    }

    @Test
    public void testSuperSimple() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testSuperSimple");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        Scan scan = new Scan();
        scan.addColumn(FAMILY, TABLE);
        ResultScanner scanner = ht.getScanner(scan);
        Result result = scanner.next();
        Assert.assertTrue((String)"Expected null result", (result == null ? 1 : 0) != 0);
        scanner.close();
        System.out.println("Done.");
    }

    @Test
    public void testMaxKeyValueSize() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testMaxKeyValueSize");
        Configuration conf = TEST_UTIL.getConfiguration();
        String oldMaxSize = conf.get("hbase.client.keyvalue.maxsize");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        byte[] value = new byte[0x400000];
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, value);
        ht.put(put);
        try {
            conf.setInt("hbase.client.keyvalue.maxsize", 0x200000);
            TABLE = Bytes.toBytes((String)"testMaxKeyValueSize2");
            ht = TEST_UTIL.createTable(TABLE, FAMILY);
            put = new Put(ROW);
            put.add(FAMILY, QUALIFIER, value);
            ht.put(put);
            Assert.fail((String)"Inserting a too large KeyValue worked, should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        conf.set("hbase.client.keyvalue.maxsize", oldMaxSize);
    }

    @Test
    public void testFilters() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testFilters");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 10);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"col0-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col1-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col2-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col3-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col4-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col5-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col6-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col7-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col8-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col9-<d2v1>-<d3v2>")};
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(ROWS[i]);
            put.add(FAMILY, QUALIFIERS[i], VALUE);
            ht.put(put);
        }
        Scan scan = new Scan();
        scan.addFamily(FAMILY);
        QualifierFilter filter = new QualifierFilter(CompareFilter.CompareOp.EQUAL, (WritableByteArrayComparable)new RegexStringComparator("col[1-5]"));
        scan.setFilter((Filter)filter);
        ResultScanner scanner = ht.getScanner(scan);
        int expectedIndex = 1;
        for (Result result : ht.getScanner(scan)) {
            Assert.assertEquals((long)result.size(), (long)1L);
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.raw()[0].getRow(), (byte[])ROWS[expectedIndex]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.raw()[0].getQualifier(), (byte[])QUALIFIERS[expectedIndex]));
            ++expectedIndex;
        }
        Assert.assertEquals((long)expectedIndex, (long)6L);
        scanner.close();
    }

    @Test
    public void testKeyOnlyFilter() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testKeyOnlyFilter");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 10);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"col0-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col1-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col2-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col3-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col4-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col5-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col6-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col7-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col8-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col9-<d2v1>-<d3v2>")};
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(ROWS[i]);
            put.add(FAMILY, QUALIFIERS[i], VALUE);
            ht.put(put);
        }
        Scan scan = new Scan();
        scan.addFamily(FAMILY);
        KeyOnlyFilter filter = new KeyOnlyFilter(true);
        scan.setFilter((Filter)filter);
        ResultScanner scanner = ht.getScanner(scan);
        int count = 0;
        for (Result result : ht.getScanner(scan)) {
            Assert.assertEquals((long)result.size(), (long)1L);
            Assert.assertEquals((long)result.raw()[0].getValueLength(), (long)4L);
            Assert.assertEquals((long)Bytes.toInt((byte[])result.raw()[0].getValue()), (long)VALUE.length);
            ++count;
        }
        Assert.assertEquals((long)count, (long)10L);
        scanner.close();
    }

    @Test
    public void testSimpleMissing() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testSimpleMissing");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 4);
        Get get = new Get(ROWS[0]);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILY);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILY, QUALIFIER);
        result = ht.get(get);
        this.assertEmptyResult(result);
        Scan scan = new Scan();
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0], ROWS[1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addFamily(FAMILY);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILY, QUALIFIER);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        Put put = new Put(ROWS[2]);
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        get = new Get(ROWS[1]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILY);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[3]);
        get.addColumn(FAMILY, QUALIFIER);
        result = ht.get(get);
        this.assertEmptyResult(result);
        scan = new Scan(ROWS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0], ROWS[2]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get = new Get(ROWS[2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        get = new Get(ROWS[2]);
        get.addFamily(FAMILY);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        get = new Get(ROWS[2]);
        get.addColumn(FAMILY, QUALIFIER);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan();
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan(ROWS[0], ROWS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan(ROWS[2], ROWS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
    }

    @Test
    public void testSingleRowMultipleFamily() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testSingleRowMultipleFamily");
        byte[][] ROWS = this.makeN(ROW, 3);
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 10);
        byte[][] QUALIFIERS = this.makeN(QUALIFIER, 10);
        byte[][] VALUES = this.makeN(VALUE, 10);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILIES);
        Put put = new Put(ROWS[0]);
        put.add(FAMILIES[4], QUALIFIERS[0], VALUES[0]);
        ht.put(put);
        this.getVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.scanVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.getVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        this.scanVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        TEST_UTIL.flush();
        this.getVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.scanVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.getVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        this.scanVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        put = new Put(ROWS[0]);
        put.add(FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIERS[4], VALUES[4]);
        put.add(FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        put.add(FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        put.add(FAMILIES[6], QUALIFIERS[7], VALUES[7]);
        put.add(FAMILIES[7], QUALIFIERS[7], VALUES[7]);
        put.add(FAMILIES[9], QUALIFIERS[0], VALUES[0]);
        ht.put(put);
        this.singleRowGetTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        this.singleRowScanTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        TEST_UTIL.flush();
        this.singleRowGetTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        this.singleRowScanTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        put = new Put(ROWS[0]);
        put.add(FAMILIES[6], QUALIFIERS[5], VALUES[5]);
        put.add(FAMILIES[6], QUALIFIERS[8], VALUES[8]);
        put.add(FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        put.add(FAMILIES[4], QUALIFIERS[3], VALUES[3]);
        ht.put(put);
        Delete delete = new Delete(ROWS[0]);
        delete.deleteColumns(FAMILIES[6], QUALIFIERS[7]);
        ht.delete(delete);
        Get get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[7]);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
        Scan scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[8], VALUES[8]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[8], VALUES[8]);
        delete = new Delete(ROWS[0]);
        delete.deleteColumns(FAMILIES[6], QUALIFIERS[8]);
        ht.delete(delete);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        delete = new Delete(ROWS[0]);
        delete.deleteFamily(FAMILIES[4]);
        ht.delete(delete);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[4]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        TEST_UTIL.flush();
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[4]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
    }

    @Test
    public void testNull() throws Exception {
        Put put;
        Put put2;
        byte[] TABLE = Bytes.toBytes((String)"testNull");
        try {
            TEST_UTIL.createTable(null, FAMILY);
            Assert.fail((String)"Creating a table with null name passed, should have failed");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            TEST_UTIL.createTable(TABLE, (byte[])null);
            Assert.fail((String)"Creating a table with a null family passed, should fail");
        }
        catch (Exception e) {
            // empty catch block
        }
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        try {
            put2 = new Put((byte[])null);
            put2.add(FAMILY, QUALIFIER, VALUE);
            ht.put(put2);
            Assert.fail((String)"Inserting a null row worked, should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        put2 = new Put(ROW);
        put2.add(FAMILY, null, VALUE);
        ht.put(put2);
        this.getTestNull(ht, ROW, FAMILY, VALUE);
        this.scanTestNull(ht, ROW, FAMILY, VALUE);
        Delete delete = new Delete(ROW);
        delete.deleteColumns(FAMILY, null);
        ht.delete(delete);
        Get get = new Get(ROW);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
        byte[] TABLE2 = Bytes.toBytes((String)"testNull2");
        ht = TEST_UTIL.createTable(TABLE2, FAMILY);
        try {
            put = new Put(ROW);
            put.add(FAMILY, HConstants.EMPTY_BYTE_ARRAY, VALUE);
            ht.put(put);
            this.getTestNull(ht, ROW, FAMILY, VALUE);
            this.scanTestNull(ht, ROW, FAMILY, VALUE);
            TEST_UTIL.flush();
            this.getTestNull(ht, ROW, FAMILY, VALUE);
            this.scanTestNull(ht, ROW, FAMILY, VALUE);
            Delete delete2 = new Delete(ROW);
            delete2.deleteColumns(FAMILY, HConstants.EMPTY_BYTE_ARRAY);
            ht.delete(delete2);
            Get get2 = new Get(ROW);
            Result result2 = ht.get(get2);
            this.assertEmptyResult(result2);
        }
        catch (Exception e) {
            throw new IOException("Using a row with null qualifier threw exception, should ");
        }
        try {
            put = new Put(ROW);
            put.add(FAMILY, QUALIFIER, null);
            ht.put(put);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            result = ht.get(get);
            this.assertSingleResult(result, ROW, FAMILY, QUALIFIER, null);
            Scan scan = new Scan();
            scan.addColumn(FAMILY, QUALIFIER);
            result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROW, FAMILY, QUALIFIER, null);
            Delete delete3 = new Delete(ROW);
            delete3.deleteColumns(FAMILY, QUALIFIER);
            ht.delete(delete3);
            get = new Get(ROW);
            result = ht.get(get);
            this.assertEmptyResult(result);
        }
        catch (Exception e) {
            throw new IOException("Null values should be allowed, but threw exception");
        }
    }

    @Test
    public void testVersions() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testVersions");
        long[] STAMPS = this.makeStamps(20);
        byte[][] VALUES = this.makeNAscii(VALUE, 20);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        Get get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(2);
        Result result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        Scan scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        TEST_UTIL.flush();
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(2);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        put.add(FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        put.add(FAMILY, QUALIFIER, STAMPS[8], VALUES[8]);
        ht.put(put);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions();
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions();
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        get = new Get(ROW);
        get.setMaxVersions();
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        scan = new Scan(ROW);
        scan.setMaxVersions();
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        TEST_UTIL.flush();
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[9], VALUES[9]);
        put.add(FAMILY, QUALIFIER, STAMPS[11], VALUES[11]);
        put.add(FAMILY, QUALIFIER, STAMPS[13], VALUES[13]);
        put.add(FAMILY, QUALIFIER, STAMPS[15], VALUES[15]);
        ht.put(put);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        Delete delete = new Delete(ROW);
        delete.deleteColumn(FAMILY, QUALIFIER, STAMPS[11]);
        delete.deleteColumn(FAMILY, QUALIFIER, STAMPS[7]);
        ht.delete(delete);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
    }

    @Test
    public void testVersionLimits() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testVersionLimits");
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 3);
        int[] LIMITS = new int[]{1, 3, 5};
        long[] STAMPS = this.makeStamps(10);
        byte[][] VALUES = this.makeNAscii(VALUE, 10);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILIES, LIMITS);
        Put put = new Put(ROW);
        put.add(FAMILIES[0], QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILIES[0], QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[5], VALUES[5]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[6], VALUES[6]);
        ht.put(put);
        Get get = new Get(ROW);
        get.addColumn(FAMILIES[0], QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        get = new Get(ROW);
        get.addFamily(FAMILIES[0]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        Scan scan = new Scan(ROW);
        scan.addColumn(FAMILIES[0], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        get = new Get(ROW);
        get.addColumn(FAMILIES[1], QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        get = new Get(ROW);
        get.addFamily(FAMILIES[1]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        scan = new Scan(ROW);
        scan.addColumn(FAMILIES[1], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[1]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        get = new Get(ROW);
        get.addColumn(FAMILIES[2], QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        get = new Get(ROW);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        scan = new Scan(ROW);
        scan.addColumn(FAMILIES[2], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        get = new Get(ROW);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        get = new Get(ROW);
        get.addFamily(FAMILIES[0]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        get = new Get(ROW);
        get.addColumn(FAMILIES[0], QUALIFIER);
        get.addColumn(FAMILIES[1], QUALIFIER);
        get.addColumn(FAMILIES[2], QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        scan = new Scan(ROW);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        scan = new Scan(ROW);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.addFamily(FAMILIES[0]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        scan = new Scan(ROW);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.addColumn(FAMILIES[0], QUALIFIER);
        scan.addColumn(FAMILIES[1], QUALIFIER);
        scan.addColumn(FAMILIES[2], QUALIFIER);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
    }

    @Test
    public void testDeletes() throws Exception {
        byte[] bytes;
        int i;
        byte[] bytes2;
        int i2;
        byte[] TABLE = Bytes.toBytes((String)"testDeletes");
        byte[][] ROWS = this.makeNAscii(ROW, 6);
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 3);
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILIES);
        Put put = new Put(ROW);
        put.add(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[0], QUALIFIER, ts[1], VALUES[1]);
        ht.put(put);
        Delete delete = new Delete(ROW);
        delete.deleteFamily(FAMILIES[0], ts[0]);
        ht.delete(delete);
        Get get = new Get(ROW);
        get.addFamily(FAMILIES[0]);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUES[1]}, 0, 0);
        Scan scan = new Scan(ROW);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUES[1]}, 0, 0);
        put = new Put(ROW);
        put.add(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
        put.add(FAMILIES[0], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[0], QUALIFIER, ts[3], VALUES[3]);
        put.add(FAMILIES[0], null, ts[4], VALUES[4]);
        put.add(FAMILIES[0], null, ts[2], VALUES[2]);
        put.add(FAMILIES[0], null, ts[3], VALUES[3]);
        ht.put(put);
        delete = new Delete(ROW);
        delete.deleteColumn(FAMILIES[0], QUALIFIER);
        ht.delete(delete);
        get = new Get(ROW);
        get.addColumn(FAMILIES[0], QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        scan = new Scan(ROW);
        scan.addColumn(FAMILIES[0], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        delete = new Delete(ROW);
        delete.deleteColumn(FAMILIES[0], null);
        ht.delete(delete);
        delete = new Delete(ROW);
        delete.deleteColumns(FAMILIES[0], null);
        ht.delete(delete);
        put = new Put(ROW);
        put.add(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
        ht.put(put);
        get = new Get(ROW);
        get.addFamily(FAMILIES[0]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        put = new Put(ROWS[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        put = new Put(ROWS[1]);
        put.add(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        put = new Put(ROWS[2]);
        put.add(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        get = new Get(ROWS[2]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 4 key but received " + result.size() + ": " + result), (result.size() == 4 ? 1 : 0) != 0);
        delete = new Delete(ROWS[0]);
        delete.deleteFamily(FAMILIES[2]);
        ht.delete(delete);
        delete = new Delete(ROWS[1]);
        delete.deleteColumns(FAMILIES[1], QUALIFIER);
        ht.delete(delete);
        delete = new Delete(ROWS[2]);
        delete.deleteColumn(FAMILIES[1], QUALIFIER);
        delete.deleteColumn(FAMILIES[1], QUALIFIER);
        delete.deleteColumn(FAMILIES[2], QUALIFIER);
        ht.delete(delete);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        this.assertNResult(result, ROWS[0], FAMILIES[1], QUALIFIER, new long[]{ts[0], ts[1]}, new byte[][]{VALUES[0], VALUES[1]}, 0, 1);
        scan = new Scan(ROWS[0]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        this.assertNResult(result, ROWS[0], FAMILIES[1], QUALIFIER, new long[]{ts[0], ts[1]}, new byte[][]{VALUES[0], VALUES[1]}, 0, 1);
        get = new Get(ROWS[1]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        scan = new Scan(ROWS[1]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        get = new Get(ROWS[2]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertEquals((long)1L, (long)result.size());
        this.assertNResult(result, ROWS[2], FAMILIES[2], QUALIFIER, new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
        scan = new Scan(ROWS[2]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertEquals((long)1L, (long)result.size());
        this.assertNResult(result, ROWS[2], FAMILIES[2], QUALIFIER, new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
        delete = new Delete(ROWS[3]);
        delete.deleteFamily(FAMILIES[1]);
        ht.delete(delete);
        put = new Put(ROWS[3]);
        put.add(FAMILIES[2], QUALIFIER, VALUES[0]);
        ht.put(put);
        put = new Put(ROWS[4]);
        put.add(FAMILIES[1], QUALIFIER, VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, VALUES[2]);
        ht.put(put);
        get = new Get(ROWS[3]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 1 key but received " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        get = new Get(ROWS[4]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        scan = new Scan(ROWS[3]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        ResultScanner scanner = ht.getScanner(scan);
        result = scanner.next();
        Assert.assertTrue((String)("Expected 1 key but received " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.sorted()[0].getRow(), (byte[])ROWS[3]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.sorted()[0].getValue(), (byte[])VALUES[0]));
        result = scanner.next();
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.sorted()[0].getRow(), (byte[])ROWS[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.sorted()[1].getRow(), (byte[])ROWS[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.sorted()[0].getValue(), (byte[])VALUES[1]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.sorted()[1].getValue(), (byte[])VALUES[2]));
        scanner.close();
        for (i2 = 0; i2 < 10; ++i2) {
            bytes2 = Bytes.toBytes((int)i2);
            put = new Put(bytes2);
            put.add(FAMILIES[0], QUALIFIER, bytes2);
            ht.put(put);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            bytes2 = Bytes.toBytes((int)i2);
            get = new Get(bytes2);
            get.addFamily(FAMILIES[0]);
            result = ht.get(get);
            Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        }
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        for (i = 0; i < 10; ++i) {
            bytes = Bytes.toBytes((int)i);
            delete = new Delete(bytes);
            delete.deleteFamily(FAMILIES[0]);
            deletes.add(delete);
        }
        ht.delete(deletes);
        for (i = 0; i < 10; ++i) {
            bytes = Bytes.toBytes((int)i);
            get = new Get(bytes);
            get.addFamily(FAMILIES[0]);
            result = ht.get(get);
            Assert.assertTrue((result.size() == 0 ? 1 : 0) != 0);
        }
    }

    @Ignore
    @Test
    public void testMillions() throws Exception {
    }

    @Ignore
    @Test
    public void testMultipleRegionsAndBatchPuts() throws Exception {
    }

    @Ignore
    @Test
    public void testMultipleRowMultipleFamily() throws Exception {
    }

    @Test
    public void testJiraTest867() throws Exception {
        int i;
        int numRows = 10;
        int numColsPerRow = 2000;
        byte[] TABLE = Bytes.toBytes((String)"testJiraTest867");
        byte[][] ROWS = this.makeN(ROW, numRows);
        byte[][] QUALIFIERS = this.makeN(QUALIFIER, numColsPerRow);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        for (int i2 = 0; i2 < numRows; ++i2) {
            Put put = new Put(ROWS[i2]);
            for (int j = 0; j < numColsPerRow; ++j) {
                put.add(FAMILY, QUALIFIERS[j], QUALIFIERS[j]);
            }
            Assert.assertTrue((String)("Put expected to contain " + numColsPerRow + " columns but " + "only contains " + put.size()), (put.size() == numColsPerRow ? 1 : 0) != 0);
            ht.put(put);
        }
        Get get = new Get(ROWS[numRows - 1]);
        Result result = ht.get(get);
        this.assertNumKeys(result, numColsPerRow);
        KeyValue[] keys = result.sorted();
        for (int i3 = 0; i3 < result.size(); ++i3) {
            this.assertKey(keys[i3], ROWS[numRows - 1], FAMILY, QUALIFIERS[i3], QUALIFIERS[i3]);
        }
        Scan scan = new Scan();
        ResultScanner scanner = ht.getScanner(scan);
        int rowCount = 0;
        while ((result = scanner.next()) != null) {
            this.assertNumKeys(result, numColsPerRow);
            KeyValue[] kvs = result.sorted();
            for (i = 0; i < numColsPerRow; ++i) {
                this.assertKey(kvs[i], ROWS[rowCount], FAMILY, QUALIFIERS[i], QUALIFIERS[i]);
            }
            ++rowCount;
        }
        scanner.close();
        Assert.assertTrue((String)("Expected to scan " + numRows + " rows but actually scanned " + rowCount + " rows"), (rowCount == numRows ? 1 : 0) != 0);
        TEST_UTIL.flush();
        get = new Get(ROWS[numRows - 1]);
        result = ht.get(get);
        this.assertNumKeys(result, numColsPerRow);
        keys = result.sorted();
        for (int i4 = 0; i4 < result.size(); ++i4) {
            this.assertKey(keys[i4], ROWS[numRows - 1], FAMILY, QUALIFIERS[i4], QUALIFIERS[i4]);
        }
        scan = new Scan();
        scanner = ht.getScanner(scan);
        rowCount = 0;
        while ((result = scanner.next()) != null) {
            this.assertNumKeys(result, numColsPerRow);
            KeyValue[] kvs = result.sorted();
            for (i = 0; i < numColsPerRow; ++i) {
                this.assertKey(kvs[i], ROWS[rowCount], FAMILY, QUALIFIERS[i], QUALIFIERS[i]);
            }
            ++rowCount;
        }
        scanner.close();
        Assert.assertTrue((String)("Expected to scan " + numRows + " rows but actually scanned " + rowCount + " rows"), (rowCount == numRows ? 1 : 0) != 0);
    }

    @Test
    public void testJiraTest861() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testJiraTest861");
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        TEST_UTIL.flush();
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        TEST_UTIL.flush();
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
    }

    @Test
    public void testJiraTest33() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testJiraTest33");
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
        TEST_UTIL.flush();
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
    }

    @Test
    public void testJiraTest1014() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testJiraTest1014");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        long manualStamp = 12345L;
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, manualStamp, VALUE);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, manualStamp, VALUE);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, manualStamp - 1L);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, manualStamp + 1L);
    }

    @Test
    public void testJiraTest1182() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testJiraTest1182");
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        TEST_UTIL.flush();
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
    }

    @Test
    public void testJiraTest52() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testJiraTest52");
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        TEST_UTIL.flush();
        this.getAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
    }

    private void getVersionRangeAndVerifyGreaterThan(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions(Integer.MAX_VALUE);
        get.setTimeRange(stamps[start + 1], Long.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, row, family, qualifier, stamps, values, start + 1, end);
    }

    private void getVersionRangeAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions(Integer.MAX_VALUE);
        get.setTimeRange(stamps[start], stamps[end] + 1L);
        Result result = ht.get(get);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void getAllVersionsAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void scanVersionRangeAndVerifyGreaterThan(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.setTimeRange(stamps[start + 1], Long.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, row, family, qualifier, stamps, values, start + 1, end);
    }

    private void scanVersionRangeAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.setTimeRange(stamps[start], stamps[end] + 1L);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void scanAllVersionsAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setMaxVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void getVersionAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long stamp, byte[] value) throws Exception {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setTimeStamp(stamp);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertSingleResult(result, row, family, qualifier, stamp, value);
    }

    private void getVersionAndVerifyMissing(HTable ht, byte[] row, byte[] family, byte[] qualifier, long stamp) throws Exception {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setTimeStamp(stamp);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
    }

    private void scanVersionAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long stamp, byte[] value) throws Exception {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setTimeStamp(stamp);
        scan.setMaxVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, qualifier, stamp, value);
    }

    private void scanVersionAndVerifyMissing(HTable ht, byte[] row, byte[] family, byte[] qualifier, long stamp) throws Exception {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setTimeStamp(stamp);
        scan.setMaxVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
    }

    private void getTestNull(HTable ht, byte[] row, byte[] family, byte[] value) throws Exception {
        Get get = new Get(row);
        get.addColumn(family, null);
        Result result = ht.get(get);
        this.assertSingleResult(result, row, family, null, value);
        get = new Get(row);
        get.addColumn(family, HConstants.EMPTY_BYTE_ARRAY);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        get = new Get(row);
        get.addFamily(family);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        get = new Get(row);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
    }

    private void scanTestNull(HTable ht, byte[] row, byte[] family, byte[] value) throws Exception {
        Scan scan = new Scan();
        scan.addColumn(family, null);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        scan = new Scan();
        scan.addColumn(family, HConstants.EMPTY_BYTE_ARRAY);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        scan = new Scan();
        scan.addFamily(family);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        scan = new Scan();
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
    }

    private void singleRowGetTest(HTable ht, byte[][] ROWS, byte[][] FAMILIES, byte[][] QUALIFIERS, byte[][] VALUES) throws Exception {
        Get get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[0]);
        Result result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[7]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[7], QUALIFIERS[7], VALUES[7]);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[4]);
        result = ht.get(get);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = ht.get(get);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[4]);
        get.addFamily(FAMILIES[7]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{4, 0, 0}, {4, 4, 4}, {7, 7, 7}});
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[2]);
        get.addFamily(FAMILIES[4]);
        get.addFamily(FAMILIES[6]);
        get.addFamily(FAMILIES[7]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[2], QUALIFIERS[2]);
        get.addColumn(FAMILIES[2], QUALIFIERS[4]);
        get.addColumn(FAMILIES[4], QUALIFIERS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[4]);
        get.addColumn(FAMILIES[6], QUALIFIERS[6]);
        get.addColumn(FAMILIES[6], QUALIFIERS[7]);
        get.addColumn(FAMILIES[7], QUALIFIERS[7]);
        get.addColumn(FAMILIES[7], QUALIFIERS[8]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        get = new Get(ROWS[0]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}, {9, 0, 0}});
        get = new Get(ROWS[1]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[3]);
        get.addColumn(FAMILIES[2], QUALIFIERS[3]);
        result = ht.get(get);
        this.assertEmptyResult(result);
    }

    private void singleRowScanTest(HTable ht, byte[][] ROWS, byte[][] FAMILIES, byte[][] QUALIFIERS, byte[][] VALUES) throws Exception {
        Scan scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[0]);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0]);
        scan = new Scan();
        scan.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        scan = new Scan();
        scan.addFamily(FAMILIES[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[7], QUALIFIERS[7], VALUES[7]);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[0]);
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        scan.addFamily(FAMILIES[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{4, 0, 0}, {4, 4, 4}, {7, 7, 7}});
        scan = new Scan();
        scan.addFamily(FAMILIES[2]);
        scan.addFamily(FAMILIES[4]);
        scan.addFamily(FAMILIES[6]);
        scan.addFamily(FAMILIES[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        scan = new Scan();
        scan.addColumn(FAMILIES[2], QUALIFIERS[2]);
        scan.addColumn(FAMILIES[2], QUALIFIERS[4]);
        scan.addColumn(FAMILIES[4], QUALIFIERS[0]);
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        scan.addColumn(FAMILIES[6], QUALIFIERS[7]);
        scan.addColumn(FAMILIES[7], QUALIFIERS[7]);
        scan.addColumn(FAMILIES[7], QUALIFIERS[8]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        scan = new Scan();
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}, {9, 0, 0}});
        scan = new Scan(ROWS[1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[3]);
        scan.addColumn(FAMILIES[2], QUALIFIERS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
    }

    private void getVerifySingleColumn(HTable ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX, byte[][] VALUES, int VALUEIDX) throws Exception {
        Get get = new Get(ROWS[ROWIDX]);
        Result result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[FAMILYIDX - 2]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        get.addFamily(FAMILIES[FAMILYIDX + 2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[0]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[1]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        get.addColumn(FAMILIES[FAMILYIDX + 1], QUALIFIERS[1]);
        get.addColumn(FAMILIES[FAMILYIDX - 2], QUALIFIERS[1]);
        get.addFamily(FAMILIES[FAMILYIDX - 1]);
        get.addFamily(FAMILIES[FAMILYIDX + 2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
    }

    private void scanVerifySingleColumn(HTable ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX, byte[][] VALUES, int VALUEIDX) throws Exception {
        Scan scan = new Scan();
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan(ROWS[ROWIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan(ROWS[ROWIDX], ROWS[ROWIDX + 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan(HConstants.EMPTY_START_ROW, ROWS[ROWIDX + 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addFamily(FAMILIES[FAMILYIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX + 1]);
        scan.addFamily(FAMILIES[FAMILYIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX - 1], QUALIFIERS[QUALIFIERIDX + 1]);
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX]);
        scan.addFamily(FAMILIES[FAMILYIDX + 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
    }

    private void getVerifySingleEmpty(HTable ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX) throws Exception {
        Get get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[4]);
        get.addColumn(FAMILIES[4], QUALIFIERS[1]);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[4]);
        get.addColumn(FAMILIES[4], QUALIFIERS[2]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[3]);
        get.addColumn(FAMILIES[4], QUALIFIERS[2]);
        get.addFamily(FAMILIES[5]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[ROWIDX + 1]);
        result = ht.get(get);
        this.assertEmptyResult(result);
    }

    private void scanVerifySingleEmpty(HTable ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX) throws Exception {
        Scan scan = new Scan(ROWS[ROWIDX + 1]);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[ROWIDX + 1], ROWS[ROWIDX + 2]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(HConstants.EMPTY_START_ROW, ROWS[ROWIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX + 1]);
        scan.addFamily(FAMILIES[FAMILYIDX - 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
    }

    private void assertKey(KeyValue key, byte[] row, byte[] family, byte[] qualifier, byte[] value) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] " + "Got row [" + Bytes.toString((byte[])key.getRow()) + "]"), (boolean)this.equals(row, key.getRow()));
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] " + "Got family [" + Bytes.toString((byte[])key.getFamily()) + "]"), (boolean)this.equals(family, key.getFamily()));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] " + "Got qualifier [" + Bytes.toString((byte[])key.getQualifier()) + "]"), (boolean)this.equals(qualifier, key.getQualifier()));
        Assert.assertTrue((String)("Expected value [" + Bytes.toString((byte[])value) + "] " + "Got value [" + Bytes.toString((byte[])key.getValue()) + "]"), (boolean)this.equals(value, key.getValue()));
    }

    private void assertIncrementKey(KeyValue key, byte[] row, byte[] family, byte[] qualifier, long value) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] " + "Got row [" + Bytes.toString((byte[])key.getRow()) + "]"), (boolean)this.equals(row, key.getRow()));
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] " + "Got family [" + Bytes.toString((byte[])key.getFamily()) + "]"), (boolean)this.equals(family, key.getFamily()));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] " + "Got qualifier [" + Bytes.toString((byte[])key.getQualifier()) + "]"), (boolean)this.equals(qualifier, key.getQualifier()));
        Assert.assertTrue((String)("Expected value [" + value + "] " + "Got value [" + Bytes.toLong((byte[])key.getValue()) + "]"), (Bytes.toLong((byte[])key.getValue()) == value ? 1 : 0) != 0);
    }

    private void assertNumKeys(Result result, int n) throws Exception {
        Assert.assertTrue((String)("Expected " + n + " keys but got " + result.size()), (result.size() == n ? 1 : 0) != 0);
    }

    private void assertNResult(Result result, byte[] row, byte[][] families, byte[][] qualifiers, byte[][] values, int[][] idxs) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] " + "Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)this.equals(row, result.getRow()));
        Assert.assertTrue((String)("Expected " + idxs.length + " keys but result contains " + result.size()), (result.size() == idxs.length ? 1 : 0) != 0);
        KeyValue[] keys = result.sorted();
        for (int i = 0; i < keys.length; ++i) {
            byte[] family = families[idxs[i][0]];
            byte[] qualifier = qualifiers[idxs[i][1]];
            byte[] value = values[idxs[i][2]];
            KeyValue key = keys[i];
            Assert.assertTrue((String)("(" + i + ") Expected family [" + Bytes.toString((byte[])family) + "] " + "Got family [" + Bytes.toString((byte[])key.getFamily()) + "]"), (boolean)this.equals(family, key.getFamily()));
            Assert.assertTrue((String)("(" + i + ") Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] " + "Got qualifier [" + Bytes.toString((byte[])key.getQualifier()) + "]"), (boolean)this.equals(qualifier, key.getQualifier()));
            Assert.assertTrue((String)("(" + i + ") Expected value [" + Bytes.toString((byte[])value) + "] " + "Got value [" + Bytes.toString((byte[])key.getValue()) + "]"), (boolean)this.equals(value, key.getValue()));
        }
    }

    private void assertNResult(Result result, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] " + "Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)this.equals(row, result.getRow()));
        int expectedResults = end - start + 1;
        Assert.assertEquals((long)expectedResults, (long)result.size());
        KeyValue[] keys = result.sorted();
        for (int i = 0; i < keys.length; ++i) {
            byte[] value = values[end - i];
            long ts = stamps[end - i];
            KeyValue key = keys[i];
            Assert.assertTrue((String)("(" + i + ") Expected family [" + Bytes.toString((byte[])family) + "] " + "Got family [" + Bytes.toString((byte[])key.getFamily()) + "]"), (boolean)this.equals(family, key.getFamily()));
            Assert.assertTrue((String)("(" + i + ") Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] " + "Got qualifier [" + Bytes.toString((byte[])key.getQualifier()) + "]"), (boolean)this.equals(qualifier, key.getQualifier()));
            Assert.assertTrue((String)("Expected ts [" + ts + "] " + "Got ts [" + key.getTimestamp() + "]"), (ts == key.getTimestamp() ? 1 : 0) != 0);
            Assert.assertTrue((String)("(" + i + ") Expected value [" + Bytes.toString((byte[])value) + "] " + "Got value [" + Bytes.toString((byte[])key.getValue()) + "]"), (boolean)this.equals(value, key.getValue()));
        }
    }

    private void assertDoubleResult(Result result, byte[] row, byte[] familyA, byte[] qualifierA, byte[] valueA, byte[] familyB, byte[] qualifierB, byte[] valueB) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] " + "Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)this.equals(row, result.getRow()));
        Assert.assertTrue((String)("Expected two keys but result contains " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        KeyValue[] kv = result.sorted();
        KeyValue kvA = kv[0];
        Assert.assertTrue((String)("(A) Expected family [" + Bytes.toString((byte[])familyA) + "] " + "Got family [" + Bytes.toString((byte[])kvA.getFamily()) + "]"), (boolean)this.equals(familyA, kvA.getFamily()));
        Assert.assertTrue((String)("(A) Expected qualifier [" + Bytes.toString((byte[])qualifierA) + "] " + "Got qualifier [" + Bytes.toString((byte[])kvA.getQualifier()) + "]"), (boolean)this.equals(qualifierA, kvA.getQualifier()));
        Assert.assertTrue((String)("(A) Expected value [" + Bytes.toString((byte[])valueA) + "] " + "Got value [" + Bytes.toString((byte[])kvA.getValue()) + "]"), (boolean)this.equals(valueA, kvA.getValue()));
        KeyValue kvB = kv[1];
        Assert.assertTrue((String)("(B) Expected family [" + Bytes.toString((byte[])familyB) + "] " + "Got family [" + Bytes.toString((byte[])kvB.getFamily()) + "]"), (boolean)this.equals(familyB, kvB.getFamily()));
        Assert.assertTrue((String)("(B) Expected qualifier [" + Bytes.toString((byte[])qualifierB) + "] " + "Got qualifier [" + Bytes.toString((byte[])kvB.getQualifier()) + "]"), (boolean)this.equals(qualifierB, kvB.getQualifier()));
        Assert.assertTrue((String)("(B) Expected value [" + Bytes.toString((byte[])valueB) + "] " + "Got value [" + Bytes.toString((byte[])kvB.getValue()) + "]"), (boolean)this.equals(valueB, kvB.getValue()));
    }

    private void assertSingleResult(Result result, byte[] row, byte[] family, byte[] qualifier, byte[] value) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] " + "Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)this.equals(row, result.getRow()));
        Assert.assertTrue((String)("Expected a single key but result contains " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        KeyValue kv = result.sorted()[0];
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] " + "Got family [" + Bytes.toString((byte[])kv.getFamily()) + "]"), (boolean)this.equals(family, kv.getFamily()));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] " + "Got qualifier [" + Bytes.toString((byte[])kv.getQualifier()) + "]"), (boolean)this.equals(qualifier, kv.getQualifier()));
        Assert.assertTrue((String)("Expected value [" + Bytes.toString((byte[])value) + "] " + "Got value [" + Bytes.toString((byte[])kv.getValue()) + "]"), (boolean)this.equals(value, kv.getValue()));
    }

    private void assertSingleResult(Result result, byte[] row, byte[] family, byte[] qualifier, long ts, byte[] value) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] " + "Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)this.equals(row, result.getRow()));
        Assert.assertTrue((String)("Expected a single key but result contains " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        KeyValue kv = result.sorted()[0];
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] " + "Got family [" + Bytes.toString((byte[])kv.getFamily()) + "]"), (boolean)this.equals(family, kv.getFamily()));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] " + "Got qualifier [" + Bytes.toString((byte[])kv.getQualifier()) + "]"), (boolean)this.equals(qualifier, kv.getQualifier()));
        Assert.assertTrue((String)("Expected ts [" + ts + "] " + "Got ts [" + kv.getTimestamp() + "]"), (ts == kv.getTimestamp() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected value [" + Bytes.toString((byte[])value) + "] " + "Got value [" + Bytes.toString((byte[])kv.getValue()) + "]"), (boolean)this.equals(value, kv.getValue()));
    }

    private void assertEmptyResult(Result result) throws Exception {
        Assert.assertTrue((String)("expected an empty result but result contains " + result.size() + " keys"), (boolean)result.isEmpty());
    }

    private void assertNullResult(Result result) throws Exception {
        Assert.assertTrue((String)"expected null result but received a non-null result", (result == null ? 1 : 0) != 0);
    }

    private Result getSingleScanResult(HTable ht, Scan scan) throws IOException {
        ResultScanner scanner = ht.getScanner(scan);
        Result result = scanner.next();
        scanner.close();
        return result;
    }

    private byte[][] makeNAscii(byte[] base, int n) {
        if (n > 256) {
            return this.makeNBig(base, n);
        }
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byte[] tail = Bytes.toBytes((String)Integer.toString(i));
            ret[i] = Bytes.add((byte[])base, (byte[])tail);
        }
        return ret;
    }

    private byte[][] makeN(byte[] base, int n) {
        if (n > 256) {
            return this.makeNBig(base, n);
        }
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add((byte[])base, (byte[])new byte[]{(byte)i});
        }
        return ret;
    }

    private byte[][] makeNBig(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int byteA = i % 256;
            int byteB = i >> 8;
            ret[i] = Bytes.add((byte[])base, (byte[])new byte[]{(byte)byteB, (byte)byteA});
        }
        return ret;
    }

    private long[] makeStamps(int n) {
        long[] stamps = new long[n];
        for (int i = 0; i < n; ++i) {
            stamps[i] = i + 1;
        }
        return stamps;
    }

    private boolean equals(byte[] left, byte[] right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right.length == 0) {
            return true;
        }
        if (right == null && left.length == 0) {
            return true;
        }
        return Bytes.equals((byte[])left, (byte[])right);
    }

    @Test
    public void testDuplicateVersions() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testDuplicateVersions");
        long[] STAMPS = this.makeStamps(20);
        byte[][] VALUES = this.makeNAscii(VALUE, 20);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        Get get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(2);
        Result result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        Scan scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        TEST_UTIL.flush();
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(2);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[14]);
        put.add(FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        put.add(FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        put.add(FAMILY, QUALIFIER, STAMPS[8], VALUES[8]);
        ht.put(put);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(7);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(7);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        get = new Get(ROW);
        get.setMaxVersions(7);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        scan = new Scan(ROW);
        scan.setMaxVersions(7);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[14]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[14]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        TEST_UTIL.flush();
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[9], VALUES[9]);
        put.add(FAMILY, QUALIFIER, STAMPS[11], VALUES[11]);
        put.add(FAMILY, QUALIFIER, STAMPS[13], VALUES[13]);
        put.add(FAMILY, QUALIFIER, STAMPS[15], VALUES[15]);
        ht.put(put);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        Delete delete = new Delete(ROW);
        delete.deleteColumn(FAMILY, QUALIFIER, STAMPS[11]);
        delete.deleteColumn(FAMILY, QUALIFIER, STAMPS[7]);
        ht.delete(delete);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
    }

    @Test
    public void testUpdates() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testUpdates");
        HTable hTable = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        byte[] row = Bytes.toBytes((String)"row1");
        byte[] qualifier = Bytes.toBytes((String)"myCol");
        Put put = new Put(row);
        put.add(FAMILY, qualifier, 1L, Bytes.toBytes((String)"AAA"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 2L, Bytes.toBytes((String)"BBB"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 3L, Bytes.toBytes((String)"EEE"));
        hTable.put(put);
        Get get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        get.setMaxVersions();
        Result result = hTable.get(get);
        NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"AAA", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"BBB", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
        put = new Put(row);
        put.add(FAMILY, qualifier, 1L, Bytes.toBytes((String)"CCC"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 2L, Bytes.toBytes((String)"DDD"));
        hTable.put(put);
        result = hTable.get(get);
        navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"CCC", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"DDD", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
    }

    @Test
    public void testUpdatesWithMajorCompaction() throws Exception {
        String tableName = "testUpdatesWithMajorCompaction";
        byte[] TABLE = Bytes.toBytes((String)tableName);
        HTable hTable = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        byte[] row = Bytes.toBytes((String)"row2");
        byte[] qualifier = Bytes.toBytes((String)"myCol");
        Put put = new Put(row);
        put.add(FAMILY, qualifier, 1L, Bytes.toBytes((String)"AAA"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 2L, Bytes.toBytes((String)"BBB"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 3L, Bytes.toBytes((String)"EEE"));
        hTable.put(put);
        Get get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        get.setMaxVersions();
        Result result = hTable.get(get);
        NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"AAA", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"BBB", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
        admin.flush(tableName);
        admin.majorCompact(tableName);
        Thread.sleep(6000L);
        put = new Put(row);
        put.add(FAMILY, qualifier, 1L, Bytes.toBytes((String)"CCC"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 2L, Bytes.toBytes((String)"DDD"));
        hTable.put(put);
        admin.flush(tableName);
        admin.majorCompact(tableName);
        Thread.sleep(6000L);
        result = hTable.get(get);
        navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"CCC", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"DDD", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
    }

    @Test
    public void testMajorCompactionBetweenTwoUpdates() throws Exception {
        String tableName = "testMajorCompactionBetweenTwoUpdates";
        byte[] TABLE = Bytes.toBytes((String)tableName);
        HTable hTable = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        byte[] row = Bytes.toBytes((String)"row3");
        byte[] qualifier = Bytes.toBytes((String)"myCol");
        Put put = new Put(row);
        put.add(FAMILY, qualifier, 1L, Bytes.toBytes((String)"AAA"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 2L, Bytes.toBytes((String)"BBB"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 3L, Bytes.toBytes((String)"EEE"));
        hTable.put(put);
        Get get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        get.setMaxVersions();
        Result result = hTable.get(get);
        NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"AAA", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"BBB", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
        admin.flush(tableName);
        admin.majorCompact(tableName);
        Thread.sleep(6000L);
        put = new Put(row);
        put.add(FAMILY, qualifier, 1L, Bytes.toBytes((String)"CCC"));
        hTable.put(put);
        admin.flush(tableName);
        admin.majorCompact(tableName);
        Thread.sleep(6000L);
        put = new Put(row);
        put.add(FAMILY, qualifier, 2L, Bytes.toBytes((String)"DDD"));
        hTable.put(put);
        admin.flush(tableName);
        admin.majorCompact(tableName);
        Thread.sleep(6000L);
        result = hTable.get(get);
        navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"CCC", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"DDD", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
    }

    @Test
    public void testGet_EmptyTable() throws IOException {
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testGet_EmptyTable"), FAMILY);
        Get get = new Get(ROW);
        get.addFamily(FAMILY);
        Result r = table.get(get);
        Assert.assertTrue((boolean)r.isEmpty());
    }

    @Test
    public void testGet_NonExistentRow() throws IOException {
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testGet_NonExistentRow"), FAMILY);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        this.LOG.info((Object)"Row put");
        Get get = new Get(ROW);
        get.addFamily(FAMILY);
        Result r = table.get(get);
        Assert.assertFalse((boolean)r.isEmpty());
        System.out.println("Row retrieved successfully");
        byte[] missingrow = Bytes.toBytes((String)"missingrow");
        get = new Get(missingrow);
        get.addFamily(FAMILY);
        r = table.get(get);
        Assert.assertTrue((boolean)r.isEmpty());
        this.LOG.info((Object)"Row missing as it should be");
    }

    @Test
    public void testPut() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] SMALL_FAMILY = Bytes.toBytes((String)"smallfam");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] value = Bytes.toBytes((String)"abcd");
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testPut"), new byte[][]{CONTENTS_FAMILY, SMALL_FAMILY});
        Put put = new Put(row1);
        put.add(CONTENTS_FAMILY, null, value);
        table.put(put);
        put = new Put(row2);
        put.add(CONTENTS_FAMILY, null, value);
        Assert.assertEquals((long)put.size(), (long)1L);
        Assert.assertEquals((long)((List)put.getFamilyMap().get(CONTENTS_FAMILY)).size(), (long)1L);
        KeyValue kv = (KeyValue)((List)put.getFamilyMap().get(CONTENTS_FAMILY)).get(0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getFamily(), (byte[])CONTENTS_FAMILY));
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getQualifier(), (byte[])new byte[0]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getValue(), (byte[])value));
        table.put(put);
        Scan scan = new Scan();
        scan.addColumn(CONTENTS_FAMILY, null);
        ResultScanner scanner = table.getScanner(scan);
        for (Result r : scanner) {
            for (KeyValue key : r.sorted()) {
                System.out.println(Bytes.toString((byte[])r.getRow()) + ": " + key.toString());
            }
        }
    }

    @Test
    public void testRowsPut() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] SMALL_FAMILY = Bytes.toBytes((String)"smallfam");
        int NB_BATCH_ROWS = 10;
        byte[] value = Bytes.toBytes((String)"abcd");
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testRowsPut"), new byte[][]{CONTENTS_FAMILY, SMALL_FAMILY});
        ArrayList<Put> rowsUpdate = new ArrayList<Put>();
        for (int i = 0; i < 10; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            Put put = new Put(row);
            put.add(CONTENTS_FAMILY, null, value);
            rowsUpdate.add(put);
        }
        table.put(rowsUpdate);
        Scan scan = new Scan();
        scan.addFamily(CONTENTS_FAMILY);
        ResultScanner scanner = table.getScanner(scan);
        int nbRows = 0;
        for (Result row : scanner) {
            ++nbRows;
        }
        Assert.assertEquals((long)10L, (long)nbRows);
    }

    @Test
    public void testRowsPutBufferedOneFlush() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] SMALL_FAMILY = Bytes.toBytes((String)"smallfam");
        byte[] value = Bytes.toBytes((String)"abcd");
        int NB_BATCH_ROWS = 10;
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testRowsPutBufferedOneFlush"), new byte[][]{CONTENTS_FAMILY, SMALL_FAMILY});
        table.setAutoFlush(false);
        ArrayList<Put> rowsUpdate = new ArrayList<Put>();
        for (int i = 0; i < 100; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            Put put = new Put(row);
            put.add(CONTENTS_FAMILY, null, value);
            rowsUpdate.add(put);
        }
        table.put(rowsUpdate);
        Scan scan = new Scan();
        scan.addFamily(CONTENTS_FAMILY);
        ResultScanner scanner = table.getScanner(scan);
        int nbRows = 0;
        for (Result row : scanner) {
            ++nbRows;
        }
        Assert.assertEquals((long)0L, (long)nbRows);
        scanner.close();
        table.flushCommits();
        scan = new Scan();
        scan.addFamily(CONTENTS_FAMILY);
        scanner = table.getScanner(scan);
        nbRows = 0;
        for (Result row : scanner) {
            ++nbRows;
        }
        Assert.assertEquals((long)100L, (long)nbRows);
    }

    @Test
    public void testRowsPutBufferedManyManyFlushes() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] SMALL_FAMILY = Bytes.toBytes((String)"smallfam");
        byte[] value = Bytes.toBytes((String)"abcd");
        int NB_BATCH_ROWS = 10;
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testRowsPutBufferedManyManyFlushes"), new byte[][]{CONTENTS_FAMILY, SMALL_FAMILY});
        table.setAutoFlush(false);
        table.setWriteBufferSize(10L);
        ArrayList<Put> rowsUpdate = new ArrayList<Put>();
        for (int i = 0; i < 100; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            Put put = new Put(row);
            put.add(CONTENTS_FAMILY, null, value);
            rowsUpdate.add(put);
        }
        table.put(rowsUpdate);
        table.flushCommits();
        Scan scan = new Scan();
        scan.addFamily(CONTENTS_FAMILY);
        ResultScanner scanner = table.getScanner(scan);
        int nbRows = 0;
        for (Result row : scanner) {
            ++nbRows;
        }
        Assert.assertEquals((long)100L, (long)nbRows);
    }

    @Test
    public void testAddKeyValue() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] value = Bytes.toBytes((String)"abcd");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] qualifier = Bytes.toBytes((String)"qf1");
        Put put = new Put(row1);
        KeyValue kv = new KeyValue(row1, CONTENTS_FAMILY, qualifier, value);
        boolean ok = true;
        try {
            put.add(kv);
        }
        catch (IOException e) {
            ok = false;
        }
        Assert.assertEquals((Object)true, (Object)ok);
        kv = new KeyValue(row2, CONTENTS_FAMILY, qualifier, value);
        ok = false;
        try {
            put.add(kv);
        }
        catch (IOException e) {
            ok = true;
        }
        Assert.assertEquals((Object)true, (Object)ok);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHBase737() throws IOException {
        int i;
        Result r;
        byte[] FAM1 = Bytes.toBytes((String)"fam1");
        byte[] FAM2 = Bytes.toBytes((String)"fam2");
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testHBase737"), new byte[][]{FAM1, FAM2});
        Put put = new Put(ROW);
        put.add(FAM1, Bytes.toBytes((String)"letters"), Bytes.toBytes((String)"abcdefg"));
        table.put(put);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i2) {
            // empty catch block
        }
        put = new Put(ROW);
        put.add(FAM1, Bytes.toBytes((String)"numbers"), Bytes.toBytes((String)"123456"));
        table.put(put);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i3) {
            // empty catch block
        }
        put = new Put(ROW);
        put.add(FAM2, Bytes.toBytes((String)"letters"), Bytes.toBytes((String)"hijklmnop"));
        table.put(put);
        long[] times = new long[3];
        Scan scan = new Scan();
        scan.addFamily(FAM1);
        scan.addFamily(FAM2);
        ResultScanner s = table.getScanner(scan);
        try {
            int index = 0;
            r = null;
            while ((r = s.next()) != null) {
                for (KeyValue key : r.sorted()) {
                    times[index++] = key.getTimestamp();
                }
            }
        }
        finally {
            s.close();
        }
        for (i = 0; i < times.length - 1; ++i) {
            for (int j = i + 1; j < times.length; ++j) {
                Assert.assertTrue((times[j] > times[i] ? 1 : 0) != 0);
            }
        }
        TEST_UTIL.flush();
        for (i = 0; i < times.length; ++i) {
            times[i] = 0L;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i4) {
            // empty catch block
        }
        scan = new Scan();
        scan.addFamily(FAM1);
        scan.addFamily(FAM2);
        s = table.getScanner(scan);
        try {
            int index = 0;
            r = null;
            while ((r = s.next()) != null) {
                for (KeyValue key : r.sorted()) {
                    times[index++] = key.getTimestamp();
                }
            }
        }
        finally {
            s.close();
        }
        for (int i5 = 0; i5 < times.length - 1; ++i5) {
            for (int j = i5 + 1; j < times.length; ++j) {
                Assert.assertTrue((times[j] > times[i5] ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testListTables() throws IOException, InterruptedException {
        byte[] t1 = Bytes.toBytes((String)"testListTables1");
        byte[] t2 = Bytes.toBytes((String)"testListTables2");
        byte[] t3 = Bytes.toBytes((String)"testListTables3");
        byte[][] tables = new byte[][]{t1, t2, t3};
        for (int i = 0; i < tables.length; ++i) {
            TEST_UTIL.createTable(tables[i], FAMILY);
        }
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        HTableDescriptor[] ts = admin.listTables();
        HashSet<HTableDescriptor> result = new HashSet<HTableDescriptor>(ts.length);
        for (int i = 0; i < ts.length; ++i) {
            result.add(ts[i]);
        }
        int size = result.size();
        Assert.assertTrue((size >= tables.length ? 1 : 0) != 0);
        for (int i = 0; i < tables.length && i < size; ++i) {
            boolean found = false;
            for (int j = 0; j < ts.length; ++j) {
                if (!Bytes.equals((byte[])ts[j].getName(), (byte[])tables[i])) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Not found: " + Bytes.toString((byte[])tables[i])), (boolean)found);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiscHTableStuff() throws IOException {
        byte[] tableAname = Bytes.toBytes((String)"testMiscHTableStuffA");
        byte[] tableBname = Bytes.toBytes((String)"testMiscHTableStuffB");
        byte[] attrName = Bytes.toBytes((String)"TESTATTR");
        byte[] attrValue = Bytes.toBytes((String)"somevalue");
        byte[] value = Bytes.toBytes((String)"value");
        HTable a = TEST_UTIL.createTable(tableAname, HConstants.CATALOG_FAMILY);
        HTable b = TEST_UTIL.createTable(tableBname, HConstants.CATALOG_FAMILY);
        Put put = new Put(ROW);
        put.add(HConstants.CATALOG_FAMILY, null, value);
        a.put(put);
        HTable newA = new HTable(TEST_UTIL.getConfiguration(), tableAname);
        Scan scan = new Scan();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        ResultScanner s = newA.getScanner(scan);
        try {
            for (Result r : s) {
                put = new Put(r.getRow());
                for (KeyValue kv : r.sorted()) {
                    put.add(kv);
                }
                b.put(put);
            }
        }
        finally {
            s.close();
        }
        HTable anotherA = new HTable(TEST_UTIL.getConfiguration(), tableAname);
        Get get = new Get(ROW);
        get.addFamily(HConstants.CATALOG_FAMILY);
        anotherA.get(get);
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        HTableDescriptor desc = new HTableDescriptor(a.getTableDescriptor());
        admin.disableTable(tableAname);
        desc.setValue(attrName, attrValue);
        for (HColumnDescriptor c : desc.getFamilies()) {
            c.setValue(attrName, attrValue);
        }
        admin.modifyTable(tableAname, desc);
        admin.enableTable(tableAname);
        desc = a.getTableDescriptor();
        Assert.assertTrue((String)"wrong table descriptor returned", (Bytes.compareTo((byte[])desc.getName(), (byte[])tableAname) == 0 ? 1 : 0) != 0);
        value = desc.getValue(attrName);
        Assert.assertFalse((String)"missing HTD attribute value", (value == null ? 1 : 0) != 0);
        Assert.assertFalse((String)"HTD attribute value is incorrect", (Bytes.compareTo((byte[])value, (byte[])attrValue) != 0 ? 1 : 0) != 0);
        for (HColumnDescriptor c : desc.getFamilies()) {
            value = c.getValue(attrName);
            Assert.assertFalse((String)"missing HCD attribute value", (value == null ? 1 : 0) != 0);
            Assert.assertFalse((String)"HCD attribute value is incorrect", (Bytes.compareTo((byte[])value, (byte[])attrValue) != 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetClosestRowBefore() throws IOException {
        byte[] tableAname = Bytes.toBytes((String)"testGetClosestRowBefore");
        byte[] row = Bytes.toBytes((String)"row");
        byte[] firstRow = Bytes.toBytes((String)"ro");
        byte[] beforeFirstRow = Bytes.toBytes((String)"rn");
        byte[] beforeSecondRow = Bytes.toBytes((String)"rov");
        HTable table = TEST_UTIL.createTable(tableAname, new byte[][]{HConstants.CATALOG_FAMILY, Bytes.toBytes((String)"info2")});
        Put put = new Put(firstRow);
        Put put2 = new Put(row);
        byte[] zero = new byte[]{0};
        byte[] one = new byte[]{1};
        put.add(HConstants.CATALOG_FAMILY, null, zero);
        put2.add(HConstants.CATALOG_FAMILY, null, one);
        table.put(put);
        table.put(put2);
        Result result = null;
        result = table.getRowOrBefore(beforeFirstRow, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((result == null ? 1 : 0) != 0);
        result = table.getRowOrBefore(firstRow, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])zero));
        result = table.getRowOrBefore(beforeSecondRow, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])zero));
        result = table.getRowOrBefore(row, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])one));
        result = table.getRowOrBefore(Bytes.add((byte[])row, (byte[])one), HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])one));
    }

    @Test
    public void testScanVariableReuse() throws Exception {
        Scan scan = new Scan();
        scan.addFamily(FAMILY);
        scan.addColumn(FAMILY, ROW);
        Assert.assertTrue((((NavigableSet)scan.getFamilyMap().get(FAMILY)).size() == 1 ? 1 : 0) != 0);
        scan = new Scan();
        scan.addFamily(FAMILY);
        Assert.assertTrue((scan.getFamilyMap().get(FAMILY) == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)scan.getFamilyMap().containsKey(FAMILY));
    }

    @Test
    public void testRegionCacheDeSerialization() throws Exception {
        this.LOG.info((Object)"Starting testRegionCacheDeSerialization");
        byte[] TABLENAME = Bytes.toBytes((String)"testCachePrewarm2");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        Configuration conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.createTable(TABLENAME, FAMILY);
        HTable table = new HTable(conf, TABLENAME);
        TEST_UTIL.createMultiRegions(table, FAMILY);
        Path tempPath = new Path(HBaseTestingUtility.getTestDir(), "regions.dat");
        String tempFileName = tempPath.toString();
        FileOutputStream fos = new FileOutputStream(tempFileName);
        DataOutputStream dos = new DataOutputStream(fos);
        table.serializeRegionInfo((DataOutput)dos);
        dos.flush();
        dos.close();
        FileInputStream fis = new FileInputStream(tempFileName);
        DataInputStream dis = new DataInputStream(fis);
        Map deserRegions = table.deserializeRegionInfo((DataInput)dis);
        dis.close();
        Map loadedRegions = table.getRegionsInfo();
        table.getConnection().clearRegionCache();
        table.getConnection().prewarmRegionCache(table.getTableName(), deserRegions);
        Assert.assertEquals((String)"Number of cached region is incorrect", (long)HConnectionManager.getCachedRegionCount((Configuration)conf, (byte[])TABLENAME), (long)loadedRegions.size());
        for (Map.Entry e : loadedRegions.entrySet()) {
            HRegionInfo hri = (HRegionInfo)e.getKey();
            Assert.assertTrue((boolean)HConnectionManager.isRegionCached((Configuration)conf, (byte[])hri.getTableDesc().getName(), (byte[])hri.getStartKey()));
        }
        File f = new File(tempFileName);
        f.delete();
        this.LOG.info((Object)"Finishing testRegionCacheDeSerialization");
    }

    @Test
    public void testRegionCachePreWarm() throws Exception {
        this.LOG.info((Object)"Starting testRegionCachePreWarm");
        byte[] TABLENAME = Bytes.toBytes((String)"testCachePrewarm");
        Configuration conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.createTable(TABLENAME, FAMILY);
        HTable.setRegionCachePrefetch((Configuration)conf, (byte[])TABLENAME, (boolean)false);
        Assert.assertFalse((String)"The table is disabled for region cache prefetch", (boolean)HTable.getRegionCachePrefetch((Configuration)conf, (byte[])TABLENAME));
        HTable table = new HTable(conf, TABLENAME);
        TEST_UTIL.createMultiRegions(table, FAMILY);
        TEST_UTIL.countRows(table);
        table.getConnection().clearRegionCache();
        Assert.assertEquals((String)"Clearing cache should have 0 cached ", (long)0L, (long)HConnectionManager.getCachedRegionCount((Configuration)conf, (byte[])TABLENAME));
        Get g = new Get(Bytes.toBytes((String)"aaa"));
        table.get(g);
        Assert.assertEquals((String)"Number of cached region is incorrect ", (long)1L, (long)HConnectionManager.getCachedRegionCount((Configuration)conf, (byte[])TABLENAME));
        HTable.setRegionCachePrefetch((Configuration)conf, (byte[])TABLENAME, (boolean)true);
        Assert.assertTrue((String)"The table is enabled for region cache prefetch", (boolean)HTable.getRegionCachePrefetch((Configuration)conf, (byte[])TABLENAME));
        HTable.setRegionCachePrefetch((Configuration)conf, (byte[])TABLENAME, (boolean)false);
        Assert.assertFalse((String)"The table is disabled for region cache prefetch", (boolean)HTable.getRegionCachePrefetch((Configuration)conf, (byte[])TABLENAME));
        HTable.setRegionCachePrefetch((Configuration)conf, (byte[])TABLENAME, (boolean)true);
        Assert.assertTrue((String)"The table is enabled for region cache prefetch", (boolean)HTable.getRegionCachePrefetch((Configuration)conf, (byte[])TABLENAME));
        table.getConnection().clearRegionCache();
        Assert.assertEquals((String)"Number of cached region is incorrect ", (long)0L, (long)HConnectionManager.getCachedRegionCount((Configuration)conf, (byte[])TABLENAME));
        Get g2 = new Get(Bytes.toBytes((String)"bbb"));
        table.get(g2);
        int prefetchRegionNumber = conf.getInt("hbase.client.prefetch.limit", 10);
        this.LOG.info((Object)"Testing how many regions cached");
        Assert.assertEquals((String)"Number of cached region is incorrect ", (long)prefetchRegionNumber, (long)HConnectionManager.getCachedRegionCount((Configuration)conf, (byte[])TABLENAME));
        table.getConnection().clearRegionCache();
        Get g3 = new Get(Bytes.toBytes((String)"abc"));
        table.get(g3);
        Assert.assertEquals((String)"Number of cached region is incorrect ", (long)prefetchRegionNumber, (long)HConnectionManager.getCachedRegionCount((Configuration)conf, (byte[])TABLENAME));
        this.LOG.info((Object)"Finishing testRegionCachePreWarm");
    }

    @Test
    public void testIncrement() throws Exception {
        int i;
        this.LOG.info((Object)"Starting testIncrement");
        byte[] TABLENAME = Bytes.toBytes((String)"testIncrement");
        HTable ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[][] ROWS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g"), Bytes.toBytes((String)"h"), Bytes.toBytes((String)"i")};
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g"), Bytes.toBytes((String)"h"), Bytes.toBytes((String)"i")};
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[0], 1L);
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[1], 2L);
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[2], 3L);
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[3], 4L);
        Increment inc = new Increment(ROW);
        inc.addColumn(FAMILY, QUALIFIERS[1], 1L);
        inc.addColumn(FAMILY, QUALIFIERS[3], 1L);
        inc.addColumn(FAMILY, QUALIFIERS[4], 1L);
        ht.increment(inc);
        Result r = ht.get(new Get(ROW));
        KeyValue[] kvs = r.raw();
        Assert.assertEquals((long)5L, (long)kvs.length);
        this.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[0], 1L);
        this.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[1], 3L);
        this.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 3L);
        this.assertIncrementKey(kvs[3], ROW, FAMILY, QUALIFIERS[3], 5L);
        this.assertIncrementKey(kvs[4], ROW, FAMILY, QUALIFIERS[4], 1L);
        inc = new Increment(ROWS[0]);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], (long)(i + 1));
        }
        ht.increment(inc);
        r = ht.get(new Get(ROWS[0]));
        kvs = r.raw();
        Assert.assertEquals((long)QUALIFIERS.length, (long)kvs.length);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            this.assertIncrementKey(kvs[i], ROWS[0], FAMILY, QUALIFIERS[i], i + 1);
        }
        inc = new Increment(ROWS[0]);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], (long)(i + 1));
        }
        ht.increment(inc);
        r = ht.get(new Get(ROWS[0]));
        kvs = r.raw();
        Assert.assertEquals((long)QUALIFIERS.length, (long)kvs.length);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            this.assertIncrementKey(kvs[i], ROWS[0], FAMILY, QUALIFIERS[i], 2 * (i + 1));
        }
    }
}

