/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class TestGetRowVersions
extends HBaseClusterTestCase {
    private static final Log LOG = LogFactory.getLog(TestGetRowVersions.class);
    private static final String TABLE_NAME = "test";
    private static final byte[] CONTENTS = Bytes.toBytes((String)"contents");
    private static final byte[] ROW = Bytes.toBytes((String)"row");
    private static final byte[] VALUE1 = Bytes.toBytes((String)"value1");
    private static final byte[] VALUE2 = Bytes.toBytes((String)"value2");
    private static final long TIMESTAMP1 = 100L;
    private static final long TIMESTAMP2 = 200L;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        HTableDescriptor desc = new HTableDescriptor(TABLE_NAME);
        desc.addFamily(new HColumnDescriptor(CONTENTS));
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(desc);
    }

    public void testGetRowMultipleVersions() throws Exception {
        Put put = new Put(ROW, 100L, null);
        put.add(CONTENTS, CONTENTS, VALUE1);
        HTable table = new HTable(new Configuration(this.conf), TABLE_NAME);
        table.put(put);
        this.cluster.shutdown();
        this.zooKeeperCluster.shutdown();
        LOG.debug((Object)"HBase cluster shut down -- restarting");
        this.hBaseClusterSetup();
        table = new HTable(new Configuration(this.conf), TABLE_NAME);
        put = new Put(ROW, 200L, null);
        put.add(CONTENTS, CONTENTS, VALUE2);
        table.put(put);
        Get get = new Get(ROW);
        Result r = table.get(get);
        TestGetRowVersions.assertNotNull((Object)r);
        TestGetRowVersions.assertFalse((boolean)r.isEmpty());
        TestGetRowVersions.assertTrue((r.size() == 1 ? 1 : 0) != 0);
        byte[] value = r.getValue(CONTENTS, CONTENTS);
        TestGetRowVersions.assertTrue((value.length != 0 ? 1 : 0) != 0);
        TestGetRowVersions.assertTrue((boolean)Bytes.equals((byte[])value, (byte[])VALUE2));
        get = new Get(ROW);
        get.setMaxVersions();
        r = table.get(get);
        TestGetRowVersions.assertTrue((r.size() == 2 ? 1 : 0) != 0);
        value = r.getValue(CONTENTS, CONTENTS);
        TestGetRowVersions.assertTrue((value.length != 0 ? 1 : 0) != 0);
        TestGetRowVersions.assertTrue((boolean)Bytes.equals((byte[])value, (byte[])VALUE2));
        NavigableMap map = r.getMap();
        NavigableMap familyMap = (NavigableMap)map.get(CONTENTS);
        NavigableMap versionMap = (NavigableMap)familyMap.get(CONTENTS);
        TestGetRowVersions.assertTrue((versionMap.size() == 2 ? 1 : 0) != 0);
        TestGetRowVersions.assertTrue((boolean)Bytes.equals((byte[])VALUE1, (byte[])((byte[])versionMap.get(100L))));
        TestGetRowVersions.assertTrue((boolean)Bytes.equals((byte[])VALUE2, (byte[])((byte[])versionMap.get(200L))));
    }
}

