/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHCM {
    private static final Log LOG = LogFactory.getLog(TestHCM.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] TABLE_NAME = Bytes.toBytes((String)"test");
    private static final byte[] FAM_NAM = Bytes.toBytes((String)"f");
    private static final byte[] ROW = Bytes.toBytes((String)"bbb");
    private static Random _randy = new Random();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testManyNewConnectionsDoesnotOOME() throws SecurityException, IllegalArgumentException, ZooKeeperConnectionException, NoSuchFieldException, IllegalAccessException, InterruptedException {
        TestHCM.createNewConfigurations();
    }

    public static void createNewConfigurations() throws SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InterruptedException, ZooKeeperConnectionException {
        HConnection last = null;
        for (int i = 0; i <= 62; ++i) {
            Configuration configuration = HBaseConfiguration.create();
            configuration.set("somekey", String.valueOf(_randy.nextInt()));
            System.out.println("Hash Code: " + configuration.hashCode());
            HConnection connection = HConnectionManager.getConnection((Configuration)configuration);
            if (last != null && last == connection) {
                System.out.println("!! Got same connection for once !!");
            }
            configuration.set("someotherkey", String.valueOf(_randy.nextInt()));
            last = connection;
            LOG.info((Object)("Cache Size: " + TestHCM.getHConnectionManagerCacheSize() + ", Valid Keys: " + TestHCM.getValidKeyCount()));
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)31L, (long)TestHCM.getHConnectionManagerCacheSize());
        Assert.assertEquals((long)31L, (long)TestHCM.getValidKeyCount());
    }

    private static int getHConnectionManagerCacheSize() throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field cacheField = HConnectionManager.class.getDeclaredField("HBASE_INSTANCES");
        cacheField.setAccessible(true);
        Map cache = (Map)cacheField.get(null);
        return cache.size();
    }

    private static int getValidKeyCount() throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field cacheField = HConnectionManager.class.getDeclaredField("HBASE_INSTANCES");
        cacheField.setAccessible(true);
        Map cache = (Map)cacheField.get(null);
        ArrayList keys = new ArrayList(cache.keySet());
        HashSet values = new HashSet();
        for (Object key : keys) {
            values.add(cache.get(key));
        }
        return values.size();
    }

    @Test
    public void testRegionCaching() throws Exception {
        HTable table = TEST_UTIL.createTable(TABLE_NAME, FAM_NAM);
        TEST_UTIL.createMultiRegions(table, FAM_NAM);
        Put put = new Put(ROW);
        put.add(FAM_NAM, ROW, ROW);
        table.put(put);
        HConnectionManager.HConnectionImplementation conn = (HConnectionManager.HConnectionImplementation)table.getConnection();
        Assert.assertNotNull((Object)conn.getCachedLocation(TABLE_NAME, ROW));
        conn.deleteCachedLocation(TABLE_NAME, ROW);
        HRegionLocation rl = conn.getCachedLocation(TABLE_NAME, ROW);
        Assert.assertNull((String)("What is this location?? " + rl), (Object)rl);
    }
}

