/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHTablePool {
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] TABLENAME = Bytes.toBytes((String)"TestHTablePool");

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(TABLENAME, HConstants.CATALOG_FAMILY);
    }

    @AfterClass
    public static void afterClass() throws IOException {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testTableWithStringName() {
        HTablePool pool = new HTablePool(TEST_UTIL.getConfiguration(), Integer.MAX_VALUE);
        String tableName = Bytes.toString((byte[])TABLENAME);
        HTableInterface table = pool.getTable(tableName);
        Assert.assertNotNull((Object)table);
        pool.putTable(table);
        HTableInterface sameTable = pool.getTable(tableName);
        Assert.assertSame((Object)table, (Object)sameTable);
    }

    @Test
    public void testTableWithByteArrayName() throws IOException {
        HTablePool pool = new HTablePool(TEST_UTIL.getConfiguration(), Integer.MAX_VALUE);
        HTableInterface table = pool.getTable(TABLENAME);
        Assert.assertNotNull((Object)table);
        pool.putTable(table);
        HTableInterface sameTable = pool.getTable(TABLENAME);
        Assert.assertSame((Object)table, (Object)sameTable);
    }

    @Test
    public void testTableWithMaxSize() {
        HTablePool pool = new HTablePool(TEST_UTIL.getConfiguration(), 2);
        HTableInterface table1 = pool.getTable(TABLENAME);
        HTableInterface table2 = pool.getTable(TABLENAME);
        HTableInterface table3 = pool.getTable(TABLENAME);
        pool.putTable(table1);
        pool.putTable(table2);
        pool.putTable(table3);
        HTableInterface sameTable1 = pool.getTable(TABLENAME);
        HTableInterface sameTable2 = pool.getTable(TABLENAME);
        HTableInterface sameTable3 = pool.getTable(TABLENAME);
        Assert.assertSame((Object)table1, (Object)sameTable1);
        Assert.assertSame((Object)table2, (Object)sameTable2);
        Assert.assertNotSame((Object)table3, (Object)sameTable3);
    }

    @Test
    public void testTablesWithDifferentNames() throws IOException {
        HTablePool pool = new HTablePool(TEST_UTIL.getConfiguration(), Integer.MAX_VALUE);
        byte[] otherTable = Bytes.toBytes((String)"OtherTable");
        TEST_UTIL.createTable(otherTable, HConstants.CATALOG_FAMILY);
        HTableInterface table1 = pool.getTable(TABLENAME);
        HTableInterface table2 = pool.getTable(otherTable);
        Assert.assertNotNull((Object)table2);
        pool.putTable(table1);
        pool.putTable(table2);
        HTableInterface sameTable1 = pool.getTable(TABLENAME);
        HTableInterface sameTable2 = pool.getTable(otherTable);
        Assert.assertSame((Object)table1, (Object)sameTable1);
        Assert.assertSame((Object)table2, (Object)sameTable2);
    }

    @Test
    public void testCloseTablePool() throws IOException {
        int i;
        HTablePool pool = new HTablePool(TEST_UTIL.getConfiguration(), 4);
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        if (admin.tableExists(TABLENAME)) {
            admin.disableTable(TABLENAME);
            admin.deleteTable(TABLENAME);
        }
        HTableDescriptor tableDescriptor = new HTableDescriptor(TABLENAME);
        tableDescriptor.addFamily(new HColumnDescriptor("randomFamily"));
        admin.createTable(tableDescriptor);
        HTableInterface[] tables = new HTableInterface[4];
        for (i = 0; i < 4; ++i) {
            tables[i] = pool.getTable(TABLENAME);
        }
        pool.closeTablePool(TABLENAME);
        for (i = 0; i < 4; ++i) {
            pool.putTable(tables[i]);
        }
        Assert.assertEquals((int)4, (int)pool.getCurrentPoolSize(Bytes.toString((byte[])TABLENAME)));
        pool.closeTablePool(TABLENAME);
        Assert.assertEquals((int)0, (int)pool.getCurrentPoolSize(Bytes.toString((byte[])TABLENAME)));
    }
}

