/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestReplicationAdmin {
    private static final Log LOG = LogFactory.getLog(TestReplicationAdmin.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final String ID_ONE = "1";
    private final String KEY_ONE = "127.0.0.1:2181:/hbase";
    private final String ID_SECOND = "2";
    private final String KEY_SECOND = "127.0.0.1:2181:/hbase2";
    private static ReplicationSourceManager manager;
    private static ReplicationAdmin admin;
    private static AtomicBoolean replicating;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.replication", true);
        admin = new ReplicationAdmin(conf);
        Path oldLogDir = new Path(TEST_UTIL.getTestDir(), ".oldlogs");
        Path logDir = new Path(TEST_UTIL.getTestDir(), ".logs");
        manager = new ReplicationSourceManager(admin.getReplicationZk(), conf, null, FileSystem.get((Configuration)conf), replicating, logDir, oldLogDir);
    }

    @Test
    public void testAddRemovePeer() throws Exception {
        Assert.assertEquals((long)0L, (long)manager.getSources().size());
        admin.addPeer("1", "127.0.0.1:2181:/hbase");
        try {
            admin.addPeer("1", "127.0.0.1:2181:/hbase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        try {
            admin.removePeer("2");
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        try {
            admin.addPeer("2", "127.0.0.1:2181:/hbase2");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        admin.removePeer("1");
        Assert.assertEquals((long)0L, (long)admin.getPeersCount());
    }

    static {
        replicating = new AtomicBoolean(true);
    }
}

