/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.executor;

import java.io.IOException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.junit.Assert;
import org.junit.Test;

public class TestExecutorService {
    private static final Log LOG = LogFactory.getLog(TestExecutorService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutorService() throws Exception {
        int tries;
        int maxThreads = 5;
        int maxTries = 10;
        int sleepInterval = 10;
        ExecutorService executorService = new ExecutorService("unit_test");
        executorService.startExecutorService(ExecutorService.ExecutorType.MASTER_SERVER_OPERATIONS, maxThreads);
        ExecutorService.Executor executor = executorService.getExecutor(ExecutorService.ExecutorType.MASTER_SERVER_OPERATIONS);
        ThreadPoolExecutor pool = executor.threadPoolExecutor;
        Assert.assertEquals((long)0L, (long)pool.getPoolSize());
        AtomicBoolean lock = new AtomicBoolean(true);
        AtomicInteger counter = new AtomicInteger(0);
        for (int i = 0; i < maxThreads; ++i) {
            executorService.submit((EventHandler)new TestEventHandler(EventHandler.EventType.M_SERVER_SHUTDOWN, lock, counter));
        }
        for (tries = 0; counter.get() < maxThreads && tries < maxTries; ++tries) {
            LOG.info((Object)"Waiting for all event handlers to start...");
            Thread.sleep(sleepInterval);
        }
        Assert.assertEquals((long)maxThreads, (long)counter.get());
        Assert.assertEquals((long)maxThreads, (long)pool.getPoolSize());
        AtomicBoolean atomicBoolean = lock;
        synchronized (atomicBoolean) {
            lock.set(false);
            lock.notifyAll();
        }
        while (counter.get() < maxThreads * 2 && tries < maxTries) {
            System.out.println("Waiting for all event handlers to finish...");
            Thread.sleep(sleepInterval);
            ++tries;
        }
        Assert.assertEquals((long)(maxThreads * 2), (long)counter.get());
        Assert.assertEquals((long)maxThreads, (long)pool.getPoolSize());
        for (int i = 0; i < 2 * maxThreads; ++i) {
            executorService.submit((EventHandler)new TestEventHandler(EventHandler.EventType.M_SERVER_SHUTDOWN, lock, counter));
        }
        AtomicBoolean atomicBoolean2 = lock;
        synchronized (atomicBoolean2) {
            lock.set(false);
            lock.notifyAll();
        }
        executor.getClass();
        Thread.sleep(1000L * 2L);
        Assert.assertEquals((long)maxThreads, (long)pool.getPoolSize());
    }

    public static class TestEventHandler
    extends EventHandler {
        private AtomicBoolean lock;
        private AtomicInteger counter;

        public TestEventHandler(EventHandler.EventType eventType, AtomicBoolean lock, AtomicInteger counter) {
            super(null, eventType);
            this.lock = lock;
            this.counter = counter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() throws IOException {
            int num = this.counter.incrementAndGet();
            LOG.info((Object)("Running process #" + num + ", threadName=" + Thread.currentThread().getName()));
            AtomicBoolean atomicBoolean = this.lock;
            synchronized (atomicBoolean) {
                while (this.lock.get()) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.counter.incrementAndGet();
        }
    }
}

