/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;

public class TestColumnPrefixFilter {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @Test
    public void testColumnPrefixFilter() throws IOException {
        String family = "Family";
        HTableDescriptor htd = new HTableDescriptor("TestColumnPrefixFilter");
        htd.addFamily(new HColumnDescriptor(family));
        HRegionInfo info = new HRegionInfo(htd, null, null, false);
        HRegion region = HRegion.createHRegion((HRegionInfo)info, (Path)HBaseTestingUtility.getTestDir(), (Configuration)TEST_UTIL.getConfiguration());
        List<String> rows = this.generateRandomWords(100, "row");
        List<String> columns = this.generateRandomWords(10000, "column");
        long maxTimestamp = 2L;
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        HashMap prefixMap = new HashMap();
        prefixMap.put("p", new ArrayList());
        prefixMap.put("s", new ArrayList());
        String valueString = "ValueString";
        for (String row : rows) {
            Put p = new Put(Bytes.toBytes((String)row));
            for (String column : columns) {
                for (long timestamp = 1L; timestamp <= maxTimestamp; ++timestamp) {
                    KeyValue kv = KeyValueTestUtil.create(row, family, column, timestamp, valueString);
                    p.add(kv);
                    kvList.add(kv);
                    for (String s : prefixMap.keySet()) {
                        if (!column.startsWith(s)) continue;
                        ((List)prefixMap.get(s)).add(kv);
                    }
                }
            }
            region.put(p);
        }
        Scan scan = new Scan();
        scan.setMaxVersions();
        for (String s : prefixMap.keySet()) {
            ColumnPrefixFilter filter = new ColumnPrefixFilter(Bytes.toBytes((String)s));
            scan.setFilter((Filter)filter);
            InternalScanner scanner = region.getScanner(scan);
            ArrayList results = new ArrayList();
            while (scanner.next(results)) {
            }
            Assert.assertEquals((long)((List)prefixMap.get(s)).size(), (long)results.size());
        }
    }

    List<String> generateRandomWords(int numberOfWords, String suffix) {
        HashSet<String> wordSet = new HashSet<String>();
        for (int i = 0; i < numberOfWords; ++i) {
            int lengthOfWords = (int)(Math.random() * 2.0) + 1;
            char[] wordChar = new char[lengthOfWords];
            for (int j = 0; j < wordChar.length; ++j) {
                wordChar[j] = (char)(Math.random() * 26.0 + 97.0);
            }
            String word = suffix == null ? new String(wordChar) : new String(wordChar) + suffix;
            wordSet.add(word);
        }
        ArrayList<String> wordList = new ArrayList<String>(wordSet);
        return wordList;
    }
}

