/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.nio.ByteBuffer;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.util.ClassSize;

public class TestLruBlockCache
extends TestCase {
    public void testBackgroundEvictionThread() throws Exception {
        Block[] blocks;
        long maxSize = 100000L;
        long blockSize = this.calculateBlockSizeDefault(maxSize, 9);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize);
        for (Block block : blocks = this.generateFixedBlocks(10, blockSize, "block")) {
            cache.cacheBlock(block.blockName, block.buf);
        }
        int n = 0;
        while (cache.getEvictionCount() == 0L) {
            System.out.println("sleep");
            Thread.sleep(1000L);
            TestLruBlockCache.assertTrue((n++ < 2 ? 1 : 0) != 0);
        }
        System.out.println("Background Evictions run: " + cache.getEvictionCount());
        TestLruBlockCache.assertEquals((long)cache.getEvictionCount(), (long)1L);
    }

    public void testCacheSimple() throws Exception {
        ByteBuffer buf;
        long maxSize = 1000000L;
        long blockSize = this.calculateBlockSizeDefault(maxSize, 101);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize);
        Block[] blocks = this.generateRandomBlocks(100, blockSize);
        long expectedCacheSize = cache.heapSize();
        for (Block block : blocks) {
            TestLruBlockCache.assertTrue((cache.getBlock(block.blockName, true) == null ? 1 : 0) != 0);
        }
        for (Block block : blocks) {
            cache.cacheBlock(block.blockName, block.buf);
            expectedCacheSize += block.heapSize();
        }
        TestLruBlockCache.assertEquals((long)expectedCacheSize, (long)cache.heapSize());
        for (Block block : blocks) {
            buf = cache.getBlock(block.blockName, true);
            TestLruBlockCache.assertTrue((buf != null ? 1 : 0) != 0);
            TestLruBlockCache.assertEquals((int)buf.capacity(), (int)block.buf.capacity());
        }
        for (Block block : blocks) {
            try {
                cache.cacheBlock(block.blockName, block.buf);
                TestLruBlockCache.assertTrue((String)"Cache should not allow re-caching a block", (boolean)false);
            }
            catch (RuntimeException re) {
                // empty catch block
            }
        }
        TestLruBlockCache.assertEquals((long)expectedCacheSize, (long)cache.heapSize());
        for (Block block : blocks) {
            buf = cache.getBlock(block.blockName, true);
            TestLruBlockCache.assertTrue((buf != null ? 1 : 0) != 0);
            TestLruBlockCache.assertEquals((int)buf.capacity(), (int)block.buf.capacity());
        }
        TestLruBlockCache.assertEquals((long)0L, (long)cache.getEvictionCount());
        LruBlockCache.StatisticsThread t = new LruBlockCache.StatisticsThread(cache);
        t.start();
        t.join();
    }

    public void testCacheEvictionSimple() throws Exception {
        long maxSize = 100000L;
        long blockSize = this.calculateBlockSizeDefault(maxSize, 10);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize, false);
        Block[] blocks = this.generateFixedBlocks(10, blockSize, "block");
        long expectedCacheSize = cache.heapSize();
        for (Block block : blocks) {
            cache.cacheBlock(block.blockName, block.buf);
            expectedCacheSize += block.heapSize();
        }
        TestLruBlockCache.assertEquals((long)1L, (long)cache.getEvictionCount());
        TestLruBlockCache.assertTrue(((float)expectedCacheSize > (float)maxSize * 0.85f ? 1 : 0) != 0);
        TestLruBlockCache.assertTrue((cache.heapSize() < maxSize ? 1 : 0) != 0);
        TestLruBlockCache.assertTrue(((float)cache.heapSize() < (float)maxSize * 0.85f ? 1 : 0) != 0);
        TestLruBlockCache.assertTrue((cache.getBlock(blocks[0].blockName, true) == null ? 1 : 0) != 0);
        TestLruBlockCache.assertTrue((cache.getBlock(blocks[1].blockName, true) == null ? 1 : 0) != 0);
        for (int i = 2; i < blocks.length; ++i) {
            TestLruBlockCache.assertEquals((Object)cache.getBlock(blocks[i].blockName, true), (Object)blocks[i].buf);
        }
    }

    public void testCacheEvictionTwoPriorities() throws Exception {
        long maxSize = 100000L;
        long blockSize = this.calculateBlockSizeDefault(maxSize, 10);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize, false);
        Block[] singleBlocks = this.generateFixedBlocks(5, 10000, "single");
        Block[] multiBlocks = this.generateFixedBlocks(5, 10000, "multi");
        long expectedCacheSize = cache.heapSize();
        for (Block block : multiBlocks) {
            cache.cacheBlock(block.blockName, block.buf);
            expectedCacheSize += block.heapSize();
            TestLruBlockCache.assertEquals((Object)cache.getBlock(block.blockName, true), (Object)block.buf);
        }
        for (Block block : singleBlocks) {
            cache.cacheBlock(block.blockName, block.buf);
            expectedCacheSize += block.heapSize();
        }
        TestLruBlockCache.assertEquals((long)cache.getEvictionCount(), (long)1L);
        TestLruBlockCache.assertEquals((long)cache.getEvictedCount(), (long)2L);
        TestLruBlockCache.assertTrue(((float)expectedCacheSize > (float)maxSize * 0.85f ? 1 : 0) != 0);
        TestLruBlockCache.assertTrue((cache.heapSize() <= maxSize ? 1 : 0) != 0);
        TestLruBlockCache.assertTrue(((float)cache.heapSize() <= (float)maxSize * 0.85f ? 1 : 0) != 0);
        TestLruBlockCache.assertTrue((cache.getBlock(singleBlocks[0].blockName, true) == null ? 1 : 0) != 0);
        TestLruBlockCache.assertTrue((cache.getBlock(multiBlocks[0].blockName, true) == null ? 1 : 0) != 0);
        for (int i = 1; i < 4; ++i) {
            TestLruBlockCache.assertEquals((Object)cache.getBlock(singleBlocks[i].blockName, true), (Object)singleBlocks[i].buf);
            TestLruBlockCache.assertEquals((Object)cache.getBlock(multiBlocks[i].blockName, true), (Object)multiBlocks[i].buf);
        }
    }

    public void testCacheEvictionThreePriorities() throws Exception {
        long maxSize = 100000L;
        long blockSize = this.calculateBlockSize(maxSize, 10);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize, false, (int)Math.ceil(1.2 * (double)maxSize / (double)blockSize), 0.75f, 16, 0.98f, 0.99f, 0.33f, 0.33f, 0.34f);
        Block[] singleBlocks = this.generateFixedBlocks(5, blockSize, "single");
        Block[] multiBlocks = this.generateFixedBlocks(5, blockSize, "multi");
        Block[] memoryBlocks = this.generateFixedBlocks(5, blockSize, "memory");
        long expectedCacheSize = cache.heapSize();
        for (int i = 0; i < 3; ++i) {
            cache.cacheBlock(singleBlocks[i].blockName, singleBlocks[i].buf);
            expectedCacheSize += singleBlocks[i].heapSize();
            cache.cacheBlock(multiBlocks[i].blockName, multiBlocks[i].buf);
            expectedCacheSize += multiBlocks[i].heapSize();
            cache.getBlock(multiBlocks[i].blockName, true);
            cache.cacheBlock(memoryBlocks[i].blockName, memoryBlocks[i].buf, true);
            expectedCacheSize += memoryBlocks[i].heapSize();
        }
        TestLruBlockCache.assertEquals((long)0L, (long)cache.getEvictionCount());
        TestLruBlockCache.assertEquals((long)expectedCacheSize, (long)cache.heapSize());
        cache.cacheBlock(singleBlocks[3].blockName, singleBlocks[3].buf);
        TestLruBlockCache.assertEquals((long)1L, (long)cache.getEvictionCount());
        TestLruBlockCache.assertEquals((long)1L, (long)cache.getEvictedCount());
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(singleBlocks[0].blockName, true));
        cache.getBlock(singleBlocks[1].blockName, true);
        cache.cacheBlock(singleBlocks[4].blockName, singleBlocks[4].buf);
        TestLruBlockCache.assertEquals((long)2L, (long)cache.getEvictionCount());
        TestLruBlockCache.assertEquals((long)2L, (long)cache.getEvictedCount());
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(multiBlocks[0].blockName, true));
        cache.cacheBlock(memoryBlocks[3].blockName, memoryBlocks[3].buf, true);
        TestLruBlockCache.assertEquals((long)3L, (long)cache.getEvictionCount());
        TestLruBlockCache.assertEquals((long)3L, (long)cache.getEvictedCount());
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(memoryBlocks[0].blockName, true));
        Block[] bigBlocks = this.generateFixedBlocks(3, blockSize * 3L, "big");
        cache.cacheBlock(bigBlocks[0].blockName, bigBlocks[0].buf);
        TestLruBlockCache.assertEquals((long)4L, (long)cache.getEvictionCount());
        TestLruBlockCache.assertEquals((long)6L, (long)cache.getEvictedCount());
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(singleBlocks[2].blockName, true));
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(singleBlocks[3].blockName, true));
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(singleBlocks[4].blockName, true));
        cache.getBlock(bigBlocks[0].blockName, true);
        cache.cacheBlock(bigBlocks[1].blockName, bigBlocks[1].buf);
        TestLruBlockCache.assertEquals((long)5L, (long)cache.getEvictionCount());
        TestLruBlockCache.assertEquals((long)9L, (long)cache.getEvictedCount());
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(singleBlocks[1].blockName, true));
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(multiBlocks[1].blockName, true));
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(multiBlocks[2].blockName, true));
        cache.cacheBlock(bigBlocks[2].blockName, bigBlocks[2].buf, true);
        TestLruBlockCache.assertEquals((long)6L, (long)cache.getEvictionCount());
        TestLruBlockCache.assertEquals((long)12L, (long)cache.getEvictedCount());
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(memoryBlocks[1].blockName, true));
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(memoryBlocks[2].blockName, true));
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(memoryBlocks[3].blockName, true));
    }

    public void testScanResistance() throws Exception {
        int i;
        Block[] multiBlocks;
        long maxSize = 100000L;
        long blockSize = this.calculateBlockSize(maxSize, 10);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize, false, (int)Math.ceil(1.2 * (double)maxSize / (double)blockSize), 0.75f, 16, 0.66f, 0.99f, 0.33f, 0.33f, 0.34f);
        Block[] singleBlocks = this.generateFixedBlocks(20, blockSize, "single");
        for (Block block : multiBlocks = this.generateFixedBlocks(5, blockSize, "multi")) {
            cache.cacheBlock(block.blockName, block.buf);
            cache.getBlock(block.blockName, true);
        }
        for (i = 0; i < 5; ++i) {
            cache.cacheBlock(singleBlocks[i].blockName, singleBlocks[i].buf);
        }
        TestLruBlockCache.assertEquals((long)1L, (long)cache.getEvictionCount());
        TestLruBlockCache.assertEquals((long)4L, (long)cache.getEvictedCount());
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(singleBlocks[0].blockName, true));
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(singleBlocks[1].blockName, true));
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(multiBlocks[0].blockName, true));
        TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(multiBlocks[1].blockName, true));
        for (i = 5; i < 18; ++i) {
            cache.cacheBlock(singleBlocks[i].blockName, singleBlocks[i].buf);
        }
        TestLruBlockCache.assertEquals((long)4L, (long)cache.getEvictionCount());
        TestLruBlockCache.assertEquals((long)16L, (long)cache.getEvictedCount());
        TestLruBlockCache.assertEquals((long)7L, (long)cache.size());
    }

    public void testResizeBlockCache() throws Exception {
        int i;
        long maxSize = 300000L;
        long blockSize = this.calculateBlockSize(maxSize, 31);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize, false, (int)Math.ceil(1.2 * (double)maxSize / (double)blockSize), 0.75f, 16, 0.98f, 0.99f, 0.33f, 0.33f, 0.34f);
        Block[] singleBlocks = this.generateFixedBlocks(10, blockSize, "single");
        Block[] multiBlocks = this.generateFixedBlocks(10, blockSize, "multi");
        Block[] memoryBlocks = this.generateFixedBlocks(10, blockSize, "memory");
        for (i = 0; i < 10; ++i) {
            cache.cacheBlock(singleBlocks[i].blockName, singleBlocks[i].buf);
            cache.cacheBlock(multiBlocks[i].blockName, multiBlocks[i].buf);
            cache.getBlock(multiBlocks[i].blockName, true);
            cache.cacheBlock(memoryBlocks[i].blockName, memoryBlocks[i].buf, true);
        }
        TestLruBlockCache.assertEquals((long)0L, (long)cache.getEvictionCount());
        cache.setMaxSize((long)((float)maxSize * 0.5f));
        TestLruBlockCache.assertEquals((long)1L, (long)cache.getEvictionCount());
        TestLruBlockCache.assertEquals((long)15L, (long)cache.getEvictedCount());
        for (i = 0; i < 5; ++i) {
            TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(singleBlocks[i].blockName, true));
            TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(multiBlocks[i].blockName, true));
            TestLruBlockCache.assertEquals(null, (Object)cache.getBlock(memoryBlocks[i].blockName, true));
        }
        for (i = 5; i < 10; ++i) {
            TestLruBlockCache.assertEquals((Object)singleBlocks[i].buf, (Object)cache.getBlock(singleBlocks[i].blockName, true));
            TestLruBlockCache.assertEquals((Object)multiBlocks[i].buf, (Object)cache.getBlock(multiBlocks[i].blockName, true));
            TestLruBlockCache.assertEquals((Object)memoryBlocks[i].buf, (Object)cache.getBlock(memoryBlocks[i].blockName, true));
        }
    }

    private Block[] generateFixedBlocks(int numBlocks, int size, String pfx) {
        Block[] blocks = new Block[numBlocks];
        for (int i = 0; i < numBlocks; ++i) {
            blocks[i] = new Block(pfx + i, size);
        }
        return blocks;
    }

    private Block[] generateFixedBlocks(int numBlocks, long size, String pfx) {
        return this.generateFixedBlocks(numBlocks, (int)size, pfx);
    }

    private Block[] generateRandomBlocks(int numBlocks, long maxSize) {
        Block[] blocks = new Block[numBlocks];
        Random r = new Random();
        for (int i = 0; i < numBlocks; ++i) {
            blocks[i] = new Block("block" + i, r.nextInt((int)maxSize) + 1);
        }
        return blocks;
    }

    private long calculateBlockSize(long maxSize, int numBlocks) {
        long roughBlockSize = maxSize / (long)numBlocks;
        int numEntries = (int)Math.ceil(1.2 * (double)maxSize / (double)roughBlockSize);
        long totalOverhead = LruBlockCache.CACHE_FIXED_OVERHEAD + (long)ClassSize.CONCURRENT_HASHMAP + (long)(numEntries * ClassSize.CONCURRENT_HASHMAP_ENTRY) + (long)(16 * ClassSize.CONCURRENT_HASHMAP_SEGMENT);
        long negateBlockSize = totalOverhead / (long)numEntries;
        return ClassSize.align((long)((long)Math.floor((float)(roughBlockSize - (negateBlockSize += CachedBlock.PER_BLOCK_OVERHEAD)) * 0.99f)));
    }

    private long calculateBlockSizeDefault(long maxSize, int numBlocks) {
        long roughBlockSize = maxSize / (long)numBlocks;
        int numEntries = (int)Math.ceil(1.2 * (double)maxSize / (double)roughBlockSize);
        long totalOverhead = LruBlockCache.CACHE_FIXED_OVERHEAD + (long)ClassSize.CONCURRENT_HASHMAP + (long)(numEntries * ClassSize.CONCURRENT_HASHMAP_ENTRY) + (long)(16 * ClassSize.CONCURRENT_HASHMAP_SEGMENT);
        long negateBlockSize = totalOverhead / (long)numEntries;
        return ClassSize.align((long)((long)Math.floor((float)(roughBlockSize - (negateBlockSize += CachedBlock.PER_BLOCK_OVERHEAD)) * 0.85f)));
    }

    private static class Block
    implements HeapSize {
        String blockName;
        ByteBuffer buf;

        Block(String blockName, int size) {
            this.blockName = blockName;
            this.buf = ByteBuffer.allocate(size);
        }

        public long heapSize() {
            return CachedBlock.PER_BLOCK_OVERHEAD + (long)ClassSize.align((int)this.blockName.length()) + (long)ClassSize.align((int)this.buf.capacity());
        }
    }
}

