/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.Bytes;

public class TestSeekTo
extends HBaseTestCase {
    Path makeNewFile() throws IOException {
        Path ncTFile = new Path(this.testDir, "basic.hfile");
        FSDataOutputStream fout = this.fs.create(ncTFile);
        HFile.Writer writer = new HFile.Writer(fout, 40, "none", null);
        writer.append(Bytes.toBytes((String)"c"), Bytes.toBytes((String)"value"));
        writer.append(Bytes.toBytes((String)"e"), Bytes.toBytes((String)"value"));
        writer.append(Bytes.toBytes((String)"g"), Bytes.toBytes((String)"value"));
        writer.append(Bytes.toBytes((String)"i"), Bytes.toBytes((String)"value"));
        writer.append(Bytes.toBytes((String)"k"), Bytes.toBytes((String)"value"));
        writer.close();
        fout.close();
        return ncTFile;
    }

    public void testSeekBefore() throws Exception {
        Path p = this.makeNewFile();
        HFile.Reader reader = new HFile.Reader(this.fs, p, null, false);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(false, true);
        TestSeekTo.assertEquals((boolean)false, (boolean)scanner.seekBefore(Bytes.toBytes((String)"a")));
        TestSeekTo.assertEquals((boolean)false, (boolean)scanner.seekBefore(Bytes.toBytes((String)"c")));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes((String)"d")));
        TestSeekTo.assertEquals((String)"c", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes((String)"e")));
        TestSeekTo.assertEquals((String)"c", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes((String)"f")));
        TestSeekTo.assertEquals((String)"e", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes((String)"g")));
        TestSeekTo.assertEquals((String)"e", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes((String)"h")));
        TestSeekTo.assertEquals((String)"g", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes((String)"i")));
        TestSeekTo.assertEquals((String)"g", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes((String)"j")));
        TestSeekTo.assertEquals((String)"i", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes((String)"k")));
        TestSeekTo.assertEquals((String)"i", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(Bytes.toBytes((String)"l")));
        TestSeekTo.assertEquals((String)"k", (String)scanner.getKeyString());
    }

    public void testSeekTo() throws Exception {
        Path p = this.makeNewFile();
        HFile.Reader reader = new HFile.Reader(this.fs, p, null, false);
        reader.loadFileInfo();
        TestSeekTo.assertEquals((int)2, (int)reader.blockIndex.count);
        HFileScanner scanner = reader.getScanner(false, true);
        TestSeekTo.assertEquals((int)-1, (int)scanner.seekTo(Bytes.toBytes((String)"a")));
        TestSeekTo.assertEquals((int)1, (int)scanner.seekTo(Bytes.toBytes((String)"d")));
        TestSeekTo.assertEquals((String)"c", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((int)1, (int)scanner.seekTo(Bytes.toBytes((String)"h")));
        TestSeekTo.assertEquals((String)"g", (String)scanner.getKeyString());
        TestSeekTo.assertEquals((int)1, (int)scanner.seekTo(Bytes.toBytes((String)"l")));
        TestSeekTo.assertEquals((String)"k", (String)scanner.getKeyString());
    }

    public void testBlockContainingKey() throws Exception {
        Path p = this.makeNewFile();
        HFile.Reader reader = new HFile.Reader(this.fs, p, null, false);
        reader.loadFileInfo();
        System.out.println(reader.blockIndex.toString());
        TestSeekTo.assertEquals((int)-1, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes((String)"a"), 0, 1));
        TestSeekTo.assertEquals((int)0, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes((String)"c"), 0, 1));
        TestSeekTo.assertEquals((int)0, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes((String)"d"), 0, 1));
        TestSeekTo.assertEquals((int)0, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes((String)"e"), 0, 1));
        TestSeekTo.assertEquals((int)0, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes((String)"g"), 0, 1));
        TestSeekTo.assertEquals((int)0, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes((String)"h"), 0, 1));
        TestSeekTo.assertEquals((int)1, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes((String)"i"), 0, 1));
        TestSeekTo.assertEquals((int)1, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes((String)"j"), 0, 1));
        TestSeekTo.assertEquals((int)1, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes((String)"k"), 0, 1));
        TestSeekTo.assertEquals((int)1, (int)reader.blockIndex.blockContainingKey(Bytes.toBytes((String)"l"), 0, 1));
    }
}

