/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.mapreduce.ImportTsv;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;

public class TestImportTsv {
    @Test
    public void testTsvParserSpecParsing() {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
        parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col1:scol1", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(1));
        this.assertBytesEquals(Bytes.toBytes((String)"scol1"), parser.getQualifier(1));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
        parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col1:scol1,col1:scol2", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(1));
        this.assertBytesEquals(Bytes.toBytes((String)"scol1"), parser.getQualifier(1));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(2));
        this.assertBytesEquals(Bytes.toBytes((String)"scol2"), parser.getQualifier(2));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
    }

    @Test
    public void testTsvParser() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("col_a,col_b:qual,HBASE_ROW_KEY,col_d", "\t");
        this.assertBytesEquals(Bytes.toBytes((String)"col_a"), parser.getFamily(0));
        this.assertBytesEquals(HConstants.EMPTY_BYTE_ARRAY, parser.getQualifier(0));
        this.assertBytesEquals(Bytes.toBytes((String)"col_b"), parser.getFamily(1));
        this.assertBytesEquals(Bytes.toBytes((String)"qual"), parser.getQualifier(1));
        Assert.assertNull((Object)parser.getFamily(2));
        Assert.assertNull((Object)parser.getQualifier(2));
        Assert.assertEquals((long)2L, (long)parser.getRowKeyColumnIndex());
        byte[] line = Bytes.toBytes((String)"val_a\tval_b\tval_c\tval_d");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
        this.checkParsing(parsed, Splitter.on((String)"\t").split((CharSequence)Bytes.toString((byte[])line)));
    }

    private void checkParsing(ImportTsv.TsvParser.ParsedLine parsed, Iterable<String> expected) {
        ArrayList<String> parsedCols = new ArrayList<String>();
        for (int i = 0; i < parsed.getColumnCount(); ++i) {
            parsedCols.add(Bytes.toString((byte[])parsed.getLineBytes(), (int)parsed.getColumnOffset(i), (int)parsed.getColumnLength(i)));
        }
        if (!Iterables.elementsEqual(parsedCols, expected)) {
            Assert.fail((String)("Expected: " + Joiner.on((String)",").join(expected) + "\n" + "Got:" + Joiner.on((String)",").join(parsedCols)));
        }
    }

    private void assertBytesEquals(byte[] a, byte[] b) {
        Assert.assertEquals((Object)Bytes.toStringBinary((byte[])a), (Object)Bytes.toStringBinary((byte[])b));
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineExcessiveColumns() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col_a", "\t");
        byte[] line = Bytes.toBytes((String)"val_a\tval_b\tval_c");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineZeroColumn() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col_a", "\t");
        byte[] line = Bytes.toBytes((String)"");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineOnlyKey() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col_a", "\t");
        byte[] line = Bytes.toBytes((String)"key_only");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineNoRowKey() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("col_a,HBASE_ROW_KEY", "\t");
        byte[] line = Bytes.toBytes((String)"only_cola_data_and_no_row_key");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
    }
}

