/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;

public class TestLoadIncrementalHFiles {
    private static final byte[] TABLE = Bytes.toBytes((String)"mytable");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"myqual");
    private static final byte[] FAMILY = Bytes.toBytes((String)"myfam");
    private static final byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"ppp")};
    public static int BLOCKSIZE = 65536;
    public static String COMPRESSION = Compression.Algorithm.NONE.getName();
    private HBaseTestingUtility util = new HBaseTestingUtility();

    @Test
    public void testSimpleLoad() throws Exception {
        this.runTest("testSimpleLoad", new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"cccc")}, new byte[][]{Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"ooo")}});
    }

    @Test
    public void testRegionCrossingLoad() throws Exception {
        this.runTest("testRegionCrossingLoad", new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(String testName, byte[][][] hfileRanges) throws Exception {
        Path dir = HBaseTestingUtility.getTestDir(testName);
        FileSystem fs = this.util.getTestFileSystem();
        dir = dir.makeQualified(fs);
        Path familyDir = new Path(dir, Bytes.toString((byte[])FAMILY));
        int hfileIdx = 0;
        for (byte[][] range : hfileRanges) {
            byte[] from = range[0];
            byte[] to = range[1];
            TestLoadIncrementalHFiles.createHFile(fs, new Path(familyDir, "hfile_" + hfileIdx++), FAMILY, QUALIFIER, from, to, 1000);
        }
        int expectedRows = hfileIdx * 1000;
        this.util.startMiniCluster();
        try {
            HBaseAdmin admin = new HBaseAdmin(this.util.getConfiguration());
            HTableDescriptor htd = new HTableDescriptor(TABLE);
            htd.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(htd, SPLIT_KEYS);
            HTable table = new HTable(this.util.getConfiguration(), TABLE);
            this.util.waitTableAvailable(TABLE, 30000L);
            LoadIncrementalHFiles loader = new LoadIncrementalHFiles(this.util.getConfiguration());
            loader.doBulkLoad(dir, table);
            Assert.assertEquals((long)expectedRows, (long)this.util.countRows(table));
        }
        finally {
            this.util.shutdownMiniCluster();
        }
    }

    @Test
    public void testSplitStoreFile() throws IOException {
        Path dir = HBaseTestingUtility.getTestDir("testSplitHFile");
        FileSystem fs = this.util.getTestFileSystem();
        Path testIn = new Path(dir, "testhfile");
        HColumnDescriptor familyDesc = new HColumnDescriptor(FAMILY);
        TestLoadIncrementalHFiles.createHFile(fs, testIn, FAMILY, QUALIFIER, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 1000);
        Path bottomOut = new Path(dir, "bottom.out");
        Path topOut = new Path(dir, "top.out");
        LoadIncrementalHFiles.splitStoreFile((Configuration)this.util.getConfiguration(), (Path)testIn, (HColumnDescriptor)familyDesc, (byte[])Bytes.toBytes((String)"ggg"), (Path)bottomOut, (Path)topOut);
        int rowCount = this.verifyHFile(bottomOut);
        Assert.assertEquals((long)1000L, (long)(rowCount += this.verifyHFile(topOut)));
    }

    private int verifyHFile(Path p) throws IOException {
        Configuration conf = this.util.getConfiguration();
        HFile.Reader reader = new HFile.Reader(p.getFileSystem(conf), p, null, false);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(false, false);
        scanner.seekTo();
        int count = 0;
        do {
            ++count;
        } while (scanner.next());
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createHFile(FileSystem fs, Path path, byte[] family, byte[] qualifier, byte[] startKey, byte[] endKey, int numRows) throws IOException {
        HFile.Writer writer = new HFile.Writer(fs, path, BLOCKSIZE, COMPRESSION, KeyValue.KEY_COMPARATOR);
        long now = System.currentTimeMillis();
        try {
            for (byte[] key : Bytes.iterateOnSplits((byte[])startKey, (byte[])endKey, (int)(numRows - 2))) {
                KeyValue kv = new KeyValue(key, family, qualifier, now, key);
                writer.append(kv);
            }
        }
        finally {
            writer.close();
        }
    }
}

