/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.YouAreDeadException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class BROKE_FIX_TestKillingServersFromMaster {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster;

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.startMiniCluster(2);
        cluster = TEST_UTIL.getHBaseCluster();
    }

    @AfterClass
    public static void afterAllTests() throws IOException {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        TEST_UTIL.ensureSomeRegionServersAvailable(2);
    }

    @Ignore
    @Test(timeout=180000L)
    public void testRsReportsWrongStartCode() throws Exception {
        MiniHBaseCluster.MiniHBaseClusterRegionServer firstServer = (MiniHBaseCluster.MiniHBaseClusterRegionServer)cluster.getRegionServer(0);
        HServerInfo hsi = firstServer.getServerInfo();
        firstServer.setHServerInfo(new HServerInfo(hsi.getServerAddress(), hsi.getInfoPort(), hsi.getHostname()));
        cluster.waitOnRegionServer(0);
        Assert.assertEquals((long)1L, (long)cluster.getLiveRegionServerThreads().size());
    }

    @Ignore
    @Test(timeout=180000L)
    public void testRsReportsWrongAddress() throws Exception {
        MiniHBaseCluster.MiniHBaseClusterRegionServer firstServer = (MiniHBaseCluster.MiniHBaseClusterRegionServer)cluster.getRegionServer(0);
        firstServer.getHServerInfo().setServerAddress(new HServerAddress("0.0.0.0", 60010));
        cluster.waitOnRegionServer(0);
        Assert.assertEquals((long)1L, (long)cluster.getLiveRegionServerThreads().size());
    }

    @Ignore
    @Test(timeout=180000L)
    public void testSendYouAreDead() throws Exception {
        cluster.addExceptionToSendRegionServer(0, (IOException)new YouAreDeadException("bam!"));
        cluster.waitOnRegionServer(0);
        Assert.assertEquals((long)1L, (long)cluster.getLiveRegionServerThreads().size());
    }
}

