/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.master.ActiveMasterManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestActiveMasterManager {
    private static final Log LOG = LogFactory.getLog(TestActiveMasterManager.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testRestartMaster() throws IOException, KeeperException {
        ZooKeeperWatcher zk = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "testActiveMasterManagerFromZK", null);
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)zk, (String)zk.baseZNode);
        try {
            ZKUtil.deleteNode((ZooKeeperWatcher)zk, (String)zk.masterAddressZNode);
        }
        catch (KeeperException.NoNodeException nne) {
            // empty catch block
        }
        HServerAddress master = new HServerAddress("localhost", 1);
        DummyMaster dummyMaster = new DummyMaster();
        ActiveMasterManager activeMasterManager = new ActiveMasterManager(zk, master, (Server)dummyMaster);
        zk.registerListener((ZooKeeperListener)activeMasterManager);
        Assert.assertFalse((boolean)activeMasterManager.clusterHasActiveMaster.get());
        activeMasterManager.blockUntilBecomingActiveMaster();
        Assert.assertTrue((boolean)activeMasterManager.clusterHasActiveMaster.get());
        this.assertMaster(zk, master);
        DummyMaster secondDummyMaster = new DummyMaster();
        ActiveMasterManager secondActiveMasterManager = new ActiveMasterManager(zk, master, (Server)secondDummyMaster);
        zk.registerListener((ZooKeeperListener)secondActiveMasterManager);
        Assert.assertFalse((boolean)secondActiveMasterManager.clusterHasActiveMaster.get());
        activeMasterManager.blockUntilBecomingActiveMaster();
        Assert.assertTrue((boolean)activeMasterManager.clusterHasActiveMaster.get());
        this.assertMaster(zk, master);
    }

    @Test
    public void testActiveMasterManagerFromZK() throws Exception {
        int sleeps;
        ZooKeeperWatcher zk = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "testActiveMasterManagerFromZK", null);
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)zk, (String)zk.baseZNode);
        try {
            ZKUtil.deleteNode((ZooKeeperWatcher)zk, (String)zk.masterAddressZNode);
        }
        catch (KeeperException.NoNodeException nne) {
            // empty catch block
        }
        HServerAddress firstMasterAddress = new HServerAddress("localhost", 1);
        HServerAddress secondMasterAddress = new HServerAddress("localhost", 2);
        DummyMaster ms1 = new DummyMaster();
        ActiveMasterManager activeMasterManager = new ActiveMasterManager(zk, firstMasterAddress, (Server)ms1);
        zk.registerListener((ZooKeeperListener)activeMasterManager);
        Assert.assertFalse((boolean)activeMasterManager.clusterHasActiveMaster.get());
        activeMasterManager.blockUntilBecomingActiveMaster();
        Assert.assertTrue((boolean)activeMasterManager.clusterHasActiveMaster.get());
        this.assertMaster(zk, firstMasterAddress);
        WaitToBeMasterThread t = new WaitToBeMasterThread(zk, secondMasterAddress);
        zk.registerListener((ZooKeeperListener)t.manager);
        t.start();
        for (sleeps = 0; !t.manager.clusterHasActiveMaster.get() && sleeps < 100; ++sleeps) {
            Thread.sleep(10L);
        }
        Assert.assertTrue((boolean)activeMasterManager.clusterHasActiveMaster.get());
        Assert.assertTrue((boolean)t.manager.clusterHasActiveMaster.get());
        Assert.assertFalse((boolean)t.isActiveMaster);
        ms1.stop("stopping first server");
        NodeDeletionListener listener = new NodeDeletionListener(zk, zk.masterAddressZNode);
        zk.registerListener((ZooKeeperListener)listener);
        LOG.info((Object)"Deleting master node");
        ZKUtil.deleteNode((ZooKeeperWatcher)zk, (String)zk.masterAddressZNode);
        LOG.info((Object)"Waiting for active master manager to be notified");
        listener.waitForDeletion();
        LOG.info((Object)"Master node deleted");
        for (sleeps = 0; !t.isActiveMaster && sleeps < 100; ++sleeps) {
            Thread.sleep(10L);
        }
        LOG.debug((Object)("Slept " + sleeps + " times"));
        Assert.assertTrue((boolean)t.manager.clusterHasActiveMaster.get());
        Assert.assertTrue((boolean)t.isActiveMaster);
        LOG.info((Object)"Deleting master node");
        ZKUtil.deleteNode((ZooKeeperWatcher)zk, (String)zk.masterAddressZNode);
    }

    private void assertMaster(ZooKeeperWatcher zk, HServerAddress expectedAddress) throws KeeperException {
        HServerAddress readAddress = ZKUtil.getDataAsAddress((ZooKeeperWatcher)zk, (String)zk.masterAddressZNode);
        Assert.assertNotNull((Object)readAddress);
        Assert.assertTrue((boolean)expectedAddress.equals((Object)readAddress));
    }

    public static class DummyMaster
    implements Server {
        private volatile boolean stopped;

        public void abort(String msg, Throwable t) {
        }

        public Configuration getConfiguration() {
            return null;
        }

        public ZooKeeperWatcher getZooKeeper() {
            return null;
        }

        public String getServerName() {
            return null;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public void stop(String why) {
            this.stopped = true;
        }

        public CatalogTracker getCatalogTracker() {
            return null;
        }
    }

    public static class NodeDeletionListener
    extends ZooKeeperListener {
        private static final Log LOG = LogFactory.getLog(NodeDeletionListener.class);
        private Semaphore lock = new Semaphore(0);
        private String node;

        public NodeDeletionListener(ZooKeeperWatcher watcher, String node) {
            super(watcher);
            this.node = node;
        }

        public void nodeDeleted(String path) {
            if (path.equals(this.node)) {
                LOG.debug((Object)("nodeDeleted(" + path + ")"));
                this.lock.release();
            }
        }

        public void waitForDeletion() throws InterruptedException {
            this.lock.acquire();
        }
    }

    public static class WaitToBeMasterThread
    extends Thread {
        ActiveMasterManager manager;
        boolean isActiveMaster;

        public WaitToBeMasterThread(ZooKeeperWatcher zk, HServerAddress address) {
            this.manager = new ActiveMasterManager(zk, address, (Server)new DummyMaster());
            this.isActiveMaster = false;
        }

        @Override
        public void run() {
            this.manager.blockUntilBecomingActiveMaster();
            LOG.info((Object)"Second master has become the active master!");
            this.isActiveMaster = true;
        }
    }
}

