/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCatalogJanitor {
    @Test
    public void testGetHRegionInfo() throws IOException {
        Assert.assertNull((Object)CatalogJanitor.getHRegionInfo((Result)new Result()));
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        Result r = new Result(kvs);
        Assert.assertNull((Object)CatalogJanitor.getHRegionInfo((Result)r));
        byte[] f = HConstants.CATALOG_FAMILY;
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, f, HConstants.SERVER_QUALIFIER, f));
        r = new Result(kvs);
        Assert.assertNull((Object)CatalogJanitor.getHRegionInfo((Result)r));
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, f, HConstants.REGIONINFO_QUALIFIER, f));
        HRegionInfo hri = CatalogJanitor.getHRegionInfo((Result)new Result(kvs));
        Assert.assertTrue((hri == null ? 1 : 0) != 0);
        kvs.clear();
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, f, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)HRegionInfo.FIRST_META_REGIONINFO)));
        hri = CatalogJanitor.getHRegionInfo((Result)new Result(kvs));
        Assert.assertNotNull((Object)hri);
        Assert.assertTrue((boolean)hri.equals((Object)HRegionInfo.FIRST_META_REGIONINFO));
    }

    @Test
    public void testCleanParent() throws IOException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        MockServer server = new MockServer(htu);
        MockMasterServices services = new MockMasterServices(server);
        CatalogJanitor janitor = new CatalogJanitor((Server)server, (MasterServices)services);
        HTableDescriptor htd = new HTableDescriptor("table");
        htd.addFamily(new HColumnDescriptor("family"));
        HRegionInfo parent = new HRegionInfo(htd, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"eee"));
        HRegionInfo splita = new HRegionInfo(htd, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        HRegionInfo splitb = new HRegionInfo(htd, Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"eee"));
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(parent.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, Writables.getBytes((Writable)splita)));
        kvs.add(new KeyValue(parent.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, Writables.getBytes((Writable)splitb)));
        Result r = new Result(kvs);
        Path rootdir = services.getMasterFileSystem().getRootDir();
        Path tabledir = HTableDescriptor.getTableDir((Path)rootdir, (byte[])htd.getName());
        Path storedir = Store.getStoreHomedir((Path)tabledir, (String)splita.getEncodedName(), (byte[])htd.getColumnFamilies()[0].getName());
        Reference ref = new Reference(Bytes.toBytes((String)"ccc"), Reference.Range.top);
        long now = System.currentTimeMillis();
        Path p = new Path(storedir, Long.toString(now) + "." + parent.getEncodedName());
        FileSystem fs = services.getMasterFileSystem().getFileSystem();
        ref.write(fs, p);
        Assert.assertFalse((boolean)janitor.cleanParent(parent, r));
        Assert.assertTrue((boolean)fs.delete(p, true));
        Assert.assertTrue((boolean)janitor.cleanParent(parent, r));
    }

    class MockMasterServices
    implements MasterServices {
        private final MasterFileSystem mfs;

        MockMasterServices(Server server) throws IOException {
            this.mfs = new MasterFileSystem(server, null);
        }

        public void checkTableModifiable(byte[] tableName) throws IOException {
        }

        public AssignmentManager getAssignmentManager() {
            return null;
        }

        public ExecutorService getExecutorService() {
            return null;
        }

        public MasterFileSystem getMasterFileSystem() {
            return this.mfs;
        }

        public ServerManager getServerManager() {
            return null;
        }
    }

    class MockServer
    implements Server {
        private final Configuration c;
        private final CatalogTracker ct;

        MockServer(HBaseTestingUtility htu) throws NotAllMetaRegionsOnlineException, IOException {
            this.c = htu.getConfiguration();
            FileSystem fs = FileSystem.get((Configuration)this.c);
            Path rootdir = fs.makeQualified(HBaseTestingUtility.getTestDir("hbase.rootdir"));
            this.c.set("hbase.rootdir", rootdir.toString());
            this.ct = (CatalogTracker)Mockito.mock(CatalogTracker.class);
            HRegionInterface hri = (HRegionInterface)Mockito.mock(HRegionInterface.class);
            Mockito.when((Object)this.ct.waitForMetaServerConnectionDefault()).thenReturn((Object)hri);
        }

        public CatalogTracker getCatalogTracker() {
            return this.ct;
        }

        public Configuration getConfiguration() {
            return this.c;
        }

        public String getServerName() {
            return null;
        }

        public ZooKeeperWatcher getZooKeeper() {
            return null;
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isStopped() {
            return false;
        }

        public void stop(String why) {
        }
    }
}

