/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.Assert;
import org.junit.Test;

public class TestHMasterRPCException {
    @Test
    public void testRPCException() throws Exception {
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.startMiniZKCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.master.port", "0");
        HMaster hm = new HMaster(conf);
        HServerAddress hma = hm.getMasterAddress();
        try {
            HMasterInterface inf = (HMasterInterface)HBaseRPC.getProxy(HMasterInterface.class, (long)27L, (InetSocketAddress)hma.getInetSocketAddress(), (Configuration)conf, (int)100);
            inf.isMasterRunning();
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertTrue((boolean)ex.getMessage().startsWith("org.apache.hadoop.hbase.ipc.ServerNotRunningException: Server is not running yet"));
        }
        catch (Throwable t) {
            Assert.fail((String)("Unexpected throwable: " + t));
        }
    }
}

