/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestMasterTransitions {
    private static final Log LOG = LogFactory.getLog(TestMasterTransitions.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String TABLENAME = "master_transitions";
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.startMiniCluster(2);
        TEST_UTIL.createTable(Bytes.toBytes((String)TABLENAME), FAMILIES);
        HTable t = new HTable(TEST_UTIL.getConfiguration(), TABLENAME);
        int countOfRegions = TEST_UTIL.createMultiRegions(t, TestMasterTransitions.getTestFamily());
        TEST_UTIL.waitUntilAllRegionsAssigned(countOfRegions);
        TestMasterTransitions.addToEachStartKey(countOfRegions);
    }

    @AfterClass
    public static void afterAllTests() throws IOException {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        TEST_UTIL.ensureSomeRegionServersAvailable(2);
    }

    @Ignore
    @Test(timeout=300000L)
    public void testRegionCloseWhenNoMetaHBase2428() throws Exception {
    }

    @Ignore
    @Test(timeout=300000L)
    public void testAddingServerBeforeOldIsDead2413() throws IOException {
    }

    @Ignore
    @Test(timeout=300000L)
    public void testKillRSWithOpeningRegion2482() throws Exception {
    }

    private static int addToEachStartKey(int expected) throws IOException {
        byte[] b;
        HTable t = new HTable(TEST_UTIL.getConfiguration(), TABLENAME);
        HTable meta = new HTable(TEST_UTIL.getConfiguration(), HConstants.META_TABLE_NAME);
        int rows = 0;
        Scan scan = new Scan();
        scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        ResultScanner s = meta.getScanner(scan);
        Result r = null;
        while ((r = s.next()) != null && (b = r.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER)) != null && b.length > 0) {
            HRegionInfo hri = Writables.getHRegionInfo((byte[])b);
            byte[] row = TestMasterTransitions.getStartKey(hri);
            Put p = new Put(row);
            p.add(TestMasterTransitions.getTestFamily(), TestMasterTransitions.getTestQualifier(), row);
            t.put(p);
            ++rows;
        }
        s.close();
        Assert.assertEquals((long)expected, (long)rows);
        return rows;
    }

    private static int count() throws IOException {
        HTable t = new HTable(TEST_UTIL.getConfiguration(), TABLENAME);
        int rows = 0;
        Scan scan = new Scan();
        ResultScanner s = t.getScanner(scan);
        Result r = null;
        while ((r = s.next()) != null) {
            ++rows;
        }
        s.close();
        LOG.info((Object)("Counted=" + rows));
        return rows;
    }

    private static byte[] getStartKey(HRegionInfo hri) {
        return Bytes.equals((byte[])HConstants.EMPTY_START_ROW, (byte[])hri.getStartKey()) ? Bytes.toBytes((String)"aaa") : hri.getStartKey();
    }

    private static byte[] getTestFamily() {
        return FAMILIES[0];
    }

    private static byte[] getTestQualifier() {
        return TestMasterTransitions.getTestFamily();
    }
}

