/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRestartCluster {
    private static final Log LOG = LogFactory.getLog(TestRestartCluster.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static ZooKeeperWatcher zooKeeper;
    private static final byte[] TABLENAME;
    private static final byte[][] FAMILIES;
    private static final byte[][] TABLES;
    private static final byte[] FAMILY;

    @Before
    public void setup() throws Exception {
    }

    @After
    public void teardown() throws IOException {
        UTIL.shutdownMiniCluster();
    }

    @Test(timeout=300000L)
    public void testRestartClusterAfterKill() throws Exception {
        UTIL.startMiniZKCluster();
        zooKeeper = new ZooKeeperWatcher(UTIL.getConfiguration(), "cluster1", null);
        String unassignedZNode = TestRestartCluster.zooKeeper.assignmentZNode;
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)zooKeeper, (String)unassignedZNode);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zooKeeper, (HRegionInfo)HRegionInfo.ROOT_REGIONINFO, (String)"master");
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zooKeeper, (HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO, (String)"master");
        LOG.debug((Object)("Created UNASSIGNED zNode for ROOT and META regions in state " + EventHandler.EventType.M_ZK_REGION_OFFLINE));
        LOG.info((Object)"Starting HBase cluster...");
        UTIL.startMiniCluster(2);
        UTIL.createTable(TABLENAME, FAMILIES);
        LOG.info((Object)"Created a table, waiting for table to be available...");
        UTIL.waitTableAvailable(TABLENAME, 60000L);
        LOG.info((Object)"Master deleted unassigned region and started up successfully.");
    }

    @Test(timeout=300000L)
    public void testClusterRestart() throws Exception {
        UTIL.startMiniCluster(3);
        LOG.info((Object)"\n\nCreating tables");
        for (byte[] TABLE : TABLES) {
            UTIL.createTable(TABLE, FAMILY);
            UTIL.waitTableAvailable(TABLE, 30000L);
        }
        List allRegions = MetaScanner.listAllRegions((Configuration)UTIL.getConfiguration());
        Assert.assertEquals((long)3L, (long)allRegions.size());
        LOG.info((Object)"\n\nShutting down cluster");
        UTIL.getHBaseCluster().shutdown();
        UTIL.getHBaseCluster().join();
        LOG.info((Object)"\n\nSleeping a bit");
        Thread.sleep(2000L);
        LOG.info((Object)"\n\nStarting cluster the second time");
        UTIL.restartHBaseCluster(3);
        allRegions = MetaScanner.listAllRegions((Configuration)new Configuration(UTIL.getConfiguration()));
        Assert.assertEquals((long)3L, (long)allRegions.size());
        LOG.info((Object)"\n\nWaiting for tables to be available");
        for (byte[] TABLE : TABLES) {
            try {
                UTIL.createTable(TABLE, FAMILY);
                Assert.assertTrue((String)"Able to create table that should already exist", (boolean)false);
            }
            catch (TableExistsException tee) {
                LOG.info((Object)"Table already exists as expected");
            }
            UTIL.waitTableAvailable(TABLE, 30000L);
        }
    }

    static {
        TABLENAME = Bytes.toBytes((String)"master_transitions");
        FAMILIES = new byte[][]{Bytes.toBytes((String)"a")};
        TABLES = new byte[][]{Bytes.toBytes((String)"restartTableOne"), Bytes.toBytes((String)"restartTableTwo"), Bytes.toBytes((String)"restartTableThree")};
        FAMILY = Bytes.toBytes((String)"family");
    }
}

