/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestCompaction
extends HBaseTestCase {
    static final Log LOG = LogFactory.getLog((String)TestCompaction.class.getName());
    private HRegion r = null;
    private Path compactionDir = null;
    private Path regionCompactionDir = null;
    private static final byte[] COLUMN_FAMILY = fam1;
    private final byte[] STARTROW = Bytes.toBytes((String)this.START_KEY);
    private static final byte[] COLUMN_FAMILY_TEXT = COLUMN_FAMILY;
    private int compactionThreshold;
    private byte[] firstRowBytes;
    private byte[] secondRowBytes;
    private byte[] thirdRowBytes;
    private final byte[] col1;
    private final byte[] col2;
    private MiniDFSCluster cluster;

    public TestCompaction() throws Exception {
        this.conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        this.conf.setInt("hbase.hregion.memstore.block.multiplier", 100);
        this.cluster = null;
        this.compactionThreshold = this.conf.getInt("hbase.hstore.compactionThreshold", 3);
        this.firstRowBytes = this.START_KEY.getBytes("UTF-8");
        this.secondRowBytes = this.START_KEY.getBytes("UTF-8");
        int n = START_KEY_BYTES.length - 1;
        this.secondRowBytes[n] = (byte)(this.secondRowBytes[n] + 1);
        this.thirdRowBytes = this.START_KEY.getBytes("UTF-8");
        int n2 = START_KEY_BYTES.length - 1;
        this.thirdRowBytes[n2] = (byte)(this.thirdRowBytes[n2] + 1);
        int n3 = START_KEY_BYTES.length - 1;
        this.thirdRowBytes[n3] = (byte)(this.thirdRowBytes[n3] + 1);
        this.col1 = "column1".getBytes("UTF-8");
        this.col2 = "column2".getBytes("UTF-8");
    }

    @Override
    public void setUp() throws Exception {
        this.cluster = new MiniDFSCluster(this.conf, 2, true, (String[])null);
        this.conf.set("hbase.rootdir", this.cluster.getFileSystem().getHomeDirectory().toString());
        super.setUp();
        HTableDescriptor htd = this.createTableDescriptor(this.getName());
        this.r = this.createNewHRegion(htd, null, null);
    }

    @Override
    public void tearDown() throws Exception {
        HLog hlog = this.r.getLog();
        this.r.close();
        hlog.closeAndDelete();
        if (this.cluster != null) {
            TestCompaction.shutdownDfs(this.cluster);
        }
        super.tearDown();
    }

    public void testMajorCompactingToNoOutput() throws IOException {
        ArrayList results;
        boolean result;
        boolean result2;
        this.createStoreFile(this.r);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            this.createStoreFile(this.r);
        }
        InternalScanner s = this.r.getScanner(new Scan());
        do {
            ArrayList results2 = new ArrayList();
            result2 = s.next(results2);
            this.r.delete(new Delete(((KeyValue)results2.get(0)).getRow()), null, false);
        } while (result2);
        this.r.flushcache();
        this.r.compactStores(true);
        s = this.r.getScanner(new Scan());
        int counter = 0;
        while (result = s.next(results = new ArrayList())) {
            ++counter;
        }
        TestCompaction.assertEquals((int)0, (int)counter);
    }

    public void testMajorCompaction() throws Exception {
        this.createStoreFile(this.r);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            this.createStoreFile(this.r);
        }
        TestCompaction.addContent(new HBaseTestCase.HRegionIncommon(this.r), Bytes.toString((byte[])COLUMN_FAMILY));
        Result result = this.r.get(new Get(this.STARTROW).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)this.compactionThreshold, (int)result.size());
        this.r.flushcache();
        this.r.compactStores(true);
        byte[] secondRowBytes = this.START_KEY.getBytes("UTF-8");
        int n = START_KEY_BYTES.length - 1;
        secondRowBytes[n] = (byte)(secondRowBytes[n] + 1);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)this.compactionThreshold, (int)result.size());
        Delete delete = new Delete(secondRowBytes, System.currentTimeMillis(), null);
        byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
        delete.deleteFamily(famAndQf[0]);
        this.r.delete(delete, null, true);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertTrue((String)"Second row should have been deleted", (boolean)result.isEmpty());
        this.r.flushcache();
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertTrue((String)"Second row should have been deleted", (boolean)result.isEmpty());
        this.createSmallerStoreFile(this.r);
        this.r.flushcache();
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertTrue((String)"Second row should still be deleted", (boolean)result.isEmpty());
        this.r.compactStores(true);
        TestCompaction.assertEquals((int)this.r.getStore(COLUMN_FAMILY_TEXT).getStorefiles().size(), (int)1);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertTrue((String)"Second row should still be deleted", (boolean)result.isEmpty());
        this.verifyCounts(3, 0);
        boolean ttlInSeconds = true;
        for (Store store : this.r.stores.values()) {
            store.ttl = 1000L;
        }
        Thread.sleep(1000L);
        this.r.compactStores(true);
        int count = this.count();
        TestCompaction.assertTrue((String)"Should not see anything after TTL has expired", (count == 0 ? 1 : 0) != 0);
    }

    public void testMinorCompactionWithDeleteRow() throws Exception {
        Delete deleteRow = new Delete(this.secondRowBytes);
        this.testMinorCompactionWithDelete(deleteRow);
    }

    public void testMinorCompactionWithDeleteColumn1() throws Exception {
        Delete dc = new Delete(this.secondRowBytes);
        dc.deleteColumns(fam2, this.col2);
        this.testMinorCompactionWithDelete(dc);
    }

    public void testMinorCompactionWithDeleteColumn2() throws Exception {
        Delete dc = new Delete(this.secondRowBytes);
        dc.deleteColumn(fam2, this.col2);
        this.testMinorCompactionWithDelete(dc, 3);
    }

    public void testMinorCompactionWithDeleteColumnFamily() throws Exception {
        Delete deleteCF = new Delete(this.secondRowBytes);
        deleteCF.deleteFamily(fam2);
        this.testMinorCompactionWithDelete(deleteCF);
    }

    public void testMinorCompactionWithDeleteVersion1() throws Exception {
        Delete deleteVersion = new Delete(this.secondRowBytes);
        deleteVersion.deleteColumns(fam2, this.col2, 2L);
        this.testMinorCompactionWithDelete(deleteVersion, 1);
    }

    public void testMinorCompactionWithDeleteVersion2() throws Exception {
        Delete deleteVersion = new Delete(this.secondRowBytes);
        deleteVersion.deleteColumn(fam2, this.col2, 1L);
        this.testMinorCompactionWithDelete(deleteVersion, 2);
    }

    private void testMinorCompactionWithDelete(Delete delete) throws Exception {
        this.testMinorCompactionWithDelete(delete, 0);
    }

    private void testMinorCompactionWithDelete(Delete delete, int expectedResultsAfterDelete) throws Exception {
        HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(this.r);
        for (int i = 0; i < this.compactionThreshold + 1; ++i) {
            TestCompaction.addContent(loader, Bytes.toString((byte[])fam1), Bytes.toString((byte[])this.col1), this.firstRowBytes, this.thirdRowBytes, i);
            TestCompaction.addContent(loader, Bytes.toString((byte[])fam1), Bytes.toString((byte[])this.col2), this.firstRowBytes, this.thirdRowBytes, i);
            TestCompaction.addContent(loader, Bytes.toString((byte[])fam2), Bytes.toString((byte[])this.col1), this.firstRowBytes, this.thirdRowBytes, i);
            TestCompaction.addContent(loader, Bytes.toString((byte[])fam2), Bytes.toString((byte[])this.col2), this.firstRowBytes, this.thirdRowBytes, i);
            this.r.flushcache();
        }
        Result result = this.r.get(new Get(this.firstRowBytes).addColumn(fam1, this.col1).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)this.compactionThreshold, (int)result.size());
        result = this.r.get(new Get(this.secondRowBytes).addColumn(fam2, this.col2).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)this.compactionThreshold, (int)result.size());
        this.r.delete(delete, null, true);
        result = this.r.get(new Get(this.secondRowBytes).addColumn(fam2, this.col2).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)expectedResultsAfterDelete, (int)result.size());
        result = this.r.get(new Get(this.firstRowBytes).addColumn(fam1, this.col1).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)this.compactionThreshold, (int)result.size());
        this.r.flushcache();
        result = this.r.get(new Get(this.secondRowBytes).addColumn(fam2, this.col2).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)expectedResultsAfterDelete, (int)result.size());
        result = this.r.get(new Get(this.firstRowBytes).addColumn(fam1, this.col1).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)this.compactionThreshold, (int)result.size());
        Store store2 = (Store)this.r.stores.get(fam2);
        int numFiles1 = store2.getStorefiles().size();
        TestCompaction.assertTrue((String)"Was expecting to see 4 store files", (numFiles1 > this.compactionThreshold ? 1 : 0) != 0);
        store2.compactRecent(this.compactionThreshold);
        int numFiles2 = store2.getStorefiles().size();
        TestCompaction.assertTrue((String)"Number of store files should go down", (numFiles1 > numFiles2 ? 1 : 0) != 0);
        TestCompaction.assertTrue((String)"Was not supposed to be a major compaction", (numFiles2 > 1 ? 1 : 0) != 0);
        result = this.r.get(new Get(this.secondRowBytes).addColumn(fam2, this.col2).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)expectedResultsAfterDelete, (int)result.size());
        result = this.r.get(new Get(this.firstRowBytes).addColumn(fam1, this.col1).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)this.compactionThreshold, (int)result.size());
    }

    private void verifyCounts(int countRow1, int countRow2) throws Exception {
        int count1 = 0;
        int count2 = 0;
        for (StoreFile f : ((Store)this.r.stores.get(COLUMN_FAMILY_TEXT)).getStorefiles()) {
            HFileScanner scanner = f.getReader().getScanner(false, false);
            scanner.seekTo();
            do {
                byte[] row;
                if (Bytes.equals((byte[])(row = scanner.getKeyValue().getRow()), (byte[])this.STARTROW)) {
                    ++count1;
                    continue;
                }
                if (!Bytes.equals((byte[])row, (byte[])this.secondRowBytes)) continue;
                ++count2;
            } while (scanner.next());
        }
        TestCompaction.assertEquals((int)countRow1, (int)count1);
        TestCompaction.assertEquals((int)countRow2, (int)count2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInterruptCompaction() throws Exception {
        TestCompaction.assertEquals((int)0, (int)this.count());
        int origWI = Store.closeCheckInterval;
        Store.closeCheckInterval = 10000;
        try {
            int jmax = (int)Math.ceil(15.0 / (double)this.compactionThreshold);
            byte[] pad = new byte[1000];
            for (int i = 0; i < this.compactionThreshold; ++i) {
                HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(this.r);
                Put p = new Put(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
                for (int j = 0; j < jmax; ++j) {
                    p.add(COLUMN_FAMILY, Bytes.toBytes((int)j), pad);
                }
                TestCompaction.addContent(loader, Bytes.toString((byte[])COLUMN_FAMILY));
                loader.put(p);
                loader.flushcache();
            }
            HRegion spyR = (HRegion)Mockito.spy((Object)this.r);
            ((HRegion)Mockito.doAnswer((Answer)new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    ((TestCompaction)TestCompaction.this).r.writestate.writesEnabled = false;
                    return invocation.callRealMethod();
                }
            }).when((Object)spyR)).doRegionCompactionPrep();
            spyR.compactStores();
            Store s = (Store)this.r.stores.get(COLUMN_FAMILY);
            TestCompaction.assertEquals((int)this.compactionThreshold, (int)s.getStorefilesCount());
            TestCompaction.assertTrue((s.getStorefilesSize() > 15000L ? 1 : 0) != 0);
            FileStatus[] ls = this.cluster.getFileSystem().listStatus(this.r.getTmpDir());
            TestCompaction.assertEquals((int)0, (int)ls.length);
            this.r.writestate.writesEnabled = true;
            Store.closeCheckInterval = origWI;
        }
        catch (Throwable throwable) {
            this.r.writestate.writesEnabled = true;
            Store.closeCheckInterval = origWI;
            for (int i = 0; i < this.compactionThreshold; ++i) {
                Delete delete = new Delete(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
                byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
                delete.deleteFamily(famAndQf[0]);
                this.r.delete(delete, null, true);
            }
            this.r.flushcache();
            boolean ttlInSeconds = true;
            for (Store store : this.r.stores.values()) {
                store.ttl = 1000L;
            }
            Thread.sleep(1000L);
            this.r.compactStores(true);
            TestCompaction.assertEquals((int)0, (int)this.count());
            throw throwable;
        }
        for (int i = 0; i < this.compactionThreshold; ++i) {
            Delete delete = new Delete(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
            byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
            delete.deleteFamily(famAndQf[0]);
            this.r.delete(delete, null, true);
        }
        this.r.flushcache();
        boolean ttlInSeconds = true;
        for (Store store : this.r.stores.values()) {
            store.ttl = 1000L;
        }
        Thread.sleep(1000L);
        this.r.compactStores(true);
        TestCompaction.assertEquals((int)0, (int)this.count());
    }

    private int count() throws IOException {
        int count = 0;
        for (StoreFile f : ((Store)this.r.stores.get(COLUMN_FAMILY_TEXT)).getStorefiles()) {
            HFileScanner scanner = f.getReader().getScanner(false, false);
            if (!scanner.seekTo()) continue;
            do {
                ++count;
            } while (scanner.next());
        }
        return count;
    }

    private void createStoreFile(HRegion region) throws IOException {
        HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(region);
        TestCompaction.addContent(loader, Bytes.toString((byte[])COLUMN_FAMILY));
        loader.flushcache();
    }

    private void createSmallerStoreFile(HRegion region) throws IOException {
        HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(region);
        TestCompaction.addContent(loader, Bytes.toString((byte[])COLUMN_FAMILY), "bbb".getBytes(), null);
        loader.flushcache();
    }
}

