/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.ReadWriteConsistencyControl;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.io.Writable;

public class TestHRegion
extends HBaseTestCase {
    static final Log LOG = LogFactory.getLog(TestHRegion.class);
    HRegion region = null;
    private final String DIR = HBaseTestingUtility.getTestDir() + "/TestHRegion/";
    private final int MAX_VERSIONS = 2;
    protected final byte[] tableName = Bytes.toBytes((String)"testtable");
    protected final byte[] qual1 = Bytes.toBytes((String)"qual1");
    protected final byte[] qual2 = Bytes.toBytes((String)"qual2");
    protected final byte[] qual3 = Bytes.toBytes((String)"qual3");
    protected final byte[] value1 = Bytes.toBytes((String)"value1");
    protected final byte[] value2 = Bytes.toBytes((String)"value2");
    protected final byte[] row = Bytes.toBytes((String)"rowA");

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        EnvironmentEdgeManagerTestHelper.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetWhileRegionClose() throws IOException {
        Configuration hc = this.initSplit();
        int numRows = 100;
        byte[][] families = new byte[][]{fam1, fam2, fam3};
        String method = this.getName();
        this.initHRegion(this.tableName, method, hc, (byte[][])families);
        int startRow = 100;
        this.putData(100, numRows, this.qual1, families);
        this.putData(100, numRows, this.qual2, families);
        this.putData(100, numRows, this.qual3, families);
        AtomicBoolean done = new AtomicBoolean(false);
        AtomicInteger gets = new AtomicInteger(0);
        GetTillDoneOrException[] threads = new GetTillDoneOrException[10];
        try {
            int i;
            for (i = 0; i < threads.length / 2; ++i) {
                threads[i] = new GetTillDoneOrException(i, Bytes.toBytes((String)"100"), done, gets);
                threads[i].setDaemon(true);
                threads[i].start();
            }
            this.region.closing.set(true);
            for (i = threads.length / 2; i < threads.length; ++i) {
                threads[i] = new GetTillDoneOrException(i, Bytes.toBytes((String)"100"), done, gets);
                threads[i].setDaemon(true);
                threads[i].start();
            }
        }
        finally {
            if (this.region != null) {
                this.region.close();
                this.region.getLog().closeAndDelete();
            }
        }
        done.set(true);
        for (GetTillDoneOrException t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (t.e == null) continue;
            LOG.info((Object)("Exception=" + t.e));
            TestHRegion.assertFalse((String)("Found a NPE in " + t.getName()), (boolean)(t.e instanceof NullPointerException));
        }
    }

    public void testWeirdCacheBehaviour() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testWeirdCacheBehaviour");
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"trans-blob"), Bytes.toBytes((String)"trans-type"), Bytes.toBytes((String)"trans-date"), Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"trans-group")};
        this.initHRegion(TABLE, this.getName(), FAMILIES);
        String value = "this is the value";
        String value2 = "this is some other value";
        String keyPrefix1 = "prefix1";
        String keyPrefix2 = "prefix2";
        String keyPrefix3 = "prefix3";
        this.putRows(this.region, 3, value, keyPrefix1);
        this.putRows(this.region, 3, value, keyPrefix2);
        this.putRows(this.region, 3, value, keyPrefix3);
        this.putRows(this.region, 3, value2, keyPrefix1);
        this.putRows(this.region, 3, value2, keyPrefix2);
        this.putRows(this.region, 3, value2, keyPrefix3);
        System.out.println("Checking values for key: " + keyPrefix1);
        TestHRegion.assertEquals((String)"Got back incorrect number of rows from scan", (int)3, (int)this.getNumberOfRows(keyPrefix1, value2, this.region));
        System.out.println("Checking values for key: " + keyPrefix2);
        TestHRegion.assertEquals((String)"Got back incorrect number of rows from scan", (int)3, (int)this.getNumberOfRows(keyPrefix2, value2, this.region));
        System.out.println("Checking values for key: " + keyPrefix3);
        TestHRegion.assertEquals((String)"Got back incorrect number of rows from scan", (int)3, (int)this.getNumberOfRows(keyPrefix3, value2, this.region));
        this.deleteColumns(this.region, value2, keyPrefix1);
        this.deleteColumns(this.region, value2, keyPrefix2);
        this.deleteColumns(this.region, value2, keyPrefix3);
        System.out.println("Starting important checks.....");
        TestHRegion.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix1), (int)0, (int)this.getNumberOfRows(keyPrefix1, value2, this.region));
        TestHRegion.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix2), (int)0, (int)this.getNumberOfRows(keyPrefix2, value2, this.region));
        TestHRegion.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix3), (int)0, (int)this.getNumberOfRows(keyPrefix3, value2, this.region));
    }

    private void deleteColumns(HRegion r, String value, String keyPrefix) throws IOException {
        InternalScanner scanner = this.buildScanner(keyPrefix, value, r);
        int count = 0;
        boolean more = false;
        ArrayList results = new ArrayList();
        do {
            more = scanner.next(results);
            if (results == null || results.isEmpty()) break;
            ++count;
            Delete delete = new Delete(((KeyValue)results.get(0)).getRow());
            delete.deleteColumn(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"));
            r.delete(delete, null, false);
            results.clear();
        } while (more);
        TestHRegion.assertEquals((String)"Did not perform correct number of deletes", (int)3, (int)count);
    }

    private int getNumberOfRows(String keyPrefix, String value, HRegion r) throws Exception {
        InternalScanner resultScanner = this.buildScanner(keyPrefix, value, r);
        int numberOfResults = 0;
        ArrayList results = new ArrayList();
        boolean more = false;
        do {
            more = resultScanner.next(results);
            if (results == null || results.isEmpty()) break;
            ++numberOfResults;
            for (KeyValue kv : results) {
                System.out.println("kv=" + kv.toString() + ", " + Bytes.toString((byte[])kv.getValue()));
            }
            results.clear();
        } while (more);
        return numberOfResults;
    }

    private InternalScanner buildScanner(String keyPrefix, String value, HRegion r) throws IOException {
        FilterList allFilters = new FilterList();
        allFilters.addFilter((Filter)new PrefixFilter(Bytes.toBytes((String)keyPrefix)));
        SingleColumnValueFilter filter = new SingleColumnValueFilter(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"), CompareFilter.CompareOp.EQUAL, Bytes.toBytes((String)value));
        filter.setFilterIfMissing(true);
        allFilters.addFilter((Filter)filter);
        Scan scan = new Scan();
        scan.addFamily(Bytes.toBytes((String)"trans-blob"));
        scan.addFamily(Bytes.toBytes((String)"trans-type"));
        scan.addFamily(Bytes.toBytes((String)"trans-date"));
        scan.addFamily(Bytes.toBytes((String)"trans-tags"));
        scan.addFamily(Bytes.toBytes((String)"trans-group"));
        scan.setFilter((Filter)allFilters);
        return r.getScanner(scan);
    }

    private void putRows(HRegion r, int numRows, String value, String key) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            String row = key + "_" + i;
            System.out.println(String.format("Saving row: %s, with value %s", row, value));
            Put put = new Put(Bytes.toBytes((String)row));
            put.add(Bytes.toBytes((String)"trans-blob"), null, Bytes.toBytes((String)"value for blob"));
            put.add(Bytes.toBytes((String)"trans-type"), null, Bytes.toBytes((String)"statement"));
            put.add(Bytes.toBytes((String)"trans-date"), null, Bytes.toBytes((String)"20090921010101999"));
            put.add(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"), Bytes.toBytes((String)value));
            put.add(Bytes.toBytes((String)"trans-group"), null, Bytes.toBytes((String)"adhocTransactionGroupId"));
            r.put(put);
        }
    }

    public void testFamilyWithAndWithoutColon() throws Exception {
        byte[] b = Bytes.toBytes((String)this.getName());
        byte[] cf = Bytes.toBytes((String)"cf");
        this.initHRegion(b, this.getName(), new byte[][]{cf});
        Put p = new Put(b);
        byte[] cfwithcolon = Bytes.toBytes((String)"cf:");
        p.add(cfwithcolon, cfwithcolon, cfwithcolon);
        boolean exception = false;
        try {
            this.region.put(p);
        }
        catch (NoSuchColumnFamilyException e) {
            exception = true;
        }
        TestHRegion.assertTrue((boolean)exception);
    }

    public void testBatchPut() throws Exception {
        int i;
        int i2;
        byte[] b = Bytes.toBytes((String)this.getName());
        byte[] cf = Bytes.toBytes((String)"cf");
        byte[] qual = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"val");
        this.initHRegion(b, this.getName(), new byte[][]{cf});
        HLog.getSyncOps();
        TestHRegion.assertEquals((long)0L, (long)HLog.getSyncOps());
        LOG.info((Object)"First a batch put with all valid puts");
        final Put[] puts = new Put[10];
        for (int i3 = 0; i3 < 10; ++i3) {
            puts[i3] = new Put(Bytes.toBytes((String)("row_" + i3)));
            puts[i3].add(cf, qual, val);
        }
        HConstants.OperationStatusCode[] codes = this.region.put(puts);
        TestHRegion.assertEquals((int)10, (int)codes.length);
        for (i2 = 0; i2 < 10; ++i2) {
            TestHRegion.assertEquals((Object)HConstants.OperationStatusCode.SUCCESS, (Object)codes[i2]);
        }
        TestHRegion.assertEquals((long)1L, (long)HLog.getSyncOps());
        LOG.info((Object)"Next a batch put with one invalid family");
        puts[5].add(Bytes.toBytes((String)"BAD_CF"), qual, val);
        codes = this.region.put(puts);
        TestHRegion.assertEquals((int)10, (int)codes.length);
        for (i2 = 0; i2 < 10; ++i2) {
            TestHRegion.assertEquals((Object)(i2 == 5 ? HConstants.OperationStatusCode.BAD_FAMILY : HConstants.OperationStatusCode.SUCCESS), (Object)codes[i2]);
        }
        TestHRegion.assertEquals((long)1L, (long)HLog.getSyncOps());
        LOG.info((Object)"Next a batch put that has to break into two batches to avoid a lock");
        Integer lockedRow = this.region.obtainRowLock(Bytes.toBytes((String)"row_2"));
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(HBaseConfiguration.create());
        final AtomicReference retFromThread = new AtomicReference();
        MultithreadedTestUtil.TestThread putter = new MultithreadedTestUtil.TestThread(ctx){

            @Override
            public void doWork() throws IOException {
                retFromThread.set(TestHRegion.this.region.put(puts));
            }
        };
        LOG.info((Object)"...starting put thread while holding lock");
        ctx.addThread(putter);
        ctx.startThreads();
        LOG.info((Object)"...waiting for put thread to sync first time");
        long startWait = System.currentTimeMillis();
        while (HLog.getSyncOps() == 0L) {
            Thread.sleep(100L);
            if (System.currentTimeMillis() - startWait <= 10000L) continue;
            TestHRegion.fail((String)"Timed out waiting for thread to sync first minibatch");
        }
        LOG.info((Object)"...releasing row lock, which should let put thread continue");
        this.region.releaseRowLock(lockedRow);
        LOG.info((Object)"...joining on thread");
        ctx.stop();
        LOG.info((Object)"...checking that next batch was synced");
        TestHRegion.assertEquals((long)1L, (long)HLog.getSyncOps());
        codes = (HConstants.OperationStatusCode[])retFromThread.get();
        for (int i4 = 0; i4 < 10; ++i4) {
            TestHRegion.assertEquals((Object)(i4 == 5 ? HConstants.OperationStatusCode.BAD_FAMILY : HConstants.OperationStatusCode.SUCCESS), (Object)codes[i4]);
        }
        LOG.info((Object)"Nexta, a batch put which uses an already-held lock");
        lockedRow = this.region.obtainRowLock(Bytes.toBytes((String)"row_2"));
        LOG.info((Object)"...obtained row lock");
        ArrayList putsAndLocks = Lists.newArrayList();
        for (i = 0; i < 10; ++i) {
            Pair pair = new Pair((Object)puts[i], null);
            if (i == 2) {
                pair.setSecond((Object)lockedRow);
            }
            putsAndLocks.add(pair);
        }
        codes = this.region.put(putsAndLocks.toArray(new Pair[0]));
        LOG.info((Object)"...performed put");
        for (i = 0; i < 10; ++i) {
            TestHRegion.assertEquals((Object)(i == 5 ? HConstants.OperationStatusCode.BAD_FAMILY : HConstants.OperationStatusCode.SUCCESS), (Object)codes[i]);
        }
        TestHRegion.assertEquals((long)1L, (long)HLog.getSyncOps());
        TestHRegion.assertTrue((boolean)this.region.isRowLocked(lockedRow));
        LOG.info((Object)"...releasing lock");
        this.region.releaseRowLock(lockedRow);
    }

    public void testCheckAndMutate_WithEmptyRowValue() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] emptyVal = new byte[]{};
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        Integer lockId = null;
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam1});
        Put put = new Put(row1);
        put.add(fam1, qf1, val1);
        boolean res = this.region.checkAndMutate(row1, fam1, qf1, emptyVal, (Writable)put, lockId, true);
        TestHRegion.assertTrue((boolean)res);
        res = this.region.checkAndMutate(row1, fam1, qf1, emptyVal, (Writable)put, lockId, true);
        TestHRegion.assertFalse((boolean)res);
        Delete delete = new Delete(row1);
        delete.deleteColumn(fam1, qf1);
        res = this.region.checkAndMutate(row1, fam1, qf1, emptyVal, (Writable)delete, lockId, true);
        TestHRegion.assertFalse((boolean)res);
        put = new Put(row1);
        put.add(fam1, qf1, val2);
        res = this.region.checkAndMutate(row1, fam1, qf1, val1, (Writable)put, lockId, true);
        TestHRegion.assertTrue((boolean)res);
        delete = new Delete(row1);
        delete.deleteColumn(fam1, qf1);
        delete.deleteColumn(fam1, qf1);
        res = this.region.checkAndMutate(row1, fam1, qf1, val2, (Writable)delete, lockId, true);
        TestHRegion.assertTrue((boolean)res);
        delete = new Delete(row1);
        res = this.region.checkAndMutate(row1, fam1, qf1, emptyVal, (Writable)delete, lockId, true);
        TestHRegion.assertTrue((boolean)res);
        put = new Put(row1);
        put.add(fam1, qf1, val1);
        res = this.region.checkAndMutate(row1, fam1, qf1, null, (Writable)put, lockId, true);
        TestHRegion.assertTrue((boolean)res);
    }

    public void testCheckAndMutate_WithWrongValue() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        Integer lockId = null;
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam1});
        Put put = new Put(row1);
        put.add(fam1, qf1, val1);
        this.region.put(put);
        boolean res = this.region.checkAndMutate(row1, fam1, qf1, val2, (Writable)put, lockId, true);
        TestHRegion.assertEquals((boolean)false, (boolean)res);
        Delete delete = new Delete(row1);
        delete.deleteFamily(fam1);
        res = this.region.checkAndMutate(row1, fam1, qf1, val2, (Writable)delete, lockId, true);
        TestHRegion.assertEquals((boolean)false, (boolean)res);
    }

    public void testCheckAndMutate_WithCorrectValue() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] val1 = Bytes.toBytes((String)"value1");
        Integer lockId = null;
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam1});
        Put put = new Put(row1);
        put.add(fam1, qf1, val1);
        this.region.put(put);
        boolean res = this.region.checkAndMutate(row1, fam1, qf1, val1, (Writable)put, lockId, true);
        TestHRegion.assertEquals((boolean)true, (boolean)res);
        Delete delete = new Delete(row1);
        delete.deleteColumn(fam1, qf1);
        res = this.region.checkAndMutate(row1, fam1, qf1, val1, (Writable)put, lockId, true);
        TestHRegion.assertEquals((boolean)true, (boolean)res);
    }

    public void testCheckAndPut_ThatPutWasWritten() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] qf1 = Bytes.toBytes((String)"qualifier");
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        Integer lockId = null;
        byte[][] families = new byte[][]{fam1, fam2};
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Put put = new Put(row1);
        put.add(fam1, qf1, val1);
        this.region.put(put);
        long ts = System.currentTimeMillis();
        KeyValue kv = new KeyValue(row1, fam2, qf1, ts, KeyValue.Type.Put, val2);
        put = new Put(row1);
        put.add(kv);
        Store store = this.region.getStore(fam1);
        store.memstore.kvset.size();
        boolean res = this.region.checkAndMutate(row1, fam1, qf1, val1, (Writable)put, lockId, true);
        TestHRegion.assertEquals((boolean)true, (boolean)res);
        store.memstore.kvset.size();
        Get get = new Get(row1);
        get.addColumn(fam2, qf1);
        KeyValue[] actual = this.region.get(get, null).raw();
        KeyValue[] expected = new KeyValue[]{kv};
        TestHRegion.assertEquals((int)expected.length, (int)actual.length);
        for (int i = 0; i < actual.length; ++i) {
            TestHRegion.assertEquals((Object)expected[i], (Object)actual[i]);
        }
    }

    public void testCheckAndDelete_ThatDeleteWasWritten() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] qf3 = Bytes.toBytes((String)"qualifier3");
        byte[] val1 = Bytes.toBytes((String)"value1");
        byte[] val2 = Bytes.toBytes((String)"value2");
        byte[] val3 = Bytes.toBytes((String)"value3");
        byte[] emptyVal = new byte[]{};
        Integer lockId = null;
        byte[][] families = new byte[][]{fam1, fam2};
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Put put = new Put(row1);
        put.add(fam1, qf1, val1);
        this.region.put(put);
        Threads.sleep((int)2);
        put = new Put(row1);
        put.add(fam1, qf1, val2);
        put.add(fam2, qf1, val3);
        put.add(fam2, qf2, val2);
        put.add(fam2, qf3, val1);
        put.add(fam1, qf3, val1);
        this.region.put(put);
        Delete delete = new Delete(row1);
        delete.deleteColumn(fam1, qf1);
        delete.deleteColumn(fam2, qf1);
        delete.deleteColumn(fam1, qf3);
        boolean res = this.region.checkAndMutate(row1, fam1, qf1, val2, (Writable)delete, lockId, true);
        TestHRegion.assertEquals((boolean)true, (boolean)res);
        Get get = new Get(row1);
        get.addColumn(fam1, qf1);
        get.addColumn(fam1, qf3);
        get.addColumn(fam2, qf2);
        Result r = this.region.get(get, null);
        TestHRegion.assertEquals((int)2, (int)r.size());
        TestHRegion.assertEquals(val1, r.getValue(fam1, qf1));
        TestHRegion.assertEquals(val2, r.getValue(fam2, qf2));
        delete = new Delete(row1);
        delete.deleteFamily(fam2);
        res = this.region.checkAndMutate(row1, fam2, qf1, emptyVal, (Writable)delete, lockId, true);
        TestHRegion.assertEquals((boolean)true, (boolean)res);
        get = new Get(row1);
        r = this.region.get(get, null);
        TestHRegion.assertEquals((int)1, (int)r.size());
        TestHRegion.assertEquals(val1, r.getValue(fam1, qf1));
        delete = new Delete(row1);
        res = this.region.checkAndMutate(row1, fam1, qf1, val1, (Writable)delete, lockId, true);
        TestHRegion.assertEquals((boolean)true, (boolean)res);
        get = new Get(row1);
        r = this.region.get(get, null);
        TestHRegion.assertEquals((int)0, (int)r.size());
    }

    public void testDelete_multiDeleteColumn() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qual = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        Put put = new Put(row1);
        put.add(fam1, qual, 1L, value);
        put.add(fam1, qual, 2L, value);
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam1});
        this.region.put(put);
        Delete delete = new Delete(row1);
        delete.deleteColumn(fam1, qual);
        delete.deleteColumn(fam1, qual);
        this.region.delete(delete, null, false);
        Get get = new Get(row1);
        get.addFamily(fam1);
        Result r = this.region.get(get, null);
        TestHRegion.assertEquals((int)0, (int)r.size());
    }

    public void testDelete_CheckFamily() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] fam3 = Bytes.toBytes((String)"fam3");
        byte[] fam4 = Bytes.toBytes((String)"fam4");
        String method = this.getName();
        this.initHRegion(tableName, method, fam1, fam2, fam3);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(row1, fam4, null, null));
        byte[] family = fam2;
        try {
            HashMap<byte[], ArrayList<KeyValue>> deleteMap = new HashMap<byte[], ArrayList<KeyValue>>();
            deleteMap.put(family, kvs);
            this.region.delete(deleteMap, true);
        }
        catch (Exception e) {
            TestHRegion.assertTrue((String)("Family " + new String(family) + " does not exist"), (boolean)false);
        }
        boolean ok = false;
        family = fam4;
        try {
            HashMap<byte[], ArrayList<KeyValue>> deleteMap = new HashMap<byte[], ArrayList<KeyValue>>();
            deleteMap.put(family, kvs);
            this.region.delete(deleteMap, true);
        }
        catch (Exception e) {
            ok = true;
        }
        TestHRegion.assertEquals((String)("Family " + new String(family) + " does exist"), (boolean)true, (boolean)ok);
    }

    public void testDelete_mixed() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] fam = Bytes.toBytes((String)"info");
        byte[][] families = new byte[][]{fam};
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
        byte[] row = Bytes.toBytes((String)"table_name");
        byte[] serverinfo = Bytes.toBytes((String)"serverinfo");
        byte[] splitA = Bytes.toBytes((String)"splitA");
        byte[] splitB = Bytes.toBytes((String)"splitB");
        Put put = new Put(row);
        put.add(fam, splitA, Bytes.toBytes((String)"reference_A"));
        this.region.put(put);
        put = new Put(row);
        put.add(fam, splitB, Bytes.toBytes((String)"reference_B"));
        this.region.put(put);
        put = new Put(row);
        put.add(fam, serverinfo, Bytes.toBytes((String)"ip_address"));
        this.region.put(put);
        Delete delete = new Delete(row);
        delete.deleteColumns(fam, splitA);
        this.region.delete(delete, null, true);
        Get get = new Get(row).addColumn(fam, serverinfo);
        Result result = this.region.get(get, null);
        TestHRegion.assertEquals((int)1, (int)result.size());
        get = new Get(row).addColumn(fam, splitA);
        result = this.region.get(get, null);
        TestHRegion.assertEquals((int)0, (int)result.size());
        get = new Get(row).addColumn(fam, splitB);
        result = this.region.get(get, null);
        TestHRegion.assertEquals((int)1, (int)result.size());
        put = new Put(row);
        put.add(fam, splitA, Bytes.toBytes((String)"reference_A"));
        this.region.put(put);
        get = new Get(row);
        result = this.region.get(get, null);
        TestHRegion.assertEquals((int)3, (int)result.size());
        delete = new Delete(row);
        this.region.delete(delete, null, false);
        TestHRegion.assertEquals((int)0, (int)this.region.get(get, null).size());
        this.region.put(new Put(row).add(fam, splitA, Bytes.toBytes((String)"reference_A")));
        result = this.region.get(get, null);
        TestHRegion.assertEquals((int)1, (int)result.size());
    }

    public void testDeleteRowWithFutureTs() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] fam = Bytes.toBytes((String)"info");
        byte[][] families = new byte[][]{fam};
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        byte[] row = Bytes.toBytes((String)"table_name");
        byte[] serverinfo = Bytes.toBytes((String)"serverinfo");
        Put put = new Put(row);
        put.add(fam, serverinfo, 0x7FFFFFFFFFFFFFFAL, Bytes.toBytes((String)"value"));
        this.region.put(put);
        Delete delete = new Delete(row);
        this.region.delete(delete, null, true);
        Get get = new Get(row).addColumn(fam, serverinfo);
        Result result = this.region.get(get, null);
        TestHRegion.assertEquals((int)1, (int)result.size());
        delete = new Delete(row, 0x7FFFFFFFFFFFFFFCL, null);
        this.region.delete(delete, null, true);
        get = new Get(row).addColumn(fam, serverinfo);
        result = this.region.get(get, null);
        TestHRegion.assertEquals((int)0, (int)result.size());
    }

    public void testPutWithLatestTS() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] fam = Bytes.toBytes((String)"info");
        byte[][] families = new byte[][]{fam};
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        byte[] row = Bytes.toBytes((String)"row1");
        byte[] qual = Bytes.toBytes((String)"qual");
        Put put = new Put(row);
        put.add(fam, qual, Long.MAX_VALUE, Bytes.toBytes((String)"value"));
        this.region.put(put, false);
        Get get = new Get(row).addColumn(fam, qual);
        Result result = this.region.get(get, null);
        TestHRegion.assertEquals((int)1, (int)result.size());
        KeyValue kv = result.raw()[0];
        LOG.info((Object)("Got: " + kv));
        TestHRegion.assertTrue((String)"LATEST_TIMESTAMP was not replaced with real timestamp", (kv.getTimestamp() != Long.MAX_VALUE ? 1 : 0) != 0);
        row = Bytes.toBytes((String)"row2");
        put = new Put(row);
        put.add(fam, qual, Long.MAX_VALUE, Bytes.toBytes((String)"value"));
        this.region.put(put, true);
        get = new Get(row).addColumn(fam, qual);
        result = this.region.get(get, null);
        TestHRegion.assertEquals((int)1, (int)result.size());
        kv = result.raw()[0];
        LOG.info((Object)("Got: " + kv));
        TestHRegion.assertTrue((String)"LATEST_TIMESTAMP was not replaced with real timestamp", (kv.getTimestamp() != Long.MAX_VALUE ? 1 : 0) != 0);
    }

    public void testScanner_DeleteOneFamilyNotAnother() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"test_table");
        byte[] fam1 = Bytes.toBytes((String)"columnA");
        byte[] fam2 = Bytes.toBytes((String)"columnB");
        this.initHRegion(tableName, this.getName(), fam1, fam2);
        byte[] rowA = Bytes.toBytes((String)"rowA");
        byte[] rowB = Bytes.toBytes((String)"rowB");
        byte[] value = Bytes.toBytes((String)"value");
        Delete delete = new Delete(rowA);
        delete.deleteFamily(fam1);
        this.region.delete(delete, null, true);
        Put put = new Put(rowA);
        put.add(fam2, null, value);
        this.region.put(put);
        put = new Put(rowB);
        put.add(fam1, null, value);
        put.add(fam2, null, value);
        this.region.put(put);
        Scan scan = new Scan();
        scan.addFamily(fam1).addFamily(fam2);
        InternalScanner s = this.region.getScanner(scan);
        ArrayList results = new ArrayList();
        s.next(results);
        TestHRegion.assertTrue((boolean)Bytes.equals((byte[])rowA, (byte[])((KeyValue)results.get(0)).getRow()));
        results.clear();
        s.next(results);
        TestHRegion.assertTrue((boolean)Bytes.equals((byte[])rowB, (byte[])((KeyValue)results.get(0)).getRow()));
    }

    public void testDeleteColumns_PostInsert() throws IOException, InterruptedException {
        Delete delete = new Delete(this.row);
        delete.deleteColumns(fam1, this.qual1);
        this.doTestDelete_AndPostInsert(delete);
    }

    public void testDeleteFamily_PostInsert() throws IOException, InterruptedException {
        Delete delete = new Delete(this.row);
        delete.deleteFamily(fam1);
        this.doTestDelete_AndPostInsert(delete);
    }

    public void doTestDelete_AndPostInsert(Delete delete) throws IOException, InterruptedException {
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, this.value1);
        this.region.put(put);
        this.region.delete(delete, null, true);
        put = new Put(this.row);
        put.add(fam1, this.qual1, this.value2);
        this.region.put(put);
        Get get = new Get(this.row);
        get.addColumn(fam1, this.qual1);
        Result r = this.region.get(get, null);
        TestHRegion.assertEquals((int)1, (int)r.size());
        TestHRegion.assertByteEquals(this.value2, r.getValue(fam1, this.qual1));
        Scan scan = new Scan(this.row);
        scan.addColumn(fam1, this.qual1);
        InternalScanner s = this.region.getScanner(scan);
        ArrayList results = new ArrayList();
        TestHRegion.assertEquals((boolean)false, (boolean)s.next(results));
        TestHRegion.assertEquals((int)1, (int)results.size());
        KeyValue kv = (KeyValue)results.get(0);
        TestHRegion.assertByteEquals(this.value2, kv.getValue());
        TestHRegion.assertByteEquals(fam1, kv.getFamily());
        TestHRegion.assertByteEquals(this.qual1, kv.getQualifier());
        TestHRegion.assertByteEquals(this.row, kv.getRow());
    }

    public void testDelete_CheckTimestampUpdated() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] col1 = Bytes.toBytes((String)"col1");
        byte[] col2 = Bytes.toBytes((String)"col2");
        byte[] col3 = Bytes.toBytes((String)"col3");
        String method = this.getName();
        this.initHRegion(this.tableName, method, new byte[][]{fam1});
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(row1, fam1, col1, null));
        kvs.add(new KeyValue(row1, fam1, col2, null));
        kvs.add(new KeyValue(row1, fam1, col3, null));
        HashMap<byte[], ArrayList<KeyValue>> deleteMap = new HashMap<byte[], ArrayList<KeyValue>>();
        deleteMap.put(fam1, kvs);
        this.region.delete(deleteMap, true);
        long now = System.currentTimeMillis();
        KeyValue firstKv = this.region.getStore((byte[])TestHRegion.fam1).memstore.kvset.first();
        TestHRegion.assertTrue((firstKv.getTimestamp() <= now ? 1 : 0) != 0);
        now = firstKv.getTimestamp();
        for (KeyValue kv : this.region.getStore((byte[])TestHRegion.fam1).memstore.kvset) {
            TestHRegion.assertTrue((kv.getTimestamp() <= now ? 1 : 0) != 0);
            now = kv.getTimestamp();
        }
    }

    public void testGet_FamilyChecker() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"False");
        byte[] col1 = Bytes.toBytes((String)"col1");
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam1});
        Get get = new Get(row1);
        get.addColumn(fam2, col1);
        try {
            this.region.get(get, null);
        }
        catch (NoSuchColumnFamilyException e) {
            TestHRegion.assertFalse((boolean)false);
            return;
        }
        TestHRegion.assertFalse((boolean)true);
    }

    public void testGet_Basic() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] col1 = Bytes.toBytes((String)"col1");
        byte[] col2 = Bytes.toBytes((String)"col2");
        byte[] col3 = Bytes.toBytes((String)"col3");
        byte[] col4 = Bytes.toBytes((String)"col4");
        byte[] col5 = Bytes.toBytes((String)"col5");
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam1});
        Put put = new Put(row1);
        put.add(fam1, col1, null);
        put.add(fam1, col2, null);
        put.add(fam1, col3, null);
        put.add(fam1, col4, null);
        put.add(fam1, col5, null);
        this.region.put(put);
        Get get = new Get(row1);
        get.addColumn(fam1, col2);
        get.addColumn(fam1, col4);
        KeyValue kv1 = new KeyValue(row1, fam1, col2);
        KeyValue kv2 = new KeyValue(row1, fam1, col4);
        KeyValue[] expected = new KeyValue[]{kv1, kv2};
        Result res = this.region.get(get, null);
        TestHRegion.assertEquals((int)expected.length, (int)res.size());
        for (int i = 0; i < res.size(); ++i) {
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo((byte[])expected[i].getRow(), (byte[])res.raw()[i].getRow()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo((byte[])expected[i].getFamily(), (byte[])res.raw()[i].getFamily()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo((byte[])expected[i].getQualifier(), (byte[])res.raw()[i].getQualifier()));
        }
        Get g = new Get(row1);
        int count = 2;
        g.setFilter((Filter)new ColumnCountGetFilter(2));
        res = this.region.get(g, null);
        TestHRegion.assertEquals((int)2, (int)res.size());
    }

    public void testGet_Empty() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"emptytable");
        byte[] row = Bytes.toBytes((String)"row");
        byte[] fam = Bytes.toBytes((String)"fam");
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam});
        Get get = new Get(row);
        get.addFamily(fam);
        Result r = this.region.get(get, null);
        TestHRegion.assertTrue((boolean)r.isEmpty());
    }

    public void stestGet_Root() throws IOException {
        int i;
        String method = this.getName();
        this.initHRegion(HConstants.ROOT_TABLE_NAME, method, new byte[][]{HConstants.CATALOG_FAMILY});
        Put put = new Put(HConstants.EMPTY_START_ROW);
        put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, null);
        this.region.put(put);
        Get get = new Get(HConstants.EMPTY_START_ROW);
        get.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        KeyValue kv1 = new KeyValue(HConstants.EMPTY_START_ROW, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        KeyValue[] expected = new KeyValue[]{kv1};
        Result res = this.region.get(get, null);
        TestHRegion.assertEquals((int)expected.length, (int)res.size());
        for (i = 0; i < res.size(); ++i) {
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo((byte[])expected[i].getRow(), (byte[])res.raw()[i].getRow()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo((byte[])expected[i].getFamily(), (byte[])res.raw()[i].getFamily()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo((byte[])expected[i].getQualifier(), (byte[])res.raw()[i].getQualifier()));
        }
        this.region.flushcache();
        res = this.region.get(get, null);
        TestHRegion.assertEquals((int)expected.length, (int)res.size());
        for (i = 0; i < res.size(); ++i) {
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo((byte[])expected[i].getRow(), (byte[])res.raw()[i].getRow()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo((byte[])expected[i].getFamily(), (byte[])res.raw()[i].getFamily()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo((byte[])expected[i].getQualifier(), (byte[])res.raw()[i].getQualifier()));
        }
        Scan scan = new Scan();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        InternalScanner s = this.region.getScanner(scan);
        ArrayList result = new ArrayList();
        s.next(result);
        TestHRegion.assertEquals((int)expected.length, (int)result.size());
        for (int i2 = 0; i2 < res.size(); ++i2) {
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo((byte[])expected[i2].getRow(), (byte[])((KeyValue)result.get(i2)).getRow()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo((byte[])expected[i2].getFamily(), (byte[])((KeyValue)result.get(i2)).getFamily()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo((byte[])expected[i2].getQualifier(), (byte[])((KeyValue)result.get(i2)).getQualifier()));
        }
    }

    public void testLocks() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[][] families = new byte[][]{fam1, fam2, fam3};
        Configuration hc = this.initSplit();
        String method = this.getName();
        this.initHRegion(tableName, method, hc, (byte[][])families);
        int threadCount = 10;
        int lockCount = 10;
        ArrayList<2> threads = new ArrayList<2>(10);
        for (int i = 0; i < 10; ++i) {
            threads.add(new Thread(Integer.toString(i)){

                @Override
                public void run() {
                    int i;
                    Integer[] lockids = new Integer[10];
                    for (i = 0; i < 10; ++i) {
                        try {
                            byte[] rowid = Bytes.toBytes((String)Integer.toString(i));
                            lockids[i] = TestHRegion.this.region.obtainRowLock(rowid);
                            HBaseTestCase.assertEquals(rowid, TestHRegion.this.region.getRowFromLock(lockids[i]));
                            LOG.debug((Object)(this.getName() + " locked " + Bytes.toString((byte[])rowid)));
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    LOG.debug((Object)(this.getName() + " set " + Integer.toString(10) + " locks"));
                    for (i = 9; i >= 0; --i) {
                        TestHRegion.this.region.releaseRowLock(lockids[i]);
                        LOG.debug((Object)(this.getName() + " unlocked " + i));
                    }
                    LOG.debug((Object)(this.getName() + " released " + Integer.toString(10) + " locks"));
                }
            });
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            while (thread.isAlive()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {}
            }
        }
        LOG.info((Object)"locks completed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMerge() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[][] families = new byte[][]{fam1, fam2, fam3};
        Configuration hc = this.initSplit();
        String method = this.getName();
        this.initHRegion(tableName, method, hc, (byte[][])families);
        try {
            LOG.info((Object)("" + TestHRegion.addContent(this.region, fam3)));
            this.region.flushcache();
            byte[] splitRow = this.region.compactStores();
            TestHRegion.assertNotNull((Object)splitRow);
            LOG.info((Object)("SplitRow: " + Bytes.toString((byte[])splitRow)));
            HRegion[] subregions = this.splitRegion(this.region, splitRow);
            try {
                for (int i = 0; i < subregions.length; ++i) {
                    this.openClosedRegion(subregions[i]);
                    subregions[i].compactStores();
                }
                Path oldRegionPath = this.region.getRegionDir();
                Path oldRegion1 = subregions[0].getRegionDir();
                Path oldRegion2 = subregions[1].getRegionDir();
                long startTime = System.currentTimeMillis();
                this.region = HRegion.mergeAdjacent((HRegion)subregions[0], (HRegion)subregions[1]);
                LOG.info((Object)("Merge regions elapsed time: " + (double)(System.currentTimeMillis() - startTime) / 1000.0));
                this.fs.delete(oldRegion1, true);
                this.fs.delete(oldRegion2, true);
                this.fs.delete(oldRegionPath, true);
                LOG.info((Object)"splitAndMerge completed.");
            }
            finally {
                for (int i = 0; i < subregions.length; ++i) {
                    try {
                        subregions[i].close();
                        continue;
                    }
                    catch (IOException e) {}
                }
            }
        }
        finally {
            if (this.region != null) {
                this.region.close();
                this.region.getLog().closeAndDelete();
            }
        }
    }

    HRegion[] splitRegion(HRegion parent, byte[] midkey) throws IOException {
        PairOfSameType result = null;
        SplitTransaction st = new SplitTransaction(parent, midkey);
        if (!st.prepare()) {
            return null;
        }
        try {
            result = st.execute(null, null);
        }
        catch (IOException ioe) {
            try {
                LOG.info((Object)("Running rollback of failed split of " + parent.getRegionNameAsString() + "; " + ioe.getMessage()));
                st.rollback(null);
                LOG.info((Object)("Successful rollback of failed split of " + parent.getRegionNameAsString()));
                return null;
            }
            catch (RuntimeException e) {
                LOG.info((Object)("Failed rollback of failed split of " + parent.getRegionNameAsString() + " -- aborting server"), (Throwable)e);
            }
        }
        return new HRegion[]{(HRegion)result.getFirst(), (HRegion)result.getSecond()};
    }

    public void testGetScanner_WithOkFamilies() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[][] families = new byte[][]{fam1, fam2};
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Scan scan = new Scan();
        scan.addFamily(fam1);
        scan.addFamily(fam2);
        try {
            this.region.getScanner(scan);
        }
        catch (Exception e) {
            TestHRegion.assertTrue((String)"Families could not be found in Region", (boolean)false);
        }
    }

    public void testGetScanner_WithNotOkFamilies() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[][] families = new byte[][]{fam1};
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Scan scan = new Scan();
        scan.addFamily(fam2);
        boolean ok = false;
        try {
            this.region.getScanner(scan);
        }
        catch (Exception e) {
            ok = true;
        }
        TestHRegion.assertTrue((String)"Families could not be found in Region", (boolean)ok);
    }

    public void testGetScanner_WithNoFamilies() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] fam3 = Bytes.toBytes((String)"fam3");
        byte[] fam4 = Bytes.toBytes((String)"fam4");
        byte[][] families = new byte[][]{fam1, fam2, fam3, fam4};
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Put put = new Put(row1);
        put.add(fam1, null, null);
        put.add(fam2, null, null);
        put.add(fam3, null, null);
        put.add(fam4, null, null);
        this.region.put(put);
        Scan scan = null;
        HRegion.RegionScanner is = null;
        scan = new Scan();
        scan.addFamily(fam2);
        scan.addFamily(fam4);
        is = (HRegion.RegionScanner)this.region.getScanner(scan);
        ReadWriteConsistencyControl.resetThreadReadPoint((ReadWriteConsistencyControl)this.region.getRWCC());
        TestHRegion.assertEquals((int)1, (int)is.storeHeap.getHeap().size());
        scan = new Scan();
        is = (HRegion.RegionScanner)this.region.getScanner(scan);
        ReadWriteConsistencyControl.resetThreadReadPoint((ReadWriteConsistencyControl)this.region.getRWCC());
        TestHRegion.assertEquals((int)(families.length - 1), (int)is.storeHeap.getHeap().size());
    }

    public void testGetScanner_WithRegionClosed() {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[][] families = new byte[][]{fam1, fam2};
        String method = this.getName();
        try {
            this.initHRegion(tableName, method, families);
        }
        catch (IOException e) {
            e.printStackTrace();
            TestHRegion.fail((String)("Got IOException during initHRegion, " + e.getMessage()));
        }
        this.region.closed.set(true);
        try {
            this.region.getScanner(null);
            TestHRegion.fail((String)"Expected to get an exception during getScanner on a region that is closed");
        }
        catch (NotServingRegionException e) {
        }
        catch (IOException e) {
            TestHRegion.fail((String)("Got wrong type of exception - should be a NotServingRegionException, but was an IOException: " + e.getMessage()));
        }
    }

    public void testRegionScanner_Next() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] fam3 = Bytes.toBytes((String)"fam3");
        byte[] fam4 = Bytes.toBytes((String)"fam4");
        byte[][] families = new byte[][]{fam1, fam2, fam3, fam4};
        long ts = System.currentTimeMillis();
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Put put = null;
        put = new Put(row1);
        put.add(fam1, null, ts, null);
        put.add(fam2, null, ts, null);
        put.add(fam3, null, ts, null);
        put.add(fam4, null, ts, null);
        this.region.put(put);
        put = new Put(row2);
        put.add(fam1, null, ts, null);
        put.add(fam2, null, ts, null);
        put.add(fam3, null, ts, null);
        put.add(fam4, null, ts, null);
        this.region.put(put);
        Scan scan = new Scan();
        scan.addFamily(fam2);
        scan.addFamily(fam4);
        InternalScanner is = this.region.getScanner(scan);
        ArrayList res = null;
        ArrayList<KeyValue> expected1 = new ArrayList<KeyValue>();
        expected1.add(new KeyValue(row1, fam2, null, ts, KeyValue.Type.Put, null));
        expected1.add(new KeyValue(row1, fam4, null, ts, KeyValue.Type.Put, null));
        res = new ArrayList();
        is.next(res);
        for (int i = 0; i < res.size(); ++i) {
            TestHRegion.assertEquals(expected1.get(i), res.get(i));
        }
        ArrayList<KeyValue> expected2 = new ArrayList<KeyValue>();
        expected2.add(new KeyValue(row2, fam2, null, ts, KeyValue.Type.Put, null));
        expected2.add(new KeyValue(row2, fam4, null, ts, KeyValue.Type.Put, null));
        res = new ArrayList();
        is.next(res);
        for (int i = 0; i < res.size(); ++i) {
            TestHRegion.assertEquals(expected2.get(i), res.get(i));
        }
    }

    public void testScanner_ExplicitColumns_FromMemStore_EnforceVersions() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[][] families = new byte[][]{fam1};
        long ts1 = System.currentTimeMillis();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Put put = null;
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        put = new Put(row1);
        put.add(kv13);
        put.add(kv12);
        put.add(kv11);
        put.add(kv23);
        put.add(kv22);
        put.add(kv21);
        this.region.put(put);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv13);
        expected.add(kv12);
        Scan scan = new Scan(row1);
        scan.addColumn(fam1, qf1);
        scan.setMaxVersions(2);
        ArrayList actual = new ArrayList();
        InternalScanner scanner = this.region.getScanner(scan);
        boolean hasNext = scanner.next(actual);
        TestHRegion.assertEquals((boolean)false, (boolean)hasNext);
        for (int i = 0; i < expected.size(); ++i) {
            TestHRegion.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testScanner_ExplicitColumns_FromFilesOnly_EnforceVersions() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[][] families = new byte[][]{fam1};
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Put put = null;
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        put = new Put(row1);
        put.add(kv13);
        put.add(kv12);
        put.add(kv11);
        put.add(kv23);
        put.add(kv22);
        put.add(kv21);
        this.region.put(put);
        this.region.flushcache();
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv13);
        expected.add(kv12);
        expected.add(kv23);
        expected.add(kv22);
        Scan scan = new Scan(row1);
        scan.addColumn(fam1, qf1);
        scan.addColumn(fam1, qf2);
        scan.setMaxVersions(2);
        ArrayList actual = new ArrayList();
        InternalScanner scanner = this.region.getScanner(scan);
        boolean hasNext = scanner.next(actual);
        TestHRegion.assertEquals((boolean)false, (boolean)hasNext);
        for (int i = 0; i < expected.size(); ++i) {
            TestHRegion.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testScanner_ExplicitColumns_FromMemStoreAndFiles_EnforceVersions() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[][] families = new byte[][]{fam1};
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        long ts4 = ts1 + 3L;
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        KeyValue kv14 = new KeyValue(row1, fam1, qf1, ts4, KeyValue.Type.Put, null);
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv24 = new KeyValue(row1, fam1, qf2, ts4, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        Put put = null;
        put = new Put(row1);
        put.add(kv14);
        put.add(kv24);
        this.region.put(put);
        this.region.flushcache();
        put = new Put(row1);
        put.add(kv23);
        put.add(kv13);
        this.region.put(put);
        this.region.flushcache();
        put = new Put(row1);
        put.add(kv22);
        put.add(kv12);
        this.region.put(put);
        this.region.flushcache();
        put = new Put(row1);
        put.add(kv21);
        put.add(kv11);
        this.region.put(put);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv14);
        expected.add(kv13);
        expected.add(kv12);
        expected.add(kv24);
        expected.add(kv23);
        expected.add(kv22);
        Scan scan = new Scan(row1);
        scan.addColumn(fam1, qf1);
        scan.addColumn(fam1, qf2);
        int versions = 3;
        scan.setMaxVersions(versions);
        ArrayList actual = new ArrayList();
        InternalScanner scanner = this.region.getScanner(scan);
        boolean hasNext = scanner.next(actual);
        TestHRegion.assertEquals((boolean)false, (boolean)hasNext);
        for (int i = 0; i < expected.size(); ++i) {
            TestHRegion.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testScanner_Wildcard_FromMemStore_EnforceVersions() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[][] families = new byte[][]{fam1};
        long ts1 = System.currentTimeMillis();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Put put = null;
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        put = new Put(row1);
        put.add(kv13);
        put.add(kv12);
        put.add(kv11);
        put.add(kv23);
        put.add(kv22);
        put.add(kv21);
        this.region.put(put);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv13);
        expected.add(kv12);
        expected.add(kv23);
        expected.add(kv22);
        Scan scan = new Scan(row1);
        scan.addFamily(fam1);
        scan.setMaxVersions(2);
        ArrayList actual = new ArrayList();
        InternalScanner scanner = this.region.getScanner(scan);
        boolean hasNext = scanner.next(actual);
        TestHRegion.assertEquals((boolean)false, (boolean)hasNext);
        for (int i = 0; i < expected.size(); ++i) {
            TestHRegion.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testScanner_Wildcard_FromFilesOnly_EnforceVersions() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"qualifier2");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam1});
        Put put = null;
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        put = new Put(row1);
        put.add(kv13);
        put.add(kv12);
        put.add(kv11);
        put.add(kv23);
        put.add(kv22);
        put.add(kv21);
        this.region.put(put);
        this.region.flushcache();
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv13);
        expected.add(kv12);
        expected.add(kv23);
        expected.add(kv22);
        Scan scan = new Scan(row1);
        scan.addFamily(fam1);
        scan.setMaxVersions(2);
        ArrayList actual = new ArrayList();
        InternalScanner scanner = this.region.getScanner(scan);
        boolean hasNext = scanner.next(actual);
        TestHRegion.assertEquals((boolean)false, (boolean)hasNext);
        for (int i = 0; i < expected.size(); ++i) {
            TestHRegion.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testScanner_StopRow1542() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"test_table");
        byte[] family = Bytes.toBytes((String)"testFamily");
        this.initHRegion(tableName, this.getName(), new byte[][]{family});
        byte[] row1 = Bytes.toBytes((String)"row111");
        byte[] row2 = Bytes.toBytes((String)"row222");
        byte[] row3 = Bytes.toBytes((String)"row333");
        byte[] row4 = Bytes.toBytes((String)"row444");
        byte[] row5 = Bytes.toBytes((String)"row555");
        byte[] col1 = Bytes.toBytes((String)"Pub111");
        byte[] col2 = Bytes.toBytes((String)"Pub222");
        Put put = new Put(row1);
        put.add(family, col1, Bytes.toBytes((long)10L));
        this.region.put(put);
        put = new Put(row2);
        put.add(family, col1, Bytes.toBytes((long)15L));
        this.region.put(put);
        put = new Put(row3);
        put.add(family, col2, Bytes.toBytes((long)20L));
        this.region.put(put);
        put = new Put(row4);
        put.add(family, col2, Bytes.toBytes((long)30L));
        this.region.put(put);
        put = new Put(row5);
        put.add(family, col1, Bytes.toBytes((long)40L));
        this.region.put(put);
        Scan scan = new Scan(row3, row4);
        scan.setMaxVersions();
        scan.addColumn(family, col1);
        InternalScanner s = this.region.getScanner(scan);
        ArrayList results = new ArrayList();
        TestHRegion.assertEquals((boolean)false, (boolean)s.next(results));
        TestHRegion.assertEquals((int)0, (int)results.size());
    }

    public void testIncrementColumnValue_UpdatingInPlace() throws IOException {
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        long value = 1L;
        long amount = 3L;
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, Bytes.toBytes((long)value));
        this.region.put(put);
        long result = this.region.incrementColumnValue(this.row, fam1, this.qual1, amount, true);
        TestHRegion.assertEquals((long)(value + amount), (long)result);
        Store store = this.region.getStore(fam1);
        TestHRegion.assertEquals((int)1, (int)store.memstore.kvset.size());
        TestHRegion.assertTrue((boolean)store.memstore.snapshot.isEmpty());
        this.assertICV(this.row, fam1, this.qual1, value + amount);
    }

    public void testIncrementColumnValue_BumpSnapshot() throws IOException {
        ManualEnvironmentEdge mee = new ManualEnvironmentEdge();
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)mee);
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        long value = 42L;
        long incr = 44L;
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, Bytes.toBytes((long)value));
        this.region.put(put);
        Store s = this.region.getStore(fam1);
        s.snapshot();
        long newVal = this.region.incrementColumnValue(this.row, fam1, this.qual1, incr, false);
        TestHRegion.assertEquals((long)(value + incr), (long)newVal);
        Get get = new Get(this.row);
        get.setMaxVersions();
        get.addColumn(fam1, this.qual1);
        Result r = this.region.get(get, null);
        TestHRegion.assertEquals((int)2, (int)r.size());
        KeyValue first = r.raw()[0];
        KeyValue second = r.raw()[1];
        TestHRegion.assertTrue((String)"ICV failed to upgrade timestamp", (first.getTimestamp() != second.getTimestamp() ? 1 : 0) != 0);
    }

    public void testIncrementColumnValue_ConcurrentFlush() throws IOException {
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        long value = 1L;
        long amount = 3L;
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, Bytes.toBytes((long)value));
        this.region.put(put);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    TestHRegion.this.region.flushcache();
                }
                catch (IOException e) {
                    LOG.info((Object)"test ICV, got IOE during flushcache()");
                }
            }
        };
        t.start();
        long r = this.region.incrementColumnValue(this.row, fam1, this.qual1, amount, true);
        TestHRegion.assertEquals((long)(value + amount), (long)r);
        this.assertICV(this.row, fam1, this.qual1, value + amount);
    }

    public void testIncrementColumnValue_heapSize() throws IOException {
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        long byAmount = 1L;
        for (int i = 0; i < 1000; ++i) {
            this.region.incrementColumnValue(this.row, fam1, this.qual1, byAmount, true);
            long size = this.region.memstoreSize.get();
            TestHRegion.assertTrue((String)("memstore size: " + size), (size >= 0L ? 1 : 0) != 0);
        }
    }

    public void testIncrementColumnValue_UpdatingInPlace_Negative() throws IOException {
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        long value = 3L;
        long amount = -1L;
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, Bytes.toBytes((long)value));
        this.region.put(put);
        long result = this.region.incrementColumnValue(this.row, fam1, this.qual1, amount, true);
        TestHRegion.assertEquals((long)(value + amount), (long)result);
        this.assertICV(this.row, fam1, this.qual1, value + amount);
    }

    public void testIncrementColumnValue_AddingNew() throws IOException {
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        long value = 1L;
        long amount = 3L;
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, Bytes.toBytes((long)value));
        put.add(fam1, this.qual2, Bytes.toBytes((long)value));
        this.region.put(put);
        long result = this.region.incrementColumnValue(this.row, fam1, this.qual3, amount, true);
        TestHRegion.assertEquals((long)amount, (long)result);
        Get get = new Get(this.row);
        get.addColumn(fam1, this.qual3);
        Result rr = this.region.get(get, null);
        TestHRegion.assertEquals((int)1, (int)rr.size());
        this.assertICV(this.row, fam1, this.qual1, value);
        this.assertICV(this.row, fam1, this.qual2, value);
        this.assertICV(this.row, fam1, this.qual3, amount);
    }

    public void testIncrementColumnValue_UpdatingFromSF() throws IOException {
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        long value = 1L;
        long amount = 3L;
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, Bytes.toBytes((long)value));
        put.add(fam1, this.qual2, Bytes.toBytes((long)value));
        this.region.put(put);
        this.region.flushcache();
        Store store = this.region.getStore(fam1);
        TestHRegion.assertEquals((int)0, (int)store.memstore.kvset.size());
        long r = this.region.incrementColumnValue(this.row, fam1, this.qual1, amount, true);
        TestHRegion.assertEquals((long)(value + amount), (long)r);
        this.assertICV(this.row, fam1, this.qual1, value + amount);
    }

    public void testIncrementColumnValue_AddingNewAfterSFCheck() throws IOException {
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        long value = 1L;
        long amount = 3L;
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, Bytes.toBytes((long)value));
        put.add(fam1, this.qual2, Bytes.toBytes((long)value));
        this.region.put(put);
        this.region.flushcache();
        Store store = this.region.getStore(fam1);
        TestHRegion.assertEquals((int)0, (int)store.memstore.kvset.size());
        long r = this.region.incrementColumnValue(this.row, fam1, this.qual3, amount, true);
        TestHRegion.assertEquals((long)amount, (long)r);
        this.assertICV(this.row, fam1, this.qual3, amount);
        this.region.flushcache();
        this.assertICV(this.row, fam1, this.qual3, amount);
    }

    public void testIncrementColumnValue_UpdatingInPlace_TimestampClobber() throws IOException {
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        long value = 1L;
        long amount = 3L;
        long now = EnvironmentEdgeManager.currentTimeMillis();
        ManualEnvironmentEdge mock = new ManualEnvironmentEdge();
        mock.setValue(now);
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)mock);
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, now, Bytes.toBytes((long)value));
        this.region.put(put);
        long result = this.region.incrementColumnValue(this.row, fam1, this.qual1, amount, true);
        TestHRegion.assertEquals((long)(value + amount), (long)result);
        Store store = this.region.getStore(fam1);
        TestHRegion.assertEquals((int)1, (int)store.memstore.kvset.size());
        TestHRegion.assertTrue((boolean)store.memstore.snapshot.isEmpty());
        this.assertICV(this.row, fam1, this.qual1, value + amount);
        put = new Put(this.row);
        put.add(fam1, this.qual2, now + 1L, Bytes.toBytes((long)value));
        this.region.put(put);
        result = this.region.incrementColumnValue(this.row, fam1, this.qual2, amount, true);
        TestHRegion.assertEquals((long)(value + amount), (long)result);
        store = this.region.getStore(fam1);
        TestHRegion.assertEquals((int)2, (int)store.memstore.kvset.size());
        TestHRegion.assertTrue((boolean)store.memstore.snapshot.isEmpty());
        this.assertICV(this.row, fam1, this.qual2, value + amount);
        EnvironmentEdgeManagerTestHelper.reset();
    }

    private void assertICV(byte[] row, byte[] familiy, byte[] qualifier, long amount) throws IOException {
        Get get = new Get(row);
        get.addColumn(familiy, qualifier);
        Result result = this.region.get(get, null);
        TestHRegion.assertEquals((int)1, (int)result.size());
        KeyValue kv = result.raw()[0];
        long r = Bytes.toLong((byte[])kv.getValue());
        TestHRegion.assertEquals((long)amount, (long)r);
    }

    public void testScanner_Wildcard_FromMemStoreAndFiles_EnforceVersions() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] qf1 = Bytes.toBytes((String)"qualifier1");
        byte[] qf2 = Bytes.toBytes((String)"quateslifier2");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        long ts4 = ts1 + 3L;
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam1});
        KeyValue kv14 = new KeyValue(row1, fam1, qf1, ts4, KeyValue.Type.Put, null);
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv24 = new KeyValue(row1, fam1, qf2, ts4, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        Put put = null;
        put = new Put(row1);
        put.add(kv14);
        put.add(kv24);
        this.region.put(put);
        this.region.flushcache();
        put = new Put(row1);
        put.add(kv23);
        put.add(kv13);
        this.region.put(put);
        this.region.flushcache();
        put = new Put(row1);
        put.add(kv22);
        put.add(kv12);
        this.region.put(put);
        this.region.flushcache();
        put = new Put(row1);
        put.add(kv21);
        put.add(kv11);
        this.region.put(put);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv14);
        expected.add(kv13);
        expected.add(kv12);
        expected.add(kv24);
        expected.add(kv23);
        expected.add(kv22);
        Scan scan = new Scan(row1);
        int versions = 3;
        scan.setMaxVersions(versions);
        ArrayList actual = new ArrayList();
        InternalScanner scanner = this.region.getScanner(scan);
        boolean hasNext = scanner.next(actual);
        TestHRegion.assertEquals((boolean)false, (boolean)hasNext);
        for (int i = 0; i < expected.size(); ++i) {
            TestHRegion.assertEquals(expected.get(i), actual.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicSplit() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[][] families = new byte[][]{fam1, fam2, fam3};
        Configuration hc = this.initSplit();
        String method = this.getName();
        this.initHRegion(tableName, method, hc, (byte[][])families);
        try {
            LOG.info((Object)("" + TestHRegion.addContent(this.region, fam3)));
            this.region.flushcache();
            byte[] splitRow = this.region.compactStores();
            TestHRegion.assertNotNull((Object)splitRow);
            LOG.info((Object)("SplitRow: " + Bytes.toString((byte[])splitRow)));
            HRegion[] regions = this.splitRegion(this.region, splitRow);
            try {
                int i;
                for (i = 0; i < regions.length; ++i) {
                    regions[i] = this.openClosedRegion(regions[i]);
                }
                this.assertGet(regions[0], fam3, Bytes.toBytes((String)this.START_KEY));
                this.assertGet(regions[1], fam3, splitRow);
                this.assertScan(regions[0], fam3, Bytes.toBytes((String)this.START_KEY));
                this.assertScan(regions[1], fam3, splitRow);
                for (i = 0; i < regions.length; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        TestHRegion.addContent(regions[i], fam3);
                    }
                    TestHRegion.addContent(regions[i], fam2);
                    TestHRegion.addContent(regions[i], fam1);
                    regions[i].flushcache();
                }
                byte[][] midkeys = new byte[regions.length][];
                for (int i2 = 0; i2 < regions.length; ++i2) {
                    midkeys[i2] = regions[i2].compactStores();
                }
                TreeMap<String, HRegion> sortedMap = new TreeMap<String, HRegion>();
                for (int i3 = 0; i3 < regions.length; ++i3) {
                    HRegion[] rs = null;
                    if (midkeys[i3] == null) continue;
                    rs = this.splitRegion(regions[i3], midkeys[i3]);
                    for (int j = 0; j < rs.length; ++j) {
                        sortedMap.put(Bytes.toString((byte[])rs[j].getRegionName()), this.openClosedRegion(rs[j]));
                    }
                }
                LOG.info((Object)"Made 4 regions");
                int interval = 8;
                byte[] b = Bytes.toBytes((String)this.START_KEY);
                for (HRegion r : sortedMap.values()) {
                    this.assertGet(r, fam3, b);
                    b[0] = (byte)(b[0] + interval);
                }
            }
            finally {
                for (int i = 0; i < regions.length; ++i) {
                    try {
                        regions[i].close();
                        continue;
                    }
                    catch (IOException e) {}
                }
            }
        }
        finally {
            if (this.region != null) {
                this.region.close();
                this.region.getLog().closeAndDelete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitRegion() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testtable");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        Configuration hc = this.initSplit();
        int numRows = 10;
        byte[][] families = new byte[][]{fam1, fam3};
        String method = this.getName();
        this.initHRegion(tableName, method, hc, (byte[][])families);
        int startRow = 100;
        this.putData(startRow, numRows, qualifier, families);
        int splitRow = startRow + numRows;
        this.putData(splitRow, numRows, qualifier, families);
        this.region.flushcache();
        HRegion[] regions = null;
        try {
            regions = this.splitRegion(this.region, Bytes.toBytes((String)("" + splitRow)));
            for (int i = 0; i < regions.length; ++i) {
                regions[i] = this.openClosedRegion(regions[i]);
            }
            TestHRegion.assertEquals((int)2, (int)regions.length);
            this.verifyData(regions[0], startRow, numRows, qualifier, families);
            this.verifyData(regions[1], splitRow, numRows, qualifier, families);
        }
        finally {
            if (this.region != null) {
                this.region.close();
                this.region.getLog().closeAndDelete();
            }
        }
    }

    public void testFlushCacheWhileScanning() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes((String)"testFlushCacheWhileScanning");
        byte[] family = Bytes.toBytes((String)"family");
        int numRows = 1000;
        int flushAndScanInterval = 10;
        int compactInterval = 10 * flushAndScanInterval;
        String method = "testFlushCacheWhileScanning";
        this.initHRegion(tableName, method, new byte[][]{family});
        FlushThread flushThread = new FlushThread();
        flushThread.start();
        Scan scan = new Scan();
        scan.addFamily(family);
        scan.setFilter((Filter)new SingleColumnValueFilter(family, this.qual1, CompareFilter.CompareOp.EQUAL, (WritableByteArrayComparable)new BinaryComparator(Bytes.toBytes((long)5L))));
        int expectedCount = 0;
        ArrayList res = new ArrayList();
        boolean toggle = true;
        for (long i = 0L; i < (long)numRows; ++i) {
            Put put = new Put(Bytes.toBytes((long)i));
            put.add(family, this.qual1, Bytes.toBytes((long)(i % 10L)));
            this.region.put(put);
            if (i != 0L && i % (long)compactInterval == 0L) {
                this.region.compactStores(true);
            }
            if (i % 10L == 5L) {
                ++expectedCount;
            }
            if (i == 0L || i % (long)flushAndScanInterval != 0L) continue;
            res.clear();
            InternalScanner scanner = this.region.getScanner(scan);
            if (toggle) {
                flushThread.flush();
            }
            while (scanner.next(res)) {
            }
            if (!toggle) {
                flushThread.flush();
            }
            TestHRegion.assertEquals((String)("i=" + i), (int)expectedCount, (int)res.size());
            toggle = !toggle;
        }
        flushThread.done();
        flushThread.join();
        flushThread.checkNoError();
    }

    public void testWritesWhileScanning() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes((String)"testWritesWhileScanning");
        int testCount = 100;
        int numRows = 1;
        int numFamilies = 10;
        int numQualifiers = 100;
        int flushInterval = 7;
        int compactInterval = 5 * flushInterval;
        byte[][] families = new byte[numFamilies][];
        for (int i = 0; i < numFamilies; ++i) {
            families[i] = Bytes.toBytes((String)("family" + i));
        }
        byte[][] qualifiers = new byte[numQualifiers][];
        for (int i = 0; i < numQualifiers; ++i) {
            qualifiers[i] = Bytes.toBytes((String)("qual" + i));
        }
        String method = "testWritesWhileScanning";
        this.initHRegion(tableName, method, families);
        PutThread putThread = new PutThread(numRows, families, qualifiers);
        putThread.start();
        putThread.waitForFirstPut();
        FlushThread flushThread = new FlushThread();
        flushThread.start();
        Scan scan = new Scan(Bytes.toBytes((String)"row0"), Bytes.toBytes((String)"row1"));
        int expectedCount = numFamilies * numQualifiers;
        ArrayList res = new ArrayList();
        long prevTimestamp = 0L;
        for (int i = 0; i < testCount; ++i) {
            if (i != 0 && i % compactInterval == 0) {
                this.region.compactStores(true);
            }
            if (i != 0 && i % flushInterval == 0) {
                flushThread.flush();
            }
            boolean previousEmpty = res.isEmpty();
            res.clear();
            InternalScanner scanner = this.region.getScanner(scan);
            while (scanner.next(res)) {
            }
            if (res.isEmpty() && previousEmpty && i <= compactInterval) continue;
            TestHRegion.assertEquals((String)("i=" + i), (int)expectedCount, (int)res.size());
            long timestamp = ((KeyValue)res.get(0)).getTimestamp();
            TestHRegion.assertTrue((String)("Timestamps were broke: " + timestamp + " prev: " + prevTimestamp), (timestamp >= prevTimestamp ? 1 : 0) != 0);
            prevTimestamp = timestamp;
        }
        putThread.done();
        this.region.flushcache();
        putThread.join();
        putThread.checkNoError();
        flushThread.done();
        flushThread.join();
        flushThread.checkNoError();
    }

    public void testWritesWhileGetting() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes((String)"testWritesWhileScanning");
        int testCount = 100;
        int numRows = 1;
        int numFamilies = 10;
        int numQualifiers = 100;
        int flushInterval = 10;
        int compactInterval = 10 * flushInterval;
        byte[][] families = new byte[numFamilies][];
        for (int i = 0; i < numFamilies; ++i) {
            families[i] = Bytes.toBytes((String)("family" + i));
        }
        byte[][] qualifiers = new byte[numQualifiers][];
        for (int i = 0; i < numQualifiers; ++i) {
            qualifiers[i] = Bytes.toBytes((String)("qual" + i));
        }
        String method = "testWritesWhileScanning";
        this.initHRegion(tableName, method, families);
        PutThread putThread = new PutThread(numRows, families, qualifiers);
        putThread.start();
        putThread.waitForFirstPut();
        FlushThread flushThread = new FlushThread();
        flushThread.start();
        Get get = new Get(Bytes.toBytes((String)"row0"));
        Result result = null;
        int expectedCount = numFamilies * numQualifiers;
        long prevTimestamp = 0L;
        for (int i = 0; i < testCount; ++i) {
            if (i != 0 && i % compactInterval == 0) {
                this.region.compactStores(true);
            }
            if (i != 0 && i % flushInterval == 0) {
                flushThread.flush();
            }
            boolean previousEmpty = result == null || result.isEmpty();
            result = this.region.get(get, null);
            if (result.isEmpty() && previousEmpty && i <= compactInterval) continue;
            TestHRegion.assertEquals((String)("i=" + i), (int)expectedCount, (int)result.size());
            long timestamp = 0L;
            for (KeyValue kv : result.sorted()) {
                if (!Bytes.equals((byte[])kv.getFamily(), (byte[])families[0]) || !Bytes.equals((byte[])kv.getQualifier(), (byte[])qualifiers[0])) continue;
                timestamp = kv.getTimestamp();
            }
            TestHRegion.assertTrue((timestamp >= prevTimestamp ? 1 : 0) != 0);
            prevTimestamp = timestamp;
            byte[] gotValue = null;
            for (KeyValue kv : result.raw()) {
                byte[] thisValue = kv.getValue();
                if (gotValue != null) {
                    TestHRegion.assertEquals(gotValue, thisValue);
                }
                gotValue = thisValue;
            }
        }
        putThread.done();
        this.region.flushcache();
        putThread.join();
        putThread.checkNoError();
        flushThread.done();
        flushThread.join();
        flushThread.checkNoError();
    }

    public void testIndexesScanWithOneDeletedRow() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testIndexesScanWithOneDeletedRow");
        byte[] family = Bytes.toBytes((String)"family");
        String method = "testIndexesScanWithOneDeletedRow";
        this.initHRegion(tableName, method, HBaseConfiguration.create(), (byte[][])new byte[][]{family});
        Put put = new Put(Bytes.toBytes((long)1L));
        put.add(family, this.qual1, 1L, Bytes.toBytes((long)1L));
        this.region.put(put);
        this.region.flushcache();
        Delete delete = new Delete(Bytes.toBytes((long)1L), 1L, null);
        this.region.delete(delete, null, true);
        put = new Put(Bytes.toBytes((long)2L));
        put.add(family, this.qual1, 2L, Bytes.toBytes((long)2L));
        this.region.put(put);
        Scan idxScan = new Scan();
        idxScan.addFamily(family);
        idxScan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(new SingleColumnValueFilter(family, this.qual1, CompareFilter.CompareOp.GREATER_OR_EQUAL, (WritableByteArrayComparable)new BinaryComparator(Bytes.toBytes((long)0L))), new SingleColumnValueFilter(family, this.qual1, CompareFilter.CompareOp.LESS_OR_EQUAL, (WritableByteArrayComparable)new BinaryComparator(Bytes.toBytes((long)3L))))));
        InternalScanner scanner = this.region.getScanner(idxScan);
        ArrayList res = new ArrayList();
        while (scanner.next(res)) {
        }
        TestHRegion.assertEquals((long)1L, (long)res.size());
    }

    public void testAllColumnsWithBloomFilter() throws IOException {
        byte[] TABLE = Bytes.toBytes((String)"testAllColumnsWithBloomFilter");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY, Integer.MAX_VALUE, HColumnDescriptor.DEFAULT_COMPRESSION, false, true, Integer.MAX_VALUE, Integer.MAX_VALUE, "rowcol", 0);
        HTableDescriptor htd = new HTableDescriptor(TABLE);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd, null, null, false);
        Path path = new Path(this.DIR + "testAllColumnsWithBloomFilter");
        this.region = HRegion.createHRegion((HRegionInfo)info, (Path)path, (Configuration)this.conf);
        byte[] row = Bytes.toBytes((String)"row:0");
        byte[] column = Bytes.toBytes((String)"column:0");
        Put put = new Put(row);
        for (long idx = 1L; idx <= 4L; ++idx) {
            put.add(FAMILY, column, idx, Bytes.toBytes((String)("value-version-" + idx)));
        }
        this.region.put(put);
        this.region.flushcache();
        Get get = new Get(row);
        get.setMaxVersions();
        KeyValue[] kvs = this.region.get(get, null).raw();
        TestHRegion.assertEquals((int)4, (int)kvs.length);
        this.checkOneCell(kvs[0], FAMILY, 0, 0, 4L);
        this.checkOneCell(kvs[1], FAMILY, 0, 0, 3L);
        this.checkOneCell(kvs[2], FAMILY, 0, 0, 2L);
        this.checkOneCell(kvs[3], FAMILY, 0, 0, 1L);
    }

    public void testDeleteRowWithBloomFilter() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testDeleteRowWithBloomFilter");
        byte[] familyName = Bytes.toBytes((String)"familyName");
        HColumnDescriptor hcd = new HColumnDescriptor(familyName, Integer.MAX_VALUE, HColumnDescriptor.DEFAULT_COMPRESSION, false, true, Integer.MAX_VALUE, "rowcol");
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd, null, null, false);
        Path path = new Path(this.DIR + "TestDeleteRowWithBloomFilter");
        this.region = HRegion.createHRegion((HRegionInfo)info, (Path)path, (Configuration)this.conf);
        byte[] row = Bytes.toBytes((String)"row1");
        byte[] col = Bytes.toBytes((String)"col1");
        Put put = new Put(row);
        put.add(familyName, col, 1L, Bytes.toBytes((String)"SomeRandomValue"));
        this.region.put(put);
        this.region.flushcache();
        Delete del = new Delete(row);
        this.region.delete(del, null, true);
        this.region.flushcache();
        Get get = new Get(row);
        get.addColumn(familyName, col);
        KeyValue[] keyValues = this.region.get(get, null).raw();
        TestHRegion.assertTrue((keyValues.length == 0 ? 1 : 0) != 0);
    }

    private void putData(int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = startRow; i < startRow + numRows; ++i) {
            Put put = new Put(Bytes.toBytes((String)("" + i)));
            for (byte[] family : families) {
                put.add(family, qf, null);
            }
            this.region.put(put);
        }
    }

    private void verifyData(HRegion newReg, int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = startRow; i < startRow + numRows; ++i) {
            byte[] row = Bytes.toBytes((String)("" + i));
            Get get = new Get(row);
            for (byte[] family : families) {
                get.addColumn(family, qf);
            }
            Result result = newReg.get(get, null);
            KeyValue[] raw = result.sorted();
            TestHRegion.assertEquals((int)families.length, (int)result.size());
            for (int j = 0; j < families.length; ++j) {
                TestHRegion.assertEquals((int)0, (int)Bytes.compareTo((byte[])row, (byte[])raw[j].getRow()));
                TestHRegion.assertEquals((int)0, (int)Bytes.compareTo((byte[])families[j], (byte[])raw[j].getFamily()));
                TestHRegion.assertEquals((int)0, (int)Bytes.compareTo((byte[])qf, (byte[])raw[j].getQualifier()));
            }
        }
    }

    private void assertGet(HRegion r, byte[] family, byte[] k) throws IOException {
        Get get = new Get(k).addFamily(family).setMaxVersions();
        KeyValue[] results = r.get(get, null).raw();
        for (int j = 0; j < results.length; ++j) {
            byte[] tmp = results[j].getValue();
            TestHRegion.assertTrue((boolean)Bytes.equals((byte[])k, (byte[])tmp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertScan(HRegion r, byte[] fs, byte[] firstValue) throws IOException {
        block7: {
            byte[][] families = new byte[][]{fs};
            Scan scan = new Scan();
            for (int i = 0; i < families.length; ++i) {
                scan.addFamily(families[i]);
            }
            InternalScanner s = r.getScanner(scan);
            try {
                ArrayList curVals = new ArrayList();
                boolean first = true;
                while (s.next(curVals)) {
                    for (KeyValue kv : curVals) {
                        byte[] val;
                        byte[] curval = val = kv.getValue();
                        if (first) {
                            first = false;
                            TestHRegion.assertTrue((Bytes.compareTo((byte[])curval, (byte[])firstValue) == 0 ? 1 : 0) != 0);
                            continue;
                        }
                        break block7;
                    }
                }
            }
            finally {
                s.close();
            }
        }
    }

    private Configuration initSplit() {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.hstore.compactionThreshold", 2);
        conf.setInt("hbase.master.lease.thread.wakefrequency", 5000);
        conf.setInt(HConstants.HBASE_REGIONSERVER_LEASE_PERIOD_KEY, 10000);
        conf.setLong("hbase.client.pause", 15000L);
        conf.setLong("hbase.hregion.max.filesize", 131072L);
        return conf;
    }

    private void initHRegion(byte[] tableName, String callingMethod, byte[] ... families) throws IOException {
        this.initHRegion(tableName, callingMethod, HBaseConfiguration.create(), families);
    }

    private void initHRegion(byte[] tableName, String callingMethod, Configuration conf, byte[] ... families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            htd.addFamily(new HColumnDescriptor(family));
        }
        HRegionInfo info = new HRegionInfo(htd, null, null, false);
        Path path = new Path(this.DIR + callingMethod);
        if (this.fs.exists(path) && !this.fs.delete(path, true)) {
            throw new IOException("Failed delete of " + path);
        }
        this.region = HRegion.createHRegion((HRegionInfo)info, (Path)path, (Configuration)conf);
    }

    private void checkOneCell(KeyValue kv, byte[] cf, int rowIdx, int colIdx, long ts) {
        String ctx = "rowIdx=" + rowIdx + "; colIdx=" + colIdx + "; ts=" + ts;
        TestHRegion.assertEquals((String)("Row mismatch which checking: " + ctx), (String)("row:" + rowIdx), (String)Bytes.toString((byte[])kv.getRow()));
        TestHRegion.assertEquals((String)("ColumnFamily mismatch while checking: " + ctx), (String)Bytes.toString((byte[])cf), (String)Bytes.toString((byte[])kv.getFamily()));
        TestHRegion.assertEquals((String)("Column qualifier mismatch while checking: " + ctx), (String)("column:" + colIdx), (String)Bytes.toString((byte[])kv.getQualifier()));
        TestHRegion.assertEquals((String)("Timestamp mismatch while checking: " + ctx), (long)ts, (long)kv.getTimestamp());
        TestHRegion.assertEquals((String)("Value mismatch while checking: " + ctx), (String)("value-version-" + ts), (String)Bytes.toString((byte[])kv.getValue()));
    }

    protected class PutThread
    extends Thread {
        private volatile boolean done;
        private volatile int numPutsFinished = 0;
        private Throwable error = null;
        private int numRows;
        private byte[][] families;
        private byte[][] qualifiers;

        private PutThread(int numRows, byte[][] families, byte[][] qualifiers) {
            this.numRows = numRows;
            this.families = families;
            this.qualifiers = qualifiers;
        }

        public void waitForFirstPut() throws InterruptedException {
            while (this.numPutsFinished == 0) {
                this.checkNoError();
                Thread.sleep(50L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.done = true;
            PutThread putThread = this;
            synchronized (putThread) {
                this.interrupt();
            }
        }

        public void checkNoError() {
            if (this.error != null) {
                Assert.assertNull((Object)this.error);
            }
        }

        @Override
        public void run() {
            this.done = false;
            while (!this.done) {
                try {
                    for (int r = 0; r < this.numRows; ++r) {
                        byte[] row = Bytes.toBytes((String)("row" + r));
                        Put put = new Put(row);
                        for (byte[] family : this.families) {
                            for (byte[] qualifier : this.qualifiers) {
                                put.add(family, qualifier, (long)this.numPutsFinished, Bytes.toBytes((int)this.numPutsFinished));
                            }
                        }
                        TestHRegion.this.region.put(put);
                        ++this.numPutsFinished;
                        if (this.numPutsFinished > 0 && this.numPutsFinished % 47 == 0) {
                            System.out.println("put iteration = " + this.numPutsFinished);
                            Delete delete = new Delete(row, (long)this.numPutsFinished - 30L, null);
                            TestHRegion.this.region.delete(delete, null, true);
                        }
                        ++this.numPutsFinished;
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"error while putting records", (Throwable)e);
                    this.error = e;
                    break;
                }
            }
        }
    }

    protected class FlushThread
    extends Thread {
        private volatile boolean done;
        private Throwable error = null;

        protected FlushThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.done = true;
            FlushThread flushThread = this;
            synchronized (flushThread) {
                this.interrupt();
            }
        }

        public void checkNoError() {
            if (this.error != null) {
                Assert.assertNull((Object)this.error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.done = false;
            while (!this.done) {
                FlushThread flushThread = this;
                synchronized (flushThread) {
                    block8: {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ignored) {
                            if (!this.done) break block8;
                            break;
                        }
                    }
                }
                try {
                    TestHRegion.this.region.flushcache();
                }
                catch (IOException e) {
                    if (this.done) break;
                    LOG.error((Object)"Error while flusing cache", (Throwable)e);
                    this.error = e;
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            FlushThread flushThread = this;
            synchronized (flushThread) {
                this.notify();
            }
        }
    }

    class GetTillDoneOrException
    extends Thread {
        private final Get g;
        private final AtomicBoolean done;
        private final AtomicInteger count;
        private Exception e;

        GetTillDoneOrException(int i, byte[] r, AtomicBoolean d, AtomicInteger c) {
            super("getter." + i);
            this.g = new Get(r);
            this.done = d;
            this.count = c;
        }

        @Override
        public void run() {
            while (!this.done.get()) {
                try {
                    Assert.assertTrue((TestHRegion.this.region.get(this.g, null).size() > 0 ? 1 : 0) != 0);
                    this.count.incrementAndGet();
                }
                catch (Exception e) {
                    this.e = e;
                    break;
                }
            }
        }
    }
}

