/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.junit.Assert;
import org.junit.Test;

public class TestHRegionInfo {
    @Test
    public void testCreateHRegionInfoName() throws Exception {
        String tableName = "tablename";
        byte[] tn = Bytes.toBytes((String)tableName);
        String startKey = "startkey";
        byte[] sk = Bytes.toBytes((String)startKey);
        String id = "id";
        byte[] name = HRegionInfo.createRegionName((byte[])tn, (byte[])sk, (String)id, (boolean)false);
        String nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id), (Object)nameStr);
        String md5HashInHex = MD5Hash.getMD5AsHex((byte[])name);
        Assert.assertEquals((long)32L, (long)md5HashInHex.length());
        name = HRegionInfo.createRegionName((byte[])tn, (byte[])sk, (String)id, (boolean)true);
        nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id + "." + md5HashInHex + "."), (Object)nameStr);
    }

    @Test
    public void testContainsRange() {
        HTableDescriptor tableDesc = new HTableDescriptor("testtable");
        HRegionInfo hri = new HRegionInfo(tableDesc, Bytes.toBytes((String)"a"), Bytes.toBytes((String)"g"));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"a")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"c")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"c"), Bytes.toBytes((String)"c")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"g")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes((String)"g"), Bytes.toBytes((String)"g")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes((String)"z"), Bytes.toBytes((String)"z")));
        try {
            hri.containsRange(Bytes.toBytes((String)"z"), Bytes.toBytes((String)"a"));
            Assert.fail((String)"Invalid range did not throw IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

