/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.ScanDeleteTracker;
import org.apache.hadoop.hbase.util.Bytes;

public class TestScanDeleteTracker
extends HBaseTestCase {
    private ScanDeleteTracker sdt;
    private long timestamp = 10L;
    private byte deleteType = 0;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.sdt = new ScanDeleteTracker();
    }

    public void testDeletedBy_Delete() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.Delete.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        boolean ret = this.sdt.isDeleted(qualifier, 0, qualifier.length, this.timestamp);
        TestScanDeleteTracker.assertEquals((boolean)true, (boolean)ret);
    }

    public void testDeletedBy_DeleteColumn() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.DeleteColumn.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        this.timestamp -= 5L;
        boolean ret = this.sdt.isDeleted(qualifier, 0, qualifier.length, this.timestamp);
        TestScanDeleteTracker.assertEquals((boolean)true, (boolean)ret);
    }

    public void testDeletedBy_DeleteFamily() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.DeleteFamily.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        this.timestamp -= 5L;
        boolean ret = this.sdt.isDeleted(qualifier, 0, qualifier.length, this.timestamp);
        TestScanDeleteTracker.assertEquals((boolean)true, (boolean)ret);
    }

    public void testDelete_DeleteColumn() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.Delete.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        this.timestamp -= 5L;
        this.deleteType = KeyValue.Type.DeleteColumn.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        this.timestamp -= 5L;
        boolean ret = this.sdt.isDeleted(qualifier, 0, qualifier.length, this.timestamp);
        TestScanDeleteTracker.assertEquals((boolean)true, (boolean)ret);
    }

    public void testDeleteColumn_Delete() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.DeleteColumn.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        qualifier = Bytes.toBytes((String)"qualifier1");
        this.deleteType = KeyValue.Type.Delete.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        boolean ret = this.sdt.isDeleted(qualifier, 0, qualifier.length, this.timestamp);
        TestScanDeleteTracker.assertEquals((boolean)true, (boolean)ret);
    }

    public void testDelete_KeepDelete() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.Delete.getCode();
        this.sdt.add(qualifier, 0, qualifier.length, this.timestamp, this.deleteType);
        this.sdt.isDeleted(qualifier, 0, qualifier.length, this.timestamp);
        TestScanDeleteTracker.assertEquals((boolean)false, (boolean)this.sdt.isEmpty());
    }
}

