/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.Writable;

public class TestScanner
extends HBaseTestCase {
    private final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final byte[] FIRST_ROW = HConstants.EMPTY_START_ROW;
    private static final byte[][] COLS = new byte[][]{HConstants.CATALOG_FAMILY};
    private static final byte[][] EXPLICIT_COLS = new byte[][]{HConstants.REGIONINFO_QUALIFIER, HConstants.SERVER_QUALIFIER};
    static final HTableDescriptor TESTTABLEDESC = new HTableDescriptor("testscanner");
    public static final HRegionInfo REGION_INFO;
    private static final byte[] ROW_KEY;
    private static final long START_CODE = Long.MAX_VALUE;
    private MiniDFSCluster cluster = null;
    private HRegion r;
    private HBaseTestCase.HRegionIncommon region;

    @Override
    public void setUp() throws Exception {
        this.cluster = new MiniDFSCluster(this.conf, 2, true, (String[])null);
        this.conf.set("hbase.rootdir", this.cluster.getFileSystem().getHomeDirectory().toString());
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStopRow() throws Exception {
        byte[] startrow = Bytes.toBytes((String)"bbb");
        byte[] stoprow = Bytes.toBytes((String)"ccc");
        try {
            this.r = this.createNewHRegion(REGION_INFO.getTableDesc(), null, null);
            TestScanner.addContent(this.r, HConstants.CATALOG_FAMILY);
            ArrayList results = new ArrayList();
            Scan scan = new Scan(Bytes.toBytes((String)"abc"), Bytes.toBytes((String)"abd"));
            scan.addFamily(HConstants.CATALOG_FAMILY);
            InternalScanner s = this.r.getScanner(scan);
            int count = 0;
            while (s.next(results)) {
                ++count;
            }
            s.close();
            TestScanner.assertEquals((int)0, (int)count);
            scan = new Scan(startrow, stoprow);
            scan.addFamily(HConstants.CATALOG_FAMILY);
            s = this.r.getScanner(scan);
            count = 0;
            KeyValue kv = null;
            results = new ArrayList();
            boolean first = true;
            while (s.next(results)) {
                kv = (KeyValue)results.get(0);
                if (first) {
                    TestScanner.assertTrue((Bytes.BYTES_COMPARATOR.compare(startrow, kv.getRow()) == 0 ? 1 : 0) != 0);
                    first = false;
                }
                ++count;
            }
            TestScanner.assertTrue((Bytes.BYTES_COMPARATOR.compare(stoprow, kv.getRow()) > 0 ? 1 : 0) != 0);
            TestScanner.assertTrue((count > 10 ? 1 : 0) != 0);
            s.close();
        }
        finally {
            this.r.close();
            this.r.getLog().closeAndDelete();
            TestScanner.shutdownDfs(this.cluster);
        }
    }

    void rowPrefixFilter(Scan scan) throws IOException {
        ArrayList results = new ArrayList();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        InternalScanner s = this.r.getScanner(scan);
        boolean hasMore = true;
        while (hasMore) {
            hasMore = s.next(results);
            for (KeyValue kv : results) {
                TestScanner.assertEquals((byte)97, (byte)kv.getRow()[0]);
                TestScanner.assertEquals((byte)98, (byte)kv.getRow()[1]);
            }
            results.clear();
        }
        s.close();
    }

    void rowInclusiveStopFilter(Scan scan, byte[] stopRow) throws IOException {
        ArrayList results = new ArrayList();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        InternalScanner s = this.r.getScanner(scan);
        boolean hasMore = true;
        while (hasMore) {
            hasMore = s.next(results);
            for (KeyValue kv : results) {
                TestScanner.assertTrue((Bytes.compareTo((byte[])kv.getRow(), (byte[])stopRow) <= 0 ? 1 : 0) != 0);
            }
            results.clear();
        }
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFilters() throws IOException {
        try {
            this.r = this.createNewHRegion(REGION_INFO.getTableDesc(), null, null);
            TestScanner.addContent(this.r, HConstants.CATALOG_FAMILY);
            byte[] prefix = Bytes.toBytes((String)"ab");
            PrefixFilter newFilter = new PrefixFilter(prefix);
            Scan scan = new Scan();
            scan.setFilter((Filter)newFilter);
            this.rowPrefixFilter(scan);
            byte[] stopRow = Bytes.toBytes((String)"bbc");
            newFilter = new WhileMatchFilter((Filter)new InclusiveStopFilter(stopRow));
            scan = new Scan();
            scan.setFilter((Filter)newFilter);
            this.rowInclusiveStopFilter(scan, stopRow);
        }
        finally {
            this.r.close();
            this.r.getLog().closeAndDelete();
            TestScanner.shutdownDfs(this.cluster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRaceBetweenClientAndTimeout() throws Exception {
        try {
            this.r = this.createNewHRegion(REGION_INFO.getTableDesc(), null, null);
            TestScanner.addContent(this.r, HConstants.CATALOG_FAMILY);
            Scan scan = new Scan();
            InternalScanner s = this.r.getScanner(scan);
            ArrayList results = new ArrayList();
            try {
                s.next(results);
                s.close();
                s.next(results);
                TestScanner.fail((String)"We don't want anything more, we should be failing");
            }
            catch (UnknownScannerException ex) {
                this.r.close();
                this.r.getLog().closeAndDelete();
                TestScanner.shutdownDfs(this.cluster);
                return;
            }
        }
        finally {
            this.r.close();
            this.r.getLog().closeAndDelete();
            TestScanner.shutdownDfs(this.cluster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScanner() throws IOException {
        try {
            this.r = this.createNewHRegion(TESTTABLEDESC, null, null);
            this.region = new HBaseTestCase.HRegionIncommon(this.r);
            Put put = new Put(ROW_KEY, System.currentTimeMillis(), null);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream s = new DataOutputStream(byteStream);
            REGION_INFO.write((DataOutput)s);
            put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, byteStream.toByteArray());
            this.region.put(put);
            this.scan(false, null);
            this.getRegionInfo();
            this.r.close();
            this.r = this.openClosedRegion(this.r);
            this.region = new HBaseTestCase.HRegionIncommon(this.r);
            this.scan(false, null);
            this.getRegionInfo();
            HServerAddress address = new HServerAddress("foo.bar.com:1234");
            put = new Put(ROW_KEY, System.currentTimeMillis(), null);
            put.add(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)address.toString()));
            this.region.put(put);
            this.scan(true, address.toString());
            this.getRegionInfo();
            this.region.flushcache();
            this.scan(true, address.toString());
            this.getRegionInfo();
            this.r.close();
            this.r = this.openClosedRegion(this.r);
            this.region = new HBaseTestCase.HRegionIncommon(this.r);
            this.scan(true, address.toString());
            this.getRegionInfo();
            address = new HServerAddress("bar.foo.com:4321");
            put = new Put(ROW_KEY, System.currentTimeMillis(), null);
            put.add(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)address.toString()));
            this.region.put(put);
            this.scan(true, address.toString());
            this.getRegionInfo();
            this.region.flushcache();
            this.scan(true, address.toString());
            this.getRegionInfo();
            this.r.close();
            this.r = this.openClosedRegion(this.r);
            this.region = new HBaseTestCase.HRegionIncommon(this.r);
            this.scan(true, address.toString());
            this.getRegionInfo();
            this.r.close();
            this.r.getLog().closeAndDelete();
        }
        finally {
            TestScanner.shutdownDfs(this.cluster);
        }
    }

    private void validateRegionInfo(byte[] regionBytes) throws IOException {
        HRegionInfo info = (HRegionInfo)Writables.getWritable((byte[])regionBytes, (Writable)new HRegionInfo());
        TestScanner.assertEquals((long)REGION_INFO.getRegionId(), (long)info.getRegionId());
        TestScanner.assertEquals((int)0, (int)info.getStartKey().length);
        TestScanner.assertEquals((int)0, (int)info.getEndKey().length);
        TestScanner.assertEquals((int)0, (int)Bytes.compareTo((byte[])info.getRegionName(), (byte[])REGION_INFO.getRegionName()));
        TestScanner.assertEquals((int)0, (int)info.getTableDesc().compareTo(REGION_INFO.getTableDesc()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(boolean validateStartcode, String serverName) throws IOException {
        InternalScanner scanner = null;
        Scan scan = null;
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        byte[][][] scanColumns = new byte[][][]{COLS, EXPLICIT_COLS};
        for (int i = 0; i < scanColumns.length; ++i) {
            try {
                scan = new Scan(FIRST_ROW);
                for (int ii = 0; ii < EXPLICIT_COLS.length; ++ii) {
                    scan.addColumn(COLS[0], EXPLICIT_COLS[ii]);
                }
                scanner = this.r.getScanner(scan);
                while (scanner.next(results)) {
                    TestScanner.assertTrue((boolean)this.hasColumn(results, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                    byte[] val = this.getColumn(results, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER).getValue();
                    this.validateRegionInfo(val);
                    if (validateStartcode) {
                        TestScanner.assertNotNull((Object)val);
                        TestScanner.assertFalse((val.length == 0 ? 1 : 0) != 0);
                        long startCode = Bytes.toLong((byte[])val);
                        TestScanner.assertEquals((long)Long.MAX_VALUE, (long)startCode);
                    }
                    if (serverName == null) continue;
                    TestScanner.assertTrue((boolean)this.hasColumn(results, HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER));
                    val = this.getColumn(results, HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER).getValue();
                    TestScanner.assertNotNull((Object)val);
                    TestScanner.assertFalse((val.length == 0 ? 1 : 0) != 0);
                    String server = Bytes.toString((byte[])val);
                    TestScanner.assertEquals((int)0, (int)server.compareTo(serverName));
                }
                continue;
            }
            finally {
                InternalScanner s = scanner;
                scanner = null;
                if (s != null) {
                    s.close();
                }
            }
        }
    }

    private boolean hasColumn(List<KeyValue> kvs, byte[] family, byte[] qualifier) {
        for (KeyValue kv : kvs) {
            if (!kv.matchingFamily(family) || !kv.matchingQualifier(qualifier)) continue;
            return true;
        }
        return false;
    }

    private KeyValue getColumn(List<KeyValue> kvs, byte[] family, byte[] qualifier) {
        for (KeyValue kv : kvs) {
            if (!kv.matchingFamily(family) || !kv.matchingQualifier(qualifier)) continue;
            return kv;
        }
        return null;
    }

    private void getRegionInfo() throws IOException {
        Get get = new Get(ROW_KEY);
        get.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        Result result = this.region.get(get, null);
        byte[] bytes = result.value();
        this.validateRegionInfo(bytes);
    }

    public void testScanAndSyncFlush() throws Exception {
        this.r = this.createNewHRegion(REGION_INFO.getTableDesc(), null, null);
        HBaseTestCase.HRegionIncommon hri = new HBaseTestCase.HRegionIncommon(this.r);
        try {
            this.LOG.info((Object)("Added: " + TestScanner.addContent(hri, Bytes.toString((byte[])HConstants.CATALOG_FAMILY), Bytes.toString((byte[])HConstants.REGIONINFO_QUALIFIER))));
            int count = this.count(hri, -1, false);
            TestScanner.assertEquals((int)count, (int)this.count(hri, 100, false));
        }
        catch (Exception e) {
            this.LOG.error((Object)"Failed", (Throwable)e);
            throw e;
        }
        finally {
            this.r.close();
            this.r.getLog().closeAndDelete();
            TestScanner.shutdownDfs(this.cluster);
        }
    }

    public void testScanAndRealConcurrentFlush() throws Exception {
        this.r = this.createNewHRegion(REGION_INFO.getTableDesc(), null, null);
        HBaseTestCase.HRegionIncommon hri = new HBaseTestCase.HRegionIncommon(this.r);
        try {
            this.LOG.info((Object)("Added: " + TestScanner.addContent(hri, Bytes.toString((byte[])HConstants.CATALOG_FAMILY), Bytes.toString((byte[])HConstants.REGIONINFO_QUALIFIER))));
            int count = this.count(hri, -1, false);
            TestScanner.assertEquals((int)count, (int)this.count(hri, 100, true));
        }
        catch (Exception e) {
            this.LOG.error((Object)"Failed", (Throwable)e);
            throw e;
        }
        finally {
            this.r.close();
            this.r.getLog().closeAndDelete();
            TestScanner.shutdownDfs(this.cluster);
        }
    }

    private int count(final HBaseTestCase.HRegionIncommon hri, int flushIndex, boolean concurrent) throws IOException {
        this.LOG.info((Object)"Taking out counting scan");
        HBaseTestCase.ScannerIncommon s = hri.getScanner(HConstants.CATALOG_FAMILY, EXPLICIT_COLS, HConstants.EMPTY_START_ROW, Long.MAX_VALUE);
        ArrayList<KeyValue> values = new ArrayList<KeyValue>();
        int count = 0;
        boolean justFlushed = false;
        while (s.next(values)) {
            if (justFlushed) {
                this.LOG.info((Object)"after next() just after next flush");
                justFlushed = false;
            }
            if (flushIndex != ++count) continue;
            this.LOG.info((Object)("Starting flush at flush index " + flushIndex));
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        hri.flushcache();
                        TestScanner.this.LOG.info((Object)"Finishing flush");
                    }
                    catch (IOException e) {
                        TestScanner.this.LOG.info((Object)"Failed flush cache");
                    }
                }
            };
            if (concurrent) {
                t.start();
            } else {
                t.run();
            }
            this.LOG.info((Object)"Continuing on after kicking off background flush");
            justFlushed = true;
        }
        s.close();
        this.LOG.info((Object)("Found " + count + " items"));
        return count;
    }

    static {
        TESTTABLEDESC.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY, 10, Compression.Algorithm.NONE.getName(), false, true, 8192, Integer.MAX_VALUE, StoreFile.BloomType.NONE.toString(), 0));
        REGION_INFO = new HRegionInfo(TESTTABLEDESC, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY);
        ROW_KEY = REGION_INFO.getRegionName();
    }
}

