/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSplitTransaction {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final Path testdir = HBaseTestingUtility.getTestDir(this.getClass().getName());
    private HRegion parent;
    private HLog wal;
    private FileSystem fs;
    private static final byte[] STARTROW = new byte[]{97, 97, 97};
    private static final byte[] ENDROW = new byte[]{123, 123, 123};
    private static final byte[] GOOD_SPLIT_ROW = new byte[]{100, 100, 100};
    private static final byte[] CF = HConstants.CATALOG_FAMILY;

    @Before
    public void setup() throws IOException {
        this.fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        this.fs.delete(this.testdir, true);
        this.wal = new HLog(this.fs, new Path(this.testdir, "logs"), new Path(this.testdir, "archive"), TEST_UTIL.getConfiguration());
        this.parent = TestSplitTransaction.createRegion(this.testdir, this.wal);
        TEST_UTIL.getConfiguration().setBoolean("hbase.testing.nocluster", true);
    }

    @After
    public void teardown() throws IOException {
        if (this.parent != null && !this.parent.isClosed()) {
            this.parent.close();
        }
        if (this.fs.exists(this.parent.getRegionDir()) && !this.fs.delete(this.parent.getRegionDir(), true)) {
            throw new IOException("Failed delete of " + this.parent.getRegionDir());
        }
        if (this.wal != null) {
            this.wal.closeAndDelete();
        }
        this.fs.delete(this.testdir, true);
    }

    @Test
    public void testPrepare() throws IOException {
        this.prepareGOOD_SPLIT_ROW();
    }

    private SplitTransaction prepareGOOD_SPLIT_ROW() {
        SplitTransaction st = new SplitTransaction(this.parent, GOOD_SPLIT_ROW);
        Assert.assertTrue((boolean)st.prepare());
        return st;
    }

    @Test
    public void testPrepareWithBadSplitRow() throws IOException {
        SplitTransaction st = new SplitTransaction(this.parent, STARTROW);
        Assert.assertFalse((boolean)st.prepare());
        st = new SplitTransaction(this.parent, HConstants.EMPTY_BYTE_ARRAY);
        Assert.assertFalse((boolean)st.prepare());
        st = new SplitTransaction(this.parent, new byte[]{65, 65, 65});
        Assert.assertFalse((boolean)st.prepare());
        st = new SplitTransaction(this.parent, ENDROW);
        Assert.assertFalse((boolean)st.prepare());
    }

    @Test
    public void testPrepareWithClosedRegion() throws IOException {
        this.parent.close();
        SplitTransaction st = new SplitTransaction(this.parent, GOOD_SPLIT_ROW);
        Assert.assertFalse((boolean)st.prepare());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWholesomeSplit() throws IOException {
        int rowcount = TEST_UTIL.loadRegion(this.parent, CF);
        Assert.assertTrue((rowcount > 0 ? 1 : 0) != 0);
        int parentRowCount = this.countRows(this.parent);
        Assert.assertEquals((long)rowcount, (long)parentRowCount);
        SplitTransaction st = this.prepareGOOD_SPLIT_ROW();
        Server mockServer = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)TEST_UTIL.getConfiguration());
        PairOfSameType daughters = st.execute(mockServer, null);
        Assert.assertTrue((boolean)this.fs.exists(st.getSplitDir()));
        Assert.assertTrue((boolean)this.parent.isClosed());
        Assert.assertEquals((long)0L, (long)this.fs.listStatus(st.getSplitDir()).length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])this.parent.getStartKey(), (byte[])((HRegion)daughters.getFirst()).getStartKey()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])GOOD_SPLIT_ROW, (byte[])((HRegion)daughters.getFirst()).getEndKey()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])((HRegion)daughters.getSecond()).getStartKey(), (byte[])GOOD_SPLIT_ROW));
        Assert.assertTrue((boolean)Bytes.equals((byte[])this.parent.getEndKey(), (byte[])((HRegion)daughters.getSecond()).getEndKey()));
        int daughtersRowCount = 0;
        for (HRegion r : daughters) {
            HRegion openRegion = HRegion.openHRegion((HRegionInfo)r.getRegionInfo(), (HLog)r.getLog(), (Configuration)r.getConf());
            try {
                int count = this.countRows(openRegion);
                Assert.assertTrue((count > 0 && count != rowcount ? 1 : 0) != 0);
                daughtersRowCount += count;
            }
            finally {
                openRegion.close();
            }
        }
        Assert.assertEquals((long)rowcount, (long)daughtersRowCount);
        Assert.assertTrue((!this.parent.lock.writeLock().isHeldByCurrentThread() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollback() throws IOException {
        int rowcount = TEST_UTIL.loadRegion(this.parent, CF);
        Assert.assertTrue((rowcount > 0 ? 1 : 0) != 0);
        int parentRowCount = this.countRows(this.parent);
        Assert.assertEquals((long)rowcount, (long)parentRowCount);
        SplitTransaction st = this.prepareGOOD_SPLIT_ROW();
        SplitTransaction spiedUponSt = (SplitTransaction)Mockito.spy((Object)st);
        Mockito.when((Object)spiedUponSt.createDaughterRegion(spiedUponSt.getSecondDaughter(), null)).thenThrow(new Throwable[]{new MockedFailedDaughterCreation()});
        boolean expectedException = false;
        Server mockServer = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)TEST_UTIL.getConfiguration());
        try {
            spiedUponSt.execute(mockServer, null);
        }
        catch (MockedFailedDaughterCreation e) {
            expectedException = true;
        }
        Assert.assertTrue((boolean)expectedException);
        spiedUponSt.rollback(null);
        int parentRowCount2 = this.countRows(this.parent);
        Assert.assertEquals((long)parentRowCount, (long)parentRowCount2);
        Assert.assertTrue((!this.fs.exists(HRegion.getRegionDir((Path)this.testdir, (HRegionInfo)st.getFirstDaughter())) ? 1 : 0) != 0);
        Assert.assertTrue((!this.fs.exists(HRegion.getRegionDir((Path)this.testdir, (HRegionInfo)st.getSecondDaughter())) ? 1 : 0) != 0);
        Assert.assertTrue((!this.parent.lock.writeLock().isHeldByCurrentThread() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)st.prepare());
        PairOfSameType daughters = st.execute(mockServer, null);
        int daughtersRowCount = 0;
        for (HRegion r : daughters) {
            HRegion openRegion = HRegion.openHRegion((HRegionInfo)r.getRegionInfo(), (HLog)r.getLog(), (Configuration)r.getConf());
            try {
                int count = this.countRows(openRegion);
                Assert.assertTrue((count > 0 && count != rowcount ? 1 : 0) != 0);
                daughtersRowCount += count;
            }
            finally {
                openRegion.close();
            }
        }
        Assert.assertEquals((long)rowcount, (long)daughtersRowCount);
        Assert.assertTrue((!this.parent.lock.writeLock().isHeldByCurrentThread() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countRows(HRegion r) throws IOException {
        int rowcount = 0;
        InternalScanner scanner = r.getScanner(new Scan());
        try {
            ArrayList kvs = new ArrayList();
            boolean hasNext = true;
            while (hasNext) {
                hasNext = scanner.next(kvs);
                if (kvs.isEmpty()) continue;
                ++rowcount;
            }
        }
        finally {
            scanner.close();
        }
        return rowcount;
    }

    static HRegion createRegion(Path testdir, HLog wal) throws IOException {
        HTableDescriptor htd = new HTableDescriptor("table");
        HColumnDescriptor hcd = new HColumnDescriptor(CF);
        htd.addFamily(hcd);
        HRegionInfo hri = new HRegionInfo(htd, STARTROW, ENDROW);
        return HRegion.openHRegion((HRegionInfo)hri, (HLog)wal, (Configuration)TEST_UTIL.getConfiguration());
    }

    private class MockedFailedDaughterCreation
    extends IOException {
        private MockedFailedDaughterCreation() {
        }
    }
}

