/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.mockito.Mockito;

public class TestStoreFile
extends HBaseTestCase {
    static final Log LOG = LogFactory.getLog(TestStoreFile.class);
    private MiniDFSCluster cluster;
    private static String ROOT_DIR = HBaseTestingUtility.getTestDir("TestStoreFile").toString();
    private static String localFormatter = "%010d";

    @Override
    public void setUp() throws Exception {
        try {
            this.cluster = new MiniDFSCluster(this.conf, 2, true, (String[])null);
            this.conf.set("hbase.rootdir", this.cluster.getFileSystem().getHomeDirectory().toString());
        }
        catch (IOException e) {
            TestStoreFile.shutdownDfs(this.cluster);
        }
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        TestStoreFile.shutdownDfs(this.cluster);
    }

    public void testBasicHalfMapFile() throws Exception {
        StoreFile.Writer writer = StoreFile.createWriter((FileSystem)this.fs, (Path)new Path(new Path(this.testDir, "regionname"), "familyname"), (int)2048);
        this.writeStoreFile(writer);
        this.checkHalfHFile(new StoreFile(this.fs, writer.getPath(), true, this.conf, StoreFile.BloomType.NONE, false));
    }

    private void writeStoreFile(StoreFile.Writer writer) throws IOException {
        TestStoreFile.writeStoreFile(writer, Bytes.toBytes((String)this.getName()), Bytes.toBytes((String)this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStoreFile(StoreFile.Writer writer, byte[] fam, byte[] qualifier) throws IOException {
        long now = System.currentTimeMillis();
        try {
            for (int d = 97; d <= 122; d = (int)((char)(d + 1))) {
                for (int e = 97; e <= 122; e = (int)((char)(e + 1))) {
                    byte[] b = new byte[]{(byte)d, (byte)e};
                    writer.append(new KeyValue(b, fam, qualifier, now, b));
                }
            }
        }
        finally {
            writer.close();
        }
    }

    public void testReference() throws IOException {
        Path storedir = new Path(new Path(this.testDir, "regionname"), "familyname");
        Path dir = new Path(storedir, "1234567890");
        StoreFile.Writer writer = StoreFile.createWriter((FileSystem)this.fs, (Path)dir, (int)8192);
        this.writeStoreFile(writer);
        StoreFile hsf = new StoreFile(this.fs, writer.getPath(), true, this.conf, StoreFile.BloomType.NONE, false);
        StoreFile.Reader reader = hsf.createReader();
        KeyValue kv = KeyValue.createKeyValueFromKey((byte[])reader.midkey());
        byte[] midRow = kv.getRow();
        kv = KeyValue.createKeyValueFromKey((byte[])reader.getLastKey());
        byte[] finalRow = kv.getRow();
        Path refPath = StoreFile.split((FileSystem)this.fs, (Path)dir, (StoreFile)hsf, (byte[])midRow, (Reference.Range)Reference.Range.top);
        StoreFile refHsf = new StoreFile(this.fs, refPath, true, this.conf, StoreFile.BloomType.NONE, false);
        HFileScanner s = refHsf.createReader().getScanner(false, false);
        boolean first = true;
        while (!s.isSeeked() && s.seekTo() || s.next()) {
            ByteBuffer bb = s.getKey();
            kv = KeyValue.createKeyValueFromKey((ByteBuffer)bb);
            if (!first) continue;
            TestStoreFile.assertTrue((boolean)Bytes.equals((byte[])kv.getRow(), (byte[])midRow));
            first = false;
        }
        TestStoreFile.assertTrue((boolean)Bytes.equals((byte[])kv.getRow(), (byte[])finalRow));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHalfHFile(StoreFile f) throws IOException {
        byte[] midkey = f.createReader().midkey();
        KeyValue midKV = KeyValue.createKeyValueFromKey((byte[])midkey);
        byte[] midRow = midKV.getRow();
        Path topDir = Store.getStoreHomedir((Path)this.testDir, (String)"1", (byte[])Bytes.toBytes((String)f.getPath().getParent().getName()));
        if (this.fs.exists(topDir)) {
            this.fs.delete(topDir, true);
        }
        Path topPath = StoreFile.split((FileSystem)this.fs, (Path)topDir, (StoreFile)f, (byte[])midRow, (Reference.Range)Reference.Range.top);
        Path bottomDir = Store.getStoreHomedir((Path)this.testDir, (String)"2", (byte[])Bytes.toBytes((String)f.getPath().getParent().getName()));
        if (this.fs.exists(bottomDir)) {
            this.fs.delete(bottomDir, true);
        }
        Path bottomPath = StoreFile.split((FileSystem)this.fs, (Path)bottomDir, (StoreFile)f, (byte[])midRow, (Reference.Range)Reference.Range.bottom);
        StoreFile.Reader top = new StoreFile(this.fs, topPath, true, this.conf, StoreFile.BloomType.NONE, false).createReader();
        StoreFile.Reader bottom = new StoreFile(this.fs, bottomPath, true, this.conf, StoreFile.BloomType.NONE, false).createReader();
        ByteBuffer previous = null;
        LOG.info((Object)("Midkey: " + midKV.toString()));
        ByteBuffer bbMidkeyBytes = ByteBuffer.wrap(midkey);
        try {
            int i;
            String tmp;
            KeyValue keyKV;
            boolean first = true;
            ByteBuffer key = null;
            HFileScanner topScanner = top.getScanner(false, false);
            while (!topScanner.isSeeked() && topScanner.seekTo() || topScanner.isSeeked() && topScanner.next()) {
                key = topScanner.getKey();
                TestStoreFile.assertTrue((topScanner.getReader().getComparator().compare(key.array(), key.arrayOffset(), key.limit(), midkey, 0, midkey.length) >= 0 ? 1 : 0) != 0);
                if (!first) continue;
                first = false;
                LOG.info((Object)("First in top: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)key))));
            }
            LOG.info((Object)("Last in top: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)key))));
            first = true;
            HFileScanner bottomScanner = bottom.getScanner(false, false);
            while (!bottomScanner.isSeeked() && bottomScanner.seekTo() || bottomScanner.next()) {
                previous = bottomScanner.getKey();
                key = bottomScanner.getKey();
                if (first) {
                    first = false;
                    LOG.info((Object)("First in bottom: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)previous))));
                }
                TestStoreFile.assertTrue((key.compareTo(bbMidkeyBytes) < 0 ? 1 : 0) != 0);
            }
            if (previous != null) {
                LOG.info((Object)("Last in bottom: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)previous))));
            }
            this.fs.delete(topPath, false);
            this.fs.delete(bottomPath, false);
            byte[] badmidkey = Bytes.toBytes((String)"  .");
            topPath = StoreFile.split((FileSystem)this.fs, (Path)topDir, (StoreFile)f, (byte[])badmidkey, (Reference.Range)Reference.Range.top);
            bottomPath = StoreFile.split((FileSystem)this.fs, (Path)bottomDir, (StoreFile)f, (byte[])badmidkey, (Reference.Range)Reference.Range.bottom);
            top = new StoreFile(this.fs, topPath, true, this.conf, StoreFile.BloomType.NONE, false).createReader();
            bottom = new StoreFile(this.fs, bottomPath, true, this.conf, StoreFile.BloomType.NONE, false).createReader();
            bottomScanner = bottom.getScanner(false, false);
            int count = 0;
            while (!bottomScanner.isSeeked() && bottomScanner.seekTo() || bottomScanner.next()) {
                ++count;
            }
            TestStoreFile.assertTrue((count == 0 ? 1 : 0) != 0);
            first = true;
            topScanner = top.getScanner(false, false);
            while (!topScanner.isSeeked() && topScanner.seekTo() || topScanner.next()) {
                key = topScanner.getKey();
                TestStoreFile.assertTrue((topScanner.getReader().getComparator().compare(key.array(), key.arrayOffset(), key.limit(), badmidkey, 0, badmidkey.length) >= 0 ? 1 : 0) != 0);
                if (!first) continue;
                first = false;
                keyKV = KeyValue.createKeyValueFromKey((ByteBuffer)key);
                LOG.info((Object)("First top when key < bottom: " + keyKV));
                tmp = Bytes.toString((byte[])keyKV.getRow());
                for (i = 0; i < tmp.length(); ++i) {
                    TestStoreFile.assertTrue((tmp.charAt(i) == 'a' ? 1 : 0) != 0);
                }
            }
            keyKV = KeyValue.createKeyValueFromKey((ByteBuffer)key);
            LOG.info((Object)("Last top when key < bottom: " + keyKV));
            tmp = Bytes.toString((byte[])keyKV.getRow());
            for (i = 0; i < tmp.length(); ++i) {
                TestStoreFile.assertTrue((tmp.charAt(i) == 'z' ? 1 : 0) != 0);
            }
            this.fs.delete(topPath, false);
            this.fs.delete(bottomPath, false);
            badmidkey = Bytes.toBytes((String)"|||");
            topPath = StoreFile.split((FileSystem)this.fs, (Path)topDir, (StoreFile)f, (byte[])badmidkey, (Reference.Range)Reference.Range.top);
            bottomPath = StoreFile.split((FileSystem)this.fs, (Path)bottomDir, (StoreFile)f, (byte[])badmidkey, (Reference.Range)Reference.Range.bottom);
            top = new StoreFile(this.fs, topPath, true, this.conf, StoreFile.BloomType.NONE, false).createReader();
            bottom = new StoreFile(this.fs, bottomPath, true, this.conf, StoreFile.BloomType.NONE, false).createReader();
            first = true;
            bottomScanner = bottom.getScanner(false, false);
            while (!bottomScanner.isSeeked() && bottomScanner.seekTo() || bottomScanner.next()) {
                key = bottomScanner.getKey();
                if (!first) continue;
                first = false;
                keyKV = KeyValue.createKeyValueFromKey((ByteBuffer)key);
                LOG.info((Object)("First bottom when key > top: " + keyKV));
                tmp = Bytes.toString((byte[])keyKV.getRow());
                for (i = 0; i < tmp.length(); ++i) {
                    TestStoreFile.assertTrue((tmp.charAt(i) == 'a' ? 1 : 0) != 0);
                }
            }
            keyKV = KeyValue.createKeyValueFromKey((ByteBuffer)key);
            LOG.info((Object)("Last bottom when key > top: " + keyKV));
            for (i = 0; i < tmp.length(); ++i) {
                TestStoreFile.assertTrue((Bytes.toString((byte[])keyKV.getRow()).charAt(i) == 'z' ? 1 : 0) != 0);
            }
            count = 0;
            topScanner = top.getScanner(false, false);
            while (!topScanner.isSeeked() && topScanner.seekTo() || topScanner.isSeeked() && topScanner.next()) {
                ++count;
            }
            TestStoreFile.assertTrue((count == 0 ? 1 : 0) != 0);
        }
        finally {
            if (top != null) {
                top.close();
            }
            if (bottom != null) {
                bottom.close();
            }
            this.fs.delete(f.getPath(), true);
        }
    }

    private void bloomWriteRead(StoreFile.Writer writer, FileSystem fs) throws Exception {
        float err = this.conf.getFloat("io.storefile.bloom.error.rate", 0.0f);
        Path f = writer.getPath();
        long now = System.currentTimeMillis();
        for (int i = 0; i < 2000; i += 2) {
            String row = String.format(localFormatter, i);
            KeyValue kv = new KeyValue(row.getBytes(), "family".getBytes(), "col".getBytes(), now, "value".getBytes());
            writer.append(kv);
        }
        writer.close();
        StoreFile.Reader reader = new StoreFile.Reader(fs, f, null, false);
        reader.loadFileInfo();
        reader.loadBloomfilter();
        StoreFileScanner scanner = reader.getStoreFileScanner(false, false);
        int falsePos = 0;
        int falseNeg = 0;
        for (int i = 0; i < 2000; ++i) {
            String row = String.format(localFormatter, i);
            TreeSet<byte[]> columns = new TreeSet<byte[]>();
            columns.add("family:col".getBytes());
            Scan scan = new Scan(row.getBytes(), row.getBytes());
            scan.addColumn("family".getBytes(), "family:col".getBytes());
            boolean exists = scanner.shouldSeek(scan, columns);
            if (i % 2 == 0) {
                if (exists) continue;
                ++falseNeg;
                continue;
            }
            if (!exists) continue;
            ++falsePos;
        }
        reader.close();
        fs.delete(f, true);
        System.out.println("False negatives: " + falseNeg);
        TestStoreFile.assertEquals((int)0, (int)falseNeg);
        System.out.println("False positives: " + falsePos);
        if (!((float)falsePos <= 4000.0f * err)) {
            System.out.println("WTFBBQ! " + falsePos + ", " + 4000.0f * err);
        }
        TestStoreFile.assertTrue(((float)falsePos <= 4000.0f * err ? 1 : 0) != 0);
    }

    public void testBloomFilter() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        this.conf.setFloat("io.storefile.bloom.error.rate", 0.01f);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        Path f = new Path(ROOT_DIR, this.getName());
        StoreFile.Writer writer = new StoreFile.Writer((FileSystem)fs, f, 8192, HFile.DEFAULT_COMPRESSION_ALGORITHM, this.conf, KeyValue.COMPARATOR, StoreFile.BloomType.ROW, 2000);
        this.bloomWriteRead(writer, (FileSystem)fs);
    }

    public void testBloomTypes() throws Exception {
        float err = 0.01f;
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        this.conf.setFloat("io.storefile.bloom.error.rate", err);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        int rowCount = 50;
        int colCount = 10;
        int versions = 2;
        StoreFile.BloomType[] bt = new StoreFile.BloomType[]{StoreFile.BloomType.ROWCOL, StoreFile.BloomType.ROW};
        int[] expKeys = new int[]{rowCount * colCount, rowCount};
        float[] expErr = new float[]{(float)(2 * rowCount * colCount) * err, (float)(2 * rowCount * 2 * colCount) * err};
        for (int x : new int[]{0, 1}) {
            Path f = new Path(ROOT_DIR, this.getName());
            StoreFile.Writer writer = new StoreFile.Writer((FileSystem)fs, f, 8192, HFile.DEFAULT_COMPRESSION_ALGORITHM, this.conf, KeyValue.COMPARATOR, bt[x], expKeys[x]);
            long now = System.currentTimeMillis();
            for (int i = 0; i < rowCount * 2; i += 2) {
                for (int j = 0; j < colCount * 2; j += 2) {
                    String row = String.format(localFormatter, i);
                    String col = String.format(localFormatter, j);
                    for (int k = 0; k < versions; ++k) {
                        KeyValue kv = new KeyValue(row.getBytes(), "family".getBytes(), ("col" + col).getBytes(), now - (long)k, Bytes.toBytes((long)-1L));
                        writer.append(kv);
                    }
                }
            }
            writer.close();
            StoreFile.Reader reader = new StoreFile.Reader((FileSystem)fs, f, null, false);
            reader.loadFileInfo();
            reader.loadBloomfilter();
            StoreFileScanner scanner = reader.getStoreFileScanner(false, false);
            TestStoreFile.assertEquals((int)expKeys[x], (int)reader.bloomFilter.getKeyCount());
            int falsePos = 0;
            int falseNeg = 0;
            for (int i = 0; i < rowCount * 2; ++i) {
                for (int j = 0; j < colCount * 2; ++j) {
                    String row = String.format(localFormatter, i);
                    String col = String.format(localFormatter, j);
                    TreeSet<byte[]> columns = new TreeSet<byte[]>();
                    columns.add(("col" + col).getBytes());
                    Scan scan = new Scan(row.getBytes(), row.getBytes());
                    scan.addColumn("family".getBytes(), ("col" + col).getBytes());
                    boolean exists = scanner.shouldSeek(scan, columns);
                    boolean shouldRowExist = i % 2 == 0;
                    boolean shouldColExist = j % 2 == 0;
                    boolean bl = shouldColExist = shouldColExist || bt[x] == StoreFile.BloomType.ROW;
                    if (shouldRowExist && shouldColExist) {
                        if (exists) continue;
                        ++falseNeg;
                        continue;
                    }
                    if (!exists) continue;
                    ++falsePos;
                }
            }
            reader.close();
            fs.delete(f, true);
            System.out.println(bt[x].toString());
            System.out.println("  False negatives: " + falseNeg);
            System.out.println("  False positives: " + falsePos);
            TestStoreFile.assertEquals((int)0, (int)falseNeg);
            TestStoreFile.assertTrue(((float)falsePos < 2.0f * expErr[x] ? 1 : 0) != 0);
        }
    }

    public void testBloomEdgeCases() throws Exception {
        float err = 0.005f;
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        Path f = new Path(ROOT_DIR, this.getName());
        this.conf.setFloat("io.storefile.bloom.error.rate", err);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        this.conf.setInt("io.storefile.bloom.max.keys", 1000);
        StoreFile.Writer writer = new StoreFile.Writer((FileSystem)fs, f, 8192, HFile.DEFAULT_COMPRESSION_ALGORITHM, this.conf, KeyValue.COMPARATOR, StoreFile.BloomType.ROW, 2000);
        TestStoreFile.assertFalse((boolean)writer.hasBloom());
        writer.close();
        fs.delete(f, true);
        this.conf.setInt("io.storefile.bloom.max.keys", Integer.MAX_VALUE);
        writer = new StoreFile.Writer((FileSystem)fs, f, 8192, HFile.DEFAULT_COMPRESSION_ALGORITHM, this.conf, KeyValue.COMPARATOR, StoreFile.BloomType.ROW, Integer.MAX_VALUE);
        TestStoreFile.assertFalse((boolean)writer.hasBloom());
        writer.close();
        fs.delete(f, true);
    }

    public void testFlushTimeComparator() {
        this.assertOrdering(StoreFile.Comparators.FLUSH_TIME, this.mockStoreFile(true, 1000L, -1L, "/foo/123"), this.mockStoreFile(true, 1000L, -1L, "/foo/126"), this.mockStoreFile(true, 2000L, -1L, "/foo/126"), this.mockStoreFile(false, -1L, 1L, "/foo/1"), this.mockStoreFile(false, -1L, 3L, "/foo/2"), this.mockStoreFile(false, -1L, 5L, "/foo/2"), this.mockStoreFile(false, -1L, 5L, "/foo/3"));
    }

    private void assertOrdering(Comparator<StoreFile> comparator, StoreFile ... sfs) {
        ArrayList sorted = Lists.newArrayList((Object[])sfs);
        Collections.shuffle(sorted);
        Collections.sort(sorted, comparator);
        LOG.debug((Object)("sfs: " + Joiner.on((String)",").join((Object[])sfs)));
        LOG.debug((Object)("sorted: " + Joiner.on((String)",").join((Iterable)sorted)));
        TestStoreFile.assertTrue((boolean)Iterables.elementsEqual(Arrays.asList(sfs), (Iterable)sorted));
    }

    private StoreFile mockStoreFile(boolean bulkLoad, long bulkTimestamp, long seqId, String path) {
        StoreFile mock = (StoreFile)Mockito.mock(StoreFile.class);
        ((StoreFile)Mockito.doReturn((Object)bulkLoad).when((Object)mock)).isBulkLoadResult();
        ((StoreFile)Mockito.doReturn((Object)bulkTimestamp).when((Object)mock)).getBulkLoadTimestamp();
        if (bulkLoad) {
            ((StoreFile)Mockito.doThrow((Throwable)new IllegalAccessError("bulk load")).when((Object)mock)).getMaxSequenceId();
        } else {
            ((StoreFile)Mockito.doReturn((Object)seqId).when((Object)mock)).getMaxSequenceId();
        }
        ((StoreFile)Mockito.doReturn((Object)new Path(path)).when((Object)mock)).getPath();
        String name = "mock storefile, bulkLoad=" + bulkLoad + " bulkTimestamp=" + bulkTimestamp + " seqId=" + seqId + " path=" + path;
        ((StoreFile)Mockito.doReturn((Object)name).when((Object)mock)).toString();
        return mock;
    }

    List<KeyValue> getKeyValueSet(long[] timestamps, int numRows, byte[] qualifier, byte[] family) {
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        for (int i = 1; i <= numRows; ++i) {
            byte[] b = Bytes.toBytes((int)i);
            LOG.info((Object)Bytes.toString((byte[])b));
            LOG.info((Object)Bytes.toString((byte[])b));
            for (long timestamp : timestamps) {
                kvList.add(new KeyValue(b, family, qualifier, timestamp, b));
            }
        }
        return kvList;
    }

    public void testMultipleTimestamps() throws IOException {
        byte[] family = Bytes.toBytes((String)"familyname");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        int numRows = 10;
        long[] timestamps = new long[]{20L, 10L, 5L, 1L};
        Scan scan = new Scan();
        Path storedir = new Path(new Path(this.testDir, "regionname"), "familyname");
        Path dir = new Path(storedir, "1234567890");
        StoreFile.Writer writer = StoreFile.createWriter((FileSystem)this.fs, (Path)dir, (int)8192);
        List<KeyValue> kvList = this.getKeyValueSet(timestamps, numRows, family, qualifier);
        for (KeyValue kv : kvList) {
            writer.append(kv);
        }
        writer.appendMetadata(0L, false);
        writer.close();
        StoreFile hsf = new StoreFile(this.fs, writer.getPath(), true, this.conf, StoreFile.BloomType.NONE, false);
        StoreFile.Reader reader = hsf.createReader();
        StoreFileScanner scanner = reader.getStoreFileScanner(false, false);
        TreeSet<byte[]> columns = new TreeSet<byte[]>();
        columns.add(qualifier);
        scan.setTimeRange(20L, 100L);
        TestStoreFile.assertTrue((boolean)scanner.shouldSeek(scan, columns));
        scan.setTimeRange(1L, 2L);
        TestStoreFile.assertTrue((boolean)scanner.shouldSeek(scan, columns));
        scan.setTimeRange(8L, 10L);
        TestStoreFile.assertTrue((boolean)scanner.shouldSeek(scan, columns));
        scan.setTimeRange(7L, 50L);
        TestStoreFile.assertTrue((boolean)scanner.shouldSeek(scan, columns));
    }
}

