/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.regionserver.wal.WALObserver;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHLog {
    private static final Log LOG = LogFactory.getLog(TestHLog.class);
    private static Configuration conf;
    private static FileSystem fs;
    private static Path dir;
    private static MiniDFSCluster cluster;
    private static final HBaseTestingUtility TEST_UTIL;
    private static Path hbaseDir;
    private static Path oldLogDir;

    public TestHLog() {
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)HLog.LOG).getLogger().setLevel(Level.ALL);
    }

    @Before
    public void setUp() throws Exception {
        FileStatus[] entries;
        for (FileStatus dir : entries = fs.listStatus(new Path("/"))) {
            fs.delete(dir.getPath(), true);
        }
    }

    @After
    public void tearDown() throws Exception {
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("dfs.blocksize", 0x100000);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.flushlogentries", 1);
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.getConfiguration().setInt("heartbeat.recheck.interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.socket.timeout", 5000);
        TEST_UTIL.getConfiguration().setInt("ipc.client.connect.max.retries", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.recovery.retries", 1);
        TEST_UTIL.startMiniCluster(3);
        conf = TEST_UTIL.getConfiguration();
        cluster = TEST_UTIL.getDFSCluster();
        fs = cluster.getFileSystem();
        hbaseDir = new Path(TEST_UTIL.getConfiguration().get("hbase.rootdir"));
        oldLogDir = new Path(hbaseDir, ".oldlogs");
        dir = new Path(hbaseDir, TestHLog.getName());
    }

    private static String getName() {
        return "TestHLog";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplit() throws IOException {
        byte[] tableName;
        byte[] rowName = tableName = Bytes.toBytes((String)TestHLog.getName());
        Path logdir = new Path(hbaseDir, ".logs");
        HLog log = new HLog(fs, logdir, oldLogDir, conf);
        int howmany = 3;
        HRegionInfo[] infos = new HRegionInfo[3];
        Path tabledir = new Path(hbaseDir, TestHLog.getName());
        fs.mkdirs(tabledir);
        for (int i = 0; i < 3; ++i) {
            infos[i] = new HRegionInfo(new HTableDescriptor(tableName), Bytes.toBytes((String)("" + i)), Bytes.toBytes((String)("" + (i + 1))), false);
            fs.mkdirs(new Path(tabledir, infos[i].getEncodedName()));
            LOG.info((Object)("allo " + new Path(tabledir, infos[i].getEncodedName()).toString()));
        }
        try {
            for (int ii = 0; ii < 3; ++ii) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        WALEdit edit = new WALEdit();
                        byte[] family = Bytes.toBytes((String)"column");
                        byte[] qualifier = Bytes.toBytes((String)Integer.toString(j));
                        byte[] column = Bytes.toBytes((String)("column:" + Integer.toString(j)));
                        edit.add(new KeyValue(rowName, family, qualifier, System.currentTimeMillis(), column));
                        LOG.info((Object)("Region " + i + ": " + edit));
                        log.append(infos[i], tableName, edit, System.currentTimeMillis());
                    }
                }
                log.rollWriter();
            }
            log.close();
            HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)conf, (Path)hbaseDir, (Path)logdir, (Path)oldLogDir, (FileSystem)fs);
            List splits = logSplitter.splitLog();
            this.verifySplits(splits, 3);
            log = null;
        }
        finally {
            if (log != null) {
                log.closeAndDelete();
            }
        }
    }

    @Test
    public void Broken_testSync() throws Exception {
        byte[] bytes = Bytes.toBytes((String)TestHLog.getName());
        Path p = new Path(dir, TestHLog.getName() + ".fsdos");
        FSDataOutputStream out = fs.create(p);
        out.write(bytes);
        out.sync();
        FSDataInputStream in = fs.open(p);
        Assert.assertTrue((in.available() > 0 ? 1 : 0) != 0);
        byte[] buffer = new byte[1024];
        int read = in.read(buffer);
        Assert.assertEquals((long)bytes.length, (long)read);
        out.close();
        in.close();
        Path subdir = new Path(dir, "hlogdir");
        HLog wal = new HLog(fs, subdir, oldLogDir, conf);
        int total = 20;
        HRegionInfo info = new HRegionInfo(new HTableDescriptor(bytes), null, null, false);
        for (int i = 0; i < 20; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add(new KeyValue(Bytes.toBytes((int)i), bytes, bytes));
            wal.append(info, bytes, kvs, System.currentTimeMillis());
        }
        wal.sync();
        Path walPath = wal.computeFilename();
        HLog.Reader reader = HLog.getReader((FileSystem)fs, (Path)walPath, (Configuration)conf);
        int count = 0;
        HLog.Entry entry = new HLog.Entry();
        while ((entry = reader.next(entry)) != null) {
            ++count;
        }
        Assert.assertEquals((long)20L, (long)count);
        reader.close();
        for (int i = 0; i < 20; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add(new KeyValue(Bytes.toBytes((int)i), bytes, bytes));
            wal.append(info, bytes, kvs, System.currentTimeMillis());
        }
        reader = HLog.getReader((FileSystem)fs, (Path)walPath, (Configuration)conf);
        count = 0;
        while ((entry = reader.next(entry)) != null) {
            ++count;
        }
        Assert.assertTrue((count >= 20 ? 1 : 0) != 0);
        reader.close();
        wal.sync();
        reader = HLog.getReader((FileSystem)fs, (Path)walPath, (Configuration)conf);
        count = 0;
        while ((entry = reader.next(entry)) != null) {
            ++count;
        }
        Assert.assertEquals((long)40L, (long)count);
        byte[] value = new byte[0x100400];
        for (int i = 0; i < 20; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add(new KeyValue(Bytes.toBytes((int)i), bytes, value));
            wal.append(info, bytes, kvs, System.currentTimeMillis());
        }
        wal.sync();
        reader = HLog.getReader((FileSystem)fs, (Path)walPath, (Configuration)conf);
        count = 0;
        while ((entry = reader.next(entry)) != null) {
            ++count;
        }
        Assert.assertEquals((long)60L, (long)count);
        reader.close();
        wal.close();
        reader = HLog.getReader((FileSystem)fs, (Path)walPath, (Configuration)conf);
        count = 0;
        while ((entry = reader.next(entry)) != null) {
            ++count;
        }
        Assert.assertEquals((long)60L, (long)count);
        reader.close();
    }

    @Test
    public void testFindMemstoresWithEditsEqualOrOlderThan() throws IOException {
        HashMap<byte[], Long> regionsToSeqids = new HashMap<byte[], Long>();
        for (int i = 0; i < 10; ++i) {
            Long l = i;
            regionsToSeqids.put(l.toString().getBytes(), l);
        }
        byte[][] regions = HLog.findMemstoresWithEditsEqualOrOlderThan((long)1L, regionsToSeqids);
        Assert.assertEquals((long)2L, (long)regions.length);
        Assert.assertTrue((Bytes.equals((byte[])regions[0], (byte[])"0".getBytes()) || Bytes.equals((byte[])regions[0], (byte[])"1".getBytes()) ? 1 : 0) != 0);
        regions = HLog.findMemstoresWithEditsEqualOrOlderThan((long)3L, regionsToSeqids);
        int count = 4;
        Assert.assertEquals((long)count, (long)regions.length);
        for (int i = 0; i < count; ++i) {
            Assert.assertTrue((Bytes.equals((byte[])regions[i], (byte[])"0".getBytes()) || Bytes.equals((byte[])regions[i], (byte[])"1".getBytes()) || Bytes.equals((byte[])regions[i], (byte[])"2".getBytes()) || Bytes.equals((byte[])regions[i], (byte[])"3".getBytes()) ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySplits(List<Path> splits, int howmany) throws IOException {
        Assert.assertEquals((long)howmany, (long)splits.size());
        for (int i = 0; i < splits.size(); ++i) {
            LOG.info((Object)("Verifying=" + splits.get(i)));
            HLog.Reader reader = HLog.getReader((FileSystem)fs, (Path)splits.get(i), (Configuration)conf);
            try {
                int count = 0;
                String previousRegion = null;
                long seqno = -1L;
                HLog.Entry entry = new HLog.Entry();
                while ((entry = reader.next(entry)) != null) {
                    HLogKey key = entry.getKey();
                    String region = Bytes.toString((byte[])key.getEncodedRegionName());
                    if (previousRegion != null) {
                        Assert.assertEquals(previousRegion, (Object)region);
                    }
                    LOG.info((Object)("oldseqno=" + seqno + ", newseqno=" + key.getLogSeqNum()));
                    Assert.assertTrue((seqno < key.getLogSeqNum() ? 1 : 0) != 0);
                    seqno = key.getLogSeqNum();
                    previousRegion = region;
                    ++count;
                }
                Assert.assertEquals((long)(howmany * howmany), (long)count);
                continue;
            }
            finally {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendClose() throws Exception {
        byte[] tableName = Bytes.toBytes((String)TestHLog.getName());
        HRegionInfo regioninfo = new HRegionInfo(new HTableDescriptor(tableName), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false);
        Path subdir = new Path(dir, "hlogdir");
        Path archdir = new Path(dir, "hlogdir_archive");
        HLog wal = new HLog(fs, subdir, archdir, conf);
        int total = 20;
        for (int i = 0; i < 20; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add(new KeyValue(Bytes.toBytes((int)i), tableName, tableName));
            wal.append(regioninfo, tableName, kvs, System.currentTimeMillis());
        }
        wal.sync();
        int namenodePort = cluster.getNameNodePort();
        final Path walPath = wal.computeFilename();
        try {
            cluster.getNameNode().setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.shutdown();
            try {
                wal.close();
            }
            catch (IOException e) {
                LOG.info((Object)e);
            }
            fs.close();
            LOG.info((Object)"STOPPED first instance of the cluster");
        }
        finally {
            while (cluster.isClusterUp()) {
                LOG.error((Object)"Waiting for cluster to go down");
                Thread.sleep(1000L);
            }
            cluster = new MiniDFSCluster(namenodePort, conf, 5, false, true, true, null, null, null, null);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            LOG.info((Object)"START second instance.");
        }
        Method setLeasePeriod = cluster.getClass().getDeclaredMethod("setLeasePeriod", Long.TYPE, Long.TYPE);
        setLeasePeriod.setAccessible(true);
        setLeasePeriod.invoke((Object)cluster, new Long(1000L), new Long(1000L));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOG.info((Object)e);
        }
        final FileSystem recoveredFs = fs;
        final Configuration rlConf = conf;
        class RecoverLogThread
        extends Thread {
            public Exception exception = null;

            RecoverLogThread() {
            }

            @Override
            public void run() {
                try {
                    FSUtils.recoverFileLease((FileSystem)recoveredFs, (Path)walPath, (Configuration)rlConf);
                }
                catch (IOException e) {
                    this.exception = e;
                }
            }
        }
        RecoverLogThread t = new RecoverLogThread();
        t.start();
        t.join(60000L);
        if (t.isAlive()) {
            t.interrupt();
            throw new Exception("Timed out waiting for HLog.recoverLog()");
        }
        if (t.exception != null) {
            throw t.exception;
        }
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, walPath, conf);
        int count = 0;
        HLogKey key = HLog.newKey((Configuration)conf);
        WALEdit val = new WALEdit();
        while (reader.next((Writable)key, (Writable)val)) {
            ++count;
            Assert.assertTrue((String)"Should be one KeyValue per WALEdit", (val.getKeyValues().size() == 1 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)20L, (long)count);
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditAdd() throws IOException {
        int COL_COUNT = 10;
        byte[] tableName = Bytes.toBytes((String)"tablename");
        byte[] row = Bytes.toBytes((String)"row");
        HLog.Reader reader = null;
        HLog log = new HLog(fs, dir, oldLogDir, conf);
        try {
            HLog.Entry entry;
            long timestamp = System.currentTimeMillis();
            WALEdit cols = new WALEdit();
            for (int i = 0; i < 10; ++i) {
                cols.add(new KeyValue(row, Bytes.toBytes((String)"column"), Bytes.toBytes((String)Integer.toString(i)), timestamp, new byte[]{(byte)(i + 48)}));
            }
            HRegionInfo info = new HRegionInfo(new HTableDescriptor(tableName), row, Bytes.toBytes((String)(Bytes.toString((byte[])row) + "1")), false);
            log.append(info, tableName, cols, System.currentTimeMillis());
            long logSeqId = log.startCacheFlush();
            log.completeCacheFlush(info.getEncodedNameAsBytes(), tableName, logSeqId, info.isMetaRegion());
            log.close();
            Path filename = log.computeFilename();
            log = null;
            reader = HLog.getReader((FileSystem)fs, (Path)filename, (Configuration)conf);
            for (int i = 0; i < 1 && (entry = reader.next(null)) != null; ++i) {
                HLogKey key = entry.getKey();
                WALEdit val = entry.getEdit();
                Assert.assertTrue((boolean)Bytes.equals((byte[])info.getEncodedNameAsBytes(), (byte[])key.getEncodedRegionName()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])tableName, (byte[])key.getTablename()));
                KeyValue kv = (KeyValue)val.getKeyValues().get(0);
                Assert.assertTrue((boolean)Bytes.equals((byte[])row, (byte[])kv.getRow()));
                Assert.assertEquals((long)((byte)(i + 48)), (long)kv.getValue()[0]);
                System.out.println(key + " " + val);
            }
            HLog.Entry entry2 = null;
            while ((entry2 = reader.next(null)) != null) {
                HLogKey key = entry2.getKey();
                WALEdit val = entry2.getEdit();
                Assert.assertTrue((boolean)Bytes.equals((byte[])info.getEncodedNameAsBytes(), (byte[])key.getEncodedRegionName()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])tableName, (byte[])key.getTablename()));
                KeyValue kv = (KeyValue)val.getKeyValues().get(0);
                Assert.assertTrue((boolean)Bytes.equals((byte[])HLog.METAROW, (byte[])kv.getRow()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])HLog.METAFAMILY, (byte[])kv.getFamily()));
                Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])HLog.COMPLETE_CACHE_FLUSH, (byte[])((KeyValue)val.getKeyValues().get(0)).getValue()));
                System.out.println(key + " " + val);
            }
        }
        finally {
            if (log != null) {
                log.closeAndDelete();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppend() throws IOException {
        int COL_COUNT = 10;
        byte[] tableName = Bytes.toBytes((String)"tablename");
        byte[] row = Bytes.toBytes((String)"row");
        HLog.Reader reader = null;
        HLog log = new HLog(fs, dir, oldLogDir, conf);
        try {
            long timestamp = System.currentTimeMillis();
            WALEdit cols = new WALEdit();
            for (int i = 0; i < 10; ++i) {
                cols.add(new KeyValue(row, Bytes.toBytes((String)"column"), Bytes.toBytes((String)Integer.toString(i)), timestamp, new byte[]{(byte)(i + 48)}));
            }
            HRegionInfo hri = new HRegionInfo(new HTableDescriptor(tableName), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            log.append(hri, tableName, cols, System.currentTimeMillis());
            long logSeqId = log.startCacheFlush();
            log.completeCacheFlush(hri.getEncodedNameAsBytes(), tableName, logSeqId, false);
            log.close();
            Path filename = log.computeFilename();
            log = null;
            reader = HLog.getReader((FileSystem)fs, (Path)filename, (Configuration)conf);
            HLog.Entry entry = reader.next();
            Assert.assertEquals((long)10L, (long)entry.getEdit().size());
            int idx = 0;
            for (KeyValue val : entry.getEdit().getKeyValues()) {
                Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEncodedNameAsBytes(), (byte[])entry.getKey().getEncodedRegionName()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])tableName, (byte[])entry.getKey().getTablename()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])row, (byte[])val.getRow()));
                Assert.assertEquals((long)((byte)(idx + 48)), (long)val.getValue()[0]);
                System.out.println(entry.getKey() + " " + val);
                ++idx;
            }
            entry = reader.next();
            Assert.assertEquals((long)1L, (long)entry.getEdit().size());
            for (KeyValue val : entry.getEdit().getKeyValues()) {
                Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEncodedNameAsBytes(), (byte[])entry.getKey().getEncodedRegionName()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])tableName, (byte[])entry.getKey().getTablename()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])HLog.METAROW, (byte[])val.getRow()));
                Assert.assertTrue((boolean)Bytes.equals((byte[])HLog.METAFAMILY, (byte[])val.getFamily()));
                Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])HLog.COMPLETE_CACHE_FLUSH, (byte[])val.getValue()));
                System.out.println(entry.getKey() + " " + val);
            }
        }
        finally {
            if (log != null) {
                log.closeAndDelete();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    public void testVisitors() throws Exception {
        int COL_COUNT = 10;
        byte[] tableName = Bytes.toBytes((String)"tablename");
        byte[] row = Bytes.toBytes((String)"row");
        HLog log = new HLog(fs, dir, oldLogDir, conf);
        DumbWALObserver visitor = new DumbWALObserver();
        log.registerWALActionsListener((WALObserver)visitor);
        long timestamp = System.currentTimeMillis();
        HRegionInfo hri = new HRegionInfo(new HTableDescriptor(tableName), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        for (int i = 0; i < 10; ++i) {
            WALEdit cols = new WALEdit();
            cols.add(new KeyValue(row, Bytes.toBytes((String)"column"), Bytes.toBytes((String)Integer.toString(i)), timestamp, new byte[]{(byte)(i + 48)}));
            log.append(hri, tableName, cols, System.currentTimeMillis());
        }
        Assert.assertEquals((long)10L, (long)visitor.increments);
        log.unregisterWALActionsListener((WALObserver)visitor);
        WALEdit cols = new WALEdit();
        cols.add(new KeyValue(row, Bytes.toBytes((String)"column"), Bytes.toBytes((String)Integer.toString(11)), timestamp, new byte[]{59}));
        log.append(hri, tableName, cols, System.currentTimeMillis());
        Assert.assertEquals((long)10L, (long)visitor.increments);
    }

    @Test
    public void testLogCleaning() throws Exception {
        LOG.info((Object)"testLogCleaning");
        byte[] tableName = Bytes.toBytes((String)"testLogCleaning");
        byte[] tableName2 = Bytes.toBytes((String)"testLogCleaning2");
        HLog log = new HLog(fs, dir, oldLogDir, conf);
        HRegionInfo hri = new HRegionInfo(new HTableDescriptor(tableName), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        HRegionInfo hri2 = new HRegionInfo(new HTableDescriptor(tableName2), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        this.addEdits(log, hri, tableName, 1);
        log.rollWriter();
        Assert.assertEquals((long)1L, (long)log.getNumLogFiles());
        this.addEdits(log, hri, tableName, 2);
        log.rollWriter();
        Assert.assertEquals((long)2L, (long)log.getNumLogFiles());
        this.addEdits(log, hri, tableName, 1);
        this.addEdits(log, hri2, tableName2, 1);
        this.addEdits(log, hri, tableName, 1);
        this.addEdits(log, hri2, tableName2, 1);
        log.rollWriter();
        Assert.assertEquals((long)3L, (long)log.getNumLogFiles());
        long seqId = log.startCacheFlush();
        log.completeCacheFlush(hri.getEncodedNameAsBytes(), tableName, seqId, false);
        log.rollWriter();
        Assert.assertEquals((long)2L, (long)log.getNumLogFiles());
        seqId = log.startCacheFlush();
        log.completeCacheFlush(hri2.getEncodedNameAsBytes(), tableName2, seqId, false);
        log.rollWriter();
        Assert.assertEquals((long)0L, (long)log.getNumLogFiles());
    }

    private void addEdits(HLog log, HRegionInfo hri, byte[] tableName, int times) throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        for (int i = 0; i < times; ++i) {
            long timestamp = System.currentTimeMillis();
            WALEdit cols = new WALEdit();
            cols.add(new KeyValue(row, row, row, timestamp, row));
            log.append(hri, tableName, cols, timestamp);
        }
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
    }

    static class DumbWALObserver
    implements WALObserver {
        int increments = 0;

        DumbWALObserver() {
        }

        public void visitLogEntryBeforeWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit) {
            ++this.increments;
        }

        public void logRolled(Path newFile) {
        }

        public void logRollRequested() {
        }

        public void logCloseRequested() {
        }
    }
}

