/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.FaultySequenceFileLogReader;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.InstrumentedSequenceFileLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.OrphanHLogAfterSplitException;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestHLogSplit {
    private static final Log LOG = LogFactory.getLog(TestHLogSplit.class);
    private Configuration conf;
    private FileSystem fs;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Path hbaseDir = new Path("/hbase");
    private static final Path hlogDir = new Path(hbaseDir, "hlog");
    private static final Path oldLogDir = new Path(hbaseDir, "hlog.old");
    private static final Path corruptDir = new Path(hbaseDir, ".corrupt");
    private static final int NUM_WRITERS = 10;
    private static final int ENTRIES = 10;
    private HLog.Writer[] writer = new HLog.Writer[10];
    private long seq = 0L;
    private static final byte[] TABLE_NAME = "t1".getBytes();
    private static final byte[] FAMILY = "f1".getBytes();
    private static final byte[] QUALIFIER = "q1".getBytes();
    private static final byte[] VALUE = "v1".getBytes();
    private static final String HLOG_FILE_PREFIX = "hlog.dat.";
    private static List<String> regions;
    private static final String HBASE_SKIP_ERRORS = "hbase.hlog.split.skip.errors";
    private static final Path tabledir;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.flushlogentries", 1);
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.getConfiguration().setStrings("hbase.rootdir", new String[]{hbaseDir.toString()});
        TEST_UTIL.getConfiguration().setClass("hbase.regionserver.hlog.writer.impl", InstrumentedSequenceFileLogWriter.class, HLog.Writer.class);
        TEST_UTIL.startMiniDFSCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniDFSCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.flushToConsole("Cleaning up cluster for new test\n--------------------------");
        this.conf = TEST_UTIL.getConfiguration();
        this.fs = TEST_UTIL.getDFSCluster().getFileSystem();
        FileStatus[] entries = this.fs.listStatus(new Path("/"));
        this.flushToConsole("Num entries in /:" + entries.length);
        for (FileStatus dir : entries) {
            Assert.assertTrue((String)("Deleting " + dir.getPath()), (boolean)this.fs.delete(dir.getPath(), true));
        }
        this.seq = 0L;
        regions = new ArrayList<String>();
        Collections.addAll(regions, "bbb", "ccc");
        InstrumentedSequenceFileLogWriter.activateFailure = false;
        TEST_UTIL.setNameNodeNameSystemLeasePeriod(100, 50000);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testRecoveredEditsPathForMeta() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        byte[] encoded = HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes();
        Path tdir = new Path(hbaseDir, Bytes.toString((byte[])HConstants.META_TABLE_NAME));
        Path regiondir = new Path(tdir, HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
        fs.mkdirs(regiondir);
        long now = System.currentTimeMillis();
        HLog.Entry entry = new HLog.Entry(new HLogKey(encoded, HConstants.META_TABLE_NAME, 1L, now), new WALEdit());
        Path p = HLogSplitter.getRegionSplitEditsPath((FileSystem)fs, (HLog.Entry)entry, (Path)hbaseDir);
        String parentOfParent = p.getParent().getParent().getName();
        Assert.assertEquals((Object)parentOfParent, (Object)HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=OrphanHLogAfterSplitException.class)
    public void testSplitFailsIfNewHLogGetsCreatedAfterSplitStarted() throws IOException {
        AtomicBoolean stop = new AtomicBoolean(false);
        FileStatus[] stats = this.fs.listStatus(new Path("/hbase/t1"));
        Assert.assertTrue((String)"Previous test should clean up table dir", (stats == null || stats.length == 0 ? 1 : 0) != 0);
        this.generateHLogs(-1);
        try {
            new ZombieNewLogWriterRegionServer(stop).start();
            HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
            logSplitter.splitLog();
        }
        finally {
            stop.set(true);
        }
    }

    @Test
    public void testSplitPreservesEdits() throws IOException {
        String REGION = "region__1";
        regions.removeAll(regions);
        regions.add("region__1");
        this.generateHLogs(1, 10, -1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
        logSplitter.splitLog();
        Path originalLog = this.fs.listStatus(oldLogDir)[0].getPath();
        Path splitLog = this.getLogForRegion(hbaseDir, TABLE_NAME, "region__1");
        Assert.assertEquals((String)"edits differ after split", (Object)true, (Object)this.logsAreEqual(originalLog, splitLog));
    }

    @Test
    public void testEmptyLogFiles() throws IOException {
        this.injectEmptyFile(".empty", true);
        this.generateHLogs(Integer.MAX_VALUE);
        this.injectEmptyFile("empty", true);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
        logSplitter.splitLog();
        for (String region : regions) {
            Path logfile = this.getLogForRegion(hbaseDir, TABLE_NAME, region);
            Assert.assertEquals((long)100L, (long)this.countHLog(logfile, this.fs, this.conf));
        }
    }

    @Test
    public void testEmptyOpenLogFiles() throws IOException {
        this.injectEmptyFile(".empty", false);
        this.generateHLogs(Integer.MAX_VALUE);
        this.injectEmptyFile("empty", false);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
        logSplitter.splitLog();
        for (String region : regions) {
            Path logfile = this.getLogForRegion(hbaseDir, TABLE_NAME, region);
            Assert.assertEquals((long)100L, (long)this.countHLog(logfile, this.fs, this.conf));
        }
    }

    @Test
    public void testOpenZeroLengthReportedFileButWithDataGetsSplit() throws IOException {
        this.generateHLogs(5);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
        logSplitter.splitLog();
        for (String region : regions) {
            Path logfile = this.getLogForRegion(hbaseDir, TABLE_NAME, region);
            Assert.assertEquals((long)100L, (long)this.countHLog(logfile, this.fs, this.conf));
        }
    }

    @Test
    public void testTralingGarbageCorruptionFileSkipErrorsPasses() throws IOException {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, true);
        this.generateHLogs(Integer.MAX_VALUE);
        this.corruptHLog(new Path(hlogDir, "hlog.dat.5"), Corruptions.APPEND_GARBAGE, true, this.fs);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
        logSplitter.splitLog();
        for (String region : regions) {
            Path logfile = this.getLogForRegion(hbaseDir, TABLE_NAME, region);
            Assert.assertEquals((long)100L, (long)this.countHLog(logfile, this.fs, this.conf));
        }
    }

    @Test
    public void testFirstLineCorruptionLogFileSkipErrorsPasses() throws IOException {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, true);
        this.generateHLogs(Integer.MAX_VALUE);
        this.corruptHLog(new Path(hlogDir, "hlog.dat.5"), Corruptions.INSERT_GARBAGE_ON_FIRST_LINE, true, this.fs);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
        logSplitter.splitLog();
        for (String region : regions) {
            Path logfile = this.getLogForRegion(hbaseDir, TABLE_NAME, region);
            Assert.assertEquals((long)90L, (long)this.countHLog(logfile, this.fs, this.conf));
        }
    }

    @Test
    public void testMiddleGarbageCorruptionSkipErrorsReadsHalfOfFile() throws IOException {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, true);
        this.generateHLogs(Integer.MAX_VALUE);
        this.corruptHLog(new Path(hlogDir, "hlog.dat.5"), Corruptions.INSERT_GARBAGE_IN_THE_MIDDLE, false, this.fs);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
        logSplitter.splitLog();
        for (String region : regions) {
            Path logfile = this.getLogForRegion(hbaseDir, TABLE_NAME, region);
            int goodEntries = 90;
            int firstHalfEntries = (int)Math.ceil(5.0) - 1;
            Assert.assertTrue((String)"The file up to the corrupted area hasn't been parsed", (goodEntries + firstHalfEntries <= this.countHLog(logfile, this.fs, this.conf) ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptedFileGetsArchivedIfSkipErrors() throws IOException {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, true);
        Class backupClass = this.conf.getClass("hbase.regionserver.hlog.reader.impl", HLog.Reader.class);
        InstrumentedSequenceFileLogWriter.activateFailure = false;
        HLog.resetLogReaderClass();
        try {
            Path c1 = new Path(hlogDir, "hlog.dat.0");
            this.conf.setClass("hbase.regionserver.hlog.reader.impl", FaultySequenceFileLogReader.class, HLog.Reader.class);
            for (FaultySequenceFileLogReader.FailureType failureType : FaultySequenceFileLogReader.FailureType.values()) {
                this.conf.set("faultysequencefilelogreader.failuretype", failureType.name());
                this.generateHLogs(1, 10, -1);
                this.fs.initialize(this.fs.getUri(), this.conf);
                HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
                logSplitter.splitLog();
                FileStatus[] archivedLogs = this.fs.listStatus(corruptDir);
                Assert.assertEquals((String)"expected a different file", (Object)c1.getName(), (Object)archivedLogs[0].getPath().getName());
                Assert.assertEquals((long)archivedLogs.length, (long)1L);
                this.fs.delete(new Path(oldLogDir, "hlog.dat.0"), false);
            }
        }
        finally {
            this.conf.setClass("hbase.regionserver.hlog.reader.impl", backupClass, HLog.Reader.class);
            HLog.resetLogReaderClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void testTrailingGarbageCorruptionLogFileSkipErrorsFalseThrows() throws IOException {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, false);
        Class backupClass = this.conf.getClass("hbase.regionserver.hlog.reader.impl", HLog.Reader.class);
        InstrumentedSequenceFileLogWriter.activateFailure = false;
        HLog.resetLogReaderClass();
        try {
            this.conf.setClass("hbase.regionserver.hlog.reader.impl", FaultySequenceFileLogReader.class, HLog.Reader.class);
            this.conf.set("faultysequencefilelogreader.failuretype", FaultySequenceFileLogReader.FailureType.BEGINNING.name());
            this.generateHLogs(Integer.MAX_VALUE);
            this.fs.initialize(this.fs.getUri(), this.conf);
            HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
            logSplitter.splitLog();
        }
        finally {
            this.conf.setClass("hbase.regionserver.hlog.reader.impl", backupClass, HLog.Reader.class);
            HLog.resetLogReaderClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptedLogFilesSkipErrorsFalseDoesNotTouchLogs() throws IOException {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, false);
        Class backupClass = this.conf.getClass("hbase.regionserver.hlog.reader.impl", HLog.Reader.class);
        InstrumentedSequenceFileLogWriter.activateFailure = false;
        HLog.resetLogReaderClass();
        try {
            this.conf.setClass("hbase.regionserver.hlog.reader.impl", FaultySequenceFileLogReader.class, HLog.Reader.class);
            this.conf.set("faultysequencefilelogreader.failuretype", FaultySequenceFileLogReader.FailureType.BEGINNING.name());
            this.generateHLogs(-1);
            this.fs.initialize(this.fs.getUri(), this.conf);
            HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
            try {
                logSplitter.splitLog();
            }
            catch (IOException e) {
                Assert.assertEquals((String)"if skip.errors is false all files should remain in place", (long)10L, (long)this.fs.listStatus(hlogDir).length);
            }
        }
        finally {
            this.conf.setClass("hbase.regionserver.hlog.reader.impl", backupClass, HLog.Reader.class);
            HLog.resetLogReaderClass();
        }
    }

    @Test
    public void testEOFisIgnored() throws IOException {
        HLog.Entry entry;
        this.conf.setBoolean(HBASE_SKIP_ERRORS, false);
        String REGION = "region__1";
        regions.removeAll(regions);
        regions.add("region__1");
        int entryCount = 10;
        Path c1 = new Path(hlogDir, "hlog.dat.0");
        this.generateHLogs(1, entryCount, -1);
        this.corruptHLog(c1, Corruptions.TRUNCATE, true, this.fs);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
        logSplitter.splitLog();
        Path originalLog = this.fs.listStatus(oldLogDir)[0].getPath();
        Path splitLog = this.getLogForRegion(hbaseDir, TABLE_NAME, "region__1");
        int actualCount = 0;
        HLog.Reader in = HLog.getReader((FileSystem)this.fs, (Path)splitLog, (Configuration)this.conf);
        while ((entry = in.next()) != null) {
            ++actualCount;
        }
        Assert.assertEquals((long)(entryCount - 1), (long)actualCount);
        FileStatus[] archivedLogs = this.fs.listStatus(corruptDir);
        Assert.assertEquals((long)archivedLogs.length, (long)0L);
    }

    @Test
    public void testLogsGetArchivedAfterSplit() throws IOException {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, false);
        this.generateHLogs(-1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
        logSplitter.splitLog();
        FileStatus[] archivedLogs = this.fs.listStatus(oldLogDir);
        Assert.assertEquals((String)"wrong number of files in the archive log", (long)10L, (long)archivedLogs.length);
    }

    @Test
    public void testSplit() throws IOException {
        this.generateHLogs(-1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
        logSplitter.splitLog();
        for (String region : regions) {
            Path logfile = this.getLogForRegion(hbaseDir, TABLE_NAME, region);
            Assert.assertEquals((long)100L, (long)this.countHLog(logfile, this.fs, this.conf));
        }
    }

    @Test
    public void testLogDirectoryShouldBeDeletedAfterSuccessfulSplit() throws IOException {
        this.generateHLogs(-1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
        logSplitter.splitLog();
        FileStatus[] statuses = null;
        try {
            statuses = this.fs.listStatus(hlogDir);
            if (statuses != null) {
                Assert.fail((String)("Files left in log dir: " + Joiner.on((String)",").join((Object[])FileUtil.stat2Paths((FileStatus[])statuses))));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitWillNotTouchLogsIfNewHLogGetsCreatedAfterSplitStarted() throws IOException {
        AtomicBoolean stop = new AtomicBoolean(false);
        this.generateHLogs(-1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        ZombieNewLogWriterRegionServer zombie = new ZombieNewLogWriterRegionServer(stop);
        try {
            zombie.start();
            try {
                HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
                logSplitter.splitLog();
            }
            catch (IOException ex) {
                // empty catch block
            }
            int logFilesNumber = this.fs.listStatus(hlogDir).length;
            Assert.assertEquals((String)"Log files should not be archived if there's an extra file after split", (long)11L, (long)logFilesNumber);
        }
        finally {
            stop.set(true);
        }
    }

    @Test(expected=IOException.class)
    public void testSplitWillFailIfWritingToRegionFails() throws Exception {
        this.generateHLogs(4);
        this.fs.initialize(this.fs.getUri(), this.conf);
        String region = "break";
        Path regiondir = new Path(tabledir, region);
        this.fs.mkdirs(regiondir);
        InstrumentedSequenceFileLogWriter.activateFailure = false;
        this.appendEntry(this.writer[4], TABLE_NAME, Bytes.toBytes((String)region), "r999".getBytes(), FAMILY, QUALIFIER, VALUE, 0L);
        this.writer[4].close();
        try {
            InstrumentedSequenceFileLogWriter.activateFailure = true;
            HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
            logSplitter.splitLog();
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"This exception is instrumented and should only be thrown for testing", (Object)e.getMessage());
            throw e;
        }
        finally {
            InstrumentedSequenceFileLogWriter.activateFailure = false;
        }
    }

    public void testSplittingLargeNumberOfRegionsConsistency() throws IOException {
        regions.removeAll(regions);
        for (int i = 0; i < 100; ++i) {
            regions.add("region__" + i);
        }
        this.generateHLogs(1, 100, -1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
        logSplitter.splitLog();
        this.fs.rename(oldLogDir, hlogDir);
        Path firstSplitPath = new Path(hbaseDir, Bytes.toString((byte[])TABLE_NAME) + ".first");
        Path splitPath = new Path(hbaseDir, Bytes.toString((byte[])TABLE_NAME));
        this.fs.rename(splitPath, firstSplitPath);
        this.fs.initialize(this.fs.getUri(), this.conf);
        logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
        logSplitter.splitLog();
        Assert.assertEquals((long)0L, (long)this.compareHLogSplitDirs(firstSplitPath, splitPath));
    }

    @Test
    public void testSplitDeletedRegion() throws IOException {
        regions.removeAll(regions);
        String region = "region_that_splits";
        regions.add(region);
        this.generateHLogs(1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        Path regiondir = new Path(tabledir, region);
        this.fs.delete(regiondir, true);
        HLogSplitter logSplitter = HLogSplitter.createLogSplitter((Configuration)this.conf, (Path)hbaseDir, (Path)hlogDir, (Path)oldLogDir, (FileSystem)this.fs);
        logSplitter.splitLog();
        Assert.assertFalse((boolean)this.fs.exists(regiondir));
    }

    @Test
    public void testIOEOnOutputThread() throws Exception {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, false);
        this.generateHLogs(-1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter logSplitter = new HLogSplitter(this.conf, hbaseDir, hlogDir, oldLogDir, this.fs){

            protected HLog.Writer createWriter(FileSystem fs, Path logfile, Configuration conf) throws IOException {
                HLog.Writer mockWriter = (HLog.Writer)Mockito.mock(HLog.Writer.class);
                ((HLog.Writer)Mockito.doThrow((Throwable)new IOException("Injected")).when((Object)mockWriter)).append((HLog.Entry)Mockito.any());
                return mockWriter;
            }
        };
        try {
            logSplitter.splitLog();
            Assert.fail((String)"Didn't throw!");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.toString().contains("Injected"));
        }
    }

    @Test
    public void testMovedHLogDuringRecovery() throws Exception {
        this.generateHLogs(-1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        FileSystem spiedFs = (FileSystem)Mockito.spy((Object)this.fs);
        ((FileSystem)Mockito.doThrow((Throwable)new LeaseExpiredException("Injected: File does not exist")).when((Object)spiedFs)).append((Path)Mockito.any());
        HLogSplitter logSplitter = new HLogSplitter(this.conf, hbaseDir, hlogDir, oldLogDir, spiedFs);
        try {
            logSplitter.splitLog();
            Assert.assertEquals((long)10L, (long)this.fs.listStatus(oldLogDir).length);
            Assert.assertFalse((boolean)this.fs.exists(hlogDir));
        }
        catch (IOException e) {
            Assert.fail((String)("There shouldn't be any exception but: " + e.toString()));
        }
    }

    @Test
    public void testThreading() throws Exception {
        this.doTestThreading(20000, 0x8000000, 0);
    }

    @Test
    public void testThreadingSlowWriterSmallBuffer() throws Exception {
        this.doTestThreading(200, 1024, 50);
    }

    private void doTestThreading(final int numFakeEdits, int bufferSize, final int writerSlowness) throws Exception {
        Configuration localConf = new Configuration(this.conf);
        localConf.setInt("hbase.regionserver.hlog.splitlog.buffersize", bufferSize);
        FSDataOutputStream out = this.fs.create(new Path(hlogDir, "hlog.dat..fake"));
        out.close();
        ImmutableList regions = ImmutableList.of((Object)"r0", (Object)"r1", (Object)"r2", (Object)"r3", (Object)"r4");
        this.makeRegionDirs(this.fs, (List<String>)regions);
        HLogSplitter logSplitter = new HLogSplitter(localConf, hbaseDir, hlogDir, oldLogDir, this.fs, (List)regions){
            final /* synthetic */ List val$regions;
            {
                this.val$regions = list;
                super(x0, x1, x2, x3, x4);
            }

            protected HLog.Writer createWriter(FileSystem fs, Path logfile, Configuration conf) throws IOException {
                HLog.Writer mockWriter = (HLog.Writer)Mockito.mock(HLog.Writer.class);
                ((HLog.Writer)Mockito.doAnswer((Answer)new Answer<Void>(){
                    int expectedIndex = 0;

                    public Void answer(InvocationOnMock invocation) {
                        if (writerSlowness > 0) {
                            try {
                                Thread.sleep(writerSlowness);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        HLog.Entry entry = (HLog.Entry)invocation.getArguments()[0];
                        WALEdit edit = entry.getEdit();
                        List keyValues = edit.getKeyValues();
                        Assert.assertEquals((long)1L, (long)keyValues.size());
                        KeyValue kv = (KeyValue)keyValues.get(0);
                        Assert.assertEquals((long)this.expectedIndex, (long)Bytes.toInt((byte[])kv.getRow()));
                        ++this.expectedIndex;
                        return null;
                    }
                }).when((Object)mockWriter)).append((HLog.Entry)Mockito.any());
                return mockWriter;
            }

            protected HLog.Reader getReader(FileSystem fs, Path curLogFile, Configuration conf) throws IOException {
                HLog.Reader mockReader = (HLog.Reader)Mockito.mock(HLog.Reader.class);
                ((HLog.Reader)Mockito.doAnswer((Answer)new Answer<HLog.Entry>(){
                    int index = 0;

                    public HLog.Entry answer(InvocationOnMock invocation) throws Throwable {
                        if (this.index >= numFakeEdits) {
                            return null;
                        }
                        int regionIdx = this.index % val$regions.size();
                        byte[] region = new byte[]{114, (byte)(48 + regionIdx)};
                        HLog.Entry ret = TestHLogSplit.this.createTestEntry(TABLE_NAME, region, Bytes.toBytes((int)(this.index / val$regions.size())), FAMILY, QUALIFIER, VALUE, this.index);
                        ++this.index;
                        return ret;
                    }
                }).when((Object)mockReader)).next();
                return mockReader;
            }
        };
        logSplitter.splitLog();
        Map outputCounts = logSplitter.getOutputCounts();
        for (Map.Entry entry : outputCounts.entrySet()) {
            LOG.info((Object)("Got " + entry.getValue() + " output edits for region " + Bytes.toString((byte[])((byte[])entry.getKey()))));
            Assert.assertEquals((long)((Long)entry.getValue()), (long)(numFakeEdits / regions.size()));
        }
        Assert.assertEquals((long)regions.size(), (long)outputCounts.size());
    }

    private void flushToConsole(String s) {
        System.out.println(s);
        System.out.flush();
    }

    private void generateHLogs(int leaveOpen) throws IOException {
        this.generateHLogs(10, 10, leaveOpen);
    }

    private void makeRegionDirs(FileSystem fs, List<String> regions) throws IOException {
        for (String region : regions) {
            this.flushToConsole("Creating dir for region " + region);
            fs.mkdirs(new Path(tabledir, region));
        }
    }

    private void generateHLogs(int writers, int entries, int leaveOpen) throws IOException {
        this.makeRegionDirs(this.fs, regions);
        for (int i = 0; i < writers; ++i) {
            this.writer[i] = HLog.createWriter((FileSystem)this.fs, (Path)new Path(hlogDir, HLOG_FILE_PREFIX + i), (Configuration)this.conf);
            for (int j = 0; j < entries; ++j) {
                int prefix = 0;
                for (String region : regions) {
                    String row_key = region + prefix++ + i + j;
                    this.appendEntry(this.writer[i], TABLE_NAME, region.getBytes(), row_key.getBytes(), FAMILY, QUALIFIER, VALUE, this.seq);
                }
            }
            if (i == leaveOpen) continue;
            this.writer[i].close();
            this.flushToConsole("Closing writer " + i);
        }
    }

    private Path getLogForRegion(Path rootdir, byte[] table, String region) throws IOException {
        Path tdir = HTableDescriptor.getTableDir((Path)rootdir, (byte[])table);
        Path editsdir = HLog.getRegionDirRecoveredEditsDir((Path)HRegion.getRegionDir((Path)tdir, (String)Bytes.toString((byte[])region.getBytes())));
        FileStatus[] files = this.fs.listStatus(editsdir);
        Assert.assertEquals((long)1L, (long)files.length);
        return files[0].getPath();
    }

    private void corruptHLog(Path path, Corruptions corruption, boolean close, FileSystem fs) throws IOException {
        int fileSize = (int)fs.listStatus(path)[0].getLen();
        FSDataInputStream in = fs.open(path);
        byte[] corrupted_bytes = new byte[fileSize];
        in.readFully(0L, corrupted_bytes, 0, fileSize);
        in.close();
        switch (corruption) {
            case APPEND_GARBAGE: {
                FSDataOutputStream out = fs.append(path);
                out.write("-----".getBytes());
                this.closeOrFlush(close, out);
                break;
            }
            case INSERT_GARBAGE_ON_FIRST_LINE: {
                fs.delete(path, false);
                FSDataOutputStream out = fs.create(path);
                out.write(0);
                out.write(corrupted_bytes);
                this.closeOrFlush(close, out);
                break;
            }
            case INSERT_GARBAGE_IN_THE_MIDDLE: {
                fs.delete(path, false);
                FSDataOutputStream out = fs.create(path);
                int middle = (int)Math.floor(corrupted_bytes.length / 2);
                out.write(corrupted_bytes, 0, middle);
                out.write(0);
                out.write(corrupted_bytes, middle, corrupted_bytes.length - middle);
                this.closeOrFlush(close, out);
                break;
            }
            case TRUNCATE: {
                fs.delete(path, false);
                FSDataOutputStream out = fs.create(path);
                out.write(corrupted_bytes, 0, fileSize - 32);
                this.closeOrFlush(close, out);
            }
        }
    }

    private void closeOrFlush(boolean close, FSDataOutputStream out) throws IOException {
        if (close) {
            out.close();
        } else {
            out.sync();
        }
    }

    private void dumpHLog(Path log, FileSystem fs, Configuration conf) throws IOException {
        HLog.Entry entry;
        HLog.Reader in = HLog.getReader((FileSystem)fs, (Path)log, (Configuration)conf);
        while ((entry = in.next()) != null) {
            System.out.println(entry);
        }
    }

    private int countHLog(Path log, FileSystem fs, Configuration conf) throws IOException {
        int count = 0;
        HLog.Reader in = HLog.getReader((FileSystem)fs, (Path)log, (Configuration)conf);
        while (in.next() != null) {
            ++count;
        }
        return count;
    }

    public long appendEntry(HLog.Writer writer, byte[] table, byte[] region, byte[] row, byte[] family, byte[] qualifier, byte[] value, long seq) throws IOException {
        writer.append(this.createTestEntry(table, region, row, family, qualifier, value, seq));
        writer.sync();
        return seq;
    }

    private HLog.Entry createTestEntry(byte[] table, byte[] region, byte[] row, byte[] family, byte[] qualifier, byte[] value, long seq) {
        long time = System.nanoTime();
        WALEdit edit = new WALEdit();
        edit.add(new KeyValue(row, family, qualifier, time, KeyValue.Type.Put, value));
        return new HLog.Entry(new HLogKey(region, table, ++seq, time), edit);
    }

    private void injectEmptyFile(String suffix, boolean closeFile) throws IOException {
        HLog.Writer writer = HLog.createWriter((FileSystem)this.fs, (Path)new Path(hlogDir, HLOG_FILE_PREFIX + suffix), (Configuration)this.conf);
        if (closeFile) {
            writer.close();
        }
    }

    private void listLogs(FileSystem fs, Path dir) throws IOException {
        for (FileStatus file : fs.listStatus(dir)) {
            System.out.println(file.getPath());
        }
    }

    private int compareHLogSplitDirs(Path p1, Path p2) throws IOException {
        FileStatus[] f1 = this.fs.listStatus(p1);
        FileStatus[] f2 = this.fs.listStatus(p2);
        Assert.assertNotNull((String)("Path " + p1 + " doesn't exist"), (Object)f1);
        Assert.assertNotNull((String)("Path " + p2 + " doesn't exist"), (Object)f2);
        System.out.println("Files in " + p1 + ": " + Joiner.on((String)",").join((Object[])FileUtil.stat2Paths((FileStatus[])f1)));
        System.out.println("Files in " + p2 + ": " + Joiner.on((String)",").join((Object[])FileUtil.stat2Paths((FileStatus[])f2)));
        Assert.assertEquals((long)f1.length, (long)f2.length);
        for (int i = 0; i < f1.length; ++i) {
            Path rd1 = HLog.getRegionDirRecoveredEditsDir((Path)f1[i].getPath());
            FileStatus[] rd1fs = this.fs.listStatus(rd1);
            Assert.assertEquals((long)1L, (long)rd1fs.length);
            Path rd2 = HLog.getRegionDirRecoveredEditsDir((Path)f2[i].getPath());
            FileStatus[] rd2fs = this.fs.listStatus(rd2);
            Assert.assertEquals((long)1L, (long)rd2fs.length);
            if (this.logsAreEqual(rd1fs[0].getPath(), rd2fs[0].getPath())) continue;
            return -1;
        }
        return 0;
    }

    private boolean logsAreEqual(Path p1, Path p2) throws IOException {
        HLog.Entry entry1;
        HLog.Reader in1 = HLog.getReader((FileSystem)this.fs, (Path)p1, (Configuration)this.conf);
        HLog.Reader in2 = HLog.getReader((FileSystem)this.fs, (Path)p2, (Configuration)this.conf);
        while ((entry1 = in1.next()) != null) {
            HLog.Entry entry2 = in2.next();
            if (entry1.getKey().compareTo(entry2.getKey()) == 0 && entry1.getEdit().toString().equals(entry2.getEdit().toString())) continue;
            return false;
        }
        return true;
    }

    static {
        tabledir = new Path(hbaseDir, Bytes.toString((byte[])TABLE_NAME));
    }

    class ZombieNewLogWriterRegionServer
    extends Thread {
        AtomicBoolean stop;

        public ZombieNewLogWriterRegionServer(AtomicBoolean stop) {
            super("ZombieNewLogWriterRegionServer");
            this.stop = stop;
        }

        @Override
        public void run() {
            if (this.stop.get()) {
                return;
            }
            Path tableDir = new Path(hbaseDir, new String(TABLE_NAME));
            Path regionDir = new Path(tableDir, (String)regions.get(0));
            Path recoveredEdits = new Path(regionDir, "recovered.edits");
            String region = "juliet";
            Path julietLog = new Path(hlogDir, "hlog.dat..juliet");
            try {
                while (!TestHLogSplit.this.fs.exists(recoveredEdits) && !this.stop.get()) {
                    TestHLogSplit.this.flushToConsole("Juliet: split not started, sleeping a bit...");
                    Threads.sleep((int)10);
                }
                TestHLogSplit.this.fs.mkdirs(new Path(tableDir, region));
                HLog.Writer writer = HLog.createWriter((FileSystem)TestHLogSplit.this.fs, (Path)julietLog, (Configuration)TestHLogSplit.this.conf);
                TestHLogSplit.this.appendEntry(writer, "juliet".getBytes(), "juliet".getBytes(), "r".getBytes(), FAMILY, QUALIFIER, VALUE, 0L);
                writer.close();
                TestHLogSplit.this.flushToConsole("Juliet file creator: created file " + julietLog);
            }
            catch (IOException e1) {
                Assert.assertTrue((String)("Failed to create file " + julietLog), (boolean)false);
            }
        }
    }

    class ZombieLastLogWriterRegionServer
    extends Thread {
        AtomicLong editsCount;
        AtomicBoolean stop;
        Path log;
        HLog.Writer lastLogWriter;

        public ZombieLastLogWriterRegionServer(HLog.Writer writer, AtomicLong counter, AtomicBoolean stop) {
            this.stop = stop;
            this.editsCount = counter;
            this.lastLogWriter = writer;
        }

        @Override
        public void run() {
            if (this.stop.get()) {
                return;
            }
            TestHLogSplit.this.flushToConsole("starting");
            block4: while (true) {
                try {
                    while (true) {
                        String region = "juliet";
                        TestHLogSplit.this.fs.mkdirs(new Path(new Path(hbaseDir, region), region));
                        TestHLogSplit.this.appendEntry(this.lastLogWriter, TABLE_NAME, region.getBytes(), ("r" + this.editsCount).getBytes(), FAMILY, QUALIFIER, VALUE, 0L);
                        this.lastLogWriter.sync();
                        this.editsCount.incrementAndGet();
                        try {
                            Thread.sleep(1L);
                            continue block4;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ex) {
                    if (!(ex instanceof RemoteException)) {
                        Assert.assertTrue((String)("Failed to write " + this.editsCount.get()), (boolean)false);
                        continue;
                    }
                    TestHLogSplit.this.flushToConsole("Juliet: got RemoteException " + ex.getMessage() + " while writing " + (this.editsCount.get() + 1L));
                    return;
                }
                break;
            }
        }
    }

    static enum Corruptions {
        INSERT_GARBAGE_ON_FIRST_LINE,
        INSERT_GARBAGE_IN_THE_MIDDLE,
        APPEND_GARBAGE,
        TRUNCATE;

    }
}

