/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestReplicationSource {
    private static final Log LOG = LogFactory.getLog(TestReplicationSource.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static FileSystem fs;
    private static Path oldLogDir;
    private static Path logDir;
    private static Configuration conf;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniDFSCluster(1);
        fs = TEST_UTIL.getDFSCluster().getFileSystem();
        oldLogDir = new Path(fs.getHomeDirectory(), ".oldlogs");
        logDir = new Path(fs.getHomeDirectory(), ".logs");
    }

    @Test
    public void testLogMoving() throws Exception {
        Path logPath = new Path(logDir, "log");
        HLog.Writer writer = HLog.createWriter((FileSystem)fs, (Path)logPath, (Configuration)conf);
        for (int i = 0; i < 3; ++i) {
            byte[] b = Bytes.toBytes((String)Integer.toString(i));
            KeyValue kv = new KeyValue(b, b, b);
            WALEdit edit = new WALEdit();
            edit.add(kv);
            HLogKey key = new HLogKey(b, b, 0L, 0L);
            writer.append(new HLog.Entry(key, edit));
            writer.sync();
        }
        writer.close();
        HLog.Reader reader = HLog.getReader((FileSystem)fs, (Path)logPath, (Configuration)conf);
        HLog.Entry entry = reader.next();
        Assert.assertNotNull((Object)entry);
        Path oldLogPath = new Path(oldLogDir, "log");
        fs.rename(logPath, oldLogPath);
        entry = reader.next();
        Assert.assertNotNull((Object)entry);
        entry = reader.next();
        entry = reader.next();
        Assert.assertNull((Object)entry);
    }

    static {
        conf = HBaseConfiguration.create();
    }
}

