/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTransform {
    private static final String TABLE = "TestTransform";
    private static final String CFA = "a";
    private static final String CFB = "b";
    private static final String COLUMN_1 = "a:1";
    private static final String COLUMN_2 = "b:2";
    private static final String ROW_1 = "testrow1";
    private static final byte[] VALUE_1 = Bytes.toBytes((String)"testvalue1");
    private static final byte[] VALUE_2 = Bytes.toBytes((String)"testvalue2");
    private static final byte[] VALUE_2_BASE64 = Bytes.toBytes((String)"dGVzdHZhbHVlMg==");
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static Client client;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        REST_TEST_UTIL.startServletContainer(TEST_UTIL.getConfiguration());
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(TABLE)) {
            return;
        }
        HTableDescriptor htd = new HTableDescriptor(TABLE);
        htd.addFamily(new HColumnDescriptor(CFA));
        HColumnDescriptor cfB = new HColumnDescriptor(CFB);
        cfB.setValue("Transform$1", "*:Base64");
        htd.addFamily(cfB);
        admin.createTable(htd);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testTransform() throws Exception {
        String path1 = "/TestTransform/testrow1/a:1";
        String path2 = "/TestTransform/testrow1/b:2";
        Response response = client.put(path1, "application/octet-stream", VALUE_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = client.put(path2, "application/octet-stream", VALUE_2);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), TABLE);
        Get get = new Get(Bytes.toBytes((String)ROW_1));
        get.addFamily(Bytes.toBytes((String)CFA));
        get.addFamily(Bytes.toBytes((String)CFB));
        Result result = table.get(get);
        byte[] value = result.getValue(Bytes.toBytes((String)CFA), Bytes.toBytes((String)"1"));
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)Bytes.equals((byte[])value, (byte[])VALUE_1));
        value = result.getValue(Bytes.toBytes((String)CFB), Bytes.toBytes((String)"2"));
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)Bytes.equals((byte[])value, (byte[])VALUE_2_BASE64));
        table.close();
        response = client.get(path2, "application/octet-stream");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        value = response.getBody();
        Assert.assertTrue((boolean)Bytes.equals((byte[])value, (byte[])VALUE_2));
    }
}

