/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.StorageClusterVersionModel;
import org.apache.hadoop.hbase.rest.model.VersionModel;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestVersionResource {
    private static final Log LOG = LogFactory.getLog(TestVersionResource.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static Client client;
    private static JAXBContext context;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        REST_TEST_UTIL.startServletContainer(TEST_UTIL.getConfiguration());
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        context = JAXBContext.newInstance((Class[])new Class[]{VersionModel.class, StorageClusterVersionModel.class});
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    private static void validate(VersionModel model) {
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.getRESTVersion());
        Assert.assertEquals((Object)model.getRESTVersion(), (Object)"0.0.2");
        String osVersion = model.getOSVersion();
        Assert.assertNotNull((Object)osVersion);
        Assert.assertTrue((boolean)osVersion.contains(System.getProperty("os.name")));
        Assert.assertTrue((boolean)osVersion.contains(System.getProperty("os.version")));
        Assert.assertTrue((boolean)osVersion.contains(System.getProperty("os.arch")));
        String jvmVersion = model.getJVMVersion();
        Assert.assertNotNull((Object)jvmVersion);
        Assert.assertTrue((boolean)jvmVersion.contains(System.getProperty("java.vm.vendor")));
        Assert.assertTrue((boolean)jvmVersion.contains(System.getProperty("java.version")));
        Assert.assertTrue((boolean)jvmVersion.contains(System.getProperty("java.vm.version")));
        Assert.assertNotNull((Object)model.getServerVersion());
        String jerseyVersion = model.getJerseyVersion();
        Assert.assertNotNull((Object)jerseyVersion);
        Assert.assertEquals((Object)jerseyVersion, (Object)ServletContainer.class.getPackage().getImplementationVersion());
    }

    @Test
    public void testGetStargateVersionText() throws IOException {
        Response response = client.get("/version", "text/plain");
        Assert.assertTrue((response.getCode() == 200 ? 1 : 0) != 0);
        String body = Bytes.toString((byte[])response.getBody());
        Assert.assertTrue((body.length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)body.contains("0.0.2"));
        Assert.assertTrue((boolean)body.contains(System.getProperty("java.vm.vendor")));
        Assert.assertTrue((boolean)body.contains(System.getProperty("java.version")));
        Assert.assertTrue((boolean)body.contains(System.getProperty("java.vm.version")));
        Assert.assertTrue((boolean)body.contains(System.getProperty("os.name")));
        Assert.assertTrue((boolean)body.contains(System.getProperty("os.version")));
        Assert.assertTrue((boolean)body.contains(System.getProperty("os.arch")));
        Assert.assertTrue((boolean)body.contains(ServletContainer.class.getPackage().getImplementationVersion()));
    }

    @Test
    public void testGetStargateVersionXML() throws IOException, JAXBException {
        Response response = client.get("/version", "text/xml");
        Assert.assertTrue((response.getCode() == 200 ? 1 : 0) != 0);
        VersionModel model = (VersionModel)context.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        TestVersionResource.validate(model);
        LOG.info((Object)"success retrieving Stargate version as XML");
    }

    @Test
    public void testGetStargateVersionJSON() throws IOException {
        Response response = client.get("/version", "application/json");
        Assert.assertTrue((response.getCode() == 200 ? 1 : 0) != 0);
    }

    @Test
    public void testGetStargateVersionPB() throws IOException {
        Response response = client.get("/version", "application/x-protobuf");
        Assert.assertTrue((response.getCode() == 200 ? 1 : 0) != 0);
        VersionModel model = new VersionModel();
        model.getObjectFromMessage(response.getBody());
        TestVersionResource.validate(model);
        LOG.info((Object)"success retrieving Stargate version as protobuf");
    }

    @Test
    public void testGetStorageClusterVersionText() throws IOException {
        Response response = client.get("/version/cluster", "text/plain");
        Assert.assertTrue((response.getCode() == 200 ? 1 : 0) != 0);
    }

    @Test
    public void testGetStorageClusterVersionXML() throws IOException, JAXBException {
        Response response = client.get("/version/cluster", "text/xml");
        Assert.assertTrue((response.getCode() == 200 ? 1 : 0) != 0);
        StorageClusterVersionModel clusterVersionModel = (StorageClusterVersionModel)context.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        Assert.assertNotNull((Object)clusterVersionModel);
        Assert.assertNotNull((Object)clusterVersionModel.getVersion());
        LOG.info((Object)"success retrieving storage cluster version as XML");
    }

    @Test
    public void doTestGetStorageClusterVersionJSON() throws IOException {
        Response response = client.get("/version/cluster", "application/json");
        Assert.assertTrue((response.getCode() == 200 ? 1 : 0) != 0);
    }
}

