/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.util.Bytes;

public class TestRowModel
extends TestCase {
    private static final byte[] ROW1 = Bytes.toBytes((String)"testrow1");
    private static final byte[] COLUMN1 = Bytes.toBytes((String)"testcolumn1");
    private static final byte[] VALUE1 = Bytes.toBytes((String)"testvalue1");
    private static final long TIMESTAMP1 = 1245219839331L;
    private static final String AS_XML = "<Row key=\"dGVzdHJvdzE=\"><Cell timestamp=\"1245219839331\" column=\"dGVzdGNvbHVtbjE=\">dGVzdHZhbHVlMQ==</Cell></Row>";
    private JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CellModel.class, RowModel.class});

    private RowModel buildTestModel() {
        RowModel model = new RowModel();
        model.setKey(ROW1);
        model.addCell(new CellModel(COLUMN1, 1245219839331L, VALUE1));
        return model;
    }

    private String toXML(RowModel model) throws JAXBException {
        StringWriter writer = new StringWriter();
        this.context.createMarshaller().marshal((Object)model, (Writer)writer);
        return writer.toString();
    }

    private RowModel fromXML(String xml) throws JAXBException {
        return (RowModel)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(xml));
    }

    private void checkModel(RowModel model) {
        TestRowModel.assertTrue((boolean)Bytes.equals((byte[])ROW1, (byte[])model.getKey()));
        Iterator cells = model.getCells().iterator();
        CellModel cell = (CellModel)cells.next();
        TestRowModel.assertTrue((boolean)Bytes.equals((byte[])COLUMN1, (byte[])cell.getColumn()));
        TestRowModel.assertTrue((boolean)Bytes.equals((byte[])VALUE1, (byte[])cell.getValue()));
        TestRowModel.assertTrue((boolean)cell.hasUserTimestamp());
        TestRowModel.assertEquals((long)cell.getTimestamp(), (long)1245219839331L);
        TestRowModel.assertFalse((boolean)cells.hasNext());
    }

    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    public void testFromXML() throws Exception {
        this.checkModel(this.fromXML(AS_XML));
    }
}

