/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.rest.model.TableInfoModel;
import org.apache.hadoop.hbase.rest.model.TableRegionModel;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;

public class TestTableInfoModel
extends TestCase {
    private static final String TABLE = "testtable";
    private static final byte[] START_KEY = Bytes.toBytes((String)"abracadbra");
    private static final byte[] END_KEY = Bytes.toBytes((String)"zzyzx");
    private static final long ID = 8731042424L;
    private static final String LOCATION = "testhost:9876";
    private static final String AS_XML = "<TableInfo name=\"testtable\"><Region location=\"testhost:9876\" endKey=\"enp5eng=\" startKey=\"YWJyYWNhZGJyYQ==\" id=\"8731042424\" name=\"testtable,abracadbra,8731042424\"/></TableInfo>";
    private static final String AS_PB = "Cgl0ZXN0dGFibGUSSQofdGVzdHRhYmxlLGFicmFjYWRicmEsODczMTA0MjQyNBIKYWJyYWNhZGJyYRoFenp5engg+MSkwyAqDXRlc3Rob3N0Ojk4NzY=";
    private JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{TableInfoModel.class, TableRegionModel.class});

    private TableInfoModel buildTestModel() {
        TableInfoModel model = new TableInfoModel();
        model.setName(TABLE);
        model.add(new TableRegionModel(TABLE, 8731042424L, START_KEY, END_KEY, LOCATION));
        return model;
    }

    private String toXML(TableInfoModel model) throws JAXBException {
        StringWriter writer = new StringWriter();
        this.context.createMarshaller().marshal((Object)model, (Writer)writer);
        return writer.toString();
    }

    private TableInfoModel fromXML(String xml) throws JAXBException {
        return (TableInfoModel)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(xml));
    }

    private byte[] toPB(TableInfoModel model) {
        return model.createProtobufOutput();
    }

    private TableInfoModel fromPB(String pb) throws IOException {
        return (TableInfoModel)new TableInfoModel().getObjectFromMessage(Base64.decode((String)AS_PB));
    }

    private void checkModel(TableInfoModel model) {
        TestTableInfoModel.assertEquals((String)model.getName(), (String)TABLE);
        Iterator regions = model.getRegions().iterator();
        TableRegionModel region = (TableRegionModel)regions.next();
        TestTableInfoModel.assertTrue((boolean)Bytes.equals((byte[])region.getStartKey(), (byte[])START_KEY));
        TestTableInfoModel.assertTrue((boolean)Bytes.equals((byte[])region.getEndKey(), (byte[])END_KEY));
        TestTableInfoModel.assertEquals((long)region.getId(), (long)8731042424L);
        TestTableInfoModel.assertEquals((String)region.getLocation(), (String)LOCATION);
        TestTableInfoModel.assertFalse((boolean)regions.hasNext());
    }

    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    public void testFromXML() throws Exception {
        this.checkModel(this.fromXML(AS_XML));
    }

    public void testFromPB() throws Exception {
        this.checkModel(this.fromPB(AS_PB));
    }
}

