/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.rest.model.TableRegionModel;
import org.apache.hadoop.hbase.util.Bytes;

public class TestTableRegionModel
extends TestCase {
    private static final String TABLE = "testtable";
    private static final byte[] START_KEY = Bytes.toBytes((String)"abracadbra");
    private static final byte[] END_KEY = Bytes.toBytes((String)"zzyzx");
    private static final long ID = 8731042424L;
    private static final String LOCATION = "testhost:9876";
    private static final String AS_XML = "<Region location=\"testhost:9876\" endKey=\"enp5eng=\" startKey=\"YWJyYWNhZGJyYQ==\" id=\"8731042424\" name=\"testtable,abracadbra,8731042424\"/>";
    private JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{TableRegionModel.class});

    private TableRegionModel buildTestModel() {
        TableRegionModel model = new TableRegionModel(TABLE, 8731042424L, START_KEY, END_KEY, LOCATION);
        return model;
    }

    private String toXML(TableRegionModel model) throws JAXBException {
        StringWriter writer = new StringWriter();
        this.context.createMarshaller().marshal((Object)model, (Writer)writer);
        return writer.toString();
    }

    private TableRegionModel fromXML(String xml) throws JAXBException {
        return (TableRegionModel)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(xml));
    }

    private void checkModel(TableRegionModel model) {
        TestTableRegionModel.assertTrue((boolean)Bytes.equals((byte[])model.getStartKey(), (byte[])START_KEY));
        TestTableRegionModel.assertTrue((boolean)Bytes.equals((byte[])model.getEndKey(), (byte[])END_KEY));
        TestTableRegionModel.assertEquals((long)model.getId(), (long)8731042424L);
        TestTableRegionModel.assertEquals((String)model.getLocation(), (String)LOCATION);
        TestTableRegionModel.assertEquals((String)model.getName(), (String)("testtable," + Bytes.toString((byte[])START_KEY) + "," + Long.toString(8731042424L) + ".ad9860f031282c46ed431d7af8f94aca."));
    }

    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    public void testGetName() {
        TableRegionModel model = this.buildTestModel();
        String modelName = model.getName();
        HRegionInfo hri = new HRegionInfo(new HTableDescriptor(TABLE), START_KEY, END_KEY, false, 8731042424L);
        TestTableRegionModel.assertEquals((String)modelName, (String)hri.getRegionNameAsString());
    }

    public void testSetName() {
        TableRegionModel model = this.buildTestModel();
        String name = model.getName();
        model.setName(name);
        TestTableRegionModel.assertEquals((String)name, (String)model.getName());
    }

    public void testFromXML() throws Exception {
        this.checkModel(this.fromXML(AS_XML));
    }
}

