/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.rest.model.VersionModel;
import org.apache.hadoop.hbase.util.Base64;

public class TestVersionModel
extends TestCase {
    private static final String REST_VERSION = "0.0.1";
    private static final String OS_VERSION = "Linux 2.6.18-128.1.6.el5.centos.plusxen amd64";
    private static final String JVM_VERSION = "Sun Microsystems Inc. 1.6.0_13-11.3-b02";
    private static final String JETTY_VERSION = "6.1.14";
    private static final String JERSEY_VERSION = "1.1.0-ea";
    private static final String AS_XML = "<Version REST=\"0.0.1\" OS=\"Linux 2.6.18-128.1.6.el5.centos.plusxen amd64\" JVM=\"Sun Microsystems Inc. 1.6.0_13-11.3-b02\" Server=\"6.1.14\" Jersey=\"1.1.0-ea\"/>";
    private static final String AS_PB = "CgUwLjAuMRInU3VuIE1pY3Jvc3lzdGVtcyBJbmMuIDEuNi4wXzEzLTExLjMtYjAyGi1MaW51eCAyLjYuMTgtMTI4LjEuNi5lbDUuY2VudG9zLnBsdXN4ZW4gYW1kNjQiBjYuMS4xNCoIMS4xLjAtZWE=";
    private JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{VersionModel.class});

    private VersionModel buildTestModel() {
        VersionModel model = new VersionModel();
        model.setRESTVersion(REST_VERSION);
        model.setOSVersion(OS_VERSION);
        model.setJVMVersion(JVM_VERSION);
        model.setServerVersion(JETTY_VERSION);
        model.setJerseyVersion(JERSEY_VERSION);
        return model;
    }

    private String toXML(VersionModel model) throws JAXBException {
        StringWriter writer = new StringWriter();
        this.context.createMarshaller().marshal((Object)model, (Writer)writer);
        return writer.toString();
    }

    private VersionModel fromXML(String xml) throws JAXBException {
        return (VersionModel)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(xml));
    }

    private byte[] toPB(VersionModel model) {
        return model.createProtobufOutput();
    }

    private VersionModel fromPB(String pb) throws IOException {
        return (VersionModel)new VersionModel().getObjectFromMessage(Base64.decode((String)AS_PB));
    }

    private void checkModel(VersionModel model) {
        TestVersionModel.assertEquals((String)model.getRESTVersion(), (String)REST_VERSION);
        TestVersionModel.assertEquals((String)model.getOSVersion(), (String)OS_VERSION);
        TestVersionModel.assertEquals((String)model.getJVMVersion(), (String)JVM_VERSION);
        TestVersionModel.assertEquals((String)model.getServerVersion(), (String)JETTY_VERSION);
        TestVersionModel.assertEquals((String)model.getJerseyVersion(), (String)JERSEY_VERSION);
    }

    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    public void testFromXML() throws Exception {
        this.checkModel(this.fromXML(AS_XML));
    }

    public void testFromPB() throws Exception {
        this.checkModel(this.fromPB(AS_PB));
    }
}

