/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.security.User;
import org.junit.Assert;
import org.junit.Test;

public class TestUser {
    @Test
    public void testBasicAttributes() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        User user = User.createUserForTesting((Configuration)conf, (String)"simple", (String[])new String[]{"foo"});
        Assert.assertEquals((String)"Username should match", (Object)"simple", (Object)user.getName());
        Assert.assertEquals((String)"Short username should match", (Object)"simple", (Object)user.getShortName());
    }

    @Test
    public void testRunAs() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        final User user = User.createUserForTesting((Configuration)conf, (String)"testuser", (String[])new String[]{"foo"});
        final PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                User u = User.getCurrent();
                return u.getName();
            }
        };
        String username = (String)user.runAs((PrivilegedAction)action);
        Assert.assertEquals((String)"Current user within runAs() should match", (Object)"testuser", (Object)username);
        User user2 = User.createUserForTesting((Configuration)conf, (String)"testuser2", (String[])new String[]{"foo"});
        String username2 = (String)user2.runAs((PrivilegedAction)action);
        Assert.assertEquals((String)"Second username should match second user", (Object)"testuser2", (Object)username2);
        username = (String)user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                return User.getCurrent().getName();
            }
        });
        Assert.assertEquals((String)"User name in runAs() should match", (Object)"testuser", (Object)username);
        user2.runAs(new PrivilegedAction(){

            public Object run() {
                String nestedName = (String)user.runAs(action);
                Assert.assertEquals((String)"Nest name should match nested user", (Object)"testuser", (Object)nestedName);
                Assert.assertEquals((String)"Current name should match current user", (Object)"testuser2", (Object)User.getCurrent().getName());
                return null;
            }
        });
    }
}

