/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.RawComparator;

public class TestBytes
extends TestCase {
    public void testNullHashCode() {
        byte[] b = null;
        Exception ee = null;
        try {
            Bytes.hashCode(b);
        }
        catch (Exception e) {
            ee = e;
        }
        TestBytes.assertNotNull((Object)ee);
    }

    public void testSplit() throws Exception {
        int i;
        byte[] lowest = Bytes.toBytes((String)"AAA");
        byte[] middle = Bytes.toBytes((String)"CCC");
        byte[] highest = Bytes.toBytes((String)"EEE");
        byte[][] parts = Bytes.split((byte[])lowest, (byte[])highest, (int)1);
        for (i = 0; i < parts.length; ++i) {
            System.out.println(Bytes.toString((byte[])parts[i]));
        }
        TestBytes.assertEquals((int)3, (int)parts.length);
        TestBytes.assertTrue((boolean)Bytes.equals((byte[])parts[1], (byte[])middle));
        highest = Bytes.toBytes((String)"DDD");
        parts = Bytes.split((byte[])lowest, (byte[])highest, (int)2);
        for (i = 0; i < parts.length; ++i) {
            System.out.println(Bytes.toString((byte[])parts[i]));
        }
        TestBytes.assertEquals((int)4, (int)parts.length);
        TestBytes.assertTrue((boolean)Bytes.equals((byte[])parts[2], (byte[])middle));
    }

    public void testSplit2() throws Exception {
        byte[] lowest = Bytes.toBytes((String)"http://A");
        byte[] highest = Bytes.toBytes((String)"http://z");
        byte[] middle = Bytes.toBytes((String)"http://]");
        byte[][] parts = Bytes.split((byte[])lowest, (byte[])highest, (int)1);
        for (int i = 0; i < parts.length; ++i) {
            System.out.println(Bytes.toString((byte[])parts[i]));
        }
        TestBytes.assertEquals((int)3, (int)parts.length);
        TestBytes.assertTrue((boolean)Bytes.equals((byte[])parts[1], (byte[])middle));
    }

    public void testSplit3() throws Exception {
        byte[] low = new byte[]{1, 1, 1};
        byte[] high = new byte[]{1, 1, 3};
        try {
            Bytes.split((byte[])high, (byte[])low, (int)1);
            TestBytes.assertTrue((String)"Should not be able to split if low > high", (boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        byte[][] parts = Bytes.split((byte[])low, (byte[])high, (int)1);
        for (int i = 0; i < parts.length; ++i) {
            System.out.println("" + i + " -> " + Bytes.toStringBinary((byte[])parts[i]));
        }
        TestBytes.assertTrue((String)("Returned split should have 3 parts but has " + parts.length), (parts.length == 3 ? 1 : 0) != 0);
        parts = Bytes.split((byte[])low, (byte[])high, (int)2);
        TestBytes.assertTrue((String)"Returned split but should have failed", (parts == null ? 1 : 0) != 0);
        try {
            parts = Bytes.split((byte[])low, (byte[])high, (int)0);
            TestBytes.assertTrue((String)"Should not be able to split 0 times", (boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }

    public void testToLong() throws Exception {
        long[] longs = new long[]{-1L, 123L, 122232323232L};
        for (int i = 0; i < longs.length; ++i) {
            byte[] b = Bytes.toBytes((long)longs[i]);
            TestBytes.assertEquals((long)longs[i], (long)Bytes.toLong((byte[])b));
        }
    }

    public void testToFloat() throws Exception {
        float[] floats = new float[]{-1.0f, 123.123f, Float.MAX_VALUE};
        for (int i = 0; i < floats.length; ++i) {
            byte[] b = Bytes.toBytes((float)floats[i]);
            TestBytes.assertEquals((Object)Float.valueOf(floats[i]), (Object)Float.valueOf(Bytes.toFloat((byte[])b)));
        }
    }

    public void testToDouble() throws Exception {
        double[] doubles = new double[]{Double.MIN_VALUE, Double.MAX_VALUE};
        for (int i = 0; i < doubles.length; ++i) {
            byte[] b = Bytes.toBytes((double)doubles[i]);
            TestBytes.assertEquals((Object)doubles[i], (Object)Bytes.toDouble((byte[])b));
        }
    }

    public void testBinarySearch() throws Exception {
        byte[][] arr = new byte[][]{{1}, {3}, {5}, {7}, {9}, {11}, {13}, {15}};
        byte[] key1 = new byte[]{3, 1};
        byte[] key2 = new byte[]{4, 9};
        byte[] key2_2 = new byte[]{4};
        byte[] key3 = new byte[]{5, 11};
        TestBytes.assertEquals((int)1, (int)Bytes.binarySearch((byte[][])arr, (byte[])key1, (int)0, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)0, (int)Bytes.binarySearch((byte[][])arr, (byte[])key1, (int)1, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)-3, (int)Arrays.binarySearch(arr, key2_2, Bytes.BYTES_COMPARATOR));
        TestBytes.assertEquals((int)-3, (int)Bytes.binarySearch((byte[][])arr, (byte[])key2, (int)0, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)4, (int)Bytes.binarySearch((byte[][])arr, (byte[])key2, (int)1, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)2, (int)Bytes.binarySearch((byte[][])arr, (byte[])key3, (int)0, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)5, (int)Bytes.binarySearch((byte[][])arr, (byte[])key3, (int)1, (int)1, (RawComparator)Bytes.BYTES_RAWCOMPARATOR));
    }

    public void testStartsWith() {
        TestBytes.assertTrue((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"h")));
        TestBytes.assertTrue((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"")));
        TestBytes.assertTrue((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"hello")));
        TestBytes.assertFalse((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)"hello"), (byte[])Bytes.toBytes((String)"helloworld")));
        TestBytes.assertFalse((boolean)Bytes.startsWith((byte[])Bytes.toBytes((String)""), (byte[])Bytes.toBytes((String)"hello")));
    }

    public void testIncrementBytes() throws IOException {
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, 1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(12L, 123435445L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(124634654L, 1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10005460L, 5005645L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(1L, -1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, -1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(1005435000L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, -43657655L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-1L, 1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-26L, 5034520L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-10657200L, 5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-12343250L, 45376475L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-10L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-12343250L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-12L, -34565445L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-1546543452L, -34565445L));
    }

    private static boolean checkTestIncrementBytes(long val, long amount) throws IOException {
        byte[] value = Bytes.toBytes((long)val);
        byte[] testValue = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        if (value[0] > 0) {
            testValue = new byte[8];
        }
        System.arraycopy(value, 0, testValue, testValue.length - value.length, value.length);
        long incrementResult = Bytes.toLong((byte[])Bytes.incrementBytes((byte[])value, (long)amount));
        return Bytes.toLong((byte[])testValue) + amount == incrementResult;
    }
}

