/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Assert;
import org.junit.Test;

public class TestFSUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsHDFS() throws Exception {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        htu.getConfiguration().setBoolean("dfs.support.append", false);
        Assert.assertFalse((boolean)FSUtils.isHDFS((Configuration)htu.getConfiguration()));
        Assert.assertFalse((boolean)FSUtils.isAppendSupported((Configuration)htu.getConfiguration()));
        htu.getConfiguration().setBoolean("dfs.support.append", true);
        MiniDFSCluster cluster = null;
        try {
            cluster = htu.startMiniDFSCluster(1);
            Assert.assertTrue((boolean)FSUtils.isHDFS((Configuration)htu.getConfiguration()));
            Assert.assertTrue((boolean)FSUtils.isAppendSupported((Configuration)htu.getConfiguration()));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

